#!/usr/bin/env python3
#
# GlobalChem - Montmorillonite Adsorption
#
# ---------------------------------------

class MontmorilloniteAdsorption(object):

    def __init__(self):

        self.name = 'montmorillonite_adsorption'

    @staticmethod
    def get_smiles():

        smiles = {
            '3,3′,4,4′,5-pentachlorobiphenyl': 'C1=CC(=C(C=C1C2=CC(=C(C(=C2)Cl)Cl)Cl)Cl)Cl',
            '3,4,3′,4′-tetrachlorobiphenyl': 'C1=CC(=C(C=C1C2=CC(=C(C=C2)Cl)Cl)Cl)Cl',
            '2,2′,4,4′,5,5′-hexachlorobiphenyl': 'C1=C(C(=CC(=C1Cl)Cl)Cl)C2=CC(=C(C=C2Cl)Cl)Cl',
            'bisphenol A': 'CC(C)(C1=CC=C(C=C1)O)C2=CC=C(C=C2)O',
            '2,3,3′,4,4′,5′-hexachlorobiphenyl': 'C1=CC(=C(C=C1C2=CC(=C(C(=C2Cl)Cl)Cl)Cl)Cl)Cl',
            '2,2′,4,4′,6,6′-hexachlorobiphenyl': 'C1=C(C=C(C(=C1Cl)C2=CC(=C(C=C2Cl)Cl)Cl)Cl)Cl',
            '2,2′,4,4′,5,6′-hexachlorobiphenyl': 'C1=CC=C(C(=C1)C2=C(C(=C(C(=C2Cl)Cl)Cl)Cl)Cl)Cl',
            'lindane': 'C1(C(C(C(C(C1Cl)Cl)Cl)Cl)Cl)Cl',
            'naphthalene': 'C1=CC=C2C=CC=CC2=C1',
            'benz[e]acephenanthrylene': 'C1=CC=C2C3=C4C(=CC=C3)C5=CC=CC=C5C4=CC2=C1',
            'dieldrin': 'C1C2C3C(C1C4C2O4)C5(C(=C(C3(C5(Cl)Cl)Cl)Cl)Cl)Cl',
            'linuron': 'CN(C(=O)NC1=CC(=C(C=C1)Cl)Cl)OC',
            'trifluralin': 'CCCN(CCC)C1=C(C=C(C=C1[N+](=O)[O-])C(F)(F)F)[N+](=O)[O-]',
            'toluene': 'CC1=CC=CC=C1',
            'benzene': 'C1=CC=CC=C1',
            'bisphenol S': 'C1=CC(=CC=C1O)S(=O)(=O)C2=CC=C(C=C2)O',
            'bisphenol F': 'c1cc(ccc1Cc2ccc(cc2)O)O',
            'benzo[a]pyrene': 'C1=CC=C2C3=C4C(=CC2=C1)C=CC5=C4C(=CC=C5)C=C3',
            '2,4-dichlorophenoxyacetic acid': 'C1=CC(=C(C=C1Cl)Cl)OCC(=O)O',
            'clofenotane (DDT)': 'C1=CC(=CC=C1C(C2=CC=C(C=C2)Cl)C(Cl)(Cl)Cl)Cl',
            'pyrene': 'C1=CC2=C3C(=C1)C=CC4=CC=CC(=C43)C=C2',
            'deoxynivalenol (vomitoxin)': 'CC1=CC2C(C(C1=O)O)(C3(CC(C(C34CO4)O2)O)C)CO',
            'glyphosate': 'C(C(=O)O)NCP(=O)(O)O',
            'fumonisin-B1': 'CCCCC(C)C(C(CC(C)CC(CCCCC(CC(C(C)N)O)O)O)OC(=O)CC(CC(=O)O)C(=O)O)OC(=O)CC(CC(=O)O)C(=O)O',
            'aflatoxin-B1': 'COC1=C2C3=C(C(=O)CC3)C(=O)OC2=C4C5C=COC5OC4=C1',
            '2,4,6-trichlorophenol': 'C1=C(C=C(C(=C1Cl)O)Cl)Cl',
            'diazinon': 'CCOP(=S)(OCC)OC1=NC(=NC(=C1)C)C(C)C',
            'paraquat': 'C[N+]1=CC=C(C=C1)C2=CC=[N+](C=C2)C',
            'phenol': 'C1=CC=C(C=C1)O',
            'aminomethylphosphonic acid': 'C(N)P(=O)(O)O',
            'chlorpyriphos': 'CCOP(=S)(OCC)OC1=NC(=C(C=C1Cl)Cl)Cl',
            'xearalenone': 'CC1CCCC(=O)CCCC=CC2=C(C(=CC(=C2)O)O)C(=O)O1',
            'aldicarb': 'CC(C)(C=NOC(=O)NC)SC'
        }
        return smiles

    @staticmethod
    def get_smarts():

        smarts = {
            '3,3′,4,4′,5-pentachlorobiphenyl': '[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1-[#6]1:[#6]:[#6](:[#6](:[#6](:[#6]:1)-[#17])-[#17])-[#17])-[#17])-[#17]',
            '3,4,3′,4′-tetrachlorobiphenyl': '[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1-[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1)-[#17])-[#17])-[#17])-[#17]',
            '2,2′,4,4′,5,5′-hexachlorobiphenyl': '[#6]1:[#6](:[#6](:[#6]:[#6](:[#6]:1-[#17])-[#17])-[#17])-[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1-[#17])-[#17])-[#17]',
            'bisphenol A': '[#6]-[#6](-[#6])(-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8])-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8]',
            '2,3,3′,4,4′,5′-hexachlorobiphenyl': '[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1-[#6]1:[#6]:[#6](:[#6](:[#6](:[#6]:1-[#17])-[#17])-[#17])-[#17])-[#17])-[#17]',
            '2,2′,4,4′,6,6′-hexachlorobiphenyl': '[#6]1:[#6](:[#6]:[#6](:[#6](:[#6]:1-[#17])-[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1-[#17])-[#17])-[#17])-[#17])-[#17]',
            '2,2′,4,4′,5,6′-hexachlorobiphenyl': '[#6]1:[#6]:[#6]:[#6](:[#6](:[#6]:1)-[#6]1:[#6](:[#6](:[#6](:[#6](:[#6]:1-[#17])-[#17])-[#17])-[#17])-[#17])-[#17]',
            'lindane': '[#6]1(-[#6](-[#6](-[#6](-[#6](-[#6]-1-[#17])-[#17])-[#17])-[#17])-[#17])-[#17]',
            'naphthalene': '[#6]1:[#6]:[#6]:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2:[#6]:1',
            'benz[e]acephenanthrylene': '[#6]1:[#6]:[#6]:[#6]2:[#6]3:[#6]4:[#6](:[#6]:[#6]:[#6]:3)-[#6]3:[#6]:[#6]:[#6]:[#6]:[#6]:3-[#6]:4:[#6]:[#6]:2:[#6]:1',
            'dieldrin': '[#6]1-[#6]2-[#6]3-[#6](-[#6]-1-[#6]1-[#6]-2-[#8]-1)-[#6]1(-[#6](=[#6](-[#6]-3(-[#6]-1(-[#17])-[#17])-[#17])-[#17])-[#17])-[#17]',
            'linuron': '[#6]-[#7](-[#6](=[#8])-[#7]-[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1)-[#17])-[#17])-[#8]-[#6]',
            'trifluralin': '[#6]-[#6]-[#6]-[#7](-[#6]-[#6]-[#6])-[#6]1:[#6](:[#6]:[#6](:[#6]:[#6]:1-[#7+](=[#8])-[#8-])-[#6](-[#9])(-[#9])-[#9])-[#7+](=[#8])-[#8-]',
            'toluene': '[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'benzene': '[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'bisphenol S': '[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#8])-[#16](=[#8])(=[#8])-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8]',
            'bisphenol F': '[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8])-[#8]',
            'benzo[a]pyrene': '[#6]1:[#6]:[#6]:[#6]2:[#6]3:[#6]4:[#6](:[#6]:[#6]:2:[#6]:1):[#6]:[#6]:[#6]1:[#6]:4:[#6](:[#6]:[#6]:[#6]:1):[#6]:[#6]:3',
            '2,4-dichlorophenoxyacetic acid': '[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1-[#17])-[#17])-[#8]-[#6]-[#6](=[#8])-[#8]',
            'clofenotane (DDT)': '[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#6](-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#17])-[#6](-[#17])(-[#17])-[#17])-[#17]',
            'pyrene': '[#6]1:[#6]:[#6]2:[#6]3:[#6](:[#6]:1):[#6]:[#6]:[#6]1:[#6]:[#6]:[#6]:[#6](:[#6]:3:1):[#6]:[#6]:2',
            'deoxynivalenol (vomitoxin)': '[#6]-[#6]1=[#6]-[#6]2-[#6](-[#6](-[#6]-1=[#8])-[#8])(-[#6]1(-[#6]-[#6](-[#6](-[#6]-13-[#6]-[#8]-3)-[#8]-2)-[#8])-[#6])-[#6]-[#8]',
            'glyphosate': '[#6](-[#6](=[#8])-[#8])-[#7]-[#6]-[#15](=[#8])(-[#8])-[#8]',
            'fumonisin-B1': '[#6]-[#6]-[#6]-[#6]-[#6](-[#6])-[#6](-[#6](-[#6]-[#6](-[#6])-[#6]-[#6](-[#6]-[#6]-[#6]-[#6]-[#6](-[#6]-[#6](-[#6](-[#6])-[#7])-[#8])-[#8])-[#8])-[#8]-[#6](=[#8])-[#6]-[#6](-[#6]-[#6](=[#8])-[#8])-[#6](=[#8])-[#8])-[#8]-[#6](=[#8])-[#6]-[#6](-[#6]-[#6](=[#8])-[#8])-[#6](=[#8])-[#8]',
            'aflatoxin-B1': '[#6]-[#8]-[#6]1:[#6]2:[#6]3:[#6](-[#6](=[#8])-[#6]-[#6]-3):[#6](=[#8]):[#8]:[#6]:2:[#6]2-[#6]3-[#6]=[#6]-[#8]-[#6]-3-[#8]-[#6]:2:[#6]:1',
            '2,4,6-trichlorophenol': '[#6]1:[#6](:[#6]:[#6](:[#6](:[#6]:1-[#17])-[#8])-[#17])-[#17]',
            'diazinon': '[#6]-[#6]-[#8]-[#15](=[#16])(-[#8]-[#6]-[#6])-[#8]-[#6]1:[#7]:[#6](:[#7]:[#6](:[#6]:1)-[#6])-[#6](-[#6])-[#6]',
            'paraquat': '[#6]-[#7+]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#7+](:[#6]:[#6]:1)-[#6]',
            'phenol': '[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8]',
            'aminomethylphosphonic acid': '[#6](-[#7])-[#15](=[#8])(-[#8])-[#8]',
            'chlorpyriphos': '[#6]-[#6]-[#8]-[#15](=[#16])(-[#8]-[#6]-[#6])-[#8]-[#6]1:[#7]:[#6](:[#6](:[#6]:[#6]:1-[#17])-[#17])-[#17]',
            'xearalenone': '[#6]-[#6]1-[#6]-[#6]-[#6]-[#6](=[#8])-[#6]-[#6]-[#6]-[#6]=[#6]-[#6]2:[#6](:[#6](:[#6]:[#6](:[#6]:2)-[#8])-[#8])-[#6](=[#8])-[#8]-1',
            'aldicarb': '[#6]-[#6](-[#6])(-[#6]=[#7]-[#8]-[#6](=[#8])-[#7]-[#6])-[#16]-[#6]',
        }

        return smarts

    @staticmethod
    def get_bit_vector():

        bit_vector = {
            '3,3′,4,4′,5-pentachlorobiphenyl': '00000000000000000010000000000000000000000000000001000000000000000000000000000000000000000000000000100000000000000000000000000000000000001000000000010001001000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000100000000000000000001000000000000000000100000010010000000000010000010000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000001000000000000',
            '3,4,3′,4′-tetrachlorobiphenyl': '00000000000000000010000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000010000001000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000100000000000000000001000000000000000000100000010010000000000010000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            '2,2′,4,4′,5,5′-hexachlorobiphenyl': '00000000000000000010000000000000000000000000000001000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000001100000000000001000100000010010000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'bisphenol A': '00000000100000000000000000000000010000000000000000001000000000000010000000000000000000000000000000000000000000000010000000000000010000000000000000000000000000000000000100000000000000000000000000000000000000000000001000000000000000000100000000100000000000000000000000000000000000000000000001000001000000000000000000000000000000000000000001000000000000000000100000000000000000000000000000000000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            '2,3,3′,4,4′,5′-hexachlorobiphenyl': '00000000000000000010000000000000000000000000000001000000000000100000000000000000000000000000000000000000000000000000000000000000000000001000000000010001001000000010000000000000000001000000000000000000000000000000001000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000100100100000000000001000000000000001000100000010010000000000010000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000',
            '2,2′,4,4′,6,6′-hexachlorobiphenyl': '00000000000000000010000000000000000000000000000001000000000000000000000000000000000000000000000010000000000000000000000000000000000001000000000100010000000000000000000000000000000000000100000000000000000000000001000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000001100000000000001000100000010010000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            '2,2′,4,4′,5,6′-hexachlorobiphenyl': '00000000000000000000000000000000000000000000000001000000000000101000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000001000000000000000000000000000000000001001000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100001000000000000101000100000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000001000000000000000000000000001000000000000',
            'lindane': '00000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000010000',
            'naphthalene': '00000000000000000000000000000000000000000000000000000000000000011000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000001000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'benz[e]acephenanthrylene': '00000000000000010000000000000000000001000000000000000000000000011000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000001000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001010010000000010001000000001000001000100000010000000010000010000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000001000000000000100010000000000000000000000',
            'dieldrin': '00000000000000000000100000000000000010000011000001000000000000000000000000000000000000000000010000000000000000100100000000000000000000000000000010010000000010100000000000000000000000000000000000000000100000000000000000000100000000000000000000000000000000000000000000001000000000000000000000000000100000000000000000000000000000000000000000000000000000000000100000000000000000000000100001000000000000000000100000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000010000',
            'linuron': '00000000000000000010000000000000010100000000010001000000000000000000000000000000000000000000000000000000000000000000000000000000100000000011000000010000001000000000000000000000000000011000000101000000000000000000001000000000000000000000000000000000000000000000000000000000000000001000000000000001000000000000000000000000000100000101000001000000010000000000100000010010010000000010010000000000000000000001000000000000000000000000000000000000000000000000000000000000000010000000000000000000000100000000000000000000',
            'trifluralin': '00000000000000000000000000000000010000000000000000000000000000000000000000000000100000000000000000000000000100000010000000000000000000100010000000000001000000000000000000010000000000000000000000000000000110000000000000000000010000000000100001000000000000000000000000000010000000010010000000000010010000000000000000000000000000100001000001000000000000000010100000010000010000000000000000000000111000000000000100000001000000000001010000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'toluene': '00000000000000000000000000000001010000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000010000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000001000000000000000000100000000000000000000000000010000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'benzene': '00000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'bisphenol S': '00000000000000000000000000000000000100000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000100000000000000100000000001000000000000000000100000000100000000000000000000000000000000000000000000001000001000000000000000000000001000000000000000001000000000000100000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000000000000000000000000000000000000000',
            'bisphenol F': '00000000000000000000000000000000000000010000000000000000000000000010000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000100000000000000100000000100000000000000000000000000000000000000000000001000001000000000001001000000000000000000000000001000000000000000000100000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'benzo[a]pyrene': '00000000000000010000000000000000000001000000000000000000000000011000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000001000000000000010000000101000100000000011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100010000000010001000000000000000000100000010000000000001000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000010000000000000000000000',
            '2,4-dichlorophenoxyacetic acid': '00000000000000000000000000000000000000000000000001000000000000000000000000000000100000100000001000000000000000000000000000000000000000000010000000010000000000000001010000001000000000010100000000000000010000000000001010000000000000000000000000000000000000000000000000000000000000000000000000000001000000001000000000000000000000000000000001000000000000000000100000010010000000000000010000000100000000000000000000000000100000000000100000100000000000000000000000000000000010000000000100000000000000000000000000000000',
            'clofenotane (DDT)': '01000000000000000000000000000000000000000000001001000000000000000000000000000000000000001000000000000000000000000010000000000000000000000000000000010000000000000000000000000001000000000000000000000000000000000000001010000000000000000000000010000000000000000000000001000000000000000000000000010000000000001000000000000100000000000000000001000100000000000000100000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'pyrene': '00000000000000010000000000000000000000000000000000000000000000011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000100000000011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000001000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000',
            'deoxynivalenol (vomitoxin)': '01000000000000000000001000000000010010000000000000000000000000000000000100100000100000000000000000000000000000000000000000000000000000000010000010000000000000100001001100000000000000000011000000000000100001000000000000000010000110001100000000000000001000000010000000000000010010000000000000000001000000000100000000100000000000000000000001000000000000000000100000000010000000000000000001000100000000000000001000000010000000000000000010000000000000000000000000010000010000000000000000100000000000000100000001010000',
            'glyphosate': '00000000000100000000000000000000000000000000000000000000000000000000000000000000100000000000010000000000000000000000000000000000100000000010000000000000000000000000000000000000000000000000000010000000010000000000000100000000000000000000000000000000000000000000000100000000000000000000000000000001000000100000000010000000000000000000000000000000000000000000000000000000000000000000010000000110000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000010000010000000000000000000',
            'fumonisin-B1': '01000000000000010000100000000000010010000000100000000000000000000000010000000101100000010000000000000000000100000000110000000000000000000010000000010000000000000000000010100000001000010000000000000000010000000000000000000000000100001100000000000000110000000001000000100000001000000011000000000011000000011000100000000000000000000000100001000100000010000000000000100000000000011000010000000100000000000000000000000000100000000000000000000000000000000100100000000110000000000100000000000000000000000000001000000000',
            'aflatoxin-B1': '10000000000000000000000000000000010000000000000000000000001100100000100000000000000000000000000010000000000000001000000000000100000001000010000010000000000000001000000000000000000000010000000000000000001000001011000000000000000100000000001100000000010000000100000000000000000010000000100000000000000100000000000000100000001000000100000001000000000000000000100001010000010001100000000100001000000000000001001010001010000000000000000000100000000010001000000000000000000000000000000000000000000000000000000000010000',
            '2,4,6-trichlorophenol': '00000000000000000000000000000000000000000000000001000000000000000010000000000000000000000001000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000100000000000000001000000001000010000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000001000000000000000000100000010010000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'diazinon': '01000000000000000000000010000000011000000000000000000000000000000000000000000000100001100100000001000000000000000000000000000000000000000000000000000000000000000000000100000000000110010010000011010000000000000000001000000000000000000000000000000000100000000000000000000000000000000001000000000010000000000000000000000001000100000000000001000000000000100000100000010000000000000010000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000100000010001000000000000000',
            'paraquat': '00000000000000100000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000100000000000000000100000000000000000000000000000000001000000000000000000000000000000000000000000000000100000000000000000000000000000000000000001000000000000000000000000000000001000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000001000000000000000000000000000100000000000000000000',
            'phenol': '00000000000000000000000000000000000000000000000000000000000000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000001000000000000000000100000000100000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000001000000000000000000100000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'aminomethylphosphonic acid': '00000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000010000000000000000000000000000000000000000000010000000010000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000001000000000000000010000000000000000000000000',
            'chlorpyriphos': '00010000000000000000000010000000010000000000000001000001000000000000000000000000100001000000000001000000000000000000000000000000000000000000000000010000000000000000000100000000000110010000000011000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000001000000000000100001110000000000000000100000010010000000000010000000000000000000000100000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000',
            'xearalenone': '00001100000000000000000000000000010100010000000000000000000000001010000100000000000000000000000000000000100000000000000000010000000000000010000011000000000001000000000100000000000000000000000000000000001000110001001000000000010000000100001000000000010000000001000000000000010000000000010000000001000001100000000000100000000000000000000001000000000000000001100000010000000000000000000000000000000000000000000010000010000000001000000000000000000000000000000001000000000000000101000000000000000000000000000000010000',
            'aldicarb': '00000000000000000000000000000000010000000000000000000000000000000000000000000010000000000000000000000000000000000010110000000000100000000010100000000000000000000001000100000000000000110000000000000000000000000000010010000010000000001000000000000000000000000000000000000000000000001000100000001001000000000000000000000000000000000000000000000000010000000000000010000000000000000000010000000000101000000000001000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000',
        }

        return bit_vector