#!/usr/bin/env python3
#
# GlobalChem - Schedule Two
#
# -----------------------------------

class ScheduleThree(object):

    def __init__(self):

        self.name = 'schedule_three'

    @staticmethod
    def get_smiles():

        smiles = {
            'norfentanyl': 'CCC(=O)N(C1CCNCC1)C2=CC=CC=C2',
            'benzphetamine': 'CC(CC1=CC=CC=C1)N(C)CC2=CC=CC=C2',
            'chlorphentermine': 'CN(C)CCC(C1=CC=C(C=C1)Cl)C2=CC=CC=N2',
            'clortermine': 'CC(C)(CC1=CC=CC=C1Cl)N',
            'phendimetrazine': 'CC1C(OCCN1C)C2=CC=CC=C2',
            'amobarbital': 'CCC1(C(=O)NC(=O)NC1=O)CCC(C)C',
            'secobarbital': 'CCCC(C)C1(C(=O)NC(=O)NC1=O)CC=C',
            'pentobarbital': 'CCCC(C)C1(C(=O)NC(=O)NC1=O)CC',
            'chlorhexadol': 'CC(CC(C)(C)O)OC(C(Cl)(Cl)Cl)O',
            'embutramide': 'CCC(CC)(CNC(=O)CCCO)C1=CC(=CC=C1)OC',
            'ketamine': 'CNC1(CCCCC1=O)C2=CC=CC=C2Cl',
            'lysergicacid': 'CN1CC(C=C2C1CC3=CNC4=CC=CC2=C34)C(=O)O',
            'lysergicacidamide': 'CN1CC(C=C2C1CC3=CNC4=CC=CC2=C34)C(=O)N',
            'methyprylon': 'CCC1(C(=O)C(CNC1=O)C)CC',
            'perampanel': 'C1=CC=C(C=C1)N2C=C(C=C(C2=O)C3=CC=CC=C3C#N)C4=CC=CC=N4',
            'sulfondiethylmethane': 'CCC(CC)(S(=O)(=O)CC)S(=O)(=O)CC',
            'sulfonethylmethane': 'CCC(C)(S(=O)(=O)CC)S(=O)(=O)CC',
            'sulfonmethane': 'O=S(=O)(C(C)(C)S(=O)(=O)CC)CC',
            'tiletamine': 'CCNC1(CCCCC1=O)C2=CC=CS2',
            'nalorphine_9400': 'C=CCN1CCC23C4C1CC5=C2C(=C(C=C5)O)OC3C(C=C4)O',
            'flupyrazapon': 'CC1=NN(C2=C1C(=NCC(=O)N2C)C3=CC=CC=C3F)C',
            'buprenorphine': 'CC(C)(C)C(C)(C1CC23CCC1(C4C25CCN(C3CC6=C5C(=C(C=C6)O)O4)CC7CC7)OC)O',
        }

        return smiles

    @staticmethod
    def get_smarts():

        smarts = {
            'norfentanyl': '[#6]-[#6]-[#6](=[#8])-[#7](-[#6]1-[#6]-[#6]-[#7]-[#6]-[#6]-1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'benzphetamine': '[#6]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#7](-[#6])-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'chlorphentermine': '[#6]-[#7](-[#6])-[#6]-[#6]-[#6](-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#17])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#7]:1',
            'clortermine': '[#6]-[#6](-[#6])(-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#17])-[#7]',
            'phendimetrazine': '[#6]-[#6]1-[#6](-[#8]-[#6]-[#6]-[#7]-1-[#6])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'amobarbital': '[#6]-[#6]-[#6]1(-[#6](=[#8])-[#7]-[#6](=[#8])-[#7]-[#6]-1=[#8])-[#6]-[#6]-[#6](-[#6])-[#6]',
            'secobarbital': '[#6]-[#6]-[#6]-[#6](-[#6])-[#6]1(-[#6](=[#8])-[#7]-[#6](=[#8])-[#7]-[#6]-1=[#8])-[#6]-[#6]=[#6]',
            'pentobarbital': '[#6]-[#6]-[#6]-[#6](-[#6])-[#6]1(-[#6](=[#8])-[#7]-[#6](=[#8])-[#7]-[#6]-1=[#8])-[#6]-[#6]',
            'chlorhexadol': '[#6]-[#6](-[#6]-[#6](-[#6])(-[#6])-[#8])-[#8]-[#6](-[#6](-[#17])(-[#17])-[#17])-[#8]',
            'embutramide': '[#6]-[#6]-[#6](-[#6]-[#6])(-[#6]-[#7]-[#6](=[#8])-[#6]-[#6]-[#6]-[#8])-[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1)-[#8]-[#6]',
            'ketamine': '[#6]-[#7]-[#6]1(-[#6]-[#6]-[#6]-[#6]-[#6]-1=[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#17]',
            'lysergicacid': '[#6]-[#7]1-[#6]-[#6](-[#6]=[#6]2-[#6]-1-[#6]-[#6]1:[#6]:[#7H]:[#6]3:[#6]:[#6]:[#6]:[#6]-2:[#6]:1:3)-[#6](=[#8])-[#8]',
            'lysergicacidamide': '[#6]-[#7]1-[#6]-[#6](-[#6]=[#6]2-[#6]-1-[#6]-[#6]1:[#6]:[#7H]:[#6]3:[#6]:[#6]:[#6]:[#6]-2:[#6]:1:3)-[#6](=[#8])-[#7]',
            'methyprylon': '[#6]-[#6]-[#6]1(-[#6](=[#8])-[#6](-[#6]-[#7]-[#6]-1=[#8])-[#6])-[#6]-[#6]',
            'perampanel': '[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#7]1:[#6]:[#6](:[#6]:[#6](:[#6]:1=[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#6]#[#7])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#7]:1',
            'sulfondiethylmethane': '[#6]-[#6]-[#6](-[#6]-[#6])(-[#16](=[#8])(=[#8])-[#6]-[#6])-[#16](=[#8])(=[#8])-[#6]-[#6]',
            'sulfonethylmethane': '[#6]-[#6]-[#6](-[#6])(-[#16](=[#8])(=[#8])-[#6]-[#6])-[#16](=[#8])(=[#8])-[#6]-[#6]',
            'sulfonmethane': '[#8]=[#16](=[#8])(-[#6](-[#6])(-[#6])-[#16](=[#8])(=[#8])-[#6]-[#6])-[#6]-[#6]',
            'tiletamine': '[#6]-[#6]-[#7]-[#6]1(-[#6]-[#6]-[#6]-[#6]-[#6]-1=[#8])-[#6]1:[#6]:[#6]:[#6]:[#16]:1',
            'nalorphine_9400': '[#6]=[#6]-[#6]-[#7]1-[#6]-[#6]-[#6]23-[#6]4-[#6]-1-[#6]-[#6]1:[#6]-2:[#6](:[#6](:[#6]:[#6]:1)-[#8])-[#8]-[#6]-3-[#6](-[#6]=[#6]-4)-[#8]',
            'flupyrazapon': '[#6]-[#6]1:[#7]:[#7](:[#6]2:[#6]:1-[#6](=[#7]-[#6]-[#6](=[#8])-[#7]-2-[#6])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#9])-[#6]',
            'buprenorphine': '[#6]-[#6](-[#6])(-[#6])-[#6](-[#6])(-[#6]1-[#6]-[#6]23-[#6]-[#6]-[#6]-1(-[#6]1-[#6]-24-[#6]-[#6]-[#7](-[#6]-3-[#6]-[#6]2:[#6]-4:[#6](:[#6](:[#6]:[#6]:2)-[#8])-[#8]-1)-[#6]-[#6]1-[#6]-[#6]-1)-[#8]-[#6])-[#8]',
        }

        return smarts

    @staticmethod
    def get_bit_vector():

        bit_vector = {
            'norfentanyl': '10000000000000000000000000010000010000000000000000000000000000001000000010000010100000000010010000000000000000000000000000000000000000000010000000000000000100000000000000000001000000000000000000000000000000000000001000000000000000000000000000000000000000000000000010000000000000000000100010001011010001000100000000000000000000000000000001000000001000000000100000000000010000000000010000100100000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000010000',
            'benzphetamine': '01000000000000000000000000000000010000000010001000000000000000001000000100000101100000000000000000000000000000000000000000010000000000000001010000000000000000000000000000000001000000000000000000000000000000000000001000100000000000000000000000000000000000000000000000000000000000000001000000000010000000000000000000000000000000000000000001000000010000000000100000000000010000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000010000',
            'chlorphentermine': '01000000000000000100000000000000010000000000001001000001000000001000000000010000100000000010000000000000000000000000000000000000000100000001100000010000000000000000000000000001000001000010000000000000000000000000001010000000001100000000000000000000000000000000000000000000000000000000000000000000000000001000000000000100000000000010010001000100000000000000100000000000010000000010000000000100000000000000000000000001000000000000100000000000000000001000000000000000000000000000000000000000000000000000010000000000',
            'clortermine': '00000100000000000000000000000000010000000000001001000000000001001000000000000000100000000000000000000000000000000010000000000000000000000000000000010000000000101001000000000001000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000001000000000001000000000000000000100000000010000000001000000000000000100000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000',
            'phendimetrazine': '00000000000000000000100000000000010000000000000000000010000000001000000001000000000000000000000000000000000000000000000001000001000000000000000010000000000000000000000000000001000000000000000000000000000000000000101000000000000000000000000000000000000000010000000000000000000000000000010000100000000000000000000000000000000000000000000001000000000000000000100000000000000000000000000000000100100000000010000000000010000000010000000000000010000000000000000110000000000000010000000000000010000000000000000000010000',
            'amobarbital': '01000000000000000000000000000000010010000000000000000000001000000000000000000000100000000010000000000000000000010000000000000000000000000010000000000000000000000000000000000000000000000000000000000000010000000000000000000000100100000000000000010000000000000000000000000000000000000001000000000010000000000000000100100000000011010000000000000000000000000000100000000000000000000000000000000000000000010000000000000000000000000000000000000010100000000000000000000000000000000000000000000000000000000000000100000000',
            'secobarbital': '01000000000010000000000000000000010010000000000000000000000000000000000000000000100000000010000000000000000001000000000000000000000000100010000000000000000000000000000000000000000000100000000000000000010001000000000000000000000100000000000000010000000000000000000000000000000000000011000010000010000000000000001010100000000000000000000000000010000000000000101000000000000000000000000000000000000000000000000000000000000000000000100100000010100000000000000000000000000000000000000000000000000000000000000000000000',
            'pentobarbital': '01000000000010000000000000000000010010000000000000000000000000000000000000000000100001000010000000000000000000000000000000000000000000100010000000000000000000000000000000000000000000000000000000000000010000000000000000000000000100000000000000010000000000000000000000000000000000000011000010000010000000000000001010100000000000010000000000000000000000000000100000000000000001000000000000000000000000000000000000000000000000000000000000000010100000000000000000000000000000000000000000000000000000000000000000000000',
            'chlorhexadol': '01000000100000000000000000000000110000000000000000000000000000000000000000000000100000000000000000000000000000000010000000000000000000000000000000110001000000000000100010000001000000010000000000000000000000000000000000000000010100000000000000000000000000000000000000000000000000000001000000010001000000000000000011000000000000000000000000000001000000000000000000000000000010000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000',
            'embutramide': '10000000000000010000001000001000010000000100000000100100000000001000000000000000100000000000000000000000101000000010000010000000100000000010000000000000000000000000000000000000000000110000000000000100000000000000001000000010000000000000000000000000000000000000000000000100000001000000000000000011000000000000000000000000001000000100000001000000000001000000100000010000010000010000010000000000010000000000000000000000000000000000000000001000000000000000000000001000000000000100000001000000000000000100000000000100',
            'ketamine': '00001000000000000000000000100000010010000000000001000000000000001000000000000000000000000000001000000010000000000000000000000000100001000010000000010100000000001010000000000001000000000000000000000000001000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000100001000000000000000001000000000000000000100000000010000000000000000000000000000010100000001000000010000000000000000000001000000010000000000000000010000000000000000000000000000000000000000000000000',
            'lysergicacid': '00000000000010010000000000000000010000010000000000000000000000001000000000000000000000000010000000100000000000000000000101000000000000000010000000000000000000000000000000000000000000000000000000000000010010000000101000000000000100110000000000000001000000000000000000010100000000000000000010000011000000000000000000000000000100000000000001000001000000001100100000000000000000000000010000000100000000000100001100000010000000011000000000000000000000001000000000010000000000001001010000000110000000000000000000010000',
            'lysergicacidamide': '00000000000010010000000000000000010000010000000000000000000000001000000000000000000000001010000000100000000000000000000101000000000000000010100000010000000000000000000000000000000000000000000000000000010110000000101000000000000100110000000000000001000000000000000000010100000000000000000010000011000000000000000000000000000100000000000001000001000000001100100000000000000000000000010000000000000000000100001000000010000000011000000000000000000000001000000000010000000000001000010000000010000000000000000000010000',
            'methyprylon': '00000000000000000000000000000000010010000000000000000000000000000000000000000000100010000010000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000001000010000000000010000000000100000000000000000000000000000000000000000000000000000000000010000000010010000000000000000100000000000010010000000001000000000000000100000000000000000000000000000000000000000000000000000000010000000000010000000000000000000000000000000000000000000100000000000000000000100000000000100010000',
            'perampanel': '00000000000000000000000001000000000000100000000000001000000000001000000000000000000000000000000000000000000000001000000000000000000100001010000000000000000000000010000000000011000000000000000000001000000000000100001000000000000000000000100000001000000000000000000000000000000000100000000001000000000000010000000000111000000000100010000001010000000000001000100011010000000000000010000000000100000000000000000000000000000000010000100000000000000000001100000000000100100010001001000000000000000000000000000010000000',
            'sulfondiethylmethane': '00000000000000000000000000001000010000000000000000000000000000010000000000000000100000000000000000000000000000000010000000000000000000000010000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000001000000000000000000000000000000000000000000000000100000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000001000100000000000000000000000000000000000000000000000000000000000',
            'sulfonethylmethane': '00000000000000000000000100000000010000010000000000000000000000000000000000000000100000000000000001000000000000000010000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000000000000000000000000000000000000000000100000000000000100000000000000000000000000100000000000000000000000000000000000000000000000000000001000100000000000000000000000000000000000000000000000000000000000',
            'sulfonmethane': '00000000000000000000000000000000010000000000010000000000000000000000000000000000100000000000000000000000000000000010000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000100000100000000100000000000000000000000000100000000000000000000000000000000000000000000000000000001000100000000000000000000000000100000000000000000000000000000000',
            'tiletamine': '00001000000000100000000000000001010010000000000000000000000000001000000000000000100000000000001010100010000000000000000000000000100000000010001000000000000000000011000000000000000000000000001000000000001000000010001000000000000000000000000001000000000000000000000000000000010000000000000000000010000000000000001000100001000000000000000001000000000000000000100000000000000000000000000100000000000010000000000000000010000000000000000000000000000000000000000010100000000000000000000000000000000000000000000000000000',
            'nalorphine_9400': '00000000000000010000010000000000000010000010100000000000010100000011100100000100100000000000000000000000000001000000000000000000000000010010000010010010010000000000000000000000000000100000000001000000000000000001101000000000000000010100001000000000000000000000000000000010000000000000100000000001100100000100000100000000000000000000000001000010000000000000100001000000000000000000000000000000000000000000000010000010000000010000100000000000000010000001000010000000000000000000000100000010000000000100000000010000',
            'flupyrazapon': '00100000100000000000000000000000010000000000000000000000000000001000000000000000010000000000100000100000000000001000000001000000000000010010000000001000000000000000000000000001000000000011000000000000000000000001101000001000000000000000000000000000000001000000001000000000000001000000001000000000000000001000000000100010000000000000000001000000010000001000100000000000010000000010000000000000100000000000000000000010000010010000000000000000000000000011000000000000000000001001000000000000000000000000000001000000',
            'buprenorphine': '00000000000000010010010000000100010010100000100000000000000000000010000100000000100000100000000000000000000000000010000000000000000000010110000010000010000000100000000100000000000000010000000000000000000000000000101000000000110000010000001000100000100000100000000010010010100010000000000000000001000001000000000100000000000000000100000001100000000000000000100000000000000011000100000000000100100010000010000000000010000000011100000000000000000010001001000010000000000000000000000000000010000000000001000000010100',
        }

        return bit_vector