#!/usr/bin/env python3
#
# GlobalChem - Schedule Two
#
# -----------------------------------

class ScheduleTwo(object):

    def __init__(self):

        self.name = 'schedule_two'

    @staticmethod
    def get_smiles():

        smiles = {
            'codeine': 'CN1CCC23C4C1CC5=C2C(=C(C=C5)OC)OC3C(C=C4)O',
            'dihydroetorphine': 'CCCC(C)(C1CC23CCC1(C4C25CCN(C3CC6=C5C(=C(C=C6)O)O4)C)OC)O',
            'ethylmorphine': 'CCOC1=C2C3=C(CC4C5C3(CCN4C)C(O2)C(C=C5)O)C=C1',
            'etorphinehydrochloride': 'CCCC(C)(C1CC23C=CC1(C4C25CCN(C3CC6=C5C(=C(C=C6)O)O4)C)OC)O.Cl',
            'granulated-opium': 'CN1CCC23C4C1CC5=C2C(=C(C=C5)O)OC3C(C=C4)O',
            'hydrocodone': 'CN1CCC23C4C1CC5=C2C(=C(C=C5)OC)OC3C(=O)CC4',
            'hydromorphone': 'CN1CCC23C4C1CC5=C2C(=C(C=C5)O)OC3C(=O)CC4',
            'metopon': 'CC12C(=O)CCC3C14CCN(C3CC5=C4C(=C(C=C5)O)O2)C',
            'morphine': 'CN1CCC23C4C1CC5=C2C(=C(C=C5)O)OC3C(C=C4)O',
            'noroxymorphone': 'C1CC2(C3CC4=C5C2(CCN3)C(C1=O)OC5=C(C=C4)O)O',
            'oripavine': 'CN1CCC23C4C(=CC=C2C1CC5=C3C(=C(C=C5)O)O4)OC',
            'oxycodone': 'CN1CCC23C4C(=O)CCC2(C1CC5=C3C(=C(C=C5)OC)O4)O',
            'oxymorphone': 'CN1CC[C@]23[C@H]4OC5=C(O)C=CC(C[C@@H]1[C@]2(O)CCC4=O)=C35',
            'thebaine': 'CN1CCC23C4C(=CC=C2C1CC5=C3C(=C(C=C5)OC)O4)OC',
            'alfentanil': 'CCC(=O)N(C1=CC=CC=C1)C2(CCN(CC2)CCN3C(=O)N(N=N3)CC)COC',
            'alphaprodine': 'CCC(=O)OC1(CCN(CC1C)C)C2=CC=CC=C2',
            'anileridine': 'CCOC(=O)C1(CCN(CC1)CCC2=CC=C(C=C2)N)C3=CC=CC=C3',
            'bezitramide': 'CCC(=O)N1C2=CC=CC=C2N(C1=O)C3CCN(CC3)CCC(C#N)(C4=CC=CC=C4)C5=CC=CC=C5',
            'dextropropoxyphene': 'CCC(=O)OC(CC1=CC=CC=C1)(C2=CC=CC=C2)C(C)CN(C)C',
            'carfentanil': 'CCC(=O)N(C1=CC=CC=C1)C2(CCN(CC2)CCC3=CC=CC=C3)C(=O)OC',
            'dihydrocodeine': 'CN1CCC23C4C1CC5=C2C(=C(C=C5)OC)OC3C(CC4)O',
            'diphenoxylate': 'CCOC(=O)C1(CCN(CC1)CCC(C#N)(C2=CC=CC=C2)C3=CC=CC=C3)C4=CC=CC=C4',
            'fentanyl': 'CCC(=O)N(C1CCN(CC1)CCC2=CC=CC=C2)C3=CC=CC=C3',
            'isomethadone': 'CCC(=O)C(C1=CC=CC=C1)(C2=CC=CC=C2)C(C)CN(C)C',
            'levo-alphacetylmethadol': 'CC[C@]([H])(C(C[C@@]([H])(C)N(C)C)(c1ccccc1)c2ccccc2)OC(=O)C',
            'levomethorphan': 'CN1CCC23CCCCC2C1CC4=C3C=C(C=C4)OC',
            'levorphanol': 'CN1CCC23CCCCC2C1CC4=C3C=C(C=C4)O',
            'metazocine': 'CC1C2CC3=C(C1(CCN2C)C)C=C(C=C3)O',
            'methadone': 'CCC(=O)C(CC(C)N(C)C)(C1=CC=CC=C1)C2=CC=CC=C2',
            'methadone-intermediate': 'CC(CC(C#N)(C1=CC=CC=C1)C2=CC=CC=C2)N(C)C',
            'moramide-intermediate': 'O=C(O)C(c1ccccc1)(c2ccccc2)C(C)CN3CCOCC3',
            'oliceridine': 'COC1=C(SC=C1)CNCCC2(CCOC3(C2)CCCC3)C4=CC=CC=N4',
            'pethidine': 'O=C(C1(CCN(CC1)C)C2=CC=CC=C2)OCC',
            'pethidine-intermediate-a': 'CN1CCC(CC1)(C#N)c2ccccc2',
            'pethidine-intermediate-b': 'O=C(OCC)C2(c1ccccc1)CCNCC2',
            'pethidine-intermediate-c': 'CN1CCC(CC1)(C2=CC=CC=C2)C(=O)O',
            'phenazocine': 'CC1C2CC3=C(C1(CCN2CCC4=CC=CC=C4)C)C=C(C=C3)O',
            'piminodine': 'CCOC(=O)C1(CCN(CC1)CCCNC2=CC=CC=C2)C3=CC=CC=C3',
            'racemethorphan': 'CN1CCC23CCCCC2C1CC4=C3C=C(C=C4)OC',
            'racemorphan': 'CN1CCC23CCCCC2C1CC4=C3C=C(C=C4)O',
            'remifentanil': 'CCC(=O)N(C1=CC=CC=C1)C2(CCN(CC2)CCC(=O)OC)C(=O)OC',
            'sufentanil': 'CCC(=O)N(C1=CC=CC=C1)C2(CCN(CC2)CCC3=CC=CS3)COC',
            'tapentadol': 'CCC(C1=CC(=CC=C1)O)C(C)CN(C)C',
            'thiafentanil': 'COCC(=O)N(C1=CC=CC=C1)C2(CCN(CC2)CCC3=CC=CS3)C(=O)OC',
            'amphetamine': 'CC(CC1=CC=CC=C1)N',
            'methamphetamine': 'CC(CC1=CC=CC=C1)NC',
            'phenmetrazine': 'CC1C(OCCN1)C2=CC=CC=C2',
            'methylphenidate': 'COC(=O)C(C1CCCCN1)C2=CC=CC=C2',
            'lisdexamfetamine': 'CC(CC1=CC=CC=C1)NC(=O)C(CCCCN)N',
            'amobarbital': 'CCC1(C(=O)NC(=O)NC1=O)CCC(C)C',
            'glutethimide': 'CCC1(CCC(=O)NC1=O)C2=CC=CC=C2',
            'pentobarbital': 'CCCC(C)C1(C(=O)NC(=O)NC1=O)CC',
            'phencyclidine': 'C1CCC(CC1)(C2=CC=CC=C2)N3CCCCC3',
            'secobarbital': 'CCCC(C)C1(C(=O)NC(=O)NC1=O)CC=C',
            'nabilone': 'CCCCCCC(C)(C)C1=CC(=C2C3CC(=O)CCC3C(OC2=C1)(C)C)O',
            'dronabinol': 'CCCCCC1=CC(=C2C3C=C(CCC3C(OC2=C1)(C)C)C)O',
            'phenylacetone': 'CC(=O)CC1=CC=CC=C1',
            '1-phenylcyclohexylamine': 'C1CCC(CC1)(C2=CC=CC=C2)N',
            '1-piperidinocyclohexanecarbonitrile': 'C1CCC(CC1)(C#N)N2CCCCC2',
            '4-anilino-n-phenethylpiperidine': 'C1CN(CCC1NC2=CC=CC=C2)CCC3=CC=CC=C3',
        }

        return smiles

    @staticmethod
    def get_smarts():

        smarts = {
            'codeine': '[#6]-[#7]1-[#6]-[#6]-[#6]23-[#6]4-[#6]-1-[#6]-[#6]1:[#6]-2:[#6](:[#6](:[#6]:[#6]:1)-[#8]-[#6])-[#8]-[#6]-3-[#6](-[#6]=[#6]-4)-[#8]',
            'dihydroetorphine': '[#6]-[#6]-[#6]-[#6](-[#6])(-[#6]1-[#6]-[#6]23-[#6]-[#6]-[#6]-1(-[#6]1-[#6]-24-[#6]-[#6]-[#7](-[#6]-3-[#6]-[#6]2:[#6]-4:[#6](:[#6](:[#6]:[#6]:2)-[#8])-[#8]-1)-[#6])-[#8]-[#6])-[#8]',
            'ethylmorphine': '[#6]-[#6]-[#8]-[#6]1:[#6]2:[#6]3:[#6](-[#6]-[#6]4-[#6]5-[#6]-3(-[#6]-[#6]-[#7]-4-[#6])-[#6](-[#8]-2)-[#6](-[#6]=[#6]-5)-[#8]):[#6]:[#6]:1',
            'etorphinehydrochloride': '[#6]-[#6]-[#6]-[#6](-[#6])(-[#6]1-[#6]-[#6]23-[#6]=[#6]-[#6]-1(-[#6]1-[#6]-24-[#6]-[#6]-[#7](-[#6]-3-[#6]-[#6]2:[#6]-4:[#6](:[#6](:[#6]:[#6]:2)-[#8])-[#8]-1)-[#6])-[#8]-[#6])-[#8].[#17]',
            'granulated-opium': '[#6]-[#7]1-[#6]-[#6]-[#6]23-[#6]4-[#6]-1-[#6]-[#6]1:[#6]-2:[#6](:[#6](:[#6]:[#6]:1)-[#8])-[#8]-[#6]-3-[#6](-[#6]=[#6]-4)-[#8]',
            'hydrocodone': '[#6]-[#7]1-[#6]-[#6]-[#6]23-[#6]4-[#6]-1-[#6]-[#6]1:[#6]-2:[#6](:[#6](:[#6]:[#6]:1)-[#8]-[#6])-[#8]-[#6]-3-[#6](=[#8])-[#6]-[#6]-4',
            'hydromorphone': '[#6]-[#7]1-[#6]-[#6]-[#6]23-[#6]4-[#6]-1-[#6]-[#6]1:[#6]-2:[#6](:[#6](:[#6]:[#6]:1)-[#8])-[#8]-[#6]-3-[#6](=[#8])-[#6]-[#6]-4',
            'metopon': '[#6]-[#6]12-[#6](=[#8])-[#6]-[#6]-[#6]3-[#6]-14-[#6]-[#6]-[#7](-[#6]-3-[#6]-[#6]1:[#6]-4:[#6](:[#6](:[#6]:[#6]:1)-[#8])-[#8]-2)-[#6]',
            'morphine': '[#6]-[#7]1-[#6]-[#6]-[#6]23-[#6]4-[#6]-1-[#6]-[#6]1:[#6]-2:[#6](:[#6](:[#6]:[#6]:1)-[#8])-[#8]-[#6]-3-[#6](-[#6]=[#6]-4)-[#8]',
            'noroxymorphone': '[#6]1-[#6]-[#6]2(-[#6]3-[#6]-[#6]4:[#6]5-[#6]-2(-[#6]-[#6]-[#7]-3)-[#6](-[#6]-1=[#8])-[#8]-[#6]:5:[#6](:[#6]:[#6]:4)-[#8])-[#8]',
            'oripavine': '[#6]-[#7]1-[#6]-[#6]-[#6]23-[#6]4-[#6](=[#6]-[#6]=[#6]-2-[#6]-1-[#6]-[#6]1:[#6]-3:[#6](:[#6](:[#6]:[#6]:1)-[#8])-[#8]-4)-[#8]-[#6]',
            'oxycodone': '[#6]-[#7]1-[#6]-[#6]-[#6]23-[#6]4-[#6](=[#8])-[#6]-[#6]-[#6]-2(-[#6]-1-[#6]-[#6]1:[#6]-3:[#6](:[#6](:[#6]:[#6]:1)-[#8]-[#6])-[#8]-4)-[#8]',
            'oxymorphone': '[#6]-[#7]1-[#6]-[#6]-[#6@]23-[#6@H]4-[#8]-[#6]5:[#6](-[#8]):[#6]:[#6]:[#6](-[#6]-[#6@@H]-1-[#6@]-2(-[#8])-[#6]-[#6]-[#6]-4=[#8]):[#6]:5-3',
            'thebaine': '[#6]-[#7]1-[#6]-[#6]-[#6]23-[#6]4-[#6](=[#6]-[#6]=[#6]-2-[#6]-1-[#6]-[#6]1:[#6]-3:[#6](:[#6](:[#6]:[#6]:1)-[#8]-[#6])-[#8]-4)-[#8]-[#6]',
            'alfentanil': '[#6]-[#6]-[#6](=[#8])-[#7](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1(-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#7]1:[#6](=[#8]):[#7](:[#7]:[#7]:1)-[#6]-[#6])-[#6]-[#8]-[#6]',
            'alphaprodine': '[#6]-[#6]-[#6](=[#8])-[#8]-[#6]1(-[#6]-[#6]-[#7](-[#6]-[#6]-1-[#6])-[#6])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'anileridine': '[#6]-[#6]-[#8]-[#6](=[#8])-[#6]1(-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#7])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'bezitramide': '[#6]-[#6]-[#6](=[#8])-[#7]1:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2:[#7](:[#6]:1=[#8])-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#6](-[#6]#[#7])(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'dextropropoxyphene': '[#6]-[#6]-[#6](=[#8])-[#8]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#6])-[#6]-[#7](-[#6])-[#6]',
            'carfentanil': '[#6]-[#6]-[#6](=[#8])-[#7](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1(-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](=[#8])-[#8]-[#6]',
            'dihydrocodeine': '[#6]-[#7]1-[#6]-[#6]-[#6]23-[#6]4-[#6]-1-[#6]-[#6]1:[#6]-2:[#6](:[#6](:[#6]:[#6]:1)-[#8]-[#6])-[#8]-[#6]-3-[#6](-[#6]-[#6]-4)-[#8]',
            'diphenoxylate': '[#6]-[#6]-[#8]-[#6](=[#8])-[#6]1(-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#6](-[#6]#[#7])(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'fentanyl': '[#6]-[#6]-[#6](=[#8])-[#7](-[#6]1-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'isomethadone': '[#6]-[#6]-[#6](=[#8])-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#6])-[#6]-[#7](-[#6])-[#6]',
            'levo-alphacetylmethadol': '[#6]-[#6]-[#6@H](-[#6](-[#6]-[#6@@H](-[#6])-[#7](-[#6])-[#6])(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#8]-[#6](=[#8])-[#6]',
            'levomethorphan': '[#6]-[#7]1-[#6]-[#6]-[#6]23-[#6]-[#6]-[#6]-[#6]-[#6]-2-[#6]-1-[#6]-[#6]1:[#6]-3:[#6]:[#6](:[#6]:[#6]:1)-[#8]-[#6]',
            'levorphanol': '[#6]-[#7]1-[#6]-[#6]-[#6]23-[#6]-[#6]-[#6]-[#6]-[#6]-2-[#6]-1-[#6]-[#6]1:[#6]-3:[#6]:[#6](:[#6]:[#6]:1)-[#8]',
            'metazocine': '[#6]-[#6]1-[#6]2-[#6]-[#6]3:[#6](-[#6]-1(-[#6]-[#6]-[#7]-2-[#6])-[#6]):[#6]:[#6](:[#6]:[#6]:3)-[#8]',
            'methadone': '[#6]-[#6]-[#6](=[#8])-[#6](-[#6]-[#6](-[#6])-[#7](-[#6])-[#6])(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'methadone-intermediate': '[#6]-[#6](-[#6]-[#6](-[#6]#[#7])(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#7](-[#6])-[#6]',
            'moramide-intermediate': '[#8]=[#6](-[#8])-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#6])-[#6]-[#7]1-[#6]-[#6]-[#8]-[#6]-[#6]-1',
            'oliceridine': '[#6]-[#8]-[#6]1:[#6](:[#16]:[#6]:[#6]:1)-[#6]-[#7]-[#6]-[#6]-[#6]1(-[#6]-[#6]-[#8]-[#6]2(-[#6]-1)-[#6]-[#6]-[#6]-[#6]-2)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#7]:1',
            'pethidine': '[#8]=[#6](-[#6]1(-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#8]-[#6]-[#6]',
            'pethidine-intermediate-a': '[#6]-[#7]1-[#6]-[#6]-[#6](-[#6]-[#6]-1)(-[#6]#[#7])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'pethidine-intermediate-b': '[#8]=[#6](-[#8]-[#6]-[#6])-[#6]1(-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2)-[#6]-[#6]-[#7]-[#6]-[#6]-1',
            'pethidine-intermediate-c': '[#6]-[#7]1-[#6]-[#6]-[#6](-[#6]-[#6]-1)(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](=[#8])-[#8]',
            'phenazocine': '[#6]-[#6]1-[#6]2-[#6]-[#6]3:[#6](-[#6]-1(-[#6]-[#6]-[#7]-2-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]):[#6]:[#6](:[#6]:[#6]:3)-[#8]',
            'piminodine': '[#6]-[#6]-[#8]-[#6](=[#8])-[#6]1(-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#6]-[#7]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'racemethorphan': '[#6]-[#7]1-[#6]-[#6]-[#6]23-[#6]-[#6]-[#6]-[#6]-[#6]-2-[#6]-1-[#6]-[#6]1:[#6]-3:[#6]:[#6](:[#6]:[#6]:1)-[#8]-[#6]',
            'racemorphan': '[#6]-[#7]1-[#6]-[#6]-[#6]23-[#6]-[#6]-[#6]-[#6]-[#6]-2-[#6]-1-[#6]-[#6]1:[#6]-3:[#6]:[#6](:[#6]:[#6]:1)-[#8]',
            'remifentanil': '[#6]-[#6]-[#6](=[#8])-[#7](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1(-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#6](=[#8])-[#8]-[#6])-[#6](=[#8])-[#8]-[#6]',
            'sufentanil': '[#6]-[#6]-[#6](=[#8])-[#7](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1(-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#16]:1)-[#6]-[#8]-[#6]',
            'tapentadol': '[#6]-[#6]-[#6](-[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1)-[#8])-[#6](-[#6])-[#6]-[#7](-[#6])-[#6]',
            'thiafentanil': '[#6]-[#8]-[#6]-[#6](=[#8])-[#7](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]1(-[#6]-[#6]-[#7](-[#6]-[#6]-1)-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#16]:1)-[#6](=[#8])-[#8]-[#6]',
            'amphetamine': '[#6]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#7]',
            'methamphetamine': '[#6]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#7]-[#6]',
            'phenmetrazine': '[#6]-[#6]1-[#6](-[#8]-[#6]-[#6]-[#7]-1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'methylphenidate': '[#6]-[#8]-[#6](=[#8])-[#6](-[#6]1-[#6]-[#6]-[#6]-[#6]-[#7]-1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'lisdexamfetamine': '[#6]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#7]-[#6](=[#8])-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#7]',
            'amobarbital': '[#6]-[#6]-[#6]1(-[#6](=[#8])-[#7]-[#6](=[#8])-[#7]-[#6]-1=[#8])-[#6]-[#6]-[#6](-[#6])-[#6]',
            'glutethimide': '[#6]-[#6]-[#6]1(-[#6]-[#6]-[#6](=[#8])-[#7]-[#6]-1=[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'pentobarbital': '[#6]-[#6]-[#6]-[#6](-[#6])-[#6]1(-[#6](=[#8])-[#7]-[#6](=[#8])-[#7]-[#6]-1=[#8])-[#6]-[#6]',
            'phencyclidine': '[#6]1-[#6]-[#6]-[#6](-[#6]-[#6]-1)(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#7]1-[#6]-[#6]-[#6]-[#6]-[#6]-1',
            'secobarbital': '[#6]-[#6]-[#6]-[#6](-[#6])-[#6]1(-[#6](=[#8])-[#7]-[#6](=[#8])-[#7]-[#6]-1=[#8])-[#6]-[#6]=[#6]',
            'nabilone': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#6])(-[#6])-[#6]1:[#6]:[#6](:[#6]2-[#6]3-[#6]-[#6](=[#8])-[#6]-[#6]-[#6]-3-[#6](-[#8]-[#6]:2:[#6]:1)(-[#6])-[#6])-[#8]',
            'dronabinol': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6]2-[#6]3-[#6]=[#6](-[#6]-[#6]-[#6]-3-[#6](-[#8]-[#6]:2:[#6]:1)(-[#6])-[#6])-[#6])-[#8]',
            'phenylacetone': '[#6]-[#6](=[#8])-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            '1-phenylcyclohexylamine': '[#6]1-[#6]-[#6]-[#6](-[#6]-[#6]-1)(-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#7]',
            '1-piperidinocyclohexanecarbonitrile': '[#6]1-[#6]-[#6]-[#6](-[#6]-[#6]-1)(-[#6]#[#7])-[#7]1-[#6]-[#6]-[#6]-[#6]-[#6]-1',
            '4-anilino-n-phenethylpiperidine': '[#6]1-[#6]-[#7](-[#6]-[#6]-[#6]-1-[#7]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
        }

        return smarts

    @staticmethod
    def get_bit_vector():

        bit_vector = {
            'codeine': '10000000000000010000010000000000010010000010000000000000010100000001100000000100000000100000001000000000000000000000000001000000000000010010000010010000010000000000000000000000000000010000000001000000000000000001101000000000000000010100001000000000010000000000000000000010000000000000000000000001100000000000000100000000000000000100000001000000000000000000100001000000000000000000000000000000000000000000000010000110000000010000100000100000000010000000000010000000000000000000000000000010000000000100000000010000',
            'dihydroetorphine': '00000000000000010000010000000000010010100000000000000000000000000010000100000000100000100000100000000000000000000010000001000000000000000110000010000010000000000000000100000000000000010000000000000000000000000000101000000000100000010000001000100000000000100000000010010010100010000010100000000011000001000000000100000000000000000100000001000000000000000000100000000000000011000000000000000100110001000001100000000010000000011100100000000000000010001001000010000000000000000000000000000010000000000001000000010100',
            'ethylmorphine': '00000000000000010000010000000000010010000010000000000000010100000001100000000100100000100000001000000000000000000000000001000000000000010010000010010000010000000000000000000000000000010000000001000000000000000001101000000000000000010100011000000000000001000000000000000010000000000000000000000011100000000000000100000000000000000000000001000000000000000000100001000000000000000000000000000000000000000000000010000110000000010100100000100000000010000000000010000000000000000000000000000010000000000100000000010000',
            'etorphinehydrochloride': '00100000000000010000000000100000010010000000000000000000000000000010000100000000100000000000100000000000000000000011000001000000000000000110000010000010010000000000000100000000000010010000000001000000000000000000101000000000100000010000001000000000000000100000000110010010100100000010100000000011000001000000000101000000000000000100000001000000000000000000101000000000000010000000000000000100110001000001000000000010000000010000100000000000000010001001000010000100000000000000000000000010000000000000000000010100',
            'granulated-opium': '00000000000000010000010000000000010010000010000000000000010100000011100100000100000000100000000000000000000000000000000001000000000000010010000010010010010000000000000000000000000000000000000001000000000000000001101000000000000000010100001000000000000000000000000000000010000000000000000000000001100000000000000100000000000000000000000001000000000000000000100001000000000000000000000000000000000000000000000010000110000000010000100000000000000010000001000010000000000000000000000000000010000000000100000000010000',
            'hydrocodone': '10000001000000010000000000000000011010000000000000100000000001000001100000000000100000000000011000000000000000000000000011000000000000000010000010011000010000000000000000000000000001010000000000000000001000000000101000000000000000010000001000000000010000000000000000000010000000000000000000000000000001000000000100100000000000000100000001000000000000000000100001000000001000000000000000000000000000000000000000000110000000010000100000100000000010000000000010000000000000000000000000000010000000000000000000010010',
            'hydromorphone': '00000001000000010000000000000000011010000000000000100000000001000011100100000000100000000000010000000000000000000000000011000000000000000010000010011010010000000000000000000000000001000000000000000000001000000000101000000000000000010000001000000000000000000000000000000010000000000000000000000001000001000000000100100000000000000000000001000000000000000000100001000000001000000000000000000000000000000000000000000110000000010000100000000000000010000001000010000000000000000000000000000010000000000000000000010010',
            'metopon': '00000001000000010000000000000000011010000000000000000000000001000010100100000000000000000000000000000000000000000000000001000000000000000010000010000010010000000000000000000000000000000000000000000000001000000000101000000000000000010100000100000000011000000010000010000010100000000000000000001001000001000000000100100001100000000000000001000000000000000000100000000000000000000000000000000100000000000000000000000110000000010000100000000000000010001001000010000000000000010000000000000110000000000000000000010000',
            'morphine': '00000000000000010000010000000000010010000010000000000000010100000011100100000100000000100000000000000000000000000000000001000000000000010010000010010010010000000000000000000000000000000000000001000000000000000001101000000000000000010100001000000000000000000000000000000010000000000000000000000001100000000000000100000000000000000000000001000000000000000000100001000000000000000000000000000000000000000000000010000110000000010000100000000000000010000001000010000000000000000000000000000010000000000100000000010000',
            'noroxymorphone': '00000100000000010000000000000000000010000000000000000000000000100010000100000000100000000010010000000000000000000000000010000100001000000010000010000010000000000000000000100000000000000100000000100000001000000000101000000000010000010000001000000000000000000000000010010010100000000000000000000011000000000100000100100000000000000000000001000000000000000100100000000000001000000000000100000000000000000000000000000010000000000000000000000000000010000001000000000000000000000000000000010000000000000000000000010000',
            'oripavine': '10000000000000010001000000000000110010000000000000000000000000000010000100000000100000000000000000000000000000000000010011000000000000000010000010000010000000000000000000000000000000010000000000000001010000000000101010000000010000010000001000000000000000000000000000001110000000000000000011000001000000000000000100000000000000001100000001000000000000000000100000000000100000000001000000000010000000000000000000000010000000010000100000000000000010000001000010000000000000000000000000000110000000000000000000110000',
            'oxycodone': '10000000000000010000000000000000010010000000000000000000000000000001000000000000100000000000111000000000000000000000000011000000001000000110000010000000000000000000000000100000000000010100000000000000001000000000101000000000110000010000001000000000010000000000000010010010100000000000000000000011000000000000000100100000000000010100000001000000000010000000100000000000001000000000000000000100000000000000000000000010000000010000100000100000000010000000000010000000000000000000000000000010000000000000000000010000',
            'oxymorphone': '00000000000000010000000000000000010010000000000000000000000000000010000100000000100000000000110000000000000000000000000011000000001000000110000010000010000000000000000000100000000000000100000000000000001000000000101000000000110000010000001000000000000000000000000010010010100000000000000000000011000000000000000100100000000000010000000001000000000010000000100000000000001000000000000000000100000000000000000000000010000000010000100000000000000010000001000010000000000000000000000000000010000000000000000000010000',
            'thebaine': '10000000000000010001000000000000110010000000000000000000000000000001000000000000100000000000001000000000000000000000010011000000000000000010000010000000000000000000000000000000000000010000000000000001010000000000101010000000010000010000001000000000010000000000000000001110000000000000000011000000000000000000000100000000000000001100000001000000000000000000100000000000100000000001000000000010000000000000000000000010000000010000100000100000000010000000000010000000000000000000000000000110000000000000000000110000',
            'alfentanil': '00000000001000000000000000100000011010000100000000000000000000001000000010000000100000000000010000000000100000000000000001000000000000000010000000000000000000100000000000000001000000010000000000000000100100000000001000000000000000000000010010000001100000011001000000000000000000000000000010000011000000000000000000100000000000000100000001000000000000000000100000000000010000000010010000100100000000000001100000000011010000010000000000010000000001000000000010100000000000000000000000000000000001000000010000000000',
            'alphaprodine': '00000000000000000000000000000100010010000000100000000000000010001000000000000000100000000000000000000000000000000000000001000000010000000010000000000000000000000000000000000001000001010000000000010000000000010000001000000010000100000000000000000000000001000000100000000000000000000000010000000011000000000000000000100000000000000000000001000000000000000000100000100000000000000000010000100100000000000000000000000010000000010000010000000000000000000000100010000000000000000000000010000000001000000000000000010000',
            'anileridine': '00000000000000000000010100000000010010000000100000000000000000001000000000000000100000000000000000000000000000000000000001000000000000001010000010010000000000000000000000000001000000010010000000000000000000000000001000110000000000000000000000000000000000011000101000001000000000000000000000001011000000000000001000000000010000000000000001000000000000000000100000000000000000001000010000000100000000000000000100000010000000010000000001000000000010000000000010100000000000000000000000000000000000000000000000010000',
            'bezitramide': '00000000000000000000000000000000010000000100010000000000000000001000000000001000100000000000000000000000000000000010000001000000000000000010000000000000000000000010000000000001000100000000000010000000000000000000001000000000000000000000010000001000000000010011010000000001000000100000100000000011000001000000000000100000000000000000000101010010000000000000100011000000000000100000010000110110010000000000000010001010000000010000000000000000000100000000000010100010000000000000000001000000000000000100000000010010',
            'dextropropoxyphene': '01000000000000000000000000000000010000000010000000000000000000001000000000000000100000000000000000000000000000000010000000000000000001010011100000000000000000000000000000000001000001010000001000000000100000000000001000100000001000010000000000001000000000000000000000000000000000000001000000000011000000000000000000000000100010000000000001000000000000000000100000100000010000001000010000100100010000000100000000000000000000000000000000000000000000000000000000000000000000101000000001000000000000000100000000000000',
            'carfentanil': '00000000000000000000010000000000010010000010000000000000000000001000000110000000100000000000010000000010000000000000000001000000100000000011000000000000000000000000000000000001000000010000000000000000000000000000001000110000000000000000000010000000000000011000001000000000000000000000000010000011000000000000000000000000010000000100000101000000000000000010100000000000010000000000110000100100000000000000000000000010010000010000000000000000000000000000000010100000000000000000000000000000000000000000010000000000',
            'dihydrocodeine': '10000001000000010000000000000000011010000000000000100000000001000001100000000000000000000000001000000000000000000000000001000000000000000010000010010000010000000000000000001010000000010000000000000000000000000001101000000000000000010100001000000000010000000000000000000010000000000000000000000001000001000000000100000000000000000100000001000000000000000000100001000000000000000000000000000000000000000000000000000110000000010000100001100000000010000000000010000000000000000000000000000010000000000100000000010010',
            'diphenoxylate': '00000000000000000000000100000000010010000100100000000000000000001000000000000000100000000000000000000000000000000010000001000000000000001010000000010000000000000010000000000001000000010010000010000000000000000000001000000000000000000000000000000000000000011000100000000000000000100000100000001011000000000000000000000000010000000000000001010010000000000000100011000000000000000000010000010100010000000000000100000010000000010000000000000000000110000000000010100000000000000000000001000000000000000000000000010000',
            'fentanyl': '00000000000000000000010000010000010000000010000000000000000000001000000010000010100000000000010000000000000000000000000001000000000000000010000000000000000000000000000000000001000000000000000000000000000000000000001000110000000000000000010000000000000000010000001010000000000000000000000010001011010001000000000000000000000000000000000001000000001000000000100000000000010000000000010000100100000000000000000000000010000000010000000000000000000000000000000010100000000000000000000000000000000000000000000000010000',
            'isomethadone': '01000000000000000000000000000000010000000000000000000000000000001010000000000000100000000000000000000000000000000010000000000000000001000011100000000000000000000000000000000001001000000000000000000000100000000000001000001000001000000000100000010000000000000000000000000000000000000001000000000011000000000000000000000000000010000000000001000000000000000000100000000000010000000000010000100100010000000000000000100000000000000000000000000000000000000000000000000000000000000000000101000000000000000000000000000000',
            'levo-alphacetylmethadol': '01000000100100000000000000000000010000000000000000001010000000001100010000000000100000000000000000000000000000000010000000000000000000000011000000000000000000100000000000000001000000010100000000000100001000000000001000010000000000000000000000000100010000000000000000000000000000000001000000000011000000000000000001000000000000000000000001000000000000000000100000000000011000000000010000000100010000000000000000000000000000000000000010000000000000000000000000000000000000000000000001000000000000000000000001000000',
            'levomethorphan': '10001001000000000000000000000000011010000000000000100000000000000000100000000000000000000000100000000010000000000000000001000000000000000010000000000001010000000000000000000000000000010000000000010000000000100000101000000010000000111000000000000000000000000000000000000100000000000000100000000000000001000000000000000000001000000100000001000000000000000000100000010010000000000010000000000000000000000000000000000110000000010000100000001000000010000000000010000000000000000000000000000010000000000000000000010000',
            'levorphanol': '00001001000000000000000000000000011010000000000000100000000000000010100000000000000000000000100000000010000000000000000001000000000000000010000000000001010000000000000000000000000100000000000000010000000000000000101000000010000000011100000000000000000000000000000000000000000000000000100001000001000001000000000000000000000000000000000001000000000000000000100000010010000000000010010000000000000000000000000000000110000000010000100000000000000010000000000010000000000000000000000000000010000000000000000000010000',
            'metazocine': '00000000000000000000000000000000010010000000000000000000000000000010100000100000000000000000000000000000000010000000000001000000000000000010000000100000010000000000000000000000000100000000000000000000000000000000101000000000000000010100000000000000001000000000000000000000000000000000110001000001000000000000000000000000001000000000000001000000000010000000100000010000000000000000010000000000000000000000000000000110000000010000100000000000000010000000000010000000000000000000000000000010000000000000001000010010',
            'methadone': '01000000000000000000000000000000010000000000000000000000000000001100000000000000100000000000000000000000000000000010000001000000000000000011000000000000000000000000000000010001000000000000000000000000001000000000001000000000000000000000000000010000010000000000000000000000000000000001000000000011000000000000000001000000000000000000000001000000000000000000100000000000010000000000010000100110010000000010000000000000000000000000000000000000000000000000000000000000000000000100000101000000000000000000000000000000',
            'methadone-intermediate': '01000000000000000000001000000000010000000000000000000000000000001100000000000000100000000100000000000000000000000010000000000000000000000001000000000000000000000010000000000001000000000000000010000000001000000000001000000000000000000000000000000000010000000000000000000000000000100001000000000010000000000000000001000000000000000000000001000010000000000000100010000000010000000000000000010100010000000000000000000000000000000000000000000000000100000000000000000000000000000000000001000000000000000000000000000000',
            'moramide-intermediate': '01000000000100010000000000000000010000000000000000000000000000001000000000000000100000000000000000000000000000000010000000000000000001000010000010000000000000000000000000000001001000000000100000000000100000000000001000000000000000000000100000000000000000010000000000000000000000000001000000000001000000000000000001000000000000000000000001000000000000000000100000000000000000000000010000100100010000000000000000010010010000010000000000000010010000000000000010000000010000000000000001000000000000000000000000000000',
            'oliceridine': '10001000000000100000000000001001010010000010000000000000000000001000000000000000100000000000000000010110100110000000000100010000100100000010000010000000000100000001000000010001000000010000000100000000000000000000001000000000000000000000000000000000010000010010000000000000100000000001000000000000000000000010000000100000000000000110000001000000000000000000100000000000000000000010000000000000000000000000000000000010000000000000100000100010000000001000001000000000000000000000000000010000000010000000000001100000',
            'pethidine': '00000000000000000000000100000000010010000000100000000000000000001000000000000000100000000000000000000000000000000000000001000000000000001010000000010000000000000000000000000001000000010010000000000000000000010000101000000000000000000000000000000000000000000000100000000000000000000000000000001011000000000000000000000000010000000000000001000000000000000000100000000000000000000000010000000100000000000000000100000010000000010000000000000000000010000000100010000000000000000000000000000000000000000000000000010000',
            'pethidine-intermediate-a': '00000000000000100000000000000000010010000000100000000000000000001000000000000000000000010000000000001000000000000000000001000000000000000010000000000000000000000010000000000001000000000000000000000000000000010000101000000000000000000000000000000000100000000000100000000000000000100000000000000000000000000000000000000000000000000000000001000000000000000000100010000000000000000000000000000100000000000100000000000010100000010000000000000000000000000000100010000000000000000000000000000000000000000000000000000000',
            'pethidine-intermediate-b': '00000000000000000000000100000000010010000000100000000000000000001000000000000000100000000010000000000000000000000000000000000000000000000010000000010000000000000000000000000001000000010010001000000000000000000000001000000000000000000000000000000000000000000000100000000000000000000000100000001011000000000100000000000000010000000000000001000000000000000000100000000000000000000000010000000100000000000000000100000010010000000000000000000000000010000000000000000000000000000000000000000000000010000000000000010000',
            'pethidine-intermediate-c': '00000000000000000000000100000000010010000000100000000000000000001000000000000000000000000000000000000000000000000000000001000000000000001010000000000000000000000000000000000001000000001000000000000000000000010000101000000000000000000000000000000000000000000010100000000000000000000000000000001001000000000000000000000000000000000000000001000000000000000000100000000000000000000000010000000100000000000000000000000010000000010000000000000000000000000000100010000000000000000000000000000000000000000000000000000000',
            'phenazocine': '00000000000000000000010000000000010010000010100000000000000000001010100000100000100000000000000000000000000010000000000001000000000000000010000000000000010000000000000000000001000100000000000000000000000000000000101000110000000000010100000000000000001000000000001000000000000000000000110001000001000000000000000000000000001000000000000001000000000010000000100000010000000000000000010000000100000000000000000000000010000000010000000000000000000010000100000010000000000000000000000000000010000000000000001100010010',
            'piminodine': '00000000000000000000000100000000010010000000100000000000000000101000000000000000100000000000000000000000000000000000000001000000100000001010010000010000000100000000000000000001000000010010000100000000000000000000001000000000000000000000000000000000000000011000100000000000000000000000000000001011000000000000000000000000010000000000000001000000000000100000100000000000000000010000010000000100100000000000000100000010000000010000000000001000000010000000000010100000000000000000000000000000000000000000000000010000',
            'racemethorphan': '10001001000000000000000000000000011010000000000000100000000000000000100000000000000000000000100000000010000000000000000001000000000000000010000000000001010000000000000000000000000000010000000000010000000000100000101000000010000000111000000000000000000000000000000000000100000000000000100000000000000001000000000000000000001000000100000001000000000000000000100000010010000000000010000000000000000000000000000000000110000000010000100000001000000010000000000010000000000000000000000000000010000000000000000000010000',
            'racemorphan': '00001001000000000000000000000000011010000000000000100000000000000010100000000000000000000000100000000010000000000000000001000000000000000010000000000001010000000000000000000000000100000000000000010000000000000000101000000010000000011100000000000000000000000000000000000000000000000000100001000001000001000000000000000000000000000000000001000000000000000000100000010010000000000010010000000000000000000000000000000110000000010000100000000000000010000000000010000000000000000000000000000010000000000000000000010000',
            'remifentanil': '00000000000000100000000000001000010010000000000000000000000000001000000110000000100000000000010000000010000000000000000001010000100000000011000000000000000000000000000000000001000000010000000000010000000000000000001000000000000000000000000010000000000000011000000000000000000000000000000010000011000000000000000000000000010000000100000101000000000000000010100001100000010000000000110000100100000000000000000000000010010000010000000000000000000000000000000010100000000000000000000000000000000000000000010000000000',
            'sufentanil': '00000000001000100000000000000001010010000100000000000000000000001000000010000000100000000000010000000000100000000000000001000000000000000010000010000000000000000001000000000001000000010000000000001000000000000000001000110000000000001000010011000000000000011000000000000000000000000000000010000011000000000000000000000000000000000100000001000000000000000000100000000000110000000000010100100100000000000001100000000011010000010000000000000000000000000000000010100000000000000000000000000000000001000000010000010000',
            'tapentadol': '01000000100000010000000000000000010000000000010000000000000000001110000000000000100000000000000000000000000000000000000001000000000000000001100000000000000000000000000000000000000000000000001000000000000000000000001100000000001000000100000000000000010000000000000000000000000000000001000000000011000000000000000000000000000010000000000001000100000000000000100000010000010000000000010000000000000000000000000000010000000000000000000000100000000000000000000000000010000000000000000000000000000000000000000000000000',
            'thiafentanil': '00000000000000100000000000000001010010000000000000000000000000001000000110000000100000000000000000000010000000000000000001000000100000000011000010000000000000000001000000000001000000010000000000001000000000000000001000110000000000001000000001000000000000011000000000000000000000000000000010000001000100000000000000000000010000000100000101000000000000100010100000000000110000000000110100000100000000000000000000000010010000010000000000000000000000000000000010100000000010000000000000000000000001000001010000010000',
            'amphetamine': '01000000000000010000000000000000010000000010000000000001000000001000000000000001100000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000001000000000000000000000000000000000000001000100000000000000000000000000000000000000000000000000000001000000001000000000000000000000000000000000000000000000000000001000000010000000000100000100000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'methamphetamine': '01000000000000000000000000000000010000000010000000000000000000001000000000000001100000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000001010000000000000010000000000000000000001000100000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000001000000010000000000100000000000000100000000000000000100000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000100000000000010000000000000000',
            'phenmetrazine': '00000000000000000000000000000000010000000000000000000000000000001001000001000000000000000010000000000000000000000000000001000001000000000000000010000000000000000000000010000001000000000000000000000000000000000000001000000000000000000000000000000000000000010000000000000000000000000000010000100000000000000100000001000000000000000000000001000000000000000001100000000000000000000000001000000100000000000000000000000010000000000000000000000010000000000000000000000000000000010000000000010000000000000000000000010000',
            'methylphenidate': '01001000000000000000000000000000010000000000010000000010000000001000000000000000000000000010100000000000000000000000000000000000100000000010100000010000000000000000000000000001000000010100000000010000000001000000001000000000000000000000000000000000000000000000000000000000100000000000000000000001000001000100000000000000000001000100000001000100000000000000100000000000000000001010010000000100000000000000000000000010000000000000000000001000000000000000000010000000000000000000000000010000000000000000000000010000',
            'lisdexamfetamine': '01000000000000000000000000000000010000000010000000000000001001001000000000000001100000000000000000000000000000000000010000000000100000000010000000010000000000000000000000000001000000000000000010000000000000000000001000100000000100000000001000000000000000000001000000000000001000000001000000000001000000001000000001000000000000000000000001000000010000000000100000000000000000010010010000000100000000000000000000001000000000000000000000000000000000000000000000000000000001000000000000100000000001000000100000100000',
            'amobarbital': '01000000000000000000000000000000010010000000000000000000001000000000000000000000100000000010000000000000000000010000000000000000000000000010000000000000000000000000000000000000000000000000000000000000010000000000000000000000100100000000000000010000000000000000000000000000000000000001000000000010000000000000000100100000000011010000000000000000000000000000100000000000000000000000000000000000000000010000000000000000000000000000000000000010100000000000000000000000000000000000000000000000000000000000000100000000',
            'glutethimide': '00000000000000000000000000000000010010010000100000000000000000001000010000000000100000000010000000001000000000000100000000000000001000000010000000000000010000000000000000000001000000000000000000000000011000000000001000000000000000000000000000000000000100000000100000001000000000000000000000000010000000000000000000100000000000010000000001000000000000000000100000000000000000000000000000000100000000000000000100000010000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000',
            'pentobarbital': '01000000000010000000000000000000010010000000000000000000000000000000000000000000100001000010000000000000000000000000000000000000000000100010000000000000000000000000000000000000000000000000000000000000010000000000000000000000000100000000000000010000000000000000000000000000000000000011000010000010000000000000001010100000000000010000000000000000000000000000100000000000000001000000000000000000000000000000000000000000000000000000000000000010100000000000000000000000000000000000000000000000000000000000000000000000',
            'phencyclidine': '00101000000000000000000000000000000010000000100000000000000000001000000000000000000000000000000000000010000000000000000000000000000000000010000000000000000000000000000100000001000000000000000000000000000000000000001000000000000000000000000000000000000000000000100000000000000000000000000000000000000000100000000000000000000000000000000001000001000000000000100000000000000000000000000000000100000000000000010000000010000000010010000000000000100000000000000010000010000000000000000000000000000000000000000000000000',
            'secobarbital': '01000000000010000000000000000000010010000000000000000000000000000000000000000000100000000010000000000000000001000000000000000000000000100010000000000000000000000000000000000000000000100000000000000000010001000000000000000000000100000000000000010000000000000000000000000000000000000011000010000010000000000000001010100000000000000000000000000010000000000000101000000000000000000000000000000000000000000000000000000000000000000000100100000010100000000000000000000000000000000000000000000000000000000000000000000000',
            'nabilone': '00000001000000000000000000000000010010000000000000000000001101000010000100000001100000000000000000000000000000001010000100000001000000000010000010000000000001000000000000000000000010000000010000000000001000000000000000000000010000010000000000000000001000000010000000000001010000000010100000000011000001000000000000100000000000000000000001000000000010000000100000010000010000010000000000000000110000001000000000000110010010000000000000000000000000000000000100000000000000100000100000000010000000000000000000010000',
            'dronabinol': '00000001010000000000000001000000010010000000000000000000001001000011000100000001100000000000000000000000000000001000000000000000000000000000000010000000000000001000000000000000000000000010010001000000011010000000000000110000000000000000000000000000001000000010000000000000010000000010000000000011000001000000000000000000000100000000000001000000000000000000101000010000010000010000000000000000000000001000001000000010000010000000000000000000000100000000000000000000001000100000000000000010001000000000000000010000',
            'phenylacetone': '00000000000000100000000000000000010000000010000000000000000000001000000000000000100000000000000000000000000001000000000000000000000000000010000000000000000000000000000000000001000000000000000000000000000000000000001000100000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000001000000000001000000000000000000100000000000000000000000010000000100000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000001000000',
            '1-phenylcyclohexylamine': '00101000010000000000000000001000000010000000100000000000000000001000000000000000000000000000000000000010000000000000000000000000000000000010000000010000000000000000000000000001100000000000000000000000000000000000001000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000100000000000000000000000000000000100000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000100100000000000',
            '1-piperidinocyclohexanecarbonitrile': '00101000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000010000010000000000001000000000010000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000100001000000000000000010000000000000000000000000000000000000000000000000000010100000010000000000000000100000000000000010000010000000000000000000000000000000000000000000000000',
            '4-anilino-n-phenethylpiperidine': '00010000000000000000010000000000000000000010000000000100000000001000000000100000100000000000000000100000000000000000000101000000100000000000000010000000000000000000000000000001000000000000000100000000000000000000001000110000000000000000010000000000000000010000001000000000000000000000000000000000000001000000000000000000000000000000000001000000000000000000100000000000000000000000000000000100000000000000000000000010000000010000000000000000000000000000000010100000000000000000000000000000000000000000000000010000',
        }

        return bit_vector