#!/usr/bin/env python3
#
# GlobalChem - OrganoPhosphorous Nerve Agents
#
# -------------------------------------------

class OrganoPhosphorousNerveAgents(object):

    def __init__(self):

        self.name = 'organophosphorous_nerve_agents'

    @staticmethod
    def get_smiles():

        smiles = {
            'tabun': 'CCOP(=O)(C#N)N(C)C',
            'sarin': 'CC(C)OP(=O)(C)F',
            'soman': 'CC(C(C)(C)C)OP(=O)(C)F',
            'cyclosarin': 'CP(=O)(OC1CCCCC1)F',
            'vx': 'CCOP(C)(=O)SCCN(C(C)C)C(C)C',
            'russian vx': 'CCN(CC)CCSP(=O)(C)OCC(C)C',
            'mirzayanov-a230': 'CCN(CC)C(C)=N[P](C)(F)=O',
            'mirzayanov-a232': 'CCN(CC)C(\C)=N\P(F)(=O)OC',
            'mirzayanov-a234': r'CCOP(F)(=O)\N=C(/C)\N(CC)CC',
            'hoenig-a230': r'Cl/C(F)=N/OP(F)(OCCCl)=O',
            'hoenig-a232': r'Cl/C(F)=N/OP(F)(OC(C)CCl)=O',
            'hoenig-a234': r'Cl/C(F)=N/OP(F)(OC(C)C(C)Cl)=O',
            'novichok-5': 'FP1OC(C)CO1',
            'novichok-7': 'FP1OC(C)C(C)O1',
        }

        return smiles

    @staticmethod
    def get_smarts():

        smarts = {
            'tabun': '[#6]-[#6]-[#8]-[#15](=[#8])(-[#6]#[#7])-[#7](-[#6])-[#6]',
            'sarin': '[#6]-[#6](-[#6])-[#8]-[#15](=[#8])(-[#6])-[#9]',
            'soman': '[#6]-[#6](-[#6](-[#6])(-[#6])-[#6])-[#8]-[#15](=[#8])(-[#6])-[#9]',
            'cyclosarin': '[#6]-[#15](=[#8])(-[#8]-[#6]1-[#6]-[#6]-[#6]-[#6]-[#6]-1)-[#9]',
            'vx': '[#6]-[#6]-[#8]-[#15](-[#6])(=[#8])-[#16]-[#6]-[#6]-[#7](-[#6](-[#6])-[#6])-[#6](-[#6])-[#6]',
            'russian vx': '[#6]-[#6]-[#7](-[#6]-[#6])-[#6]-[#6]-[#16]-[#15](=[#8])(-[#6])-[#8]-[#6]-[#6](-[#6])-[#6]',
            'mirzayanov-a230': '[#6]-[#6]-[#7](-[#6]-[#6])-[#6](-[#6])=[#7]-[#15](-[#6])(-[#9])=[#8]',
            'mirzayanov-a232': '[#6]-[#6]-[#7](-[#6]-[#6])/[#6](-[#6])=[#7]/[#15](-[#9])(=[#8])-[#8]-[#6]',
            'mirzayanov-a234': '[#6]-[#6]-[#8]-[#15](-[#9])(=[#8])/[#7]=[#6](\[#6])-[#7](-[#6]-[#6])-[#6]-[#6]',
            'hoenig-a230': '[#17]/[#6](-[#9])=[#7]/[#8]-[#15](-[#9])(-[#8]-[#6]-[#6]-[#17])=[#8]',
            'hoenig-a232': '[#17]/[#6](-[#9])=[#7]/[#8]-[#15](-[#9])(-[#8]-[#6](-[#6])-[#6]-[#17])=[#8]',
            'hoenig-a234': '[#17]/[#6](-[#9])=[#7]/[#8]-[#15](-[#9])(-[#8]-[#6](-[#6])-[#6](-[#6])-[#17])=[#8]',
            'novichok-5': '[#9]-[#15]1-[#8]-[#6](-[#6])-[#6]-[#8]-1',
            'novichok-7': '[#9]-[#15]1-[#8]-[#6](-[#6])-[#6](-[#6])-[#8]-1',
        }

        return smarts

    @staticmethod
    def get_bit_vector():

        bit_vector = {
            'tabun': '00000000000000000000000000000000010000000000000000000000000000000000010000000000110000000000000000000000000000000000000000010000000001000011000000000000000000000010000000000000000110010000000010000000000000000000001100000000000000000000000000000000000000000000000000000000000000100000000000000010000000010000000000000000000000000000000000000000000000000000000010000000010000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000010000000000000000000000000',
            'sarin': '01000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000010000000000000000000001000010000000000000000010000000010000000000000000000000000000000000000000000000000000000010000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000100000000000000000000000000000100000000000000000001000000000000000000000000000000000000001000010000000000000000000000000',
            'soman': '01000000100000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000001000000000010000000000000000000000010000000000000000000000000010000000000000000010000000010000000000000000000000000000000000000000000010000000000010100000000000000000000000000000001000000000000001000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000010000000000000000000000000',
            'cyclosarin': '00101000000000000000000000000000010000000000000000000000000000000000000000000000000010000000000000000001000000000000000100010000000100000010000000000000001000000000000000000000000000010000000010000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000001000000000000000000000000000000000000000010000000000000000000000000000000000010000000000000100000000000000000000010000000000000000000000000000000000000000000000000000000000000000001000010000000000000000000010000',
            'vx': '01000000000000000000000000000000010000000000000000000000000000000000000000000000100000000000000000000000000000000000100000000100000001001010000000000000000001100000000000000000100110010000000010000000000000000010001000000000000000000100000000000000000010000000000000000000000000000001000000000010000000000000000000000000000000000000000000000110000000100000000000000000010000000000000000000000000000000000000000000001000000000000000000000000000000000000100000000000000000000000000000000010000000000000000000000000',
            'russian vx': '01000000000000000000000000000000010000000000000000000000000000000000000010000000100000000000000000000000000010000000101000000100000000001010000000000000000000100000000000000000000010010000000010000000000000000000000000000100000001000000000000000000000110100000000000000000000000000001000000000010000000000000000100000000000000000000000000000110000000100000000000000000010000000000000000000000000000000000000000000001000010000000000000000000000001000000000000000000000000000000000000000010000000000000000000000000',
            'mirzayanov-a230': '00000000000000000000000000000000010000000000000000000000000000000000000000000000100000000000000000000001000000000000000000000000000000000010000000000000000000000000000000000000000000000000000010001000000000000000010000000000000000000000000000000000000000000000000001000000000000000000000000000011000000000000000000000000000000000000000000000010000000000000000000000000010000000000000000000000100000000000000000000000000010000000100000001000000000000000000000000000101000000000000000000010000000001000000001000100',
            'mirzayanov-a232': '00000000000000000000000000000000010000000000000000000000000000000000000000000000100000000100000000000001000000000000001000000000000000100010000000000001000000000000000000000000000000010000000010000000000000000000010000000000000000000000000000000000000000000000000001000000000000000000000000000011000000000000000000000000000000000100000000000000000000000000000000000000010000000000000000000000100000000000000000000000000010000000100000001000000000000000000000000000001000000000000000010010000000001000000001000000',
            'mirzayanov-a234': '00000000000000000000000000000000010000000000000000000000000000000000000000000000100000000000000000001001000000000000001000000000000000100010000000000000000000000000000000000000000110010000000010000000000000000000011000000000001000000000000000000000000000000000000001000000000000000000000000000011000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000100000000000000000000000000010000000100000001000000000000000000000000000001000000000000000000010000000001000000001000000',
            'hoenig-a230': '00000000000001000000000000000000000000000010000000000000000100000000000000000000100001000000000000000001000000000000000000000000000000000010000000010000000000000000000000000000000010010100000010000000000000000000010000000000001100000000000000000000000000000100000000001000000000100000000000000001000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000110000000000000000000000000000000000000000000000000000010000000000100000000001000',
            'hoenig-a232': '01000000000000000000000000000000110000000010000000000000000100000001000000000000100001000000000001000001000000000000000000000000000000000010000000010000000000000000000000000000000000010100000010000000000000000010010000000000001100000000000000000000010000000000000000001000000000000001001000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000010000000000000010000001000',
            'hoenig-a234': '01000000000000000000000000000000010000000010000000000000000100000001000000000000000000000000000000000001000000000000000000000000000000000010000000010000000000000000000000000000000000010100000010000000000000000010010000100000001100000000000000000000010000000000000000101000000000000001000000000001000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000000000000000000100000000000000000000000000000000000000000000000000000010000000000000000001001000',
            'novichok-5': '00000000000000000000000000000000010000000000000000000000000000000000000000100000000000000000000010000000000000000000000001000000000000100000000010000000000000000000000000000000100000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000010000000000100010000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000100000000000000000000010000100000000000000000000000000000000000000000000000000000000000000000000000000001000000000010001',
            'novichok-7': '00000000100000000000000100000000010000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000010000000000010000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000010000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000010001',
        }

        return bit_vector