"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsAuthBackendLogin = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_login vault_aws_auth_backend_login}
*/
class AwsAuthBackendLogin extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_login vault_aws_auth_backend_login} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AwsAuthBackendLoginConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'vault_aws_auth_backend_login',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.12.0',
                providerVersionConstraint: '~> 3.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // metadata - computed: true, optional: false, required: false
        this._metadata = new cdktf.StringMap(this, "metadata");
        this._backend = config.backend;
        this._iamHttpRequestMethod = config.iamHttpRequestMethod;
        this._iamRequestBody = config.iamRequestBody;
        this._iamRequestHeaders = config.iamRequestHeaders;
        this._iamRequestUrl = config.iamRequestUrl;
        this._id = config.id;
        this._identity = config.identity;
        this._namespace = config.namespace;
        this._nonce = config.nonce;
        this._pkcs7 = config.pkcs7;
        this._role = config.role;
        this._signature = config.signature;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // accessor - computed: true, optional: false, required: false
    get accessor() {
        return this.getStringAttribute('accessor');
    }
    // auth_type - computed: true, optional: false, required: false
    get authType() {
        return this.getStringAttribute('auth_type');
    }
    get backend() {
        return this.getStringAttribute('backend');
    }
    set backend(value) {
        this._backend = value;
    }
    resetBackend() {
        this._backend = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backendInput() {
        return this._backend;
    }
    // client_token - computed: true, optional: false, required: false
    get clientToken() {
        return this.getStringAttribute('client_token');
    }
    get iamHttpRequestMethod() {
        return this.getStringAttribute('iam_http_request_method');
    }
    set iamHttpRequestMethod(value) {
        this._iamHttpRequestMethod = value;
    }
    resetIamHttpRequestMethod() {
        this._iamHttpRequestMethod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get iamHttpRequestMethodInput() {
        return this._iamHttpRequestMethod;
    }
    get iamRequestBody() {
        return this.getStringAttribute('iam_request_body');
    }
    set iamRequestBody(value) {
        this._iamRequestBody = value;
    }
    resetIamRequestBody() {
        this._iamRequestBody = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get iamRequestBodyInput() {
        return this._iamRequestBody;
    }
    get iamRequestHeaders() {
        return this.getStringAttribute('iam_request_headers');
    }
    set iamRequestHeaders(value) {
        this._iamRequestHeaders = value;
    }
    resetIamRequestHeaders() {
        this._iamRequestHeaders = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get iamRequestHeadersInput() {
        return this._iamRequestHeaders;
    }
    get iamRequestUrl() {
        return this.getStringAttribute('iam_request_url');
    }
    set iamRequestUrl(value) {
        this._iamRequestUrl = value;
    }
    resetIamRequestUrl() {
        this._iamRequestUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get iamRequestUrlInput() {
        return this._iamRequestUrl;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get identity() {
        return this.getStringAttribute('identity');
    }
    set identity(value) {
        this._identity = value;
    }
    resetIdentity() {
        this._identity = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get identityInput() {
        return this._identity;
    }
    // lease_duration - computed: true, optional: false, required: false
    get leaseDuration() {
        return this.getNumberAttribute('lease_duration');
    }
    // lease_start_time - computed: true, optional: false, required: false
    get leaseStartTime() {
        return this.getStringAttribute('lease_start_time');
    }
    get metadata() {
        return this._metadata;
    }
    get namespace() {
        return this.getStringAttribute('namespace');
    }
    set namespace(value) {
        this._namespace = value;
    }
    resetNamespace() {
        this._namespace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInput() {
        return this._namespace;
    }
    get nonce() {
        return this.getStringAttribute('nonce');
    }
    set nonce(value) {
        this._nonce = value;
    }
    resetNonce() {
        this._nonce = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nonceInput() {
        return this._nonce;
    }
    get pkcs7() {
        return this.getStringAttribute('pkcs7');
    }
    set pkcs7(value) {
        this._pkcs7 = value;
    }
    resetPkcs7() {
        this._pkcs7 = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pkcs7Input() {
        return this._pkcs7;
    }
    // policies - computed: true, optional: false, required: false
    get policies() {
        return this.getListAttribute('policies');
    }
    // renewable - computed: true, optional: false, required: false
    get renewable() {
        return this.getBooleanAttribute('renewable');
    }
    get role() {
        return this.getStringAttribute('role');
    }
    set role(value) {
        this._role = value;
    }
    resetRole() {
        this._role = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get roleInput() {
        return this._role;
    }
    get signature() {
        return this.getStringAttribute('signature');
    }
    set signature(value) {
        this._signature = value;
    }
    resetSignature() {
        this._signature = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get signatureInput() {
        return this._signature;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            backend: cdktf.stringToTerraform(this._backend),
            iam_http_request_method: cdktf.stringToTerraform(this._iamHttpRequestMethod),
            iam_request_body: cdktf.stringToTerraform(this._iamRequestBody),
            iam_request_headers: cdktf.stringToTerraform(this._iamRequestHeaders),
            iam_request_url: cdktf.stringToTerraform(this._iamRequestUrl),
            id: cdktf.stringToTerraform(this._id),
            identity: cdktf.stringToTerraform(this._identity),
            namespace: cdktf.stringToTerraform(this._namespace),
            nonce: cdktf.stringToTerraform(this._nonce),
            pkcs7: cdktf.stringToTerraform(this._pkcs7),
            role: cdktf.stringToTerraform(this._role),
            signature: cdktf.stringToTerraform(this._signature),
        };
    }
}
exports.AwsAuthBackendLogin = AwsAuthBackendLogin;
_a = JSII_RTTI_SYMBOL_1;
AwsAuthBackendLogin[_a] = { fqn: "@cdktf/provider-vault.awsAuthBackendLogin.AwsAuthBackendLogin", version: "5.0.0" };
// =================
// STATIC PROPERTIES
// =================
AwsAuthBackendLogin.tfResourceType = "vault_aws_auth_backend_login";
//# sourceMappingURL=data:application/json;base64,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