import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AwsSecretBackendConfig extends cdktf.TerraformMetaArguments {
    /**
    * The AWS Access Key ID to use when generating new credentials.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend#access_key AwsSecretBackend#access_key}
    */
    readonly accessKey?: string;
    /**
    * Default lease duration for secrets in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend#default_lease_ttl_seconds AwsSecretBackend#default_lease_ttl_seconds}
    */
    readonly defaultLeaseTtlSeconds?: number;
    /**
    * Human-friendly description of the mount for the backend.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend#description AwsSecretBackend#description}
    */
    readonly description?: string;
    /**
    * If set, opts out of mount migration on path updates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend#disable_remount AwsSecretBackend#disable_remount}
    */
    readonly disableRemount?: boolean | cdktf.IResolvable;
    /**
    * Specifies a custom HTTP IAM endpoint to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend#iam_endpoint AwsSecretBackend#iam_endpoint}
    */
    readonly iamEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend#id AwsSecretBackend#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Maximum possible lease duration for secrets in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend#max_lease_ttl_seconds AwsSecretBackend#max_lease_ttl_seconds}
    */
    readonly maxLeaseTtlSeconds?: number;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend#namespace AwsSecretBackend#namespace}
    */
    readonly namespace?: string;
    /**
    * Path to mount the backend at.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend#path AwsSecretBackend#path}
    */
    readonly path?: string;
    /**
    * The AWS region to make API calls against. Defaults to us-east-1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend#region AwsSecretBackend#region}
    */
    readonly region?: string;
    /**
    * The AWS Secret Access Key to use when generating new credentials.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend#secret_key AwsSecretBackend#secret_key}
    */
    readonly secretKey?: string;
    /**
    * Specifies a custom HTTP STS endpoint to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend#sts_endpoint AwsSecretBackend#sts_endpoint}
    */
    readonly stsEndpoint?: string;
    /**
    * Template describing how dynamic usernames are generated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend#username_template AwsSecretBackend#username_template}
    */
    readonly usernameTemplate?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend vault_aws_secret_backend}
*/
export declare class AwsSecretBackend extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_aws_secret_backend";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/aws_secret_backend vault_aws_secret_backend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AwsSecretBackendConfig = {}
    */
    constructor(scope: Construct, id: string, config?: AwsSecretBackendConfig);
    private _accessKey?;
    get accessKey(): string;
    set accessKey(value: string);
    resetAccessKey(): void;
    get accessKeyInput(): string | undefined;
    private _defaultLeaseTtlSeconds?;
    get defaultLeaseTtlSeconds(): number;
    set defaultLeaseTtlSeconds(value: number);
    resetDefaultLeaseTtlSeconds(): void;
    get defaultLeaseTtlSecondsInput(): number | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disableRemount?;
    get disableRemount(): boolean | cdktf.IResolvable;
    set disableRemount(value: boolean | cdktf.IResolvable);
    resetDisableRemount(): void;
    get disableRemountInput(): boolean | cdktf.IResolvable | undefined;
    private _iamEndpoint?;
    get iamEndpoint(): string;
    set iamEndpoint(value: string);
    resetIamEndpoint(): void;
    get iamEndpointInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maxLeaseTtlSeconds?;
    get maxLeaseTtlSeconds(): number;
    set maxLeaseTtlSeconds(value: number);
    resetMaxLeaseTtlSeconds(): void;
    get maxLeaseTtlSecondsInput(): number | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _secretKey?;
    get secretKey(): string;
    set secretKey(value: string);
    resetSecretKey(): void;
    get secretKeyInput(): string | undefined;
    private _stsEndpoint?;
    get stsEndpoint(): string;
    set stsEndpoint(value: string);
    resetStsEndpoint(): void;
    get stsEndpointInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
