import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GcpAuthBackendConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend#client_email GcpAuthBackend#client_email}
    */
    readonly clientEmail?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend#client_id GcpAuthBackend#client_id}
    */
    readonly clientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend#credentials GcpAuthBackend#credentials}
    */
    readonly credentials?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend#description GcpAuthBackend#description}
    */
    readonly description?: string;
    /**
    * If set, opts out of mount migration on path updates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend#disable_remount GcpAuthBackend#disable_remount}
    */
    readonly disableRemount?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend#id GcpAuthBackend#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies if the auth method is local only
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend#local GcpAuthBackend#local}
    */
    readonly local?: boolean | cdktf.IResolvable;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend#namespace GcpAuthBackend#namespace}
    */
    readonly namespace?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend#path GcpAuthBackend#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend#private_key_id GcpAuthBackend#private_key_id}
    */
    readonly privateKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend#project_id GcpAuthBackend#project_id}
    */
    readonly projectId?: string;
    /**
    * custom_endpoint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend#custom_endpoint GcpAuthBackend#custom_endpoint}
    */
    readonly customEndpoint?: GcpAuthBackendCustomEndpoint;
}
export interface GcpAuthBackendCustomEndpoint {
    /**
    * Replaces the service endpoint used in API requests to https://www.googleapis.com.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend#api GcpAuthBackend#api}
    */
    readonly api?: string;
    /**
    * Replaces the service endpoint used in API requests to `https://compute.googleapis.com`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend#compute GcpAuthBackend#compute}
    */
    readonly compute?: string;
    /**
    * Replaces the service endpoint used in API requests to `https://cloudresourcemanager.googleapis.com`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend#crm GcpAuthBackend#crm}
    */
    readonly crm?: string;
    /**
    * Replaces the service endpoint used in API requests to `https://iam.googleapis.com`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend#iam GcpAuthBackend#iam}
    */
    readonly iam?: string;
}
export declare function gcpAuthBackendCustomEndpointToTerraform(struct?: GcpAuthBackendCustomEndpointOutputReference | GcpAuthBackendCustomEndpoint): any;
export declare class GcpAuthBackendCustomEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GcpAuthBackendCustomEndpoint | undefined;
    set internalValue(value: GcpAuthBackendCustomEndpoint | undefined);
    private _api?;
    get api(): string;
    set api(value: string);
    resetApi(): void;
    get apiInput(): string | undefined;
    private _compute?;
    get compute(): string;
    set compute(value: string);
    resetCompute(): void;
    get computeInput(): string | undefined;
    private _crm?;
    get crm(): string;
    set crm(value: string);
    resetCrm(): void;
    get crmInput(): string | undefined;
    private _iam?;
    get iam(): string;
    set iam(value: string);
    resetIam(): void;
    get iamInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend vault_gcp_auth_backend}
*/
export declare class GcpAuthBackend extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_gcp_auth_backend";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend vault_gcp_auth_backend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GcpAuthBackendConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GcpAuthBackendConfig);
    private _clientEmail?;
    get clientEmail(): string;
    set clientEmail(value: string);
    resetClientEmail(): void;
    get clientEmailInput(): string | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    private _credentials?;
    get credentials(): string;
    set credentials(value: string);
    resetCredentials(): void;
    get credentialsInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disableRemount?;
    get disableRemount(): boolean | cdktf.IResolvable;
    set disableRemount(value: boolean | cdktf.IResolvable);
    resetDisableRemount(): void;
    get disableRemountInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _local?;
    get local(): boolean | cdktf.IResolvable;
    set local(value: boolean | cdktf.IResolvable);
    resetLocal(): void;
    get localInput(): boolean | cdktf.IResolvable | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _privateKeyId?;
    get privateKeyId(): string;
    set privateKeyId(value: string);
    resetPrivateKeyId(): void;
    get privateKeyIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
    private _customEndpoint;
    get customEndpoint(): GcpAuthBackendCustomEndpointOutputReference;
    putCustomEndpoint(value: GcpAuthBackendCustomEndpoint): void;
    resetCustomEndpoint(): void;
    get customEndpointInput(): GcpAuthBackendCustomEndpoint | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
