"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubAuthBackend = exports.GithubAuthBackendTuneList = exports.GithubAuthBackendTuneOutputReference = exports.githubAuthBackendTuneToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function githubAuthBackendTuneToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_response_headers: struct.allowedResponseHeaders === undefined ? null : cdktf.listMapper(cdktf.stringToTerraform, false)(struct.allowedResponseHeaders),
        audit_non_hmac_request_keys: struct.auditNonHmacRequestKeys === undefined ? null : cdktf.listMapper(cdktf.stringToTerraform, false)(struct.auditNonHmacRequestKeys),
        audit_non_hmac_response_keys: struct.auditNonHmacResponseKeys === undefined ? null : cdktf.listMapper(cdktf.stringToTerraform, false)(struct.auditNonHmacResponseKeys),
        default_lease_ttl: struct.defaultLeaseTtl === undefined ? null : cdktf.stringToTerraform(struct.defaultLeaseTtl),
        listing_visibility: struct.listingVisibility === undefined ? null : cdktf.stringToTerraform(struct.listingVisibility),
        max_lease_ttl: struct.maxLeaseTtl === undefined ? null : cdktf.stringToTerraform(struct.maxLeaseTtl),
        passthrough_request_headers: struct.passthroughRequestHeaders === undefined ? null : cdktf.listMapper(cdktf.stringToTerraform, false)(struct.passthroughRequestHeaders),
        token_type: struct.tokenType === undefined ? null : cdktf.stringToTerraform(struct.tokenType),
    };
}
exports.githubAuthBackendTuneToTerraform = githubAuthBackendTuneToTerraform;
class GithubAuthBackendTuneOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._allowedResponseHeaders !== undefined) {
            hasAnyValues = true;
            internalValueResult.allowedResponseHeaders = this._allowedResponseHeaders;
        }
        if (this._auditNonHmacRequestKeys !== undefined) {
            hasAnyValues = true;
            internalValueResult.auditNonHmacRequestKeys = this._auditNonHmacRequestKeys;
        }
        if (this._auditNonHmacResponseKeys !== undefined) {
            hasAnyValues = true;
            internalValueResult.auditNonHmacResponseKeys = this._auditNonHmacResponseKeys;
        }
        if (this._defaultLeaseTtl !== undefined) {
            hasAnyValues = true;
            internalValueResult.defaultLeaseTtl = this._defaultLeaseTtl;
        }
        if (this._listingVisibility !== undefined) {
            hasAnyValues = true;
            internalValueResult.listingVisibility = this._listingVisibility;
        }
        if (this._maxLeaseTtl !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxLeaseTtl = this._maxLeaseTtl;
        }
        if (this._passthroughRequestHeaders !== undefined) {
            hasAnyValues = true;
            internalValueResult.passthroughRequestHeaders = this._passthroughRequestHeaders;
        }
        if (this._tokenType !== undefined) {
            hasAnyValues = true;
            internalValueResult.tokenType = this._tokenType;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._allowedResponseHeaders = undefined;
            this._auditNonHmacRequestKeys = undefined;
            this._auditNonHmacResponseKeys = undefined;
            this._defaultLeaseTtl = undefined;
            this._listingVisibility = undefined;
            this._maxLeaseTtl = undefined;
            this._passthroughRequestHeaders = undefined;
            this._tokenType = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._allowedResponseHeaders = value.allowedResponseHeaders;
            this._auditNonHmacRequestKeys = value.auditNonHmacRequestKeys;
            this._auditNonHmacResponseKeys = value.auditNonHmacResponseKeys;
            this._defaultLeaseTtl = value.defaultLeaseTtl;
            this._listingVisibility = value.listingVisibility;
            this._maxLeaseTtl = value.maxLeaseTtl;
            this._passthroughRequestHeaders = value.passthroughRequestHeaders;
            this._tokenType = value.tokenType;
        }
    }
    get allowedResponseHeaders() {
        return this.getListAttribute('allowed_response_headers');
    }
    set allowedResponseHeaders(value) {
        this._allowedResponseHeaders = value;
    }
    resetAllowedResponseHeaders() {
        this._allowedResponseHeaders = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowedResponseHeadersInput() {
        return this._allowedResponseHeaders;
    }
    get auditNonHmacRequestKeys() {
        return this.getListAttribute('audit_non_hmac_request_keys');
    }
    set auditNonHmacRequestKeys(value) {
        this._auditNonHmacRequestKeys = value;
    }
    resetAuditNonHmacRequestKeys() {
        this._auditNonHmacRequestKeys = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get auditNonHmacRequestKeysInput() {
        return this._auditNonHmacRequestKeys;
    }
    get auditNonHmacResponseKeys() {
        return this.getListAttribute('audit_non_hmac_response_keys');
    }
    set auditNonHmacResponseKeys(value) {
        this._auditNonHmacResponseKeys = value;
    }
    resetAuditNonHmacResponseKeys() {
        this._auditNonHmacResponseKeys = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get auditNonHmacResponseKeysInput() {
        return this._auditNonHmacResponseKeys;
    }
    get defaultLeaseTtl() {
        return this.getStringAttribute('default_lease_ttl');
    }
    set defaultLeaseTtl(value) {
        this._defaultLeaseTtl = value;
    }
    resetDefaultLeaseTtl() {
        this._defaultLeaseTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultLeaseTtlInput() {
        return this._defaultLeaseTtl;
    }
    get listingVisibility() {
        return this.getStringAttribute('listing_visibility');
    }
    set listingVisibility(value) {
        this._listingVisibility = value;
    }
    resetListingVisibility() {
        this._listingVisibility = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get listingVisibilityInput() {
        return this._listingVisibility;
    }
    get maxLeaseTtl() {
        return this.getStringAttribute('max_lease_ttl');
    }
    set maxLeaseTtl(value) {
        this._maxLeaseTtl = value;
    }
    resetMaxLeaseTtl() {
        this._maxLeaseTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxLeaseTtlInput() {
        return this._maxLeaseTtl;
    }
    get passthroughRequestHeaders() {
        return this.getListAttribute('passthrough_request_headers');
    }
    set passthroughRequestHeaders(value) {
        this._passthroughRequestHeaders = value;
    }
    resetPassthroughRequestHeaders() {
        this._passthroughRequestHeaders = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passthroughRequestHeadersInput() {
        return this._passthroughRequestHeaders;
    }
    get tokenType() {
        return this.getStringAttribute('token_type');
    }
    set tokenType(value) {
        this._tokenType = value;
    }
    resetTokenType() {
        this._tokenType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenTypeInput() {
        return this._tokenType;
    }
}
exports.GithubAuthBackendTuneOutputReference = GithubAuthBackendTuneOutputReference;
_a = JSII_RTTI_SYMBOL_1;
GithubAuthBackendTuneOutputReference[_a] = { fqn: "@cdktf/provider-vault.githubAuthBackend.GithubAuthBackendTuneOutputReference", version: "5.0.0" };
class GithubAuthBackendTuneList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new GithubAuthBackendTuneOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.GithubAuthBackendTuneList = GithubAuthBackendTuneList;
_b = JSII_RTTI_SYMBOL_1;
GithubAuthBackendTuneList[_b] = { fqn: "@cdktf/provider-vault.githubAuthBackend.GithubAuthBackendTuneList", version: "5.0.0" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend vault_github_auth_backend}
*/
class GithubAuthBackend extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend vault_github_auth_backend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GithubAuthBackendConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault_github_auth_backend',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.12.0',
                providerVersionConstraint: '~> 3.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // tune - computed: true, optional: true, required: false
        this._tune = new GithubAuthBackendTuneList(this, "tune", true);
        this._baseUrl = config.baseUrl;
        this._description = config.description;
        this._disableRemount = config.disableRemount;
        this._id = config.id;
        this._namespace = config.namespace;
        this._organization = config.organization;
        this._organizationId = config.organizationId;
        this._path = config.path;
        this._tokenBoundCidrs = config.tokenBoundCidrs;
        this._tokenExplicitMaxTtl = config.tokenExplicitMaxTtl;
        this._tokenMaxTtl = config.tokenMaxTtl;
        this._tokenNoDefaultPolicy = config.tokenNoDefaultPolicy;
        this._tokenNumUses = config.tokenNumUses;
        this._tokenPeriod = config.tokenPeriod;
        this._tokenPolicies = config.tokenPolicies;
        this._tokenTtl = config.tokenTtl;
        this._tokenType = config.tokenType;
        this._tune.internalValue = config.tune;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // accessor - computed: true, optional: false, required: false
    get accessor() {
        return this.getStringAttribute('accessor');
    }
    get baseUrl() {
        return this.getStringAttribute('base_url');
    }
    set baseUrl(value) {
        this._baseUrl = value;
    }
    resetBaseUrl() {
        this._baseUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get baseUrlInput() {
        return this._baseUrl;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get disableRemount() {
        return this.getBooleanAttribute('disable_remount');
    }
    set disableRemount(value) {
        this._disableRemount = value;
    }
    resetDisableRemount() {
        this._disableRemount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableRemountInput() {
        return this._disableRemount;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get namespace() {
        return this.getStringAttribute('namespace');
    }
    set namespace(value) {
        this._namespace = value;
    }
    resetNamespace() {
        this._namespace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInput() {
        return this._namespace;
    }
    get organization() {
        return this.getStringAttribute('organization');
    }
    set organization(value) {
        this._organization = value;
    }
    // Temporarily expose input value. Use with caution.
    get organizationInput() {
        return this._organization;
    }
    get organizationId() {
        return this.getNumberAttribute('organization_id');
    }
    set organizationId(value) {
        this._organizationId = value;
    }
    resetOrganizationId() {
        this._organizationId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get organizationIdInput() {
        return this._organizationId;
    }
    get path() {
        return this.getStringAttribute('path');
    }
    set path(value) {
        this._path = value;
    }
    resetPath() {
        this._path = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pathInput() {
        return this._path;
    }
    get tokenBoundCidrs() {
        return cdktf.Fn.tolist(this.getListAttribute('token_bound_cidrs'));
    }
    set tokenBoundCidrs(value) {
        this._tokenBoundCidrs = value;
    }
    resetTokenBoundCidrs() {
        this._tokenBoundCidrs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenBoundCidrsInput() {
        return this._tokenBoundCidrs;
    }
    get tokenExplicitMaxTtl() {
        return this.getNumberAttribute('token_explicit_max_ttl');
    }
    set tokenExplicitMaxTtl(value) {
        this._tokenExplicitMaxTtl = value;
    }
    resetTokenExplicitMaxTtl() {
        this._tokenExplicitMaxTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenExplicitMaxTtlInput() {
        return this._tokenExplicitMaxTtl;
    }
    get tokenMaxTtl() {
        return this.getNumberAttribute('token_max_ttl');
    }
    set tokenMaxTtl(value) {
        this._tokenMaxTtl = value;
    }
    resetTokenMaxTtl() {
        this._tokenMaxTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenMaxTtlInput() {
        return this._tokenMaxTtl;
    }
    get tokenNoDefaultPolicy() {
        return this.getBooleanAttribute('token_no_default_policy');
    }
    set tokenNoDefaultPolicy(value) {
        this._tokenNoDefaultPolicy = value;
    }
    resetTokenNoDefaultPolicy() {
        this._tokenNoDefaultPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenNoDefaultPolicyInput() {
        return this._tokenNoDefaultPolicy;
    }
    get tokenNumUses() {
        return this.getNumberAttribute('token_num_uses');
    }
    set tokenNumUses(value) {
        this._tokenNumUses = value;
    }
    resetTokenNumUses() {
        this._tokenNumUses = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenNumUsesInput() {
        return this._tokenNumUses;
    }
    get tokenPeriod() {
        return this.getNumberAttribute('token_period');
    }
    set tokenPeriod(value) {
        this._tokenPeriod = value;
    }
    resetTokenPeriod() {
        this._tokenPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenPeriodInput() {
        return this._tokenPeriod;
    }
    get tokenPolicies() {
        return cdktf.Fn.tolist(this.getListAttribute('token_policies'));
    }
    set tokenPolicies(value) {
        this._tokenPolicies = value;
    }
    resetTokenPolicies() {
        this._tokenPolicies = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenPoliciesInput() {
        return this._tokenPolicies;
    }
    get tokenTtl() {
        return this.getNumberAttribute('token_ttl');
    }
    set tokenTtl(value) {
        this._tokenTtl = value;
    }
    resetTokenTtl() {
        this._tokenTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenTtlInput() {
        return this._tokenTtl;
    }
    get tokenType() {
        return this.getStringAttribute('token_type');
    }
    set tokenType(value) {
        this._tokenType = value;
    }
    resetTokenType() {
        this._tokenType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenTypeInput() {
        return this._tokenType;
    }
    get tune() {
        return this._tune;
    }
    putTune(value) {
        this._tune.internalValue = value;
    }
    resetTune() {
        this._tune.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tuneInput() {
        return this._tune.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            base_url: cdktf.stringToTerraform(this._baseUrl),
            description: cdktf.stringToTerraform(this._description),
            disable_remount: cdktf.booleanToTerraform(this._disableRemount),
            id: cdktf.stringToTerraform(this._id),
            namespace: cdktf.stringToTerraform(this._namespace),
            organization: cdktf.stringToTerraform(this._organization),
            organization_id: cdktf.numberToTerraform(this._organizationId),
            path: cdktf.stringToTerraform(this._path),
            token_bound_cidrs: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tokenBoundCidrs),
            token_explicit_max_ttl: cdktf.numberToTerraform(this._tokenExplicitMaxTtl),
            token_max_ttl: cdktf.numberToTerraform(this._tokenMaxTtl),
            token_no_default_policy: cdktf.booleanToTerraform(this._tokenNoDefaultPolicy),
            token_num_uses: cdktf.numberToTerraform(this._tokenNumUses),
            token_period: cdktf.numberToTerraform(this._tokenPeriod),
            token_policies: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tokenPolicies),
            token_ttl: cdktf.numberToTerraform(this._tokenTtl),
            token_type: cdktf.stringToTerraform(this._tokenType),
            tune: cdktf.listMapper(githubAuthBackendTuneToTerraform, false)(this._tune.internalValue),
        };
    }
}
exports.GithubAuthBackend = GithubAuthBackend;
_c = JSII_RTTI_SYMBOL_1;
GithubAuthBackend[_c] = { fqn: "@cdktf/provider-vault.githubAuthBackend.GithubAuthBackend", version: "5.0.0" };
// =================
// STATIC PROPERTIES
// =================
GithubAuthBackend.tfResourceType = "vault_github_auth_backend";
//# sourceMappingURL=data:application/json;base64,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