import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Manage member entities externally through `vault_identity_group_member_entity_ids`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_group#external_member_entity_ids IdentityGroup#external_member_entity_ids}
    */
    readonly externalMemberEntityIds?: boolean | cdktf.IResolvable;
    /**
    * Manage member groups externally through `vault_identity_group_member_group_ids`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_group#external_member_group_ids IdentityGroup#external_member_group_ids}
    */
    readonly externalMemberGroupIds?: boolean | cdktf.IResolvable;
    /**
    * Manage policies externally through `vault_identity_group_policies`, allows using group ID in assigned policies.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_group#external_policies IdentityGroup#external_policies}
    */
    readonly externalPolicies?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_group#id IdentityGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Entity IDs to be assigned as group members.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_group#member_entity_ids IdentityGroup#member_entity_ids}
    */
    readonly memberEntityIds?: string[];
    /**
    * Group IDs to be assigned as group members.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_group#member_group_ids IdentityGroup#member_group_ids}
    */
    readonly memberGroupIds?: string[];
    /**
    * Metadata to be associated with the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_group#metadata IdentityGroup#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Name of the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_group#name IdentityGroup#name}
    */
    readonly name?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_group#namespace IdentityGroup#namespace}
    */
    readonly namespace?: string;
    /**
    * Policies to be tied to the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_group#policies IdentityGroup#policies}
    */
    readonly policies?: string[];
    /**
    * Type of the group, internal or external. Defaults to internal.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_group#type IdentityGroup#type}
    */
    readonly type?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/identity_group vault_identity_group}
*/
export declare class IdentityGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_identity_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/identity_group vault_identity_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityGroupConfig = {}
    */
    constructor(scope: Construct, id: string, config?: IdentityGroupConfig);
    private _externalMemberEntityIds?;
    get externalMemberEntityIds(): boolean | cdktf.IResolvable;
    set externalMemberEntityIds(value: boolean | cdktf.IResolvable);
    resetExternalMemberEntityIds(): void;
    get externalMemberEntityIdsInput(): boolean | cdktf.IResolvable | undefined;
    private _externalMemberGroupIds?;
    get externalMemberGroupIds(): boolean | cdktf.IResolvable;
    set externalMemberGroupIds(value: boolean | cdktf.IResolvable);
    resetExternalMemberGroupIds(): void;
    get externalMemberGroupIdsInput(): boolean | cdktf.IResolvable | undefined;
    private _externalPolicies?;
    get externalPolicies(): boolean | cdktf.IResolvable;
    set externalPolicies(value: boolean | cdktf.IResolvable);
    resetExternalPolicies(): void;
    get externalPoliciesInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _memberEntityIds?;
    get memberEntityIds(): string[];
    set memberEntityIds(value: string[]);
    resetMemberEntityIds(): void;
    get memberEntityIdsInput(): string[] | undefined;
    private _memberGroupIds?;
    get memberGroupIds(): string[];
    set memberGroupIds(value: string[]);
    resetMemberGroupIds(): void;
    get memberGroupIdsInput(): string[] | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _policies?;
    get policies(): string[];
    set policies(value: string[]);
    resetPolicies(): void;
    get policiesInput(): string[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
