import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NamespaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/namespace#id Namespace#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/namespace#namespace Namespace#namespace}
    */
    readonly namespace?: string;
    /**
    * Namespace path.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/namespace#path Namespace#path}
    */
    readonly path: string;
    /**
    * The fully qualified namespace path.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/namespace#path_fq Namespace#path_fq}
    */
    readonly pathFq?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/namespace vault_namespace}
*/
export declare class Namespace extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_namespace";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/namespace vault_namespace} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NamespaceConfig
    */
    constructor(scope: Construct, id: string, config: NamespaceConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get namespaceId(): string;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _pathFq?;
    get pathFq(): string;
    set pathFq(value: string);
    resetPathFq(): void;
    get pathFqInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
