import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VaultProviderConfig {
    /**
    * If true, adds the value of the `address` argument to the Terraform process environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#add_address_to_env VaultProvider#add_address_to_env}
    */
    readonly addAddressToEnv?: string;
    /**
    * URL of the root of the target Vault server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#address VaultProvider#address}
    */
    readonly address: string;
    /**
    * Path to directory containing CA certificate files to validate the server's certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#ca_cert_dir VaultProvider#ca_cert_dir}
    */
    readonly caCertDir?: string;
    /**
    * Path to a CA certificate file to validate the server's certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#ca_cert_file VaultProvider#ca_cert_file}
    */
    readonly caCertFile?: string;
    /**
    * Maximum TTL for secret leases requested by this provider.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#max_lease_ttl_seconds VaultProvider#max_lease_ttl_seconds}
    */
    readonly maxLeaseTtlSeconds?: number;
    /**
    * Maximum number of retries when a 5xx error code is encountered.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#max_retries VaultProvider#max_retries}
    */
    readonly maxRetries?: number;
    /**
    * Maximum number of retries for Client Controlled Consistency related operations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#max_retries_ccc VaultProvider#max_retries_ccc}
    */
    readonly maxRetriesCcc?: number;
    /**
    * The namespace to use. Available only for Vault Enterprise.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#namespace VaultProvider#namespace}
    */
    readonly namespace?: string;
    /**
    * Set this to true to prevent the creation of ephemeral child token used by this provider.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#skip_child_token VaultProvider#skip_child_token}
    */
    readonly skipChildToken?: boolean | cdktf.IResolvable;
    /**
    * Skip the dynamic fetching of the Vault server version.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#skip_get_vault_version VaultProvider#skip_get_vault_version}
    */
    readonly skipGetVaultVersion?: boolean | cdktf.IResolvable;
    /**
    * Set this to true only if the target Vault server is an insecure development instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#skip_tls_verify VaultProvider#skip_tls_verify}
    */
    readonly skipTlsVerify?: boolean | cdktf.IResolvable;
    /**
    * Name to use as the SNI host when connecting via TLS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#tls_server_name VaultProvider#tls_server_name}
    */
    readonly tlsServerName?: string;
    /**
    * Token to use to authenticate to Vault.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#token VaultProvider#token}
    */
    readonly token?: string;
    /**
    * Token name to use for creating the Vault child token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#token_name VaultProvider#token_name}
    */
    readonly tokenName?: string;
    /**
    * Override the Vault server version, which is normally determined dynamically from the target Vault server
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#vault_version_override VaultProvider#vault_version_override}
    */
    readonly vaultVersionOverride?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#alias VaultProvider#alias}
    */
    readonly alias?: string;
    /**
    * auth_login block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#auth_login VaultProvider#auth_login}
    */
    readonly authLogin?: VaultProviderAuthLogin;
    /**
    * auth_login_aws block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#auth_login_aws VaultProvider#auth_login_aws}
    */
    readonly authLoginAws?: VaultProviderAuthLoginAws;
    /**
    * auth_login_azure block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#auth_login_azure VaultProvider#auth_login_azure}
    */
    readonly authLoginAzure?: VaultProviderAuthLoginAzure;
    /**
    * auth_login_cert block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#auth_login_cert VaultProvider#auth_login_cert}
    */
    readonly authLoginCert?: VaultProviderAuthLoginCert;
    /**
    * auth_login_gcp block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#auth_login_gcp VaultProvider#auth_login_gcp}
    */
    readonly authLoginGcp?: VaultProviderAuthLoginGcp;
    /**
    * auth_login_jwt block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#auth_login_jwt VaultProvider#auth_login_jwt}
    */
    readonly authLoginJwt?: VaultProviderAuthLoginJwt;
    /**
    * auth_login_kerberos block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#auth_login_kerberos VaultProvider#auth_login_kerberos}
    */
    readonly authLoginKerberos?: VaultProviderAuthLoginKerberos;
    /**
    * auth_login_oci block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#auth_login_oci VaultProvider#auth_login_oci}
    */
    readonly authLoginOci?: VaultProviderAuthLoginOci;
    /**
    * auth_login_oidc block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#auth_login_oidc VaultProvider#auth_login_oidc}
    */
    readonly authLoginOidc?: VaultProviderAuthLoginOidc;
    /**
    * auth_login_radius block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#auth_login_radius VaultProvider#auth_login_radius}
    */
    readonly authLoginRadius?: VaultProviderAuthLoginRadius;
    /**
    * auth_login_userpass block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#auth_login_userpass VaultProvider#auth_login_userpass}
    */
    readonly authLoginUserpass?: VaultProviderAuthLoginUserpass;
    /**
    * client_auth block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#client_auth VaultProvider#client_auth}
    */
    readonly clientAuth?: VaultProviderClientAuth;
    /**
    * headers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#headers VaultProvider#headers}
    */
    readonly headers?: VaultProviderHeaders[] | cdktf.IResolvable;
}
export interface VaultProviderAuthLogin {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#method VaultProvider#method}
    */
    readonly method?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#namespace VaultProvider#namespace}
    */
    readonly namespace?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#parameters VaultProvider#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#path VaultProvider#path}
    */
    readonly path: string;
}
export declare function vaultProviderAuthLoginToTerraform(struct?: VaultProviderAuthLogin): any;
export interface VaultProviderAuthLoginAws {
    /**
    * The AWS access key ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#aws_access_key_id VaultProvider#aws_access_key_id}
    */
    readonly awsAccessKeyId?: string;
    /**
    * The IAM endpoint URL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#aws_iam_endpoint VaultProvider#aws_iam_endpoint}
    */
    readonly awsIamEndpoint?: string;
    /**
    * The name of the AWS profile.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#aws_profile VaultProvider#aws_profile}
    */
    readonly awsProfile?: string;
    /**
    * The AWS region.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#aws_region VaultProvider#aws_region}
    */
    readonly awsRegion?: string;
    /**
    * The ARN of the AWS Role to assume.Used during STS AssumeRole
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#aws_role_arn VaultProvider#aws_role_arn}
    */
    readonly awsRoleArn?: string;
    /**
    * Specifies the name to attach to the AWS role session. Used during STS AssumeRole
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#aws_role_session_name VaultProvider#aws_role_session_name}
    */
    readonly awsRoleSessionName?: string;
    /**
    * The AWS secret access key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#aws_secret_access_key VaultProvider#aws_secret_access_key}
    */
    readonly awsSecretAccessKey?: string;
    /**
    * The AWS session token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#aws_session_token VaultProvider#aws_session_token}
    */
    readonly awsSessionToken?: string;
    /**
    * Path to the AWS shared credentials file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#aws_shared_credentials_file VaultProvider#aws_shared_credentials_file}
    */
    readonly awsSharedCredentialsFile?: string;
    /**
    * The STS endpoint URL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#aws_sts_endpoint VaultProvider#aws_sts_endpoint}
    */
    readonly awsStsEndpoint?: string;
    /**
    * Path to the file containing an OAuth 2.0 access token or OpenID Connect ID token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#aws_web_identity_token_file VaultProvider#aws_web_identity_token_file}
    */
    readonly awsWebIdentityTokenFile?: string;
    /**
    * The Vault header value to include in the STS signing request.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#header_value VaultProvider#header_value}
    */
    readonly headerValue?: string;
    /**
    * The path where the authentication engine is mounted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#mount VaultProvider#mount}
    */
    readonly mount?: string;
    /**
    * The authentication engine's namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#namespace VaultProvider#namespace}
    */
    readonly namespace?: string;
    /**
    * The Vault role to use when logging into Vault.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#role VaultProvider#role}
    */
    readonly role: string;
}
export declare function vaultProviderAuthLoginAwsToTerraform(struct?: VaultProviderAuthLoginAws): any;
export interface VaultProviderAuthLoginAzure {
    /**
    * The identity's client ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#client_id VaultProvider#client_id}
    */
    readonly clientId?: string;
    /**
    * A signed JSON Web Token. If not specified on will be created automatically
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#jwt VaultProvider#jwt}
    */
    readonly jwt?: string;
    /**
    * The path where the authentication engine is mounted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#mount VaultProvider#mount}
    */
    readonly mount?: string;
    /**
    * The authentication engine's namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#namespace VaultProvider#namespace}
    */
    readonly namespace?: string;
    /**
    * The resource group for the machine that generated the MSI token. This information can be obtained through instance metadata.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#resource_group_name VaultProvider#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Name of the login role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#role VaultProvider#role}
    */
    readonly role: string;
    /**
    * The scopes to include in the token request.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#scope VaultProvider#scope}
    */
    readonly scope?: string;
    /**
    * The subscription ID for the machine that generated the MSI token. This information can be obtained through instance metadata.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#subscription_id VaultProvider#subscription_id}
    */
    readonly subscriptionId: string;
    /**
    * Provides the tenant ID to use in a multi-tenant authentication scenario.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#tenant_id VaultProvider#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * The virtual machine name for the machine that generated the MSI token. This information can be obtained through instance metadata.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#vm_name VaultProvider#vm_name}
    */
    readonly vmName?: string;
    /**
    * The virtual machine scale set name for the machine that generated the MSI token. This information can be obtained through instance metadata.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#vmss_name VaultProvider#vmss_name}
    */
    readonly vmssName?: string;
}
export declare function vaultProviderAuthLoginAzureToTerraform(struct?: VaultProviderAuthLoginAzure): any;
export interface VaultProviderAuthLoginCert {
    /**
    * Path to a file containing the client certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#cert_file VaultProvider#cert_file}
    */
    readonly certFile: string;
    /**
    * Path to a file containing the private key that the certificate was issued for.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#key_file VaultProvider#key_file}
    */
    readonly keyFile: string;
    /**
    * The path where the authentication engine is mounted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#mount VaultProvider#mount}
    */
    readonly mount?: string;
    /**
    * Name of the certificate's role
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#name VaultProvider#name}
    */
    readonly name?: string;
    /**
    * The authentication engine's namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#namespace VaultProvider#namespace}
    */
    readonly namespace?: string;
}
export declare function vaultProviderAuthLoginCertToTerraform(struct?: VaultProviderAuthLoginCert): any;
export interface VaultProviderAuthLoginGcp {
    /**
    * Path to the Google Cloud credentials file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#credentials VaultProvider#credentials}
    */
    readonly credentials?: string;
    /**
    * A signed JSON Web Token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#jwt VaultProvider#jwt}
    */
    readonly jwt?: string;
    /**
    * The path where the authentication engine is mounted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#mount VaultProvider#mount}
    */
    readonly mount?: string;
    /**
    * The authentication engine's namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#namespace VaultProvider#namespace}
    */
    readonly namespace?: string;
    /**
    * Name of the login role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#role VaultProvider#role}
    */
    readonly role: string;
    /**
    * IAM service account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#service_account VaultProvider#service_account}
    */
    readonly serviceAccount?: string;
}
export declare function vaultProviderAuthLoginGcpToTerraform(struct?: VaultProviderAuthLoginGcp): any;
export interface VaultProviderAuthLoginJwt {
    /**
    * A signed JSON Web Token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#jwt VaultProvider#jwt}
    */
    readonly jwt: string;
    /**
    * The path where the authentication engine is mounted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#mount VaultProvider#mount}
    */
    readonly mount?: string;
    /**
    * The authentication engine's namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#namespace VaultProvider#namespace}
    */
    readonly namespace?: string;
    /**
    * Name of the login role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#role VaultProvider#role}
    */
    readonly role: string;
}
export declare function vaultProviderAuthLoginJwtToTerraform(struct?: VaultProviderAuthLoginJwt): any;
export interface VaultProviderAuthLoginKerberos {
    /**
    * Disable the Kerberos FAST negotiation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#disable_fast_negotiation VaultProvider#disable_fast_negotiation}
    */
    readonly disableFastNegotiation?: boolean | cdktf.IResolvable;
    /**
    * The Kerberos keytab file containing the entry of the login entity.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#keytab_path VaultProvider#keytab_path}
    */
    readonly keytabPath?: string;
    /**
    * A valid Kerberos configuration file e.g. /etc/krb5.conf.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#krb5conf_path VaultProvider#krb5conf_path}
    */
    readonly krb5ConfPath?: string;
    /**
    * The path where the authentication engine is mounted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#mount VaultProvider#mount}
    */
    readonly mount?: string;
    /**
    * The authentication engine's namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#namespace VaultProvider#namespace}
    */
    readonly namespace?: string;
    /**
    * The Kerberos server's authoritative authentication domain
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#realm VaultProvider#realm}
    */
    readonly realm?: string;
    /**
    * Strip the host from the username found in the keytab.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#remove_instance_name VaultProvider#remove_instance_name}
    */
    readonly removeInstanceName?: boolean | cdktf.IResolvable;
    /**
    * The service principle name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#service VaultProvider#service}
    */
    readonly service?: string;
    /**
    * Simple and Protected GSSAPI Negotiation Mechanism (SPNEGO) token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#token VaultProvider#token}
    */
    readonly token?: string;
    /**
    * The username to login into Kerberos with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#username VaultProvider#username}
    */
    readonly username?: string;
}
export declare function vaultProviderAuthLoginKerberosToTerraform(struct?: VaultProviderAuthLoginKerberos): any;
export interface VaultProviderAuthLoginOci {
    /**
    * Authentication type to use when getting OCI credentials.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#auth_type VaultProvider#auth_type}
    */
    readonly authType: string;
    /**
    * The path where the authentication engine is mounted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#mount VaultProvider#mount}
    */
    readonly mount?: string;
    /**
    * The authentication engine's namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#namespace VaultProvider#namespace}
    */
    readonly namespace?: string;
    /**
    * Name of the login role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#role VaultProvider#role}
    */
    readonly role: string;
}
export declare function vaultProviderAuthLoginOciToTerraform(struct?: VaultProviderAuthLoginOci): any;
export interface VaultProviderAuthLoginOidc {
    /**
    * The callback address. Must be a valid URI without the path.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#callback_address VaultProvider#callback_address}
    */
    readonly callbackAddress?: string;
    /**
    * The callback listener's address. Must be a valid URI without the path.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#callback_listener_address VaultProvider#callback_listener_address}
    */
    readonly callbackListenerAddress?: string;
    /**
    * The path where the authentication engine is mounted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#mount VaultProvider#mount}
    */
    readonly mount?: string;
    /**
    * The authentication engine's namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#namespace VaultProvider#namespace}
    */
    readonly namespace?: string;
    /**
    * Name of the login role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#role VaultProvider#role}
    */
    readonly role: string;
}
export declare function vaultProviderAuthLoginOidcToTerraform(struct?: VaultProviderAuthLoginOidc): any;
export interface VaultProviderAuthLoginRadius {
    /**
    * The path where the authentication engine is mounted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#mount VaultProvider#mount}
    */
    readonly mount?: string;
    /**
    * The authentication engine's namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#namespace VaultProvider#namespace}
    */
    readonly namespace?: string;
    /**
    * The Radius password for username.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#password VaultProvider#password}
    */
    readonly password: string;
    /**
    * The Radius username.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#username VaultProvider#username}
    */
    readonly username: string;
}
export declare function vaultProviderAuthLoginRadiusToTerraform(struct?: VaultProviderAuthLoginRadius): any;
export interface VaultProviderAuthLoginUserpass {
    /**
    * The path where the authentication engine is mounted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#mount VaultProvider#mount}
    */
    readonly mount?: string;
    /**
    * The authentication engine's namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#namespace VaultProvider#namespace}
    */
    readonly namespace?: string;
    /**
    * Login with password
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#password VaultProvider#password}
    */
    readonly password?: string;
    /**
    * Login with password from a file
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#password_file VaultProvider#password_file}
    */
    readonly passwordFile?: string;
    /**
    * Login with username
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#username VaultProvider#username}
    */
    readonly username: string;
}
export declare function vaultProviderAuthLoginUserpassToTerraform(struct?: VaultProviderAuthLoginUserpass): any;
export interface VaultProviderClientAuth {
    /**
    * Path to a file containing the client certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#cert_file VaultProvider#cert_file}
    */
    readonly certFile?: string;
    /**
    * Path to a file containing the private key that the certificate was issued for.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#key_file VaultProvider#key_file}
    */
    readonly keyFile?: string;
}
export declare function vaultProviderClientAuthToTerraform(struct?: VaultProviderClientAuth): any;
export interface VaultProviderHeaders {
    /**
    * The header name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#name VaultProvider#name}
    */
    readonly name: string;
    /**
    * The header value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#value VaultProvider#value}
    */
    readonly value: string;
}
export declare function vaultProviderHeadersToTerraform(struct?: VaultProviderHeaders | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault vault}
*/
export declare class VaultProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "vault";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault vault} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VaultProviderConfig
    */
    constructor(scope: Construct, id: string, config: VaultProviderConfig);
    private _addAddressToEnv?;
    get addAddressToEnv(): string | undefined;
    set addAddressToEnv(value: string | undefined);
    resetAddAddressToEnv(): void;
    get addAddressToEnvInput(): string | undefined;
    private _address?;
    get address(): string | undefined;
    set address(value: string | undefined);
    get addressInput(): string | undefined;
    private _caCertDir?;
    get caCertDir(): string | undefined;
    set caCertDir(value: string | undefined);
    resetCaCertDir(): void;
    get caCertDirInput(): string | undefined;
    private _caCertFile?;
    get caCertFile(): string | undefined;
    set caCertFile(value: string | undefined);
    resetCaCertFile(): void;
    get caCertFileInput(): string | undefined;
    private _maxLeaseTtlSeconds?;
    get maxLeaseTtlSeconds(): number | undefined;
    set maxLeaseTtlSeconds(value: number | undefined);
    resetMaxLeaseTtlSeconds(): void;
    get maxLeaseTtlSecondsInput(): number | undefined;
    private _maxRetries?;
    get maxRetries(): number | undefined;
    set maxRetries(value: number | undefined);
    resetMaxRetries(): void;
    get maxRetriesInput(): number | undefined;
    private _maxRetriesCcc?;
    get maxRetriesCcc(): number | undefined;
    set maxRetriesCcc(value: number | undefined);
    resetMaxRetriesCcc(): void;
    get maxRetriesCccInput(): number | undefined;
    private _namespace?;
    get namespace(): string | undefined;
    set namespace(value: string | undefined);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _skipChildToken?;
    get skipChildToken(): boolean | cdktf.IResolvable | undefined;
    set skipChildToken(value: boolean | cdktf.IResolvable | undefined);
    resetSkipChildToken(): void;
    get skipChildTokenInput(): boolean | cdktf.IResolvable | undefined;
    private _skipGetVaultVersion?;
    get skipGetVaultVersion(): boolean | cdktf.IResolvable | undefined;
    set skipGetVaultVersion(value: boolean | cdktf.IResolvable | undefined);
    resetSkipGetVaultVersion(): void;
    get skipGetVaultVersionInput(): boolean | cdktf.IResolvable | undefined;
    private _skipTlsVerify?;
    get skipTlsVerify(): boolean | cdktf.IResolvable | undefined;
    set skipTlsVerify(value: boolean | cdktf.IResolvable | undefined);
    resetSkipTlsVerify(): void;
    get skipTlsVerifyInput(): boolean | cdktf.IResolvable | undefined;
    private _tlsServerName?;
    get tlsServerName(): string | undefined;
    set tlsServerName(value: string | undefined);
    resetTlsServerName(): void;
    get tlsServerNameInput(): string | undefined;
    private _token?;
    get token(): string | undefined;
    set token(value: string | undefined);
    resetToken(): void;
    get tokenInput(): string | undefined;
    private _tokenName?;
    get tokenName(): string | undefined;
    set tokenName(value: string | undefined);
    resetTokenName(): void;
    get tokenNameInput(): string | undefined;
    private _vaultVersionOverride?;
    get vaultVersionOverride(): string | undefined;
    set vaultVersionOverride(value: string | undefined);
    resetVaultVersionOverride(): void;
    get vaultVersionOverrideInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    private _authLogin?;
    get authLogin(): VaultProviderAuthLogin | undefined;
    set authLogin(value: VaultProviderAuthLogin | undefined);
    resetAuthLogin(): void;
    get authLoginInput(): VaultProviderAuthLogin | undefined;
    private _authLoginAws?;
    get authLoginAws(): VaultProviderAuthLoginAws | undefined;
    set authLoginAws(value: VaultProviderAuthLoginAws | undefined);
    resetAuthLoginAws(): void;
    get authLoginAwsInput(): VaultProviderAuthLoginAws | undefined;
    private _authLoginAzure?;
    get authLoginAzure(): VaultProviderAuthLoginAzure | undefined;
    set authLoginAzure(value: VaultProviderAuthLoginAzure | undefined);
    resetAuthLoginAzure(): void;
    get authLoginAzureInput(): VaultProviderAuthLoginAzure | undefined;
    private _authLoginCert?;
    get authLoginCert(): VaultProviderAuthLoginCert | undefined;
    set authLoginCert(value: VaultProviderAuthLoginCert | undefined);
    resetAuthLoginCert(): void;
    get authLoginCertInput(): VaultProviderAuthLoginCert | undefined;
    private _authLoginGcp?;
    get authLoginGcp(): VaultProviderAuthLoginGcp | undefined;
    set authLoginGcp(value: VaultProviderAuthLoginGcp | undefined);
    resetAuthLoginGcp(): void;
    get authLoginGcpInput(): VaultProviderAuthLoginGcp | undefined;
    private _authLoginJwt?;
    get authLoginJwt(): VaultProviderAuthLoginJwt | undefined;
    set authLoginJwt(value: VaultProviderAuthLoginJwt | undefined);
    resetAuthLoginJwt(): void;
    get authLoginJwtInput(): VaultProviderAuthLoginJwt | undefined;
    private _authLoginKerberos?;
    get authLoginKerberos(): VaultProviderAuthLoginKerberos | undefined;
    set authLoginKerberos(value: VaultProviderAuthLoginKerberos | undefined);
    resetAuthLoginKerberos(): void;
    get authLoginKerberosInput(): VaultProviderAuthLoginKerberos | undefined;
    private _authLoginOci?;
    get authLoginOci(): VaultProviderAuthLoginOci | undefined;
    set authLoginOci(value: VaultProviderAuthLoginOci | undefined);
    resetAuthLoginOci(): void;
    get authLoginOciInput(): VaultProviderAuthLoginOci | undefined;
    private _authLoginOidc?;
    get authLoginOidc(): VaultProviderAuthLoginOidc | undefined;
    set authLoginOidc(value: VaultProviderAuthLoginOidc | undefined);
    resetAuthLoginOidc(): void;
    get authLoginOidcInput(): VaultProviderAuthLoginOidc | undefined;
    private _authLoginRadius?;
    get authLoginRadius(): VaultProviderAuthLoginRadius | undefined;
    set authLoginRadius(value: VaultProviderAuthLoginRadius | undefined);
    resetAuthLoginRadius(): void;
    get authLoginRadiusInput(): VaultProviderAuthLoginRadius | undefined;
    private _authLoginUserpass?;
    get authLoginUserpass(): VaultProviderAuthLoginUserpass | undefined;
    set authLoginUserpass(value: VaultProviderAuthLoginUserpass | undefined);
    resetAuthLoginUserpass(): void;
    get authLoginUserpassInput(): VaultProviderAuthLoginUserpass | undefined;
    private _clientAuth?;
    get clientAuth(): VaultProviderClientAuth | undefined;
    set clientAuth(value: VaultProviderClientAuth | undefined);
    resetClientAuth(): void;
    get clientAuthInput(): VaultProviderClientAuth | undefined;
    private _headers?;
    get headers(): VaultProviderHeaders[] | cdktf.IResolvable | undefined;
    set headers(value: VaultProviderHeaders[] | cdktf.IResolvable | undefined);
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | VaultProviderHeaders[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
