"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RaftAutopilot = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/raft_autopilot vault_raft_autopilot}
*/
class RaftAutopilot extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/raft_autopilot vault_raft_autopilot} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RaftAutopilotConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'vault_raft_autopilot',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.12.0',
                providerVersionConstraint: '~> 3.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._cleanupDeadServers = config.cleanupDeadServers;
        this._deadServerLastContactThreshold = config.deadServerLastContactThreshold;
        this._disableUpgradeMigration = config.disableUpgradeMigration;
        this._id = config.id;
        this._lastContactThreshold = config.lastContactThreshold;
        this._maxTrailingLogs = config.maxTrailingLogs;
        this._minQuorum = config.minQuorum;
        this._namespace = config.namespace;
        this._serverStabilizationTime = config.serverStabilizationTime;
    }
    get cleanupDeadServers() {
        return this.getBooleanAttribute('cleanup_dead_servers');
    }
    set cleanupDeadServers(value) {
        this._cleanupDeadServers = value;
    }
    resetCleanupDeadServers() {
        this._cleanupDeadServers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cleanupDeadServersInput() {
        return this._cleanupDeadServers;
    }
    get deadServerLastContactThreshold() {
        return this.getStringAttribute('dead_server_last_contact_threshold');
    }
    set deadServerLastContactThreshold(value) {
        this._deadServerLastContactThreshold = value;
    }
    resetDeadServerLastContactThreshold() {
        this._deadServerLastContactThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deadServerLastContactThresholdInput() {
        return this._deadServerLastContactThreshold;
    }
    get disableUpgradeMigration() {
        return this.getBooleanAttribute('disable_upgrade_migration');
    }
    set disableUpgradeMigration(value) {
        this._disableUpgradeMigration = value;
    }
    resetDisableUpgradeMigration() {
        this._disableUpgradeMigration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableUpgradeMigrationInput() {
        return this._disableUpgradeMigration;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get lastContactThreshold() {
        return this.getStringAttribute('last_contact_threshold');
    }
    set lastContactThreshold(value) {
        this._lastContactThreshold = value;
    }
    resetLastContactThreshold() {
        this._lastContactThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lastContactThresholdInput() {
        return this._lastContactThreshold;
    }
    get maxTrailingLogs() {
        return this.getNumberAttribute('max_trailing_logs');
    }
    set maxTrailingLogs(value) {
        this._maxTrailingLogs = value;
    }
    resetMaxTrailingLogs() {
        this._maxTrailingLogs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxTrailingLogsInput() {
        return this._maxTrailingLogs;
    }
    get minQuorum() {
        return this.getNumberAttribute('min_quorum');
    }
    set minQuorum(value) {
        this._minQuorum = value;
    }
    resetMinQuorum() {
        this._minQuorum = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minQuorumInput() {
        return this._minQuorum;
    }
    get namespace() {
        return this.getStringAttribute('namespace');
    }
    set namespace(value) {
        this._namespace = value;
    }
    resetNamespace() {
        this._namespace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInput() {
        return this._namespace;
    }
    get serverStabilizationTime() {
        return this.getStringAttribute('server_stabilization_time');
    }
    set serverStabilizationTime(value) {
        this._serverStabilizationTime = value;
    }
    resetServerStabilizationTime() {
        this._serverStabilizationTime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serverStabilizationTimeInput() {
        return this._serverStabilizationTime;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            cleanup_dead_servers: cdktf.booleanToTerraform(this._cleanupDeadServers),
            dead_server_last_contact_threshold: cdktf.stringToTerraform(this._deadServerLastContactThreshold),
            disable_upgrade_migration: cdktf.booleanToTerraform(this._disableUpgradeMigration),
            id: cdktf.stringToTerraform(this._id),
            last_contact_threshold: cdktf.stringToTerraform(this._lastContactThreshold),
            max_trailing_logs: cdktf.numberToTerraform(this._maxTrailingLogs),
            min_quorum: cdktf.numberToTerraform(this._minQuorum),
            namespace: cdktf.stringToTerraform(this._namespace),
            server_stabilization_time: cdktf.stringToTerraform(this._serverStabilizationTime),
        };
    }
}
exports.RaftAutopilot = RaftAutopilot;
_a = JSII_RTTI_SYMBOL_1;
RaftAutopilot[_a] = { fqn: "@cdktf/provider-vault.raftAutopilot.RaftAutopilot", version: "5.0.0" };
// =================
// STATIC PROPERTIES
// =================
RaftAutopilot.tfResourceType = "vault_raft_autopilot";
//# sourceMappingURL=data:application/json;base64,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