# coding: utf-8

"""
    RIME Rest API

    API methods for RIME. Must be authenticated with `rime-api-key` header.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class NotificationSettingApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def notification_setting_create_notification(self, body, **kwargs):  # noqa: E501
        """CreateNotification  # noqa: E501

        Creates a new notification setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_setting_create_notification(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeCreateNotificationRequest body: (required)
        :return: RimeCreateNotificationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.notification_setting_create_notification_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.notification_setting_create_notification_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def notification_setting_create_notification_with_http_info(self, body, **kwargs):  # noqa: E501
        """CreateNotification  # noqa: E501

        Creates a new notification setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_setting_create_notification_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeCreateNotificationRequest body: (required)
        :return: RimeCreateNotificationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method notification_setting_create_notification" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `notification_setting_create_notification`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/notif-settings', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeCreateNotificationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def notification_setting_delete_notification(self, id, **kwargs):  # noqa: E501
        """DeleteNotification  # noqa: E501

        Hard-delete a notification setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_setting_delete_notification(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.notification_setting_delete_notification_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.notification_setting_delete_notification_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def notification_setting_delete_notification_with_http_info(self, id, **kwargs):  # noqa: E501
        """DeleteNotification  # noqa: E501

        Hard-delete a notification setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_setting_delete_notification_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method notification_setting_delete_notification" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `notification_setting_delete_notification`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/notif-settings/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def notification_setting_list_notifications(self, **kwargs):  # noqa: E501
        """ListNotifications  # noqa: E501

        Lists notification settings with options to filter by project or the type of notification.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_setting_list_notifications(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] list_notifications_query_notification_object_types:  - PROJECT: Used for notifications associated with an project. For object type is PROJECT, the notif object id is the project id.
        :param list[str] list_notifications_query_notification_object_ids:
        :param str page_token:
        :param str page_size:
        :return: RimeListNotificationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.notification_setting_list_notifications_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.notification_setting_list_notifications_with_http_info(**kwargs)  # noqa: E501
            return data

    def notification_setting_list_notifications_with_http_info(self, **kwargs):  # noqa: E501
        """ListNotifications  # noqa: E501

        Lists notification settings with options to filter by project or the type of notification.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_setting_list_notifications_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] list_notifications_query_notification_object_types:  - PROJECT: Used for notifications associated with an project. For object type is PROJECT, the notif object id is the project id.
        :param list[str] list_notifications_query_notification_object_ids:
        :param str page_token:
        :param str page_size:
        :return: RimeListNotificationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['list_notifications_query_notification_object_types', 'list_notifications_query_notification_object_ids', 'page_token', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method notification_setting_list_notifications" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'list_notifications_query_notification_object_types' in params:
            query_params.append(('listNotificationsQuery.notificationObjectTypes', params['list_notifications_query_notification_object_types']))  # noqa: E501
            collection_formats['listNotificationsQuery.notificationObjectTypes'] = 'multi'  # noqa: E501
        if 'list_notifications_query_notification_object_ids' in params:
            query_params.append(('listNotificationsQuery.notificationObjectIds', params['list_notifications_query_notification_object_ids']))  # noqa: E501
            collection_formats['listNotificationsQuery.notificationObjectIds'] = 'multi'  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/notif-settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListNotificationsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def notification_setting_update_notification(self, body, notification_id, **kwargs):  # noqa: E501
        """UpdateNotification  # noqa: E501

        Updates an existing notification setting. The ID in the provided notification is used to identify it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_setting_update_notification(body, notification_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NotifsettingsNotificationIdBody body: (required)
        :param str notification_id: (required)
        :return: RimeUpdateNotificationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.notification_setting_update_notification_with_http_info(body, notification_id, **kwargs)  # noqa: E501
        else:
            (data) = self.notification_setting_update_notification_with_http_info(body, notification_id, **kwargs)  # noqa: E501
            return data

    def notification_setting_update_notification_with_http_info(self, body, notification_id, **kwargs):  # noqa: E501
        """UpdateNotification  # noqa: E501

        Updates an existing notification setting. The ID in the provided notification is used to identify it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_setting_update_notification_with_http_info(body, notification_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NotifsettingsNotificationIdBody body: (required)
        :param str notification_id: (required)
        :return: RimeUpdateNotificationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'notification_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method notification_setting_update_notification" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `notification_setting_update_notification`")  # noqa: E501
        # verify the required parameter 'notification_id' is set
        if ('notification_id' not in params or
                params['notification_id'] is None):
            raise ValueError("Missing the required parameter `notification_id` when calling `notification_setting_update_notification`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'notification_id' in params:
            path_params['notification.id'] = params['notification_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/notif-settings/{notification.id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeUpdateNotificationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
