# poa = place of articulation (0: Labial, Labiodental; lips, 1: Koronal; tongue front, 2: Dorsal; tongue back, 3: Laryngal; glottis)
# tp: tongue position
# th: tongue height
# lr: lip rounding
import pandas as pd
		
		
phoneme_data = pd.DataFrame( [
	dict(
		phoneme_id = 'v_m_1',
		sampa = [ 'a', 'a:' ],
		phoneme_type = 'vowel',
		phoneme_class = 'monophthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = 0,
		tongue_height = -3,
		lip_rounding = 0,
	),
	dict(
		phoneme_id = 'v_m_2',
		sampa = [ 'e', 'e:' ],
		phoneme_type = 'vowel',
		phoneme_class = 'monophthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = -2,
		tongue_height = 1,
		lip_rounding = 0,
	),
	dict(
		phoneme_id = 'v_m_3',
		sampa = [ 'i', 'i:' ],
		phoneme_type = 'vowel',
		phoneme_class = 'monophthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = -2,
		tongue_height = 3,
		lip_rounding = 0,
	),
	dict(
		phoneme_id = 'v_m_4',
		sampa = [ 'o', 'o:' ],
		phoneme_type = 'vowel',
		phoneme_class = 'monophthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = 2,
		tongue_height = 1,
		lip_rounding = 1,
	),
	dict(
		phoneme_id = 'v_m_5',
		sampa = [ 'u', 'u:' ],
		phoneme_type = 'vowel',
		phoneme_class = 'monophthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = 2,
		tongue_height = 3,
		lip_rounding = 1,
	),
	dict(
		phoneme_id = 'v_m_6',
		sampa = [ 'E:' ],
		phoneme_type = 'vowel',
		phoneme_class = 'monophthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = -2,
		tongue_height = -1,
		lip_rounding = 0,
	),
	dict(
		phoneme_id = 'v_m_7',
		sampa = [ '2', '2:' ],
		phoneme_type = 'vowel',
		phoneme_class = 'monophthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = -2,
		tongue_height = 1,
		lip_rounding = 1,
	),
	dict(
		phoneme_id = 'v_m_8',
		sampa = [ 'y', 'y:' ],
		phoneme_type = 'vowel',
		phoneme_class = 'monophthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = -2,
		tongue_height = 3,
		lip_rounding = 1,
	),
	dict(
		phoneme_id = 'v_m_9',
		sampa = [ 'I' ],
		phoneme_type = 'vowel',
		phoneme_class = 'monophthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = -1,
		tongue_height = 2,
		lip_rounding = 0,
	),
	dict(
		phoneme_id = 'v_m_10',
		sampa = [ 'E' ],
		phoneme_type = 'vowel',
		phoneme_class = 'monophthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = -2,
		tongue_height = -1,
		lip_rounding = 0,
	),
	dict(
		phoneme_id = 'v_m_11',
		sampa = [ 'O' ],
		phoneme_type = 'vowel',
		phoneme_class = 'monophthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = 2,
		tongue_height = -1,
		lip_rounding = 1,
	),
	dict(
		phoneme_id = 'v_m_12',
		sampa = [ 'U' ],
		phoneme_type = 'vowel',
		phoneme_class = 'monophthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = 1,
		tongue_height = 2,
		lip_rounding = 1,
	),
	dict(
		phoneme_id = 'v_m_13',
		sampa = [ '9' ],
		phoneme_type = 'vowel',
		phoneme_class = 'monophthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = -2,
		tongue_height = -1,
		lip_rounding = 1,
	),
	dict(
		phoneme_id = 'v_m_14',
		sampa = [ 'Y' ],
		phoneme_type = 'vowel',
		phoneme_class = 'monophthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = -1,
		tongue_height = 2,
		lip_rounding = 1,
	),
	dict(
		phoneme_id = 'v_m_15',
		sampa = [ '@' ],
		phoneme_type = 'vowel',
		phoneme_class = 'monophthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = 0,
		tongue_height = 0,
		lip_rounding = 0,
	),
	dict(
		phoneme_id = 'v_m_16',
		sampa = [ '6' ],
		phoneme_type = 'vowel',
		phoneme_class = 'monophthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = 0,
		tongue_height = -2,
		lip_rounding = 0,
	),
	dict(
		phoneme_id = 'v_d_1',
		sampa = [ 'aI' ],
		phoneme_type = 'vowel',
		phoneme_class = 'diphthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'v_d_2',
		sampa = [ 'aU' ],
		phoneme_type = 'vowel',
		phoneme_class = 'diphthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'v_d_3',
		sampa = [ 'OY' ],
		phoneme_type = 'vowel',
		phoneme_class = 'diphthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'v_d_4',
		sampa = [ 'i6', 'i:6' ],
		phoneme_type = 'vowel',
		phoneme_class = 'diphthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'v_d_5',
		sampa = [ 'I6' ],
		phoneme_type = 'vowel',
		phoneme_class = 'diphthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'v_d_6',
		sampa = [ 'y6', 'y:6' ],
		phoneme_type = 'vowel',
		phoneme_class = 'diphthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'v_d_7',
		sampa = [ 'Y6' ],
		phoneme_type = 'vowel',
		phoneme_class = 'diphthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'v_d_8',
		sampa = [ 'e6', 'e:6' ],
		phoneme_type = 'vowel',
		phoneme_class = 'diphthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'v_d_9',
		sampa = [ 'E6' ],
		phoneme_type = 'vowel',
		phoneme_class = 'diphthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'v_d_10',
		sampa = [ 'E:6' ],
		phoneme_type = 'vowel',
		phoneme_class = 'diphthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'v_d_11',
		sampa = [ '26', '2:6' ],
		phoneme_type = 'vowel',
		phoneme_class = 'diphthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'v_d_12',
		sampa = [ '96' ],
		phoneme_type = 'vowel',
		phoneme_class = 'diphthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'v_d_13',
		sampa = [ 'a6', 'a:6' ],
		phoneme_type = 'vowel',
		phoneme_class = 'diphthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'v_d_14',
		sampa = [ 'u6', 'u:6' ],
		phoneme_type = 'vowel',
		phoneme_class = 'diphthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'v_d_15',
		sampa = [ 'U6' ],
		phoneme_type = 'vowel',
		phoneme_class = 'diphthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'v_d_16',
		sampa = [ 'o6', 'o:6' ],
		phoneme_type = 'vowel',
		phoneme_class = 'diphthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'v_d_17',
		sampa = [ 'O6' ],
		phoneme_type = 'vowel',
		phoneme_class = 'diphthong',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = None,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_a_1',
		sampa = [ 'pf' ],
		phoneme_type = 'consonant',
		phoneme_class = 'affricate',
		voicing = 0,
		nasality = 0,
		plosivity = 1,
		fricativity = 1,
		laterality = 0,
		place_of_articulation = 0,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_a_2',
		sampa = [ 'ts' ],
		phoneme_type = 'consonant',
		phoneme_class = 'affricate',
		voicing = 0,
		nasality = 0,
		plosivity = 1,
		fricativity = 1,
		laterality = 0,
		place_of_articulation = 1,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_a_3',
		sampa = [ 'tS' ],
		phoneme_type = 'consonant',
		phoneme_class = 'affricate',
		voicing = 0,
		nasality = 0,
		plosivity = 1,
		fricativity = 1,
		laterality = 0,
		place_of_articulation = 1,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_a_4',
		sampa = [ 'dZ' ],
		phoneme_type = 'consonant',
		phoneme_class = 'affricate',
		voicing = 1,
		nasality = 0,
		plosivity = 1,
		fricativity = 1,
		laterality = 0,
		place_of_articulation = 1,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_p_1',
		sampa = [ '?' ],
		phoneme_type = 'consonant',
		phoneme_class = 'plosive',
		voicing = 1,
		nasality = 0,
		plosivity = 1,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = 3,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_p_2',
		sampa = [ 'p' ],
		phoneme_type = 'consonant',
		phoneme_class = 'plosive',
		voicing = 0,
		nasality = 0,
		plosivity = 1,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = 0,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_p_3',
		sampa = [ 'b' ],
		phoneme_type = 'consonant',
		phoneme_class = 'plosive',
		voicing = 1,
		nasality = 0,
		plosivity = 1,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = 0,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_p_4',
		sampa = [ 't' ],
		phoneme_type = 'consonant',
		phoneme_class = 'plosive',
		voicing = 0,
		nasality = 0,
		plosivity = 1,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = 1,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_p_5',
		sampa = [ 'd' ],
		phoneme_type = 'consonant',
		phoneme_class = 'plosive',
		voicing = 1,
		nasality = 0,
		plosivity = 1,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = 1,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_p_6',
		sampa = [ 'k' ],
		phoneme_type = 'consonant',
		phoneme_class = 'plosive',
		voicing = 0,
		nasality = 0,
		plosivity = 1,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = 2,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_p_7',
		sampa = [ 'g' ],
		phoneme_type = 'consonant',
		phoneme_class = 'plosive',
		voicing = 1,
		nasality = 0,
		plosivity = 1,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = 2,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_f_1',
		sampa = [ 'f' ],
		phoneme_type = 'consonant',
		phoneme_class = 'fricative',
		voicing = 0,
		nasality = 0,
		plosivity = 0,
		fricativity = 1,
		laterality = 0,
		place_of_articulation = 0,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_f_2',
		sampa = [ 'v' ],
		phoneme_type = 'consonant',
		phoneme_class = 'fricative',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 1,
		laterality = 0,
		place_of_articulation = 0,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_f_3',
		sampa = [ 'T' ],
		phoneme_type = 'consonant',
		phoneme_class = 'fricative',
		voicing = 0,
		nasality = 0,
		plosivity = 0,
		fricativity = 1,
		laterality = 0,
		place_of_articulation = 1,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_f_4',
		sampa = [ 'D' ],
		phoneme_type = 'consonant',
		phoneme_class = 'fricative',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 1,
		laterality = 0,
		place_of_articulation = 1,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_f_5',
		sampa = [ 's' ],
		phoneme_type = 'consonant',
		phoneme_class = 'fricative',
		voicing = 0,
		nasality = 0,
		plosivity = 0,
		fricativity = 1,
		laterality = 0,
		place_of_articulation = 1,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_f_6',
		sampa = [ 'z' ],
		phoneme_type = 'consonant',
		phoneme_class = 'fricative',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 1,
		laterality = 0,
		place_of_articulation = 1,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_f_7',
		sampa = [ 'S' ],
		phoneme_type = 'consonant',
		phoneme_class = 'fricative',
		voicing = 0,
		nasality = 0,
		plosivity = 0,
		fricativity = 1,
		laterality = 0,
		place_of_articulation = 1,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_f_8',
		sampa = [ 'Z' ],
		phoneme_type = 'consonant',
		phoneme_class = 'fricative',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 1,
		laterality = 0,
		place_of_articulation = 1,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_f_9',
		sampa = [ 'C' ],
		phoneme_type = 'consonant',
		phoneme_class = 'fricative',
		voicing = 0,
		nasality = 0,
		plosivity = 0,
		fricativity = 1,
		laterality = 0,
		place_of_articulation = 2,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_f_10',
		sampa = [ 'j' ],
		phoneme_type = 'consonant',
		phoneme_class = 'fricative',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 1,
		laterality = 0,
		place_of_articulation = 2,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_f_11',
		sampa = [ 'x' ],
		phoneme_type = 'consonant',
		phoneme_class = 'fricative',
		voicing = 0,
		nasality = 0,
		plosivity = 0,
		fricativity = 1,
		laterality = 0,
		place_of_articulation = 2,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_f_12',
		sampa = [ 'r' ], # currently r and R produce the same acoustic in VTL
		phoneme_type = 'consonant',
		phoneme_class = 'fricative',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 1,
		laterality = 0,
		place_of_articulation = 1,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_f_13',
		sampa = [ 'R' ],
		phoneme_type = 'consonant',
		phoneme_class = 'fricative',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 1,
		laterality = 0,
		place_of_articulation = 2,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_f_14',
		sampa = [ 'h' ],
		phoneme_type = 'consonant',
		phoneme_class = 'fricative',
		voicing = 0,
		nasality = 0,
		plosivity = 0,
		fricativity = 1,
		laterality = 0,
		place_of_articulation = 3,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_n_1',
		sampa = [ 'm' ],
		phoneme_type = 'consonant',
		phoneme_class = 'nasal',
		voicing = 1,
		nasality = 1,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = 0,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_n_2',
		sampa = [ 'n' ],
		phoneme_type = 'consonant',
		phoneme_class = 'nasal',
		voicing = 1,
		nasality = 1,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = 1,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_n_3',
		sampa = [ 'N' ],
		phoneme_type = 'consonant',
		phoneme_class = 'nasal',
		voicing = 1,
		nasality = 1,
		plosivity = 0,
		fricativity = 0,
		laterality = 0,
		place_of_articulation = 2,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
	),
	dict(
		phoneme_id = 'c_l_1',
		sampa = [ 'l' ],
		phoneme_type = 'consonant',
		phoneme_class = 'lateral',
		voicing = 1,
		nasality = 0,
		plosivity = 0,
		fricativity = 0,
		laterality = 1,
		place_of_articulation = 1,
		tongue_position = None,
		tongue_height = None,
		lip_rounding = None,
		),
] )