# NewsCrawler
[![Build Status](https://travis-ci.org/NewsPipe/NewsCrawler.svg?branch=master)](https://travis-ci.org/NewsPipe/NewsCrawler)
[![PyPI version](https://badge.fury.io/py/NewsCrawler3.svg)](https://badge.fury.io/py/NewsCrawler3)
[![Coverage Status](https://coveralls.io/repos/github/NewsPipe/NewsCrawler/badge.svg?branch=master)](https://coveralls.io/github/NewsPipe/NewsCrawler?branch=master)

NewsCrawler is a Python library for crawling online newspaper articles. It has a minimal interface to insure maximum productivity with minimal work.

Based on the popular libraries: [Newspaper3k](https://github.com/codelucas/newspaper), [BeautifulSoup4](https://www.crummy.com/software/BeautifulSoup/) and [requests](https://github.com/psf/requests)

## Getting Started
In order to install this library, clone the repositor, go to the project's root directory and then run:
```bash
git clone https://github.com/NewsPipe/NewsCrawler.git
pip install .
```

Alternatively, you can install this library from the PyPI repository with:
```bash
pip install NewsCrawler3
```

## Examples
```
>>> from newscrawler import Crawler

>>> crawler = Crawler("zeit.de")
>>> crawler.get_article_information_as_dataframe()
                                        title  ...                                               text
0     Wolf Biermann: Wolf, hast du Angst vor dem Tod?  ...  Dass der Liedermacher Wolf Biermann noch am Le...
1              Österreich: Sie wollen doch nur helfen  ...  Wenn Wien und die ÖVP aufeinandertreffen, dann...
2                 Psychologie: Du darfst dich schämen  ...  Wozu, bitte, soll das gut sein? Das Gesicht lä...
3   Fleischindustrie in Uruguay: 150 Kilo Gewichts...  ...  So muss das Rinderparadies sein: saftig grüne ...
4   Homeschooling: Eine gerechte Note ist nicht mö...  ...  Gut zwölf Wochen Fernunterricht haben die Schü...
5        Vegane Ernährung: Fast schon so was wie Käse  ...  Auf einer aufgebockten Holzplatte hat Nour Akb...
6   Corona-Pandemie: Spanien will den Ausnahmezust...  ...  In Spanien will die Regierung den umstrittenen...
7   Bundesliga, 29. Spieltag: Gladbach klettert mi...  ...  Borussia Mönchengladbach — 1. FC Union Berlin ...
8   SpaceX: Crew-Dragon-Raumkapsel dockt erfolgrei...  ...  Nach etwa 19 Stunden Reise haben die beiden US...
9   Wetter und Viren: Hey Sommer, gib Corona den R...  ...  Der Sommer ist ein natürlicher Feind vieler Vi...
10     Fußball: Premier League darf Saison fortsetzen  ...  Die Premier League darf die Saison nach einer ...
11  Open-Source-Projekt: Entwickler veröffentliche...  ...  Die Entwickler der Corona-Warn-App der Bundesr...
12  Dietzenbach: Nach Angriff auf Beamte Polizei o...  ...  Nachdem am vergangenen Freitag Einsatzkräfte i...
13  Gymnastiklehrerin: "Meine Perspektive: stilvol...  ...  Der Ausbruch des Coronavirus verändert für vie...
14  Bürgerkriegsflüchtlinge: Obergrenze für Famili...  ...  Die Obergrenze für den Familiennachzug von sub...
[15 rows x 7 columns]


>>> crawler.get_article_information_as_dataframe().keys()
Index(['title', 'summary', 'author', 'published', 'link', 'tags', 'text'], dtype='object')
```
