# coding: utf-8

"""
    Tada AI API

    API for access Tada resources

    The version of the OpenAPI document: 0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class SpaceFile(BaseModel):
    """
    SpaceFile
    """ # noqa: E501
    created_at: datetime = Field(alias="createdAt")
    updated_at: datetime = Field(alias="updatedAt")
    id: StrictStr
    original_mime_type: StrictStr = Field(description="The mimetype of the file", alias="originalMimeType")
    space_id: StrictStr = Field(alias="spaceId")
    path: StrictStr = Field(description="The path from the root of the Space")
    status: StrictStr = Field(description="The processing status of the file.")
    __properties: ClassVar[List[str]] = ["createdAt", "updatedAt", "id", "originalMimeType", "spaceId", "path", "status"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['Pending', 'Processing', 'Error', 'Ready']):
            raise ValueError("must be one of enum values ('Pending', 'Processing', 'Error', 'Ready')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SpaceFile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SpaceFile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "id": obj.get("id"),
            "originalMimeType": obj.get("originalMimeType"),
            "spaceId": obj.get("spaceId"),
            "path": obj.get("path"),
            "status": obj.get("status")
        })
        return _obj


