"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BasePathMapping = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const apigateway_generated_1 = require("./apigateway.generated");
const restapi_1 = require("./restapi");
/**
 * This resource creates a base path that clients who call your API must use in the invocation URL.
 *
 * Unless you're importing a domain with `DomainName.fromDomainNameAttributes()`,
 * you can use `DomainName.addBasePathMapping()` to define mappings.
 *
 * @stability stable
 */
class BasePathMapping extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_apigateway_BasePathMappingProps(props);
        if (props.basePath && !core_1.Token.isUnresolved(props.basePath)) {
            if (!props.basePath.match(/^[a-zA-Z0-9$_.+!*'()-]+$/)) {
                throw new Error(`A base path may only contain letters, numbers, and one of "$-_.+!*'()", received: ${props.basePath}`);
            }
        }
        // if restApi is an owned API and it has a deployment stage, map all requests
        // to that stage. otherwise, the stage will have to be specified in the URL.
        const stage = (_b = props.stage) !== null && _b !== void 0 ? _b : (props.restApi instanceof restapi_1.RestApiBase
            ? props.restApi.deploymentStage
            : undefined);
        new apigateway_generated_1.CfnBasePathMapping(this, 'Resource', {
            basePath: props.basePath,
            domainName: props.domainName.domainName,
            restApiId: props.restApi.restApiId,
            stage: stage && stage.stageName,
        });
    }
}
exports.BasePathMapping = BasePathMapping;
_a = JSII_RTTI_SYMBOL_1;
BasePathMapping[_a] = { fqn: "@aws-cdk/aws-apigateway.BasePathMapping", version: "1.135.0" };
//# sourceMappingURL=data:application/json;base64,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