from typing import Any, Optional


def get_hello_data(client_key: Optional[str] = None) -> dict[str, Any]:
    return {
        "id": "register_0",
        "payload": {
            "client-key": client_key,
            "forcePairing": False,
            "manifest": {
                "appVersion": "1.1",
                "manifestVersion": 1,
                "permissions": [
                    "ADD_LAUNCHER_CHANNEL",
                    "APP_TO_APP",
                    "CHECK_BLUETOOTH_DEVICE",
                    "CLOSE",
                    "CONTROL_AUDIO",
                    "CONTROL_BLUETOOTH",
                    "CONTROL_BOX_CHANNEL",
                    "CONTROL_CHANNEL_BLOCK",
                    "CONTROL_CHANNEL_GROUP",
                    "CONTROL_DISPLAY",
                    "CONTROL_FAVORITE_GROUP",
                    "CONTROL_INPUT_JOYSTICK",
                    "CONTROL_INPUT_MEDIA_PLAYBACK",
                    "CONTROL_INPUT_MEDIA_RECORDING",
                    "CONTROL_INPUT_TV",
                    "CONTROL_POWER",
                    "CONTROL_RECORDING",
                    "CONTROL_TIMER_INFO",
                    "CONTROL_TV_POWER",
                    "CONTROL_TV_SCREEN",
                    "CONTROL_TV_STANBY",
                    "CONTROL_USER_INFO",
                    "CONTROL_WOL",
                    "DELETE_SELECT_CHANNEL",
                    "LAUNCH",
                    "LAUNCH_WEBAPP",
                    "READ_APP_STATUS",
                    "READ_COUNTRY_INFO",
                    "READ_CURRENT_CHANNEL",
                    "READ_INPUT_DEVICE_LIST",
                    "READ_NETWORK_STATE",
                    "READ_POWER_STATE",
                    "READ_RECORDING_LIST",
                    "READ_RECORDING_SCHEDULE",
                    "READ_RECORDING_STATE",
                    "READ_RUNNING_APPS",
                    "READ_SETTINGS",
                    "READ_STORAGE_DEVICE_LIST",
                    "READ_TV_ACR_AUTH_TOKEN",
                    "READ_TV_CHANNEL_LIST",
                    "READ_TV_CONTENT_STATE",
                    "READ_TV_CURRENT_TIME",
                    "READ_TV_PROGRAM_INFO",
                    "RELEASE_CHANNEL_SKIP",
                    "SCAN_TV_CHANNELS",
                    "SET_CHANNEL_SKIP",
                    "STB_INTERNAL_CONNECTION",
                    "TEST_OPEN",
                    "TEST_PROTECTED",
                    "WRITE_NOTIFICATION_TOAST",
                    "WRITE_RECORDING_LIST",
                    "WRITE_RECORDING_SCHEDULE",
                ],
                "signatures": [
                    {
                        "signature": "eyJhbGdvcml0aG0iOiJSU0EtU0hBMjU2Iiwia2V5SWQiOiJ0ZXN0LXNpZ25pbmctY2VydCIsInNpZ25hdHVyZVZlcnNpb24iOjF9.hrVRgjCwXVvE2OOSpDZ58hR+59aFNwYDyjQgKk3auukd7pcegmE2CzPCa0bJ0ZsRAcKkCTJrWo5iDzNhMBWRyaMOv5zWSrthlf7G128qvIlpMT0YNY+n/FaOHE73uLrS/g7swl3/qH/BGFG2Hu4RlL48eb3lLKqTt2xKHdCs6Cd4RMfJPYnzgvI4BNrFUKsjkcu+WD4OO2A27Pq1n50cMchmcaXadJhGrOqH5YmHdOCj5NSHzJYrsW0HPlpuAx/ECMeIZYDh6RMqaFM2DXzdKX9NmmyqzJ3o/0lkk/N97gfVRLW5hA29yeAwaCViZNCP8iC9aO0q9fQojoa7NQnAtw==",
                        "signatureVersion": 1,
                    }
                ],
                # These can't be changed, then we get "insufficient permissions" errors
                "signed": {
                    "appId": "com.lge.test",
                    "created": "20140509",
                    "localizedAppNames": {
                        "": "LG Remote App",
                        "ko-KR": "리모컨 앱",
                        "zxx-XX": "ЛГ Rэмotэ AПП",
                    },
                    "localizedVendorNames": {"": "LG Electronics"},
                    "permissions": [
                        "TEST_SECURE",
                        "CONTROL_INPUT_TEXT",
                        "CONTROL_MOUSE_AND_KEYBOARD",
                        "READ_INSTALLED_APPS",
                        "READ_LGE_SDX",
                        "READ_NOTIFICATIONS",
                        "SEARCH",
                        "WRITE_SETTINGS",
                        "WRITE_NOTIFICATION_ALERT",
                        "CONTROL_POWER",
                        "READ_CURRENT_CHANNEL",
                        "READ_RUNNING_APPS",
                        "READ_UPDATE_INFO",
                        "UPDATE_FROM_REMOTE_APP",
                        "READ_LGE_TV_INPUT_EVENTS",
                        "READ_TV_CURRENT_TIME",
                    ],
                    "serial": "2f930e2d2cfe083771f68e4fe7bb07",
                    "vendorId": "com.lge",
                },
            },
            "pairingType": "PROMPT",
        },
        "type": "register",
    }
