(self["webpackChunkjupyterlab_sos"] = self["webpackChunkjupyterlab_sos"] || []).push([["lib_index_js-node_modules_codemirror_addon_mode_sync_recursive"],{

/***/ "./lib/codemirror-sos.js":
/*!*******************************!*\
  !*** ./lib/codemirror-sos.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "sosHintWords": () => (/* binding */ sosHintWords),
/* harmony export */   "sos_mode": () => (/* binding */ sos_mode)
/* harmony export */ });
/* harmony import */ var codemirror__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! codemirror/lib/codemirror */ "./node_modules/codemirror/lib/codemirror.js");
/* harmony import */ var codemirror__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(codemirror__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var codemirror_mode_python_python__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! codemirror/mode/python/python */ "./node_modules/codemirror/mode/python/python.js");
/* harmony import */ var codemirror_mode_python_python__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(codemirror_mode_python_python__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var codemirror_mode_r_r__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! codemirror/mode/r/r */ "./node_modules/codemirror/mode/r/r.js");
/* harmony import */ var codemirror_mode_r_r__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(codemirror_mode_r_r__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var codemirror_mode_markdown_markdown__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! codemirror/mode/markdown/markdown */ "./node_modules/codemirror/mode/markdown/markdown.js");
/* harmony import */ var codemirror_mode_markdown_markdown__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(codemirror_mode_markdown_markdown__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var codemirror_addon_mode_loadmode__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! codemirror/addon/mode/loadmode */ "./node_modules/codemirror/addon/mode/loadmode.js");
/* harmony import */ var codemirror_addon_mode_loadmode__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(codemirror_addon_mode_loadmode__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _manager__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./manager */ "./lib/manager.js");







var sosKeywords = ["input", "output", "depends", "parameter"];
var sosActionWords = [
    "script",
    "download",
    "run",
    "bash",
    "sh",
    "csh",
    "tcsh",
    "zsh",
    "python",
    "python2",
    "python3",
    "R",
    "node",
    "julia",
    "matlab",
    "octave",
    "ruby",
    "perl",
    "report",
    "pandoc",
    "docker_build",
    "Rmarkdown"
];
var sosMagicWords = [
    "cd",
    "capture",
    "clear",
    "debug",
    "dict",
    "expand",
    "get",
    "matplotlib",
    "paste",
    "preview",
    "pull",
    "push",
    "put",
    "render",
    "rerun",
    "run",
    "save",
    "sandbox",
    "set",
    "sessioninfo",
    "sosrun",
    "sossave",
    "shutdown",
    "taskinfo",
    "tasks",
    "toc",
    "use",
    "with"
];
var sosFunctionWords = ["sos_run", "logger", "get_output"];
const sosHintWords = sosKeywords
    .concat(sosActionWords)
    .concat(sosFunctionWords)
    .concat(sosMagicWords);
var sosDirectives = sosKeywords.map(x => x + ":");
var sosActions = sosActionWords.map(x => new RegExp("^\\s*" + x + ":"));
var sosMagics = sosMagicWords.map(x => "%" + x);
function findMode(mode) {
    let modeMap = _manager__WEBPACK_IMPORTED_MODULE_5__.Manager.manager.get_config('sos.kernel_codemirror_mode');
    if (modeMap) {
        if (mode in modeMap) {
            return modeMap[mode];
        }
        else if (typeof mode === 'string' && mode.toLowerCase() in modeMap) {
            return modeMap[mode.toLowerCase()];
        }
    }
    return null;
}
function findModeFromFilename(filename) {
    var val = filename, m, mode;
    if (m = /.+\.([^.]+)$/.exec(val)) {
        var info = codemirror__WEBPACK_IMPORTED_MODULE_0___default().findModeByExtension(m[1]);
        if (info) {
            mode = info.mode;
        }
    }
    else if (/\//.test(val)) {
        var info = codemirror__WEBPACK_IMPORTED_MODULE_0___default().findModeByMIME(val);
        if (info) {
            mode = info.mode;
        }
    }
    else {
        mode = val;
    }
    return mode;
}
function markExpr(python_mode) {
    return {
        startState: function () {
            return {
                in_python: false,
                sigil: false,
                matched: true,
                python_state: codemirror__WEBPACK_IMPORTED_MODULE_0___default().startState(python_mode)
            };
        },
        copyState: function (state) {
            return {
                in_python: state.in_python,
                sigil: state.sigil,
                matched: state.matched,
                python_state: codemirror__WEBPACK_IMPORTED_MODULE_0___default().copyState(python_mode, state.python_state)
            };
        },
        token: function (stream, state) {
            if (state.in_python) {
                if (stream.match(state.sigil.right)) {
                    state.in_python = false;
                    state.python_state = codemirror__WEBPACK_IMPORTED_MODULE_0___default().startState(python_mode);
                    return "sos-sigil";
                }
                let it = null;
                try {
                    it = python_mode.token(stream, state.python_state);
                }
                catch (error) {
                    return ("sos-interpolated error" + (state.matched ? "" : " sos-unmatched"));
                }
                if (it == "variable" || it == "builtin") {
                    let ct = stream.current();
                    // warn users in the use of input and output in {}
                    if (ct === "input" || ct === "output")
                        it += " error";
                }
                return ((it ? "sos-interpolated " + it : "sos-interpolated") +
                    (state.matched ? "" : " sos-unmatched"));
            }
            else {
                // remove the double brace case, the syntax highlighter
                // does not have to worry (highlight) }}, although it would
                // probably mark an error for single }
                if (state.sigil.left === "{" && stream.match(/\{\{/))
                    return null;
                if (stream.match(state.sigil.left)) {
                    state.in_python = true;
                    // let us see if there is any right sigil till the end of the editor.
                    try {
                        let rest = stream.string.slice(stream.pos);
                        if (!rest.includes(state.sigil.right)) {
                            state.matched = false;
                            for (let idx = 1; idx < 5; ++idx) {
                                if (stream.lookAhead(idx).includes(state.sigil.right)) {
                                    state.matched = true;
                                    break;
                                }
                            }
                        }
                    }
                    catch (error) {
                        // only codemirror 5.27.0 supports this function
                    }
                    return "sos-sigil" + (state.matched ? "" : " sos-unmatched");
                }
                while (stream.next() && !stream.match(state.sigil.left, false)) { }
                return null;
            }
        }
    };
}
(codemirror__WEBPACK_IMPORTED_MODULE_0___default().modeURL) = "codemirror/mode/%N/%N.js";
function sos_mode(conf, parserConf) {
    let sosPythonConf = {};
    for (let prop in parserConf) {
        if (parserConf.hasOwnProperty(prop)) {
            sosPythonConf[prop] = parserConf[prop];
        }
    }
    sosPythonConf.name = "python";
    sosPythonConf.version = 3;
    sosPythonConf.extra_keywords = sosActionWords.concat(sosFunctionWords);
    // this is the SoS flavored python mode with more identifiers
    let base_mode = null;
    if ("base_mode" in parserConf && parserConf.base_mode) {
        let spec = findMode(parserConf.base_mode);
        if (spec) {
            let modename = spec;
            if (typeof spec != "string") {
                modename = spec.name;
            }
            if (!codemirror__WEBPACK_IMPORTED_MODULE_0___default().modes.hasOwnProperty(modename)) {
                console.log(`Load codemirror mode ${modename}`);
                codemirror__WEBPACK_IMPORTED_MODULE_0___default().requireMode(modename, function () { }, {});
            }
            base_mode = codemirror__WEBPACK_IMPORTED_MODULE_0___default().getMode(conf, spec);
            // base_mode = CodeMirror.getMode(conf, mode);
        }
        else {
            base_mode = codemirror__WEBPACK_IMPORTED_MODULE_0___default().getMode(conf, parserConf.base_mode);
        }
        // } else {
        //   console.log(
        //     `No base mode is found for ${parserConf.base_mode}. Python mode used.`
        //   );
    }
    // if there is a user specified base mode, this is the single cell mode
    if (base_mode) {
        var python_mode = codemirror__WEBPACK_IMPORTED_MODULE_0___default().getMode({}, {
            name: "python",
            version: 3
        });
        var overlay_mode = markExpr(python_mode);
        return {
            startState: function () {
                return {
                    sos_mode: true,
                    base_state: codemirror__WEBPACK_IMPORTED_MODULE_0___default().startState(base_mode),
                    overlay_state: codemirror__WEBPACK_IMPORTED_MODULE_0___default().startState(overlay_mode),
                    // for overlay
                    basePos: 0,
                    baseCur: null,
                    overlayPos: 0,
                    overlayCur: null,
                    streamSeen: null
                };
            },
            copyState: function (state) {
                return {
                    sos_mode: state.sos_mode,
                    base_state: codemirror__WEBPACK_IMPORTED_MODULE_0___default().copyState(base_mode, state.base_state),
                    overlay_state: codemirror__WEBPACK_IMPORTED_MODULE_0___default().copyState(overlay_mode, state.overlay_state),
                    // for overlay
                    basePos: state.basePos,
                    baseCur: null,
                    overlayPos: state.overlayPos,
                    overlayCur: null
                };
            },
            token: function (stream, state) {
                if (state.sos_mode) {
                    if (stream.sol()) {
                        let sl = stream.peek();
                        if (sl == "!") {
                            stream.skipToEnd();
                            return "meta";
                        }
                        else if (sl == "#") {
                            stream.skipToEnd();
                            return "comment";
                        }
                        for (var i = 0; i < sosMagics.length; i++) {
                            if (stream.match(sosMagics[i])) {
                                if (sosMagics[i] === "%expand") {
                                    // %expand, %expand --in R
                                    if (stream.eol() || stream.match(/\s*(-i\s*\S+|--in\s*\S+)?$/, false)) {
                                        state.overlay_state.sigil = {
                                            left: "{",
                                            right: "}"
                                        };
                                    }
                                    else {
                                        let found = stream.match(/\s+(\S+)\s+(\S+)\s*(-i\s*\S+|--in\s*\S+)?$/, false);
                                        if (found) {
                                            state.overlay_state.sigil = {
                                                left: found[1].match(/^.*[A-Za-z]$/) ? found[1] + ' ' : found[1],
                                                right: found[2].match(/^[A-Za-z].*$/) ? ' ' + found[2] : found[2]
                                            };
                                        }
                                        else {
                                            state.overlay_state.sigil = false;
                                        }
                                    }
                                }
                                // the rest of the lines will be processed as Python code
                                return "meta";
                            }
                        }
                        state.sos_mode = false;
                    }
                    else {
                        stream.skipToEnd();
                        return null;
                    }
                }
                if (state.overlay_state.sigil) {
                    if (stream != state.streamSeen ||
                        Math.min(state.basePos, state.overlayPos) < stream.start) {
                        state.streamSeen = stream;
                        state.basePos = state.overlayPos = stream.start;
                    }
                    if (stream.start == state.basePos) {
                        state.baseCur = base_mode.token(stream, state.base_state);
                        state.basePos = stream.pos;
                    }
                    if (stream.start == state.overlayPos) {
                        stream.pos = stream.start;
                        state.overlayCur = overlay_mode.token(stream, state.overlay_state);
                        state.overlayPos = stream.pos;
                    }
                    stream.pos = Math.min(state.basePos, state.overlayPos);
                    // state.overlay.combineTokens always takes precedence over combine,
                    // unless set to null
                    return state.overlayCur ? state.overlayCur : state.baseCur;
                }
                else {
                    return base_mode.token(stream, state.base_state);
                }
            },
            indent: function (state, textAfter) {
                // inner indent
                if (!state.sos_mode) {
                    if (!base_mode.indent)
                        return (codemirror__WEBPACK_IMPORTED_MODULE_0___default().Pass);
                    // inner mode will autoamtically indent + 4
                    return base_mode.indent(state.base_state, textAfter);
                }
                else {
                    // sos mode has no indent
                    return 0;
                }
            },
            innerMode: function (state) {
                return state.sos_mode
                    ? {
                        state: state.base_state,
                        mode: base_mode
                    }
                    : null;
            },
            lineComment: "#",
            fold: "indent"
        };
    }
    else {
        // this is SoS mode
        base_mode = codemirror__WEBPACK_IMPORTED_MODULE_0___default().getMode(conf, sosPythonConf);
        overlay_mode = markExpr(base_mode);
        return {
            startState: function () {
                return {
                    sos_state: null,
                    base_state: codemirror__WEBPACK_IMPORTED_MODULE_0___default().startState(base_mode),
                    overlay_state: codemirror__WEBPACK_IMPORTED_MODULE_0___default().startState(overlay_mode),
                    inner_mode: null,
                    inner_state: null,
                    // for overlay
                    basePos: 0,
                    baseCur: null,
                    overlayPos: 0,
                    overlayCur: null,
                    streamSeen: null
                };
            },
            copyState: function (state) {
                return {
                    sos_state: state.sos_state,
                    base_state: codemirror__WEBPACK_IMPORTED_MODULE_0___default().copyState(base_mode, state.base_state),
                    overlay_state: codemirror__WEBPACK_IMPORTED_MODULE_0___default().copyState(overlay_mode, state.overlay_state),
                    inner_mode: state.inner_mode,
                    inner_state: state.inner_mode &&
                        codemirror__WEBPACK_IMPORTED_MODULE_0___default().copyState(state.inner_mode, state.inner_state),
                    // for overlay
                    basePos: state.basePos,
                    baseCur: null,
                    overlayPos: state.overlayPos,
                    overlayCur: null
                };
            },
            token: function (stream, state) {
                if (stream.sol()) {
                    let sl = stream.peek();
                    if (sl == "[") {
                        // header, move to the end
                        if (stream.match(/^\[.*\]$/, false)) {
                            // if there is :
                            if (stream.match(/^\[[\s\w_,-]+:/)) {
                                state.sos_state = "header_option";
                                return "header line-section-header";
                            }
                            else if (stream.match(/^\[[\s\w,-]+\]$/)) {
                                // reset state
                                state.sos_state = null;
                                state.inner_mode = null;
                                return "header line-section-header";
                            }
                        }
                    }
                    else if (sl == "!") {
                        stream.eatWhile(/\S/);
                        return "meta";
                    }
                    else if (sl == "#") {
                        stream.skipToEnd();
                        return "comment";
                    }
                    else if (sl == "%") {
                        stream.eatWhile(/\S/);
                        return "meta";
                    }
                    else if (state.sos_state &&
                        state.sos_state.startsWith("entering ")) {
                        // the second parameter is starting column
                        let mode = findMode(state.sos_state.slice(9).toLowerCase());
                        if (mode) {
                            state.inner_mode = codemirror__WEBPACK_IMPORTED_MODULE_0___default().getMode(conf, mode);
                            state.inner_state = codemirror__WEBPACK_IMPORTED_MODULE_0___default().startState(state.inner_mode, stream.indentation());
                            state.sos_state = null;
                        }
                        else {
                            state.sos_state = 'unknown_language';
                        }
                        state.sos_indent = stream.indentation();
                    }
                    if (stream.indentation() === 0 &&
                        ((state.inner_mode &&
                            stream.indentation() < state.sos_indent) || state.sos_state == 'unknown_language')) {
                        state.inner_mode = null;
                        state.sos_state = null;
                    }
                    for (var i = 0; i < sosDirectives.length; i++) {
                        if (stream.match(sosDirectives[i])) {
                            // the rest of the lines will be processed as Python code
                            state.sos_state = "directive_option";
                            return "keyword strong";
                        }
                    }
                    for (var i = 0; i < sosActions.length; i++) {
                        if (stream.match(sosActions[i])) {
                            // switch to submode?
                            if (stream.eol()) {
                                // really
                                let mode = findMode(stream.current().slice(0, -1));
                                if (mode) {
                                    state.sos_state =
                                        "entering " + stream.current().slice(0, -1);
                                }
                                else {
                                    state.sos_state = "entering unknown_language";
                                }
                            }
                            else {
                                state.sos_state = "start " + stream.current().slice(0, -1);
                            }
                            state.overlay_state.sigil = false;
                            return "builtin strong";
                        }
                    }
                    // if unknown action
                    if (stream.match(/\w+:/)) {
                        state.overlay_state.sigil = false;
                        state.sos_state = "start " + stream.current().slice(0, -1);
                        return "builtin strong";
                    }
                }
                else if (state.sos_state == "header_option") {
                    // stuff after :
                    if (stream.peek() == "]") {
                        // move next
                        stream.next();
                        // ] is the last char
                        if (stream.eol()) {
                            state.sos_state = null;
                            state.inner_mode = null;
                            return "header line-section-header";
                        }
                        else {
                            stream.backUp(1);
                            let it = base_mode.token(stream, state.base_state);
                            return it ? it + " sos-option" : null;
                        }
                    }
                    else {
                        let it = base_mode.token(stream, state.base_state);
                        return it ? it + " sos-option" : null;
                    }
                }
                else if (state.sos_state == "directive_option") {
                    // stuff after input:, R: etc
                    if (stream.peek() == ",") {
                        // move next
                        stream.next();
                        // , is the last char, continue option line
                        if (stream.eol()) {
                            stream.backUp(1);
                            let it = base_mode.token(stream, state.base_state);
                            return it ? it + " sos-option" : null;
                        }
                        stream.backUp(1);
                    }
                    else if (stream.eol()) {
                        // end of line stops option mode
                        state.sos_state = null;
                        state.inner_mode = null;
                    }
                    let it = base_mode.token(stream, state.base_state);
                    return it ? it + " sos-option" : null;
                }
                else if (state.sos_state && state.sos_state.startsWith("start ")) {
                    // try to understand option expand=
                    if (stream.match(/^.*expand\s*=\s*True/, false)) {
                        // highlight {}
                        state.overlay_state.sigil = {
                            left: "{",
                            right: "}"
                        };
                    }
                    else {
                        let found = stream.match(/^.*expand\s*=\s*"(\S+) (\S+)"/, false);
                        if (!found)
                            found = stream.match(/^.*expand\s*=\s*'(\S+) (\S+)'/, false);
                        if (found) {
                            state.overlay_state.sigil = {
                                left: found[1].match(/^.*[A-Za-z]$/) ? found[1] + ' ' : found[1],
                                right: found[2].match(/^[A-Za-z].*$/) ? ' ' + found[2] : found[2]
                            };
                        }
                    }
                    let mode_string = state.sos_state.slice(6).toLowerCase();
                    // for report, we need to find "output" option
                    if (mode_string === "report" &&
                        stream.match(/^.*output\s*=\s*/, false)) {
                        let found = stream.match(/^.*output\s*=\s*[rRbufF]*"""([^"]+)"""/, false);
                        if (!found)
                            found = stream.match(/^.*output\s*=\s*[rRbufF]*'''([^.]+)'''/, false);
                        if (!found)
                            found = stream.match(/^.*output\s*=\s*[rRbufF]*"([^"]+)"/, false);
                        if (!found)
                            found = stream.match(/^.*output\s*=\s*[rRbufF]*'([^']+)'/, false);
                        // found[1] is the filename
                        state.sos_state = 'start ' + findModeFromFilename(found ? found[1] : found);
                    }
                    let token = base_mode.token(stream, state.base_state);
                    // if it is end of line, ending the starting switch mode
                    if (stream.eol() && stream.peek() !== ",") {
                        // really
                        let mode = findMode(state.sos_state.slice(6).toLowerCase());
                        if (mode) {
                            state.sos_state = "entering " + state.sos_state.slice(6);
                        }
                        else {
                            state.sos_state = "entering unknown_language";
                        }
                    }
                    return token + " sos-option";
                }
                // can be start of line but not special
                if (state.sos_state == "unknown_language") {
                    // we still handle {} in no man unknown_language
                    if (state.overlay_state.sigil) {
                        return overlay_mode.token(stream, state.overlay_state);
                    }
                    else {
                        stream.skipToEnd();
                        return null;
                    }
                }
                else if (state.inner_mode) {
                    let it = "sos_script ";
                    if (!state.overlay_state.sigil) {
                        let st = state.inner_mode.token(stream, state.inner_state);
                        return st ? it + st : null;
                    }
                    else {
                        // overlay mode, more complicated
                        if (stream != state.streamSeen ||
                            Math.min(state.basePos, state.overlayPos) < stream.start) {
                            state.streamSeen = stream;
                            state.basePos = state.overlayPos = stream.start;
                        }
                        if (stream.start == state.basePos) {
                            state.baseCur = state.inner_mode.token(stream, state.inner_state);
                            state.basePos = stream.pos;
                        }
                        if (stream.start == state.overlayPos) {
                            stream.pos = stream.start;
                            state.overlayCur = overlay_mode.token(stream, state.overlay_state);
                            state.overlayPos = stream.pos;
                        }
                        stream.pos = Math.min(state.basePos, state.overlayPos);
                        // state.overlay.combineTokens always takes precedence over combine,
                        // unless set to null
                        return ((state.overlayCur ? state.overlayCur : state.baseCur) +
                            " sos-script");
                    }
                }
                else {
                    return base_mode.token(stream, state.base_state);
                }
            },
            indent: function (state, textAfter) {
                // inner indent
                if (state.inner_mode) {
                    if (!state.inner_mode.indent)
                        return (codemirror__WEBPACK_IMPORTED_MODULE_0___default().Pass);
                    return state.inner_mode.indent(state.inner_mode, textAfter) + 2;
                }
                else {
                    return base_mode.indent(state.base_state, textAfter);
                }
            },
            innerMode: function (state) {
                return state.inner_mode
                    ? null
                    : {
                        state: state.base_state,
                        mode: base_mode
                    };
            },
            lineComment: "#",
            fold: "indent",
            electricInput: /^\s*[\}\]\)]$/
        };
    }
}
;


/***/ }),

/***/ "./lib/execute.js":
/*!************************!*\
  !*** ./lib/execute.js ***!
  \************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "wrapConsoleExecutor": () => (/* binding */ wrapConsoleExecutor),
/* harmony export */   "wrapExecutor": () => (/* binding */ wrapExecutor)
/* harmony export */ });
/* harmony import */ var _manager__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./manager */ "./lib/manager.js");
/* harmony import */ var _selectors__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./selectors */ "./lib/selectors.js");


function wrapExecutor(panel) {
    var _a;
    let kernel = (_a = panel.sessionContext.session) === null || _a === void 0 ? void 0 : _a.kernel;
    // override kernel execute with the wrapper.
    // however, this function can be called multiple times for kernel
    // restart etc, so we should be careful
    if (kernel && !kernel.hasOwnProperty("orig_execute")) {
        kernel["orig_execute"] = kernel.requestExecute;
        kernel.requestExecute = my_execute;
        console.log("executor patched");
    }
}
function wrapConsoleExecutor(panel) {
    var _a;
    let kernel = (_a = panel.sessionContext.session) === null || _a === void 0 ? void 0 : _a.kernel;
    // override kernel execute with the wrapper.
    // however, this function can be called multiple times for kernel
    // restart etc, so we should be careful
    if (!kernel.hasOwnProperty("orig_execute")) {
        kernel["orig_execute"] = kernel.requestExecute;
        kernel.requestExecute = my_execute;
        console.log("console executor patched");
    }
}
function scanHeaderLines(cells) {
    let TOC = "";
    for (let i = 0; i < cells.length; ++i) {
        let cell = cells[i].model;
        if (cell.type === "markdown") {
            var lines = cell.value.text.split("\n");
            for (let l = 0; l < lines.length; ++l) {
                if (lines[l].match("^#+ ")) {
                    TOC += lines[l] + "\n";
                }
            }
        }
    }
    return TOC;
}
// get the workflow part of text from a cell
function getCellWorkflow(cell) {
    var lines = cell.value.text.split("\n");
    var workflow = "";
    var l;
    for (l = 0; l < lines.length; ++l) {
        if (lines[l].startsWith("%include") || lines[l].startsWith("%from")) {
            workflow += lines[l] + "\n";
            continue;
        }
        else if (lines[l].startsWith("#") ||
            lines[l].startsWith("%") ||
            lines[l].trim() === "" ||
            lines[l].startsWith("!")) {
            continue;
        }
        else if (lines[l].startsWith("[") && lines[l].endsWith("]")) {
            // include comments before section header
            let c = l - 1;
            let comment = "";
            while (c >= 0 && lines[c].startsWith("#")) {
                comment = lines[c] + "\n" + comment;
                c -= 1;
            }
            workflow += comment + lines.slice(l).join("\n") + "\n\n";
            break;
        }
    }
    return workflow;
}
// get workflow from notebook
function getNotebookWorkflow(panel) {
    let cells = panel.content.widgets;
    let workflow = "";
    for (let i = 0; i < cells.length; ++i) {
        let cell = cells[i].model;
        if (cell.type === "code" &&
            (!cell.metadata.get("kernel") || cell.metadata.get("kernel") === "SoS")) {
            workflow += getCellWorkflow(cell);
        }
    }
    if (workflow != "") {
        workflow = "#!/usr/bin/env sos-runner\n#fileformat=SOS1.0\n\n" + workflow;
    }
    return workflow;
}
function getNotebookContent(panel) {
    let cells = panel.content.widgets;
    let workflow = "#!/usr/bin/env sos-runner\n#fileformat=SOS1.0\n\n";
    for (let i = 0; i < cells.length; ++i) {
        let cell = cells[i].model;
        if (cell.type === "code") {
            workflow += `# cell ${i + 1}, kernel=${cell.metadata.get("kernel")}\n${cell.value.text}\n\n`;
        }
    }
    return workflow;
}
function my_execute(content, disposeOnDone = true, metadata) {
    let code = content.code;
    metadata.sos = {};
    let panel = _manager__WEBPACK_IMPORTED_MODULE_0__.Manager.currentNotebook;
    if (code.match(/^%sosrun($|\s)|^%run($|\s)|^%convert($|\s)|^%preview\s.*(-w|--workflow).*$/m)) {
        if (code.match(/^%convert\s.*(-a|--all).*$/m)) {
            metadata.sos["workflow"] = getNotebookContent(panel);
        }
        else {
            metadata.sos["workflow"] = getNotebookWorkflow(panel);
        }
    }
    metadata.sos["path"] = panel.context.path;
    metadata.sos["use_panel"] = _manager__WEBPACK_IMPORTED_MODULE_0__.Manager.consolesOfNotebook(panel).length > 0;
    metadata.sos["use_iopub"] = true;
    let info = _manager__WEBPACK_IMPORTED_MODULE_0__.Manager.manager.get_info(panel);
    // find the cell that is being executed...
    let cells = panel.content.widgets;
    if (code.match(/^%toc/m)) {
        metadata.sos["toc"] = scanHeaderLines(cells);
    }
    let cell = panel.content.widgets.find(x => x.model.id === metadata.cellId);
    if (cell) {
        // check *
        // let prompt = cell.node.querySelector(".jp-InputArea-prompt");
        // if (!prompt || prompt.textContent.indexOf("*") === -1) continue;
        // use cell kernel if meta exists, otherwise use nb.metadata["sos"].default_kernel
        if (info.autoResume) {
            metadata.sos["rerun"] = true;
            info.autoResume = false;
        }
        metadata.sos["cell_id"] = cell.model.id;
        metadata.sos["cell_kernel"] = cell.model.metadata.get("kernel");
        if (metadata.sos["cell_kernel"] === "Markdown") {
            // fold the input of markdown cells
            cell.inputHidden = true;
        }
    }
    else {
        let labconsole = _manager__WEBPACK_IMPORTED_MODULE_0__.Manager.currentConsole.console;
        let last_cell = labconsole.cells.get(labconsole.cells.length - 1);
        let kernel = last_cell.model.metadata.get("kernel");
        kernel = kernel ? kernel.toString() : "SoS";
        // change the color of console cell
        (0,_selectors__WEBPACK_IMPORTED_MODULE_1__.changeCellKernel)(last_cell, kernel, info);
        (0,_selectors__WEBPACK_IMPORTED_MODULE_1__.changeCellKernel)(labconsole.promptCell, kernel, info);
        // hide the drop down box
        (0,_selectors__WEBPACK_IMPORTED_MODULE_1__.hideLanSelector)(last_cell);
        metadata.sos["cell_kernel"] = kernel;
        metadata.sos["cell_id"] = -1;
        content.silent = false;
        content.store_history = true;
    }
    return this.orig_execute(content, disposeOnDone, metadata);
}


/***/ }),

/***/ "./lib/index.js":
/*!**********************!*\
  !*** ./lib/index.js ***!
  \**********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SoSWidgets": () => (/* binding */ SoSWidgets),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/algorithm */ "webpack/sharing/consume/default/@lumino/algorithm");
/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lumino_disposable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/disposable */ "webpack/sharing/consume/default/@lumino/disposable");
/* harmony import */ var _lumino_disposable__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_disposable__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_settingregistry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/settingregistry */ "webpack/sharing/consume/default/@jupyterlab/settingregistry");
/* harmony import */ var _jupyterlab_settingregistry__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_settingregistry__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _jupyterlab_codemirror__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/codemirror */ "webpack/sharing/consume/default/@jupyterlab/codemirror");
/* harmony import */ var _jupyterlab_codemirror__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_codemirror__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var codemirror__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! codemirror */ "./node_modules/codemirror/lib/codemirror.js");
/* harmony import */ var codemirror__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(codemirror__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @jupyterlab/notebook */ "webpack/sharing/consume/default/@jupyterlab/notebook");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _jupyterlab_console__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @jupyterlab/console */ "webpack/sharing/consume/default/@jupyterlab/console");
/* harmony import */ var _jupyterlab_console__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_console__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _codemirror_sos__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./codemirror-sos */ "./lib/codemirror-sos.js");
/* harmony import */ var _selectors__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./selectors */ "./lib/selectors.js");
/* harmony import */ var _execute__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./execute */ "./lib/execute.js");
/* harmony import */ var _style_index_css__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../style/index.css */ "./style/index.css");
/* harmony import */ var _manager__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./manager */ "./lib/manager.js");











// define and register SoS CodeMirror mode



/*
 * Define SoS File msg_type
 */
const SOS_MIME_TYPE = "text/x-sos";
function registerSoSFileType(app) {
    app.docRegistry.addFileType({
        name: "SoS",
        displayName: "SoS File",
        extensions: [".sos"],
        mimeTypes: [SOS_MIME_TYPE],
        iconClass: "jp-MaterialIcon sos_icon"
    });
}
function defineSoSCodeMirrorMode(code_mirror_singleton) {
    // hint word for SoS mode
    try {
        code_mirror_singleton.registerHelper("hintWords", "sos", _codemirror_sos__WEBPACK_IMPORTED_MODULE_9__.sosHintWords);
    }
    catch (error) {
        console.log(`Failed to register hintWords for sos mode. ${error}`);
    }
    code_mirror_singleton.defineMode("sos", _codemirror_sos__WEBPACK_IMPORTED_MODULE_9__.sos_mode, "python");
    code_mirror_singleton.defineMIME("text/x-sos", "sos");
    code_mirror_singleton.modeInfo.push({
        ext: ["sos"],
        mime: "text/x-sos",
        mode: "sos",
        name: "SoS"
    });
}
function formatDuration(ms) {
    let res = [];
    let seconds = Math.floor(ms / 1000);
    let day = Math.floor(seconds / 86400);
    if (day > 0) {
        res.push(day + " day");
    }
    let hh = Math.floor((seconds % 86400) / 3600);
    if (hh > 0) {
        res.push(hh + " hr");
    }
    let mm = Math.floor((seconds % 3600) / 60);
    if (mm > 0) {
        res.push(mm + " min");
    }
    let ss = seconds % 60;
    if (ss > 0) {
        res.push(ss + " sec");
    }
    let ret = res.join(" ");
    if (ret === "") {
        return "0 sec";
    }
    else {
        return ret;
    }
}
function update_duration() {
    setInterval(function () {
        document
            .querySelectorAll("[id^='status_duration_']")
            .forEach((item) => {
            if (item.className != "running") {
                return;
            }
            item.innerText =
                "Ran for " +
                    formatDuration(+new Date() - +new Date(parseFloat(item.getAttribute("datetime"))));
        });
    }, 5000);
}
/* When a notebook is opened with multiple workflow or task tables,
 * the tables have display_id but the ID maps will not be properly
 * setup so that the tables cannot be updated with another
 * update_display_data message. To fix this problem, we will have
 * to manually populate the
 *   output_area._display_id_targets
 * structure.
 */
function fix_display_id(cell) {
    if (cell.outputArea._displayIdMap.size > 0) {
        return;
    }
    for (let idx = 0; idx < cell.outputArea.model.length; ++idx) {
        let output = cell.outputArea.model.get(idx);
        if (output.type != "display_data" || !output.data["text/html"]) {
            continue;
        }
        // the HTML should look like
        // <table id="task_macpro_90775d4e30583c18" class="task_table running">
        if (!output.data || !output.data["text/html"]) {
            continue;
        }
        let id = output.data["text/html"].match(/id="([^"]*)"/);
        if (!id || !id[1]) {
            continue;
        }
        let targets = cell.outputArea._displayIdMap.get(id[1]) || [];
        targets.push(idx);
        let target_id = id[1];
        if (target_id.match('^task_.*')) {
            target_id = target_id.split("_").slice(0, -1).join("_");
        }
        cell.outputArea._displayIdMap.set(target_id, targets);
    }
}
function add_data_to_cell(cell, data, display_id) {
    if (data.output_type === "update_display_data") {
        fix_display_id(cell);
        let targets = cell.outputArea._displayIdMap.get(display_id);
        if (!targets) {
            // something wrong
            console.log("Failed to rebuild displayIdMap");
            return;
        }
        data.output_type = "display_data";
        for (let index of targets) {
            cell.outputArea.model.set(index, data);
        }
    }
    else {
        cell.outputArea.model.add(data);
        let targets = cell.outputArea._displayIdMap.get(display_id) || [];
        targets.push(cell.outputArea.model.length - 1);
        cell.outputArea._displayIdMap.set(display_id, targets);
    }
}
// add workflow status indicator table
function update_workflow_status(info, panel) {
    // find the cell
    let cell_id = info.cell_id;
    let cell = panel.content.widgets.find(x => x.model.id == cell_id);
    if (!cell) {
        console.log(`Cannot find cell by ID ${info.cell_id}`);
        return;
    }
    // if there is an existing status table, try to retrieve its information
    // if the new data does not have it
    let has_status_table = document.getElementById(`workflow_${cell_id}`);
    if (!has_status_table && info.status != "pending") {
        return;
    }
    let timer_text = "";
    if (info.start_time) {
        // convert from python time to JS time.
        info.start_time = info.start_time * 1000;
    }
    if (info.status == "purged") {
        if (!has_status_table) {
            return;
        }
        let data = {
            output_type: "update_display_data",
            transient: { display_id: `workflow_${cell_id}` },
            metadata: {},
            data: {
                "text/html": ""
            }
        };
        add_data_to_cell(cell, data, `workflow_${cell_id}`);
    }
    if (has_status_table) {
        // if we already have timer, let us try to "fix" it in the notebook
        let timer = document.getElementById(`status_duration_${cell_id}`);
        timer_text = timer.innerText;
        if (timer_text === "" &&
            (info.status === "completed" ||
                info.status === "failed" ||
                info.status === "aborted")) {
            timer_text = "Ran for < 5 seconds";
        }
        if (!info.start_time) {
            info.start_time = timer.getAttribute("datetime");
        }
        //
        if (!info.workflow_id) {
            info.workflow_id = document.getElementById(`workflow_id_${cell_id}`).innerText;
        }
        if (!info.workflow_name) {
            info.workflow_name = document.getElementById(`workflow_name_${cell_id}`).innerText;
        }
        if (!info.index) {
            info.index = document.getElementById(`workflow_index_${cell_id}`).innerText;
        }
    }
    // new and existing, check icon
    let status_class = {
        pending: "fa-square-o",
        running: "fa-spinner fa-pulse fa-spin",
        completed: "fa-check-square-o",
        failed: "fa-times-circle-o",
        aborted: "fa-frown-o"
    };
    // look for status etc and update them.
    let onmouseover = `onmouseover='this.classList="fa fa-2x fa-fw fa-trash"'`;
    let onmouseleave = `onmouseleave='this.classList="fa fa-2x fa-fw ${status_class[info.status]}"'`;
    let onclick = `onclick="cancel_workflow(this.id.substring(21))"`;
    let data = {
        output_type: has_status_table ? "update_display_data" : "display_data",
        transient: { display_id: `workflow_${cell_id}` },
        metadata: {},
        data: {
            "text/html": `
<table id="workflow_${cell_id}" class="workflow_table  ${info.status}">
<tr>
      <td class="workflow_icon">
        <i id="workflow_status_icon_${cell_id}" class="fa fa-2x fa-fw ${status_class[info.status]}"
        ${onmouseover} ${onmouseleave} ${onclick}></i>
      </td>
      <td class="workflow_name">
        <pre><span id="workflow_name_${cell_id}">${info.workflow_name}</span></pre>
      </td>
      <td class="workflow_id">
        <span>Workflow ID</span></br>
        <pre><i class="fa fa-fw fa-sitemap"></i><span id="workflow_id_${cell_id}">${info.workflow_id}</span></pre>
      </td>
      <td class="workflow_index">
        <span>Index</span></br>
        <pre>#<span id="workflow_index_${cell_id}">${info.index}</span></pre>
      </td>
      <td class="workflow_status">
        <span id="status_text_${cell_id}">${info.status}</span></br>
        <pre><i class="fa fa-fw fa-clock-o"></i><time id="status_duration_${cell_id}" class="${info.status}" datetime="${info.start_time}">${timer_text}</time></pre>
      </td>
</tr>
</table>
`
        }
    };
    add_data_to_cell(cell, data, `workflow_${cell_id}`);
}
function update_task_status(info, panel) {
    // find the cell
    //console.log(info);
    // special case, purge by tag, there is no task_id
    if (!info.task_id && info.tag && info.status == "purged") {
        // find all elements by tag
        let elems = document.getElementsByClassName(`task_tag_${info.tag}`);
        if (!elems) {
            return;
        }
        let cell_elems = Array.from(elems).map(x => x.closest(".jp-CodeCell"));
        let cells = cell_elems.map(cell_elem => panel.content.widgets.find(x => x.node == cell_elem));
        let display_ids = Array.from(elems).map(x => x.closest(".task_table").id.split('_').slice(0, -1).join('_'));
        for (let i = 0; i < cells.length; ++i) {
            let data = {
                output_type: "update_display_data",
                transient: { display_id: display_ids[i] },
                metadata: {},
                data: {
                    "text/html": ""
                }
            };
            add_data_to_cell(cells[i], data, display_ids[i]);
        }
        return;
    }
    let elem_id = `${info.queue}_${info.task_id}`;
    // convert between Python and JS float time
    if (info.start_time) {
        info.start_time = info.start_time * 1000;
    }
    // find the status table
    let cell_id = info.cell_id;
    let cell = null;
    let has_status_table;
    if (cell_id) {
        cell = panel.content.widgets.find(x => x.model.id == cell_id);
        has_status_table = document.getElementById(`task_${elem_id}_${cell_id}`);
        if (!has_status_table && info.status != 'pending') {
            // if there is already a table inside, with cell_id that is different from before...
            has_status_table = document.querySelector(`[id^="task_${elem_id}"]`);
            if (has_status_table) {
                cell_id = has_status_table.id.split("_").slice(-1)[0];
                cell = panel.content.widgets.find(x => x.model.id == cell_id);
            }
        }
        if (info.update_only && !has_status_table) {
            console.log(`Cannot find cell by cell ID ${info.cell_id} or task ID ${info.task_id} to update`);
            return;
        }
    }
    else {
        has_status_table = document.querySelector(`[id^="task_${elem_id}"]`);
        let elem = has_status_table.closest(".jp-CodeCell");
        cell = panel.content.widgets.find(x => x.node == elem);
        cell_id = cell.model.id;
    }
    if (!cell) {
        console.log(`Cannot find cell by ID ${info.cell_id}`);
        return;
    }
    if (info.status == "purged") {
        if (has_status_table) {
            let data = {
                output_type: "update_display_data",
                transient: { display_id: `task_${elem_id}` },
                metadata: {},
                data: {
                    "text/html": ""
                }
            };
            add_data_to_cell(cell, data, `task_${elem_id}`);
        }
        return;
    }
    // if there is an existing status table, try to retrieve its information
    // the new data does not have it
    let timer_text = "";
    if (has_status_table) {
        // if we already have timer, let us try to "fix" it in the notebook
        let timer = document.getElementById(`status_duration_${elem_id}_${cell_id}`);
        if (!timer) {
            // we could be opening an previous document with different cell_id
            timer = document.querySelector(`[id^="status_duration_${elem_id}"]`);
        }
        if (timer) {
            timer_text = timer.innerText;
            if (timer_text === "" &&
                (info.status === "completed" ||
                    info.status === "failed" ||
                    info.status === "aborted")) {
                timer_text = "Ran for < 5 seconds";
            }
            if (!info.start_time) {
                info.start_time = timer.getAttribute("datetime");
            }
            if (!info.tags) {
                let tags = document.getElementById(`status_tags_${elem_id}_${cell_id}`);
                if (!tags) {
                    tags = document.querySelector(`[id^="status_tags_${elem_id}"]`);
                }
                if (tags) {
                    info.tags = tags.innerText;
                }
            }
        }
    }
    let status_class = {
        pending: "fa-square-o",
        submitted: "fa-spinner",
        running: "fa-spinner fa-pulse fa-spin",
        completed: "fa-check-square-o",
        failed: "fa-times-circle-o",
        aborted: "fa-frown-o",
        missing: "fa-question"
    };
    // look for status etc and update them.
    let id_elems = `<pre>${info.task_id}` +
        `<div class="task_id_actions">` +
        `<i class="fa fa-fw fa-refresh" onclick="task_action({action:'status', task:'${info.task_id}', queue: '${info.queue}'})"></i>` +
        `<i class="fa fa-fw fa-play" onclick="task_action({action:'execute', task:'${info.task_id}', queue: '${info.queue}'})"></i>` +
        `<i class="fa fa-fw fa-stop"" onclick="task_action({action:'kill', task:'${info.task_id}', queue: '${info.queue}'})"></i>` +
        `<i class="fa fa-fw fa-trash"" onclick="task_action({action:'purge', task:'${info.task_id}', queue: '${info.queue}'})"></i>` +
        `</div></pre>`;
    let tags = info.tags.split(/\s+/g);
    let tags_elems = "";
    for (let ti = 0; ti < tags.length; ++ti) {
        let tag = tags[ti];
        if (!tag) {
            continue;
        }
        tags_elems +=
            `<pre class="task_tags task_tag_${tag}">${tag}` +
                `<div class="task_tag_actions">` +
                `<i class="fa fa-fw fa-refresh" onclick="task_action({action:'status', tag:'${tag}', queue: '${info.queue}'})"></i>` +
                `<i class="fa fa-fw fa-stop"" onclick="task_action({action:'kill', tag:'${tag}', queue: '${info.queue}'})"></i>` +
                `<i class="fa fa-fw fa-trash"" onclick="task_action({action:'purge', tag:'${tag}', queue: '${info.queue}'})"></i>` +
                `</div></pre>`;
    }
    let data = {
        output_type: has_status_table ? "update_display_data" : "display_data",
        transient: { display_id: `task_${elem_id}` },
        metadata: {},
        data: {
            "text/html": `
<table id="task_${elem_id}_${cell_id}" class="task_table ${info.status}">
<tr>
  <td class="task_icon">
    <i id="task_status_icon_${elem_id}_${cell_id}" class="fa fa-2x fa-fw ${status_class[info.status]}"
    ${onmouseover} ${onmouseleave} ${onclick}></i>
  </td>
  <td class="task_id">
    <span><pre><i class="fa fa-fw fa-sitemap"></i></pre>${id_elems}</span>
  </td>
  <td class="task_tags">
    <span id="status_tags_${elem_id}_${cell_id}"><pre><i class="fa fa-fw fa-info-circle"></i></pre>${tags_elems}</span>
  </td>
  <td class="task_timer">
    <pre><i class="fa fa-fw fa-clock-o"></i><time id="status_duration_${elem_id}_${cell_id}" class="${info.status}" datetime="${info.start_time}">${timer_text}</time></pre>
  </td>
  <td class="task_status">
    <pre><i class="fa fa-fw fa-tasks"></i><span id="status_text_${elem_id}_${cell_id}">${info.status}</span></pre>
  </td>
</tr>
</table>
`
        }
    };
    add_data_to_cell(cell, data, `task_${elem_id}`);
}
/*
 * SoS frontend Comm
 */
function on_frontend_msg(msg) {
    let data = msg.content.data;
    let panel = _manager__WEBPACK_IMPORTED_MODULE_10__.Manager.manager.notebook_of_comm(msg.content.comm_id);
    let msg_type = msg.metadata.msg_type;
    let info = _manager__WEBPACK_IMPORTED_MODULE_10__.Manager.manager.get_info(panel);
    console.log(`Received ${msg_type}`);
    if (msg_type === "kernel-list") {
        info.updateLanguages(data);
        let unknownTasks = (0,_selectors__WEBPACK_IMPORTED_MODULE_11__.updateCellStyles)(panel, info);
        if (unknownTasks) {
            info.sos_comm.send({
                "update-task-status": unknownTasks
            });
        }
        console.log("kernel list updated");
    }
    else if (msg_type === "cell-kernel") {
        // jupyter lab does not yet handle panel cell
        if (data[0] === "") {
            return;
        }
        let cell = panel.content.widgets.find(x => x.model.id == data[0]);
        if (!cell) {
            return;
        }
        if (cell.model.metadata.get("kernel") !== info.DisplayName.get(data[1])) {
            (0,_selectors__WEBPACK_IMPORTED_MODULE_11__.changeCellKernel)(cell, info.DisplayName.get(data[1]), info);
            (0,_selectors__WEBPACK_IMPORTED_MODULE_11__.saveKernelInfo)();
        }
        else if (cell.model.metadata.get("tags") &&
            cell.model.metadata.get("tags").indexOf("report_output") >= 0) {
            // #639
            // if kernel is different, changeStyleOnKernel would set report_output.
            // otherwise we mark report_output
            let op = cell.node.getElementsByClassName("jp-Cell-outputWrapper");
            for (let i = 0; i < op.length; ++i) {
                op.item(i).classList.add("report-output");
            }
        }
        /* } else if (msg_type === "preview-input") {
         cell = window.my_panel.cell;
         cell.clear_input();
         cell.set_text(data);
         cell.clear_output();
       } else if (msg_type === "preview-kernel") {
         changeStyleOnKernel(window.my_panel.cell, data);
       */
    }
    else if (msg_type === "highlight-workflow") {
        let elem = document.getElementById(data[1]);
        codemirror__WEBPACK_IMPORTED_MODULE_5___default().fromTextArea(elem, {
            mode: "sos"
        });
        // if in a regular notebook, we use static version of the HTML
        // to replace the codemirror js version.
        if (data[0]) {
            let cell = panel.content.widgets.find(x => x.model.id == data[0]);
            let cm_node = elem.parentElement.lastElementChild;
            add_data_to_cell(cell, {
                output_type: "update_display_data",
                transient: { display_id: data[1] },
                metadata: {},
                data: {
                    "text/html": cm_node.outerHTML
                }
            }, data[1]);
            cm_node.remove();
        }
    }
    else if (msg_type === "tasks-pending") {
        let cell = panel.content.widgets[data[0]];
        info.pendingCells.set(cell.model.id, data[1]);
    }
    else if (msg_type === "remove-task") {
        let item = document.querySelector(`[id^="table_${data[0]}_${data[1]}"]`);
        if (item) {
            item.parentNode.removeChild(item);
        }
    }
    else if (msg_type === "task_status") {
        update_task_status(data, panel);
        if (data.status === "running") {
            update_duration();
        }
    }
    else if (msg_type == "workflow_status") {
        update_workflow_status(data, panel);
        if (data.status === "running") {
            update_duration();
        }
        // if this is a terminal status, try to execute the
        // next pending workflow
        if (data.status === "completed" ||
            data.status === "canceled" ||
            data.status === "failed") {
            // find all cell_ids with pending workflows
            let elems = document.querySelectorAll("[id^='status_duration_']");
            let pending = Array.from(elems)
                .filter(item => {
                return (item.className == "pending" && !item.id.substring(16).includes("_"));
            })
                .map(item => {
                return item.id.substring(16);
            });
            if (pending) {
                window.execute_workflow(pending);
            }
        }
    }
    else if (msg_type === "paste-table") {
        //let idx = panel.content.activeCellIndex;
        //let cm = panel.content.widgets[idx].editor;
        // cm.replaceRange(data, cm.getCursor());
    }
    else if (msg_type == "print") {
        let cell = panel.content.widgets.find(x => x.model.id == data[0]);
        cell.outputArea.model.add({
            output_type: "stream",
            name: "stdout",
            text: data[1]
        });
    }
    else if (msg_type === "alert") {
        alert(data);
    }
    else if (msg_type === "notebook-version") {
        // right now no upgrade, just save version to notebook
        panel.content.model.metadata.get("sos")["version"] = data;
    }
}
function connectSoSComm(panel, renew = false) {
    var _a;
    let info = _manager__WEBPACK_IMPORTED_MODULE_10__.Manager.manager.get_info(panel);
    if (info.sos_comm && !renew)
        return;
    try {
        let sos_comm = (_a = panel.context.sessionContext.session) === null || _a === void 0 ? void 0 : _a.kernel.createComm("sos_comm");
        if (!sos_comm) {
            console.log(`Failed to connect to sos_comm. Will try later.`);
            return null;
        }
        _manager__WEBPACK_IMPORTED_MODULE_10__.Manager.manager.register_comm(sos_comm, panel);
        sos_comm.open("initial");
        sos_comm.onMsg = on_frontend_msg;
        if (panel.content.model.metadata.has("sos")) {
            sos_comm.send({
                "notebook-version": panel.content.model.metadata.get("sos")["version"],
                "list-kernel": panel.content.model.metadata.get("sos")["kernels"]
            });
        }
        else {
            sos_comm.send({
                "notebook-version": "",
                "list-kernel": []
            });
        }
        console.log("sos comm registered");
    }
    catch (err) {
        // if the kernel is for the notebook console, an exception
        // 'Comms are disabled on this kernel connection' will be thrown
        console.log(err);
        return;
    }
}
function hideSoSWidgets(element) {
    let sos_elements = element.getElementsByClassName("sos-widget");
    for (let i = 0; i < sos_elements.length; ++i)
        sos_elements[i].style.display = "none";
}
function showSoSWidgets(element) {
    let sos_elements = element.getElementsByClassName("sos-widget");
    for (let i = 0; i < sos_elements.length; ++i)
        sos_elements[i].style.display = "";
}
window.task_action = async function (param) {
    if (!param.action) {
        return;
    }
    let commands = _manager__WEBPACK_IMPORTED_MODULE_10__.Manager.commands;
    let path = _manager__WEBPACK_IMPORTED_MODULE_10__.Manager.currentNotebook.context.path;
    let code = `%task ${param.action}` +
        (param.task ? ` ${param.task}` : "") +
        (param.tag ? ` -t ${param.tag}` : "") +
        (param.queue ? ` -q ${param.queue}` : "");
    await commands.execute("console:open", {
        activate: false,
        insertMode: "split-bottom",
        path
    });
    await commands.execute("console:inject", {
        activate: false,
        code,
        path
    });
};
window.cancel_workflow = function (cell_id) {
    console.log("Cancel workflow " + cell_id);
    let info = _manager__WEBPACK_IMPORTED_MODULE_10__.Manager.manager.get_info(_manager__WEBPACK_IMPORTED_MODULE_10__.Manager.currentNotebook);
    info.sos_comm.send({
        "cancel-workflow": [cell_id]
    });
};
window.execute_workflow = function (cell_ids) {
    console.log("Run workflows " + cell_ids);
    let info = _manager__WEBPACK_IMPORTED_MODULE_10__.Manager.manager.get_info(_manager__WEBPACK_IMPORTED_MODULE_10__.Manager.currentNotebook);
    info.sos_comm.send({
        "execute-workflow": cell_ids
    });
};
class SoSWidgets {
    /**
     * The createNew function does not return whatever created. It is just a registery that Will
     * be called when a notebook is created/opened, and the toolbar is created. it is therefore
     * a perfect time to insert SoS language selector and create comms during this time.
     */
    createNew(panel, context) {
        // register notebook to get language info, or get existing info
        // unfortunately, for new notebook, language info is currently empty
        let info = _manager__WEBPACK_IMPORTED_MODULE_10__.Manager.manager.get_info(panel);
        // this is a singleton class
        context.sessionContext.ready.then(() => {
            // kernel information (for opened notebook) should be ready at this time.
            // However, when the notebook is created from File -> New Notebook -> Select Kernel
            // The kernelPreference.name is not yet set and we have to use kernelDisplayName
            // which is SoS (not sos)
            let cur_kernel = panel.context.sessionContext.kernelPreference.name ||
                panel.context.sessionContext.kernelDisplayName;
            if (cur_kernel.toLowerCase() === "sos") {
                console.log(`session ready with kernel sos`);
                // if this is not a sos kernel, remove all buttons
                if (panel.content.model.metadata.has("sos")) {
                    info.updateLanguages(panel.content.model.metadata.get("sos")["kernels"]);
                }
                else {
                    panel.content.model.metadata.set("sos", {
                        kernels: [["SoS", "sos", "", ""]],
                        version: ""
                    });
                }
                // connectSoSComm(panel);
                // wrapExecutor(panel);
                (0,_selectors__WEBPACK_IMPORTED_MODULE_11__.updateCellStyles)(panel, info);
                showSoSWidgets(panel.node);
            }
            else {
                hideSoSWidgets(panel.node);
            }
        });
        context.sessionContext.kernelChanged.connect((sender, args) => {
            // somehow when the kernelChanged is sent, there could be no newValue?
            if (!args.newValue) {
                return;
            }
            console.log(`kernel changed to ${args.newValue.name}`);
            if (args.newValue.name === "sos") {
                if (panel.content.model.metadata.has("sos")) {
                    info.updateLanguages(panel.content.model.metadata.get("sos")["kernels"]);
                }
                else {
                    panel.content.model.metadata.set("sos", {
                        kernels: [["SoS", "sos", "", ""]],
                        version: ""
                    });
                }
                // connectSoSComm(panel);
                // wrapExecutor(panel);
                (0,_selectors__WEBPACK_IMPORTED_MODULE_11__.updateCellStyles)(panel, info);
                showSoSWidgets(panel.node);
            }
            else {
                // in this case, the .sos_widget should be hidden
                hideSoSWidgets(panel.node);
            }
        });
        context.sessionContext.statusChanged.connect((sender, status) => {
            // if a sos notebook is restarted
            if ((status === "busy" || status === "starting") &&
                panel.context.sessionContext.kernelDisplayName === "SoS") {
                connectSoSComm(panel);
                (0,_execute__WEBPACK_IMPORTED_MODULE_12__.wrapExecutor)(panel);
            }
        });
        panel.content.model.cells.changed.connect((list, changed) => {
            let cur_kernel = panel.context.sessionContext.kernelPreference.name ||
                panel.context.sessionContext.kernelDisplayName;
            if (cur_kernel.toLowerCase() === "sos") {
                (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.each)(changed.newValues, cellmodel => {
                    let idx = changed.newIndex; // panel.content.widgets.findIndex(x => x.model.id == cellmodel.id);
                    let cell = panel.content.widgets[idx];
                    if (changed.type !== "add" && changed.type !== "set") {
                        return;
                    }
                    let kernel = "SoS";
                    if (cell.model.metadata.has("kernel")) {
                        kernel = cell.model.metadata.get("kernel");
                    }
                    else {
                        // find the kernel of a cell before this one to determine the default
                        // kernel of a new cell #18
                        if (idx > 0) {
                            for (idx = idx - 1; idx >= 0; --idx) {
                                if (panel.content.widgets[idx].model.type === "code") {
                                    kernel = panel.content.widgets[idx].model.metadata.get("kernel");
                                    break;
                                }
                            }
                        }
                        cell.model.metadata.set("kernel", kernel);
                    }
                    (0,_selectors__WEBPACK_IMPORTED_MODULE_11__.addLanSelector)(cell, info);
                    (0,_selectors__WEBPACK_IMPORTED_MODULE_11__.changeStyleOnKernel)(cell, kernel, info);
                });
            }
        });
        panel.content.activeCellChanged.connect((sender, cell) => {
            // this event is triggered both when a cell gets focus, and
            // also when a new notebook is created etc when cell does not exist
            if (cell && cell.model.type === "code" && info.sos_comm) {
                if (info.sos_comm.isDisposed) {
                    // this happens after kernel restart #53
                    connectSoSComm(panel, true);
                }
                let cell_kernel = cell.model.metadata.get("kernel");
                info.sos_comm.send({
                    "set-editor-kernel": cell_kernel
                });
            }
        });
        return new _lumino_disposable__WEBPACK_IMPORTED_MODULE_1__.DisposableDelegate(() => { });
    }
}
function registerSoSWidgets(app) {
    app.docRegistry.addWidgetExtension("Notebook", new SoSWidgets());
}
window.filterDataFrame = function (id) {
    var input = document.getElementById("search_" + id);
    ;
    var filter = input.value.toUpperCase();
    var table = document.getElementById("dataframe_" + id);
    var tr = table.getElementsByTagName("tr");
    // Loop through all table rows, and hide those who do not match the search query
    for (var i = 1; i < tr.length; i++) {
        for (var j = 0; j < tr[i].cells.length; ++j) {
            var matched = false;
            if (tr[i].cells[j].innerHTML.toUpperCase().indexOf(filter) !== -1) {
                tr[i].style.display = "";
                matched = true;
                break;
            }
            if (!matched) {
                tr[i].style.display = "none";
            }
        }
    }
};
window.sortDataFrame = function (id, n, dtype) {
    var table = document.getElementById("dataframe_" + id);
    var tb = table.tBodies[0]; // use `<tbody>` to ignore `<thead>` and `<tfoot>` rows
    var tr = Array.prototype.slice.call(tb.rows, 0); // put rows into array
    var fn = dtype === "numeric"
        ? function (a, b) {
            return parseFloat(a.cells[n].textContent) <=
                parseFloat(b.cells[n].textContent)
                ? -1
                : 1;
        }
        : function (a, b) {
            var c = a.cells[n].textContent
                .trim()
                .localeCompare(b.cells[n].textContent.trim());
            return c > 0 ? 1 : c < 0 ? -1 : 0;
        };
    var isSorted = function (array, fn) {
        if (array.length < 2) {
            return 1;
        }
        var direction = fn(array[0], array[1]);
        for (var i = 1; i < array.length - 1; ++i) {
            var d = fn(array[i], array[i + 1]);
            if (d === 0) {
                continue;
            }
            else if (direction === 0) {
                direction = d;
            }
            else if (direction !== d) {
                return 0;
            }
        }
        return direction;
    };
    var sorted = isSorted(tr, fn);
    var i;
    if (sorted === 1 || sorted === -1) {
        // if sorted already, reverse it
        for (i = tr.length - 1; i >= 0; --i) {
            tb.appendChild(tr[i]); // append each row in order
        }
    }
    else {
        tr = tr.sort(fn);
        for (i = 0; i < tr.length; ++i) {
            tb.appendChild(tr[i]); // append each row in order
        }
    }
};
/**
 * Initialization data for the sos-extension extension.
 */
const PLUGIN_ID = 'jupyterlab-sos:plugin';
const extension = {
    id: "vatlab/jupyterlab-extension:sos",
    autoStart: true,
    requires: [_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_6__.INotebookTracker, _jupyterlab_console__WEBPACK_IMPORTED_MODULE_7__.IConsoleTracker, _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.ICommandPalette, _jupyterlab_codemirror__WEBPACK_IMPORTED_MODULE_4__.ICodeMirror, _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.IToolbarWidgetRegistry,
        _jupyterlab_settingregistry__WEBPACK_IMPORTED_MODULE_2__.ISettingRegistry],
    activate: async (app, notebook_tracker, console_tracker, palette, codeMirror, toolbarRegistry, settingRegistry) => {
        registerSoSFileType(app);
        registerSoSWidgets(app);
        _manager__WEBPACK_IMPORTED_MODULE_10__.Manager.set_trackers(notebook_tracker, console_tracker);
        _manager__WEBPACK_IMPORTED_MODULE_10__.Manager.set_commands(app.commands);
        // Toolbar
        // - Define a custom toolbar item
        toolbarRegistry.registerFactory('Cell', 'kernel_selector', (cell) => new _selectors__WEBPACK_IMPORTED_MODULE_11__.KernelSwitcher());
        let settings = null;
        if (settingRegistry) {
            settings = await settingRegistry.load(PLUGIN_ID);
            _manager__WEBPACK_IMPORTED_MODULE_10__.Manager.manager.update_config(settings);
        }
        console_tracker.widgetAdded.connect((sender, panel) => {
            const labconsole = panel.console;
            labconsole.promptCellCreated.connect(panel => {
                if (_manager__WEBPACK_IMPORTED_MODULE_10__.Manager.currentNotebook) {
                    let info = _manager__WEBPACK_IMPORTED_MODULE_10__.Manager.manager.get_info(_manager__WEBPACK_IMPORTED_MODULE_10__.Manager.currentNotebook);
                    (0,_selectors__WEBPACK_IMPORTED_MODULE_11__.addLanSelector)(panel.promptCell, info);
                }
            });
            labconsole.sessionContext.statusChanged.connect((sender, status) => {
                var _a;
                if (status == "busy" &&
                    ((_a = panel.console.sessionContext) === null || _a === void 0 ? void 0 : _a.kernelDisplayName) === "SoS") {
                    console.log(`connected to sos kernel`);
                    // connectSoSComm(panel, true);
                    (0,_execute__WEBPACK_IMPORTED_MODULE_12__.wrapConsoleExecutor)(panel);
                }
            });
        });
        defineSoSCodeMirrorMode(codeMirror.CodeMirror);
        // add an command to toggle output
        const command_toggle_output = "sos:toggle_output";
        app.commands.addCommand(command_toggle_output, {
            label: "Toggle cell output tags",
            execute: () => {
                // get current notebook and toggle current cell
                (0,_selectors__WEBPACK_IMPORTED_MODULE_11__.toggleDisplayOutput)(notebook_tracker.activeCell);
            }
        });
        // add an command to toggle output
        const command_toggle_kernel = "sos:toggle_kernel";
        app.commands.addCommand(command_toggle_kernel, {
            label: "Toggle cell kernel",
            execute: () => {
                // get current notebook and toggle current cell
                (0,_selectors__WEBPACK_IMPORTED_MODULE_11__.toggleCellKernel)(notebook_tracker.activeCell, notebook_tracker.currentWidget);
            }
        });
        // add an command to toggle output
        const command_toggle_markdown = "sos:toggle_markdown";
        app.commands.addCommand(command_toggle_markdown, {
            label: "Toggle cell kernel",
            execute: () => {
                // get current notebook and toggle current cell
                (0,_selectors__WEBPACK_IMPORTED_MODULE_11__.toggleMarkdownCell)(notebook_tracker.activeCell, notebook_tracker.currentWidget);
            }
        });
        // app.commands.addKeyBinding({
        //   keys: ["Ctrl Shift O"],
        //   selector: ".jp-Notebook.jp-mod-editMode",
        //   command: "sos:toggle_output"
        // });
        // app.commands.addKeyBinding({
        //   keys: ["Ctrl Shift Enter"],
        //   selector: ".jp-Notebook.jp-mod-editMode",
        //   command: "notebook:run-in-console"
        // });
        // Add the command to the palette.
        palette.addItem({ command: command_toggle_output, category: "Cell output" });
        palette.addItem({ command: command_toggle_kernel, category: "Toggle kernel" });
        palette.addItem({ command: command_toggle_markdown, category: "Toggle markdown" });
        console.log("JupyterLab extension sos-extension is activated!");
    }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (extension);


/***/ }),

/***/ "./lib/manager.js":
/*!************************!*\
  !*** ./lib/manager.js ***!
  \************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Manager": () => (/* binding */ Manager),
/* harmony export */   "NotebookInfo": () => (/* binding */ NotebookInfo),
/* harmony export */   "safe_css_name": () => (/* binding */ safe_css_name)
/* harmony export */ });
//
class NotebookInfo {
    /** create an info object from metadata of the notebook
     */
    constructor(notebook) {
        this.notebook = notebook;
        this.KernelList = new Array();
        this.autoResume = false;
        this.sos_comm = null;
        this.BackgroundColor = new Map();
        this.DisplayName = new Map();
        this.KernelName = new Map();
        this.LanguageName = new Map();
        this.KernelOptions = new Map();
        this.CodeMirrorMode = new Map();
        this.pendingCells = new Map();
        let data = [["SoS", "sos", "", ""]];
        if (notebook.model.metadata.has("sos"))
            data = notebook.model.metadata.get("sos")["kernels"];
        // fill the look up tables with language list passed from the kernel
        for (let i = 0; i < data.length; i++) {
            // BackgroundColor is color
            this.BackgroundColor.set(data[i][0], data[i][3]);
            this.BackgroundColor.set(data[i][1], data[i][3]);
            // DisplayName
            this.DisplayName.set(data[i][0], data[i][0]);
            this.DisplayName.set(data[i][1], data[i][0]);
            // Name
            this.KernelName.set(data[i][0], data[i][1]);
            this.KernelName.set(data[i][1], data[i][1]);
            // LanguageName
            this.LanguageName.set(data[i][0], data[i][2]);
            this.LanguageName.set(data[i][1], data[i][2]);
            // if codemirror mode ...
            if (data[i].length >= 5 && data[i][4]) {
                this.CodeMirrorMode.set(data[i][0], data[i][4]);
            }
            this.KernelList.push(data[i][0]);
        }
    }
    updateLanguages(data) {
        for (let i = 0; i < data.length; i++) {
            // BackgroundColor is color
            this.BackgroundColor.set(data[i][0], data[i][3]);
            // by kernel name? For compatibility ...
            if (!(data[i][1] in this.BackgroundColor)) {
                this.BackgroundColor.set(data[i][1], data[i][3]);
            }
            // DisplayName
            this.DisplayName.set(data[i][0], data[i][0]);
            if (!(data[i][1] in this.DisplayName)) {
                this.DisplayName.set(data[i][1], data[i][0]);
            }
            // Name
            this.KernelName.set(data[i][0], data[i][1]);
            if (!(data[i][1] in this.KernelName)) {
                this.KernelName.set(data[i][1], data[i][1]);
            }
            // Language Name
            this.LanguageName.set(data[i][0], data[i][2]);
            if (!(data[i][2] in this.LanguageName)) {
                this.LanguageName.set(data[i][2], data[i][2]);
            }
            // if codemirror mode ...
            if (data[i].length > 4 && data[i][4]) {
                this.CodeMirrorMode.set(data[i][0], data[i][4]);
            }
            // if options ...
            if (data[i].length > 5) {
                this.KernelOptions.set(data[i][0], data[i][5]);
            }
            if (this.KernelList.indexOf(data[i][0]) === -1)
                this.KernelList.push(data[i][0]);
        }
        // add css to window
        let css_text = this.KernelList.map(
        // add language specific css
        (lan) => {
            if (this.BackgroundColor.get(lan)) {
                let css_name = safe_css_name(`sos_lan_${lan}`);
                return `.jp-CodeCell.${css_name} .jp-InputPrompt,
            .jp-CodeCell.${css_name} .jp-OutputPrompt {
              background: ${this.BackgroundColor.get(lan)};
            }
          `;
            }
            else {
                return null;
            }
        })
            .filter(Boolean)
            .join("\n");
        var css = document.createElement("style");
        // css.type = "text/css";
        css.innerHTML = css_text;
        document.body.appendChild(css);
    }
    show() {
        console.log(this.KernelList);
    }
}
function safe_css_name(name) {
    return name.replace(/[^a-z0-9_]/g, function (s) {
        var c = s.charCodeAt(0);
        if (c == 32)
            return "-";
        if (c >= 65 && c <= 90)
            return "_" + s.toLowerCase();
        return "__" + ("000" + c.toString(16)).slice(-4);
    });
}
class Manager {
    constructor() {
        if (!this._info) {
            this._info = new Map();
        }
    }
    static set_trackers(notebook_tracker, console_tracker) {
        this._notebook_tracker = notebook_tracker;
        this._console_tracker = console_tracker;
    }
    static set_commands(commands) {
        this._commands = commands;
    }
    static get currentNotebook() {
        return this._notebook_tracker.currentWidget;
    }
    static consolesOfNotebook(panel) {
        return this._console_tracker.filter(value => {
            return value.console.sessionContext.path === panel.context.path;
        });
    }
    static get currentConsole() {
        return this._console_tracker.currentWidget;
    }
    static get commands() {
        return this._commands;
    }
    static get manager() {
        if (this._instance === null || this._instance === undefined)
            this._instance = new Manager();
        return this._instance;
    }
    // register notebook info to the global registry
    get_info(notebook) {
        if (!this._info.has(notebook)) {
            console.log("Creating a new notebook info");
            this._info.set(notebook, new NotebookInfo(notebook));
        }
        return this._info.get(notebook);
    }
    register_comm(comm, notebook) {
        this.get_info(notebook).sos_comm = comm;
    }
    // this is the same as get_info,
    notebook_of_comm(comm_id) {
        for (let [panel, info] of Array.from(this._info.entries()))
            if (info.sos_comm && info.sos_comm.commId === comm_id)
                return panel;
    }
    update_config(settings) {
        this._settings = settings;
    }
    get_config(key) {
        // sos.kernel_codemirror_mode
        return this._settings.get(key).composite;
    }
}


/***/ }),

/***/ "./lib/selectors.js":
/*!**************************!*\
  !*** ./lib/selectors.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "KernelSwitcher": () => (/* binding */ KernelSwitcher),
/* harmony export */   "addLanSelector": () => (/* binding */ addLanSelector),
/* harmony export */   "changeCellKernel": () => (/* binding */ changeCellKernel),
/* harmony export */   "changeStyleOnKernel": () => (/* binding */ changeStyleOnKernel),
/* harmony export */   "hideLanSelector": () => (/* binding */ hideLanSelector),
/* harmony export */   "saveKernelInfo": () => (/* binding */ saveKernelInfo),
/* harmony export */   "toggleCellKernel": () => (/* binding */ toggleCellKernel),
/* harmony export */   "toggleDisplayOutput": () => (/* binding */ toggleDisplayOutput),
/* harmony export */   "toggleMarkdownCell": () => (/* binding */ toggleMarkdownCell),
/* harmony export */   "updateCellStyles": () => (/* binding */ updateCellStyles)
/* harmony export */ });
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/notebook */ "webpack/sharing/consume/default/@jupyterlab/notebook");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _manager__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./manager */ "./lib/manager.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);





const CELL_LANGUAGE_DROPDOWN_CLASS = 'jp-CelllanguageDropDown';
function saveKernelInfo() {
    let panel = _manager__WEBPACK_IMPORTED_MODULE_4__.Manager.currentNotebook;
    let info = _manager__WEBPACK_IMPORTED_MODULE_4__.Manager.manager.get_info(panel);
    let used_kernels = new Set();
    let cells = panel.content.model.cells;
    for (var i = cells.length - 1; i >= 0; --i) {
        let cell = cells.get(i);
        if (cell.type === 'code' && cell.metadata.get('kernel')) {
            used_kernels.add(cell.metadata.get('kernel'));
        }
    }
    panel.content.model.metadata.get('sos')['kernels'] = Array.from(used_kernels.values())
        .sort()
        .map(function (x) {
        return [
            info.DisplayName.get(x),
            info.KernelName.get(x),
            info.LanguageName.get(x) || '',
            info.BackgroundColor.get(x) || '',
            info.CodeMirrorMode.get(x) || '',
        ];
    });
}
function hideLanSelector(cell) {
    let nodes = cell.node.getElementsByClassName(CELL_LANGUAGE_DROPDOWN_CLASS);
    if (nodes.length > 0) {
        nodes[0].style.display = 'none';
    }
}
function toggleDisplayOutput(cell) {
    if (cell.model.type === 'markdown') {
        // switch between hide_output and ""
        if (cell.model.metadata.get('tags') &&
            cell.model.metadata.get('tags').indexOf('hide_output') >= 0) {
            // if report_output on, remove it
            remove_tag(cell, 'hide_output');
        }
        else {
            add_tag(cell, 'hide_output');
        }
    }
    else if (cell.model.type === 'code') {
        // switch between report_output and ""
        if (cell.model.metadata.get('tags') &&
            cell.model.metadata.get('tags').indexOf('report_output') >= 0) {
            // if report_output on, remove it
            remove_tag(cell, 'report_output');
        }
        else {
            add_tag(cell, 'report_output');
        }
    }
}
function toggleCellKernel(cell, panel) {
    if (cell.model.type === 'markdown') {
        // markdown, to code
        // NotebookActions.changeCellType(panel.content, 'code');
        return;
    }
    else if (cell.model.type === 'code') {
        // switch to the next used kernel
        let kernels = panel.content.model.metadata.get('sos')['kernels'];
        // current kernel
        let kernel = cell.model.metadata.get('kernel');
        if (kernels.length == 1) {
            return;
        }
        // index of kernel
        for (let i = 0; i < kernels.length; ++i) {
            if (kernels[i][0] === kernel) {
                let info = _manager__WEBPACK_IMPORTED_MODULE_4__.Manager.manager.get_info(panel);
                let next = (i + 1) % kernels.length;
                // notebook_1.NotebookActions.changeCellType(panel.content, 'markdown');
                changeCellKernel(cell, kernels[next][0], info);
                break;
            }
        }
    }
}
function toggleMarkdownCell(cell, panel) {
    if (cell.model.type === 'markdown') {
        // markdown, to code
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__.NotebookActions.changeCellType(panel.content, 'code');
    }
    else {
        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_0__.NotebookActions.changeCellType(panel.content, 'markdown');
    }
}
function remove_tag(cell, tag) {
    let taglist = cell.model.metadata.get('tags');
    let new_list = [];
    for (let i = 0; i < taglist.length; i++) {
        if (taglist[i] != tag) {
            new_list.push(taglist[i]);
        }
    }
    cell.model.metadata.set('tags', new_list);
    let op = cell.node.getElementsByClassName('jp-Cell-outputWrapper');
    for (let i = 0; i < op.length; ++i) {
        op.item(i).classList.remove(tag);
    }
}
function add_tag(cell, tag) {
    let taglist = cell.model.metadata.get('tags');
    if (taglist) {
        taglist.push(tag);
    }
    else {
        taglist = [tag];
    }
    cell.model.metadata.set('tags', taglist);
    let op = cell.node.getElementsByClassName('jp-Cell-outputWrapper');
    for (let i = 0; i < op.length; ++i) {
        op.item(i).classList.add(tag);
    }
}
function addLanSelector(cell, info) {
    if (!cell.model.metadata.has('kernel')) {
        cell.model.metadata.set('kernel', 'SoS');
    }
    let kernel = cell.model.metadata.get('kernel');
    let nodes = cell.node.getElementsByClassName(CELL_LANGUAGE_DROPDOWN_CLASS);
    if (nodes.length > 0) {
        // use the existing dropdown box
        let select = nodes
            .item(0)
            .getElementsByTagName('select')[0];
        // update existing
        for (let lan of info.KernelList) {
            // ignore if already exists
            if (select.options.namedItem(lan))
                continue;
            let option = document.createElement('option');
            option.value = lan;
            option.id = lan;
            option.textContent = lan;
            select.appendChild(option);
        }
        select.value = kernel ? kernel : 'SoS';
    }
}
function changeCellKernel(cell, kernel, info) {
    cell.model.metadata.set('kernel', kernel);
    let nodes = cell.node.getElementsByClassName(CELL_LANGUAGE_DROPDOWN_CLASS);
    // use the existing dropdown box
    let select = nodes.item(0);
    if (select) {
        select.value = kernel;
    }
    changeStyleOnKernel(cell, kernel, info);
}
function changeStyleOnKernel(cell, kernel, info) {
    // Note: JupyterLab does not yet support tags
    if (cell.model.metadata.get('tags') &&
        cell.model.metadata.get('tags').indexOf('report_output') >= 0) {
        let op = cell.node.getElementsByClassName('jp-Cell-outputWrapper');
        for (let i = 0; i < op.length; ++i)
            op.item(i).classList.add('report-output');
    }
    else {
        let op = cell.node.getElementsByClassName('jp-Cell-outputWrapper');
        for (let i = 0; i < op.length; ++i)
            op.item(i).classList.remove('report-output');
    }
    for (let className of Array.from(cell.node.classList)) {
        if (className.startsWith('sos_lan_')) {
            cell.node.classList.remove(className);
        }
    }
    cell.node.classList.add((0,_manager__WEBPACK_IMPORTED_MODULE_4__.safe_css_name)(`sos_lan_${kernel}`));
    // cell.user_highlight = {
    //     name: 'sos',
    //     base_mode: info.LanguageName[kernel] || info.KernelName[kernel] || kernel,
    // };
    // //console.log(`Set cell code mirror mode to ${cell.user_highlight.base_mode}`)
    let base_mode = info.CodeMirrorMode.get(kernel) ||
        info.LanguageName.get(kernel) ||
        info.KernelName.get(kernel) ||
        kernel;
    if (!base_mode || base_mode === 'sos') {
        cell.inputArea.editorWidget.editor.setOption('mode', 'sos');
    }
    else {
        cell.inputArea.editorWidget.editor.setOption('mode', {
            name: 'sos',
            base_mode: base_mode,
        });
    }
}
function updateCellStyles(panel, info) {
    var cells = panel.content.widgets;
    // setting up background color and selection according to notebook metadata
    for (let i = 0; i < cells.length; ++i) {
        addLanSelector(cells[i], info);
        if (cells[i].model.type === 'code') {
            changeStyleOnKernel(cells[i], cells[i].model.metadata.get('kernel'), info);
        }
    }
    let panels = _manager__WEBPACK_IMPORTED_MODULE_4__.Manager.consolesOfNotebook(panel);
    for (let i = 0; i < panels.length; ++i) {
        addLanSelector(panels[i].console.promptCell, info);
        changeStyleOnKernel(panels[i].console.promptCell, panels[i].console.promptCell.model.metadata.get('kernel'), info);
    }
    let tasks = document.querySelectorAll('[id^="task_status_"]');
    let unknownTasks = [];
    for (let i = 0; i < tasks.length; ++i) {
        // status_localhost_5ea9232779ca1959
        if (tasks[i].id.match('^task_status_icon_.*')) {
            tasks[i].className = 'fa fa-fw fa-2x fa-refresh fa-spin';
            unknownTasks.push(tasks[i].id.substring(17));
        }
    }
    return unknownTasks;
}
class KernelSwitcher extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__.ReactWidget {
    constructor() {
        super();
        this.handleChange = (event) => {
            let cell = _manager__WEBPACK_IMPORTED_MODULE_4__.Manager.currentNotebook.content.activeCell;
            let kernel = event.target.value;
            cell.model.metadata.set('kernel', kernel);
            let panel = _manager__WEBPACK_IMPORTED_MODULE_4__.Manager.currentNotebook;
            let info = _manager__WEBPACK_IMPORTED_MODULE_4__.Manager.manager.get_info(panel);
            info.sos_comm.send({ 'set-editor-kernel': kernel });
            // change style
            changeStyleOnKernel(cell, kernel, info);
            // set global meta data
            saveKernelInfo();
            this.update();
        };
        this.handleKeyDown = (event) => { };
    }
    render() {
        let panel = _manager__WEBPACK_IMPORTED_MODULE_4__.Manager.currentNotebook;
        let cur_kernel = panel.context.sessionContext.kernelPreference.name ||
            panel.context.sessionContext.kernelDisplayName;
        if (cur_kernel.toLowerCase() !== "sos") {
            return;
        }
        let info = _manager__WEBPACK_IMPORTED_MODULE_4__.Manager.manager.get_info(panel);
        let cell = panel.content.activeCell;
        const optionChildren = info.KernelList.map((lan) => {
            return (react__WEBPACK_IMPORTED_MODULE_3___default().createElement("option", { key: lan, value: lan, id: lan }, lan));
        });
        let kernel = cell.model.metadata.get('kernel');
        return (react__WEBPACK_IMPORTED_MODULE_3___default().createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.HTMLSelect, { className: CELL_LANGUAGE_DROPDOWN_CLASS, onChange: this.handleChange, onKeyDown: this.handleKeyDown, value: kernel ? kernel : 'SoS', "aria-label": "Kernel", title: 'Select the cell kernel' }, optionChildren));
    }
}


/***/ }),

/***/ "./node_modules/codemirror/addon/mode sync recursive":
/*!**************************************************!*\
  !*** ./node_modules/codemirror/addon/mode/ sync ***!
  \**************************************************/
/***/ ((module) => {

function webpackEmptyContext(req) {
	var e = new Error("Cannot find module '" + req + "'");
	e.code = 'MODULE_NOT_FOUND';
	throw e;
}
webpackEmptyContext.keys = () => ([]);
webpackEmptyContext.resolve = webpackEmptyContext;
webpackEmptyContext.id = "./node_modules/codemirror/addon/mode sync recursive";
module.exports = webpackEmptyContext;

/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/index.css":
/*!***************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/index.css ***!
  \***************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_cssWithMappingToString_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/cssWithMappingToString.js */ "./node_modules/css-loader/dist/runtime/cssWithMappingToString.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_cssWithMappingToString_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_cssWithMappingToString_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/getUrl.js */ "./node_modules/css-loader/dist/runtime/getUrl.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _sos_icon_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./sos_icon.svg */ "./style/sos_icon.svg");
/* harmony import */ var _sos_icon_svg__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_sos_icon_svg__WEBPACK_IMPORTED_MODULE_3__);
// Imports




var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_cssWithMappingToString_js__WEBPACK_IMPORTED_MODULE_0___default()));
var ___CSS_LOADER_URL_REPLACEMENT_0___ = _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()((_sos_icon_svg__WEBPACK_IMPORTED_MODULE_3___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, ".sos_icon {\n  background-image: url(" + ___CSS_LOADER_URL_REPLACEMENT_0___ + ");\n  background-repeat: no-repeat;\n  background-position: center center;\n}\n\n.cm-sos-interpolated {\n  background-color: rgb(223, 144, 207, 0.4);\n}\n\n.cm-sos-sigil {\n  background-color: rgb(223, 144, 207, 0.4);\n}\n\n.cm-sos-unmatched {\n  background-color: orange;\n}\n\n.jp-CelllanguageDropDown {\n  display: none;\n}\n\n.jp-OutputArea-prompt:empty {\n  padding: 0px;\n}\n\n/*\n.cm-sos-script {\n\tfont-style: normal;\n}\n\n.cm-sos-option {\n\tfont-style: italic;\n} */\n.jp-CodeCell .jp-InputArea .jp-CelllanguageDropDown {\n  width: 70pt;\n  background: none;\n  z-index: 1000;\n  position: absolute;\n  height: 1.7em;\n  margin-top: 3pt;\n  right: 8pt;\n  font-size: 80%;\n  display: block;\n}\n\n.jp-CodeCell .jp-cell-menu .jp-CelllanguageDropDown {\n  width: 70pt;\n  background: none;\n  font-size: 80%;\n  display: block;\n  margin-left: 5px;\n  margin-right: 5px;\n  border: 0px;\n}\n\n.sos_logging {\n  font-family: monospace;\n  margin: -0.4em;\n  padding-left: 0.4em;\n}\n\n.sos_hint {\n  color: rgba(0, 0, 0, .4);\n  font-family: monospace;\n}\n\n.sos_debug {\n  color: blue;\n}\n\n.sos_trace {\n  color: darkcyan;\n}\n\n.sos_hilight {\n  color: green;\n}\n\n.sos_info {\n  color: black;\n}\n\n.sos_warning {\n  color: black;\n  background: #fdd\n}\n\n.sos_error {\n  color: black;\n  background: #fdd\n}\n\n.report_output {\n  border-right-width: 13px;\n  border-right-color: #aaaaaa;\n  border-right-style: solid;\n}\n\n.sos_hint {\n  color: gray;\n  font-family: monospace;\n}\n\n\n.session_info td {\n  text-align: left;\n}\n\n.session_info th {\n  text-align: left;\n}\n\n.session_section {\n  text-align: left;\n  font-weight: bold;\n  font-size: 120%;\n}\n\n\n.one_liner {\n  overflow: hidden;\n  height: 15px;\n}\n\n.one_liner:hover {\n  height: auto;\n  width: auto;\n}\n\n.dataframe_container {\n  max-height: 400px\n}\n\n.dataframe_input {\n  border: 1px solid #ddd;\n  margin-bottom: 5px;\n}\n\n.scatterplot_by_rowname div.xAxis div.tickLabel {\n  transform: translateY(15px) translateX(15px) rotate(45deg);\n  -ms-transform: translateY(15px) translateX(15px) rotate(45deg);\n  -moz-transform: translateY(15px) translateX(15px) rotate(45deg);\n  -webkit-transform: translateY(15px) translateX(15px) rotate(45deg);\n  -o-transform: translateY(15px) translateX(15px) rotate(45deg);\n  /*rotation-point:50% 50%;*/\n  /*rotation:270deg;*/\n}\n\n.sos_dataframe td,\n.sos_dataframe th {\n  white-space: nowrap;\n}\n\npre.section-header.CodeMirror-line {\n  border-top: 1px dotted #cfcfcf\n}\n\n\n.jp-CodeCell .cm-header-1,\n.jp-CodeCell .cm-header-2,\n.jp-CodeCell .cm-header-3,\n.jp-CodeCell .cm-header-4,\n.jp-CodeCell .cm-header-5,\n.jp-CodeCell .cm-header-6 {\n  font-size: 100%;\n  font-style: normal;\n  font-weight: normal;\n  font-family: monospace;\n}\n\n/* jp-NotebooklanguageDropDown */\n/* jp-CelllanguageDropDown */\n\n/* sos generated static TOC */\n\n.jp-OutputArea .toc {\n  padding: 0px;\n  overflow-y: auto;\n  font-weight: normal;\n  white-space: nowrap;\n  overflow-x: auto;\n}\n\n.jp-OutputArea .toc ul.toc-item {\n  list-style-type: none;\n  padding-left: 1em;\n}\n\n.jp-OutputArea .toc-item-highlight-select {\n  background-color: Gold\n}\n\n.jp-OutputArea .toc-item-highlight-execute {\n  background-color: red\n}\n\n.jp-OutputArea .lev1 {\n  margin-left: 5px\n}\n\n.jp-OutputArea .lev2 {\n  margin-left: 10px\n}\n\n.jp-OutputArea .lev3 {\n  margin-left: 10px\n}\n\n.jp-OutputArea .lev4 {\n  margin-left: 10px\n}\n\n.jp-OutputArea .lev5 {\n  margin-left: 10px\n}\n\n.jp-OutputArea .lev6 {\n  margin-left: 10px\n}\n\n.jp-OutputArea .lev7 {\n  margin-left: 10px\n}\n\n.jp-OutputArea .lev8 {\n  margin-left: 10px\n}\n\n\ntable.workflow_table,\ntable.task_table {\n  border: 0px;\n}\n\n\ntable.workflow_table i,\ntable.task_table i {\n  margin-right: 5px;\n}\n\ntd.workflow_name {\n  width: 10em;\n  text-align: left;\n}\n\ntd.workflow_name pre,\ntd.task_name pre {\n  font-size: 1.2em;\n}\n\ntd.workflow_id,\ntd.task_id {\n  width: 15em;\n  text-align: left;\n}\n\ntd.task_tags {\n  text-align: left;\n  max-width: 33em;\n}\n\ntd.task_id {\n  text-align: left;\n}\n\ntd.task_id span,\ntd.task_tags span {\n  display: inline-flex;\n}\n\ntd.task_tags span pre {\n  padding-right: 0.5em;\n}\n\ntd.task_tags i {\n  margin-right: 0px;\n}\n\n.task_id_actions,\n.task_tag_actions {\n  display: none;\n}\n\n.task_id_actions .fa:hover,\n.task_tag_actions .fa:hover {\n  color: blue;\n}\n\n.task_id:hover .task_id_actions,\n.task_tags:hover .task_tag_actions {\n  display: flex;\n  flex-direction: row;\n}\n\ntd.workflow_index {\n  width: 5em;\n  text-align: left;\n}\n\ntd.workflow_status {\n  width: 20em;\n  text-align: left;\n}\n\ntd.task_timer {\n  width: 15em;\n  text-align: left !important;\n}\n\ntd.task_timer pre {\n  text-overflow: ellipsis;\n  overflow: hidden;\n  white-space: nowrap;\n}\n\n.workflow_table pre,\n.task_table pre {\n  background: unset;\n}\n\ntd.task_icon {\n  font-size: 0.75em;\n}\n\ntd.task_status,\n  {\n  width: 15em;\n  text-align: left;\n}\n\ntable.workflow_table span {\n  /* text-transform: uppercase; */\n  font-family: monospace;\n}\n\ntable.task_table span {\n  /* text-transform: uppercase; */\n  font-family: monospace;\n}\n\ntable.workflow_table.pending pre,\ntable.task_table.pending pre,\ntable.task_table.submitted pre,\ntable.task_table.missing pre {\n  color: #9d9d9d;\n  /* gray */\n}\n\ntable.workflow_table.running pre,\ntable.task_table.running pre {\n  color: #cdb62c;\n  /* yellow */\n}\n\ntable.workflow_table.completed pre,\ntable.task_table.completed pre {\n  color: #39aa56;\n  /* green */\n}\n\ntable.workflow_table.aborted pre,\ntable.task_table.aborted pre {\n  color: #FFA07A;\n  /* salmon */\n}\n\ntable.workflow_table.failed pre,\ntable.task_table.failed pre {\n  color: #db4545;\n  /* red */\n}\n\ntable.task_table {\n  border: 0px;\n  border-style: solid;\n}\n\n\n.bs-callout {\n  padding: 20px;\n  margin: 20px 0;\n  border: 1px solid #eee;\n  border-left-width: 5px;\n  border-radius: 3px;\n}\n\n.bs-callout h4 {\n  margin-top: 0 !important;\n  margin-bottom: 5px;\n  font-weight: 500;\n  line-height: 1.1;\n  display: block;\n  margin-block-start: 1.33em;\n  margin-block-end: 1.33em;\n  margin-inline-start: 0px;\n  margin-inline-end: 0px;\n}\n\n.bs-callout p:last-child {\n  margin-bottom: 0;\n}\n\n.bs-callout code {\n  border-radius: 3px;\n}\n\n.bs-callout+.bs-callout {\n  margin-top: -5px;\n}\n\n.bs-callout-default {\n  border-left-color: #777;\n}\n\n.bs-callout-default h4 {\n  color: #777;\n}\n\n.bs-callout-primary {\n  border-left-color: #428bca;\n}\n\n.bs-callout-primary h4 {\n  color: #428bca;\n}\n\n.bs-callout-success {\n  border-left-color: #5cb85c;\n}\n\n.bs-callout-success h4 {\n  color: #5cb85c;\n}\n\n.bs-callout-danger {\n  border-left-color: #d9534f;\n}\n\n.bs-callout-danger h4 {\n  color: #d9534f;\n}\n\n.bs-callout-warning {\n  border-left-color: #f0ad4e;\n}\n\n.bs-callout-warning h4 {\n  color: #f0ad4e;\n}\n\n.bs-callout-info {\n  border-left-color: #5bc0de;\n}\n\n.bs-callout-info h4 {\n  color: #5bc0de;\n}", "",{"version":3,"sources":["webpack://./style/index.css"],"names":[],"mappings":"AAAA;EACE,yDAAuC;EACvC,4BAA4B;EAC5B,kCAAkC;AACpC;;AAEA;EACE,yCAAyC;AAC3C;;AAEA;EACE,yCAAyC;AAC3C;;AAEA;EACE,wBAAwB;AAC1B;;AAEA;EACE,aAAa;AACf;;AAEA;EACE,YAAY;AACd;;AAEA;;;;;;;GAOG;AACH;EACE,WAAW;EACX,gBAAgB;EAChB,aAAa;EACb,kBAAkB;EAClB,aAAa;EACb,eAAe;EACf,UAAU;EACV,cAAc;EACd,cAAc;AAChB;;AAEA;EACE,WAAW;EACX,gBAAgB;EAChB,cAAc;EACd,cAAc;EACd,gBAAgB;EAChB,iBAAiB;EACjB,WAAW;AACb;;AAEA;EACE,sBAAsB;EACtB,cAAc;EACd,mBAAmB;AACrB;;AAEA;EACE,wBAAwB;EACxB,sBAAsB;AACxB;;AAEA;EACE,WAAW;AACb;;AAEA;EACE,eAAe;AACjB;;AAEA;EACE,YAAY;AACd;;AAEA;EACE,YAAY;AACd;;AAEA;EACE,YAAY;EACZ;AACF;;AAEA;EACE,YAAY;EACZ;AACF;;AAEA;EACE,wBAAwB;EACxB,2BAA2B;EAC3B,yBAAyB;AAC3B;;AAEA;EACE,WAAW;EACX,sBAAsB;AACxB;;;AAGA;EACE,gBAAgB;AAClB;;AAEA;EACE,gBAAgB;AAClB;;AAEA;EACE,gBAAgB;EAChB,iBAAiB;EACjB,eAAe;AACjB;;;AAGA;EACE,gBAAgB;EAChB,YAAY;AACd;;AAEA;EACE,YAAY;EACZ,WAAW;AACb;;AAEA;EACE;AACF;;AAEA;EACE,sBAAsB;EACtB,kBAAkB;AACpB;;AAEA;EACE,0DAA0D;EAC1D,8DAA8D;EAC9D,+DAA+D;EAC/D,kEAAkE;EAClE,6DAA6D;EAC7D,0BAA0B;EAC1B,mBAAmB;AACrB;;AAEA;;EAEE,mBAAmB;AACrB;;AAEA;EACE;AACF;;;AAGA;;;;;;EAME,eAAe;EACf,kBAAkB;EAClB,mBAAmB;EACnB,sBAAsB;AACxB;;AAEA,gCAAgC;AAChC,4BAA4B;;AAE5B,6BAA6B;;AAE7B;EACE,YAAY;EACZ,gBAAgB;EAChB,mBAAmB;EACnB,mBAAmB;EACnB,gBAAgB;AAClB;;AAEA;EACE,qBAAqB;EACrB,iBAAiB;AACnB;;AAEA;EACE;AACF;;AAEA;EACE;AACF;;AAEA;EACE;AACF;;AAEA;EACE;AACF;;AAEA;EACE;AACF;;AAEA;EACE;AACF;;AAEA;EACE;AACF;;AAEA;EACE;AACF;;AAEA;EACE;AACF;;AAEA;EACE;AACF;;;AAGA;;EAEE,WAAW;AACb;;;AAGA;;EAEE,iBAAiB;AACnB;;AAEA;EACE,WAAW;EACX,gBAAgB;AAClB;;AAEA;;EAEE,gBAAgB;AAClB;;AAEA;;EAEE,WAAW;EACX,gBAAgB;AAClB;;AAEA;EACE,gBAAgB;EAChB,eAAe;AACjB;;AAEA;EACE,gBAAgB;AAClB;;AAEA;;EAEE,oBAAoB;AACtB;;AAEA;EACE,oBAAoB;AACtB;;AAEA;EACE,iBAAiB;AACnB;;AAEA;;EAEE,aAAa;AACf;;AAEA;;EAEE,WAAW;AACb;;AAEA;;EAEE,aAAa;EACb,mBAAmB;AACrB;;AAEA;EACE,UAAU;EACV,gBAAgB;AAClB;;AAEA;EACE,WAAW;EACX,gBAAgB;AAClB;;AAEA;EACE,WAAW;EACX,2BAA2B;AAC7B;;AAEA;EACE,uBAAuB;EACvB,gBAAgB;EAChB,mBAAmB;AACrB;;AAEA;;EAEE,iBAAiB;AACnB;;AAEA;EACE,iBAAiB;AACnB;;AAEA;;EAEE,WAAW;EACX,gBAAgB;AAClB;;AAEA;EACE,+BAA+B;EAC/B,sBAAsB;AACxB;;AAEA;EACE,+BAA+B;EAC/B,sBAAsB;AACxB;;AAEA;;;;EAIE,cAAc;EACd,SAAS;AACX;;AAEA;;EAEE,cAAc;EACd,WAAW;AACb;;AAEA;;EAEE,cAAc;EACd,UAAU;AACZ;;AAEA;;EAEE,cAAc;EACd,WAAW;AACb;;AAEA;;EAEE,cAAc;EACd,QAAQ;AACV;;AAEA;EACE,WAAW;EACX,mBAAmB;AACrB;;;AAGA;EACE,aAAa;EACb,cAAc;EACd,sBAAsB;EACtB,sBAAsB;EACtB,kBAAkB;AACpB;;AAEA;EACE,wBAAwB;EACxB,kBAAkB;EAClB,gBAAgB;EAChB,gBAAgB;EAChB,cAAc;EACd,0BAA0B;EAC1B,wBAAwB;EACxB,wBAAwB;EACxB,sBAAsB;AACxB;;AAEA;EACE,gBAAgB;AAClB;;AAEA;EACE,kBAAkB;AACpB;;AAEA;EACE,gBAAgB;AAClB;;AAEA;EACE,uBAAuB;AACzB;;AAEA;EACE,WAAW;AACb;;AAEA;EACE,0BAA0B;AAC5B;;AAEA;EACE,cAAc;AAChB;;AAEA;EACE,0BAA0B;AAC5B;;AAEA;EACE,cAAc;AAChB;;AAEA;EACE,0BAA0B;AAC5B;;AAEA;EACE,cAAc;AAChB;;AAEA;EACE,0BAA0B;AAC5B;;AAEA;EACE,cAAc;AAChB;;AAEA;EACE,0BAA0B;AAC5B;;AAEA;EACE,cAAc;AAChB","sourcesContent":[".sos_icon {\n  background-image: url('./sos_icon.svg');\n  background-repeat: no-repeat;\n  background-position: center center;\n}\n\n.cm-sos-interpolated {\n  background-color: rgb(223, 144, 207, 0.4);\n}\n\n.cm-sos-sigil {\n  background-color: rgb(223, 144, 207, 0.4);\n}\n\n.cm-sos-unmatched {\n  background-color: orange;\n}\n\n.jp-CelllanguageDropDown {\n  display: none;\n}\n\n.jp-OutputArea-prompt:empty {\n  padding: 0px;\n}\n\n/*\n.cm-sos-script {\n\tfont-style: normal;\n}\n\n.cm-sos-option {\n\tfont-style: italic;\n} */\n.jp-CodeCell .jp-InputArea .jp-CelllanguageDropDown {\n  width: 70pt;\n  background: none;\n  z-index: 1000;\n  position: absolute;\n  height: 1.7em;\n  margin-top: 3pt;\n  right: 8pt;\n  font-size: 80%;\n  display: block;\n}\n\n.jp-CodeCell .jp-cell-menu .jp-CelllanguageDropDown {\n  width: 70pt;\n  background: none;\n  font-size: 80%;\n  display: block;\n  margin-left: 5px;\n  margin-right: 5px;\n  border: 0px;\n}\n\n.sos_logging {\n  font-family: monospace;\n  margin: -0.4em;\n  padding-left: 0.4em;\n}\n\n.sos_hint {\n  color: rgba(0, 0, 0, .4);\n  font-family: monospace;\n}\n\n.sos_debug {\n  color: blue;\n}\n\n.sos_trace {\n  color: darkcyan;\n}\n\n.sos_hilight {\n  color: green;\n}\n\n.sos_info {\n  color: black;\n}\n\n.sos_warning {\n  color: black;\n  background: #fdd\n}\n\n.sos_error {\n  color: black;\n  background: #fdd\n}\n\n.report_output {\n  border-right-width: 13px;\n  border-right-color: #aaaaaa;\n  border-right-style: solid;\n}\n\n.sos_hint {\n  color: gray;\n  font-family: monospace;\n}\n\n\n.session_info td {\n  text-align: left;\n}\n\n.session_info th {\n  text-align: left;\n}\n\n.session_section {\n  text-align: left;\n  font-weight: bold;\n  font-size: 120%;\n}\n\n\n.one_liner {\n  overflow: hidden;\n  height: 15px;\n}\n\n.one_liner:hover {\n  height: auto;\n  width: auto;\n}\n\n.dataframe_container {\n  max-height: 400px\n}\n\n.dataframe_input {\n  border: 1px solid #ddd;\n  margin-bottom: 5px;\n}\n\n.scatterplot_by_rowname div.xAxis div.tickLabel {\n  transform: translateY(15px) translateX(15px) rotate(45deg);\n  -ms-transform: translateY(15px) translateX(15px) rotate(45deg);\n  -moz-transform: translateY(15px) translateX(15px) rotate(45deg);\n  -webkit-transform: translateY(15px) translateX(15px) rotate(45deg);\n  -o-transform: translateY(15px) translateX(15px) rotate(45deg);\n  /*rotation-point:50% 50%;*/\n  /*rotation:270deg;*/\n}\n\n.sos_dataframe td,\n.sos_dataframe th {\n  white-space: nowrap;\n}\n\npre.section-header.CodeMirror-line {\n  border-top: 1px dotted #cfcfcf\n}\n\n\n.jp-CodeCell .cm-header-1,\n.jp-CodeCell .cm-header-2,\n.jp-CodeCell .cm-header-3,\n.jp-CodeCell .cm-header-4,\n.jp-CodeCell .cm-header-5,\n.jp-CodeCell .cm-header-6 {\n  font-size: 100%;\n  font-style: normal;\n  font-weight: normal;\n  font-family: monospace;\n}\n\n/* jp-NotebooklanguageDropDown */\n/* jp-CelllanguageDropDown */\n\n/* sos generated static TOC */\n\n.jp-OutputArea .toc {\n  padding: 0px;\n  overflow-y: auto;\n  font-weight: normal;\n  white-space: nowrap;\n  overflow-x: auto;\n}\n\n.jp-OutputArea .toc ul.toc-item {\n  list-style-type: none;\n  padding-left: 1em;\n}\n\n.jp-OutputArea .toc-item-highlight-select {\n  background-color: Gold\n}\n\n.jp-OutputArea .toc-item-highlight-execute {\n  background-color: red\n}\n\n.jp-OutputArea .lev1 {\n  margin-left: 5px\n}\n\n.jp-OutputArea .lev2 {\n  margin-left: 10px\n}\n\n.jp-OutputArea .lev3 {\n  margin-left: 10px\n}\n\n.jp-OutputArea .lev4 {\n  margin-left: 10px\n}\n\n.jp-OutputArea .lev5 {\n  margin-left: 10px\n}\n\n.jp-OutputArea .lev6 {\n  margin-left: 10px\n}\n\n.jp-OutputArea .lev7 {\n  margin-left: 10px\n}\n\n.jp-OutputArea .lev8 {\n  margin-left: 10px\n}\n\n\ntable.workflow_table,\ntable.task_table {\n  border: 0px;\n}\n\n\ntable.workflow_table i,\ntable.task_table i {\n  margin-right: 5px;\n}\n\ntd.workflow_name {\n  width: 10em;\n  text-align: left;\n}\n\ntd.workflow_name pre,\ntd.task_name pre {\n  font-size: 1.2em;\n}\n\ntd.workflow_id,\ntd.task_id {\n  width: 15em;\n  text-align: left;\n}\n\ntd.task_tags {\n  text-align: left;\n  max-width: 33em;\n}\n\ntd.task_id {\n  text-align: left;\n}\n\ntd.task_id span,\ntd.task_tags span {\n  display: inline-flex;\n}\n\ntd.task_tags span pre {\n  padding-right: 0.5em;\n}\n\ntd.task_tags i {\n  margin-right: 0px;\n}\n\n.task_id_actions,\n.task_tag_actions {\n  display: none;\n}\n\n.task_id_actions .fa:hover,\n.task_tag_actions .fa:hover {\n  color: blue;\n}\n\n.task_id:hover .task_id_actions,\n.task_tags:hover .task_tag_actions {\n  display: flex;\n  flex-direction: row;\n}\n\ntd.workflow_index {\n  width: 5em;\n  text-align: left;\n}\n\ntd.workflow_status {\n  width: 20em;\n  text-align: left;\n}\n\ntd.task_timer {\n  width: 15em;\n  text-align: left !important;\n}\n\ntd.task_timer pre {\n  text-overflow: ellipsis;\n  overflow: hidden;\n  white-space: nowrap;\n}\n\n.workflow_table pre,\n.task_table pre {\n  background: unset;\n}\n\ntd.task_icon {\n  font-size: 0.75em;\n}\n\ntd.task_status,\n  {\n  width: 15em;\n  text-align: left;\n}\n\ntable.workflow_table span {\n  /* text-transform: uppercase; */\n  font-family: monospace;\n}\n\ntable.task_table span {\n  /* text-transform: uppercase; */\n  font-family: monospace;\n}\n\ntable.workflow_table.pending pre,\ntable.task_table.pending pre,\ntable.task_table.submitted pre,\ntable.task_table.missing pre {\n  color: #9d9d9d;\n  /* gray */\n}\n\ntable.workflow_table.running pre,\ntable.task_table.running pre {\n  color: #cdb62c;\n  /* yellow */\n}\n\ntable.workflow_table.completed pre,\ntable.task_table.completed pre {\n  color: #39aa56;\n  /* green */\n}\n\ntable.workflow_table.aborted pre,\ntable.task_table.aborted pre {\n  color: #FFA07A;\n  /* salmon */\n}\n\ntable.workflow_table.failed pre,\ntable.task_table.failed pre {\n  color: #db4545;\n  /* red */\n}\n\ntable.task_table {\n  border: 0px;\n  border-style: solid;\n}\n\n\n.bs-callout {\n  padding: 20px;\n  margin: 20px 0;\n  border: 1px solid #eee;\n  border-left-width: 5px;\n  border-radius: 3px;\n}\n\n.bs-callout h4 {\n  margin-top: 0 !important;\n  margin-bottom: 5px;\n  font-weight: 500;\n  line-height: 1.1;\n  display: block;\n  margin-block-start: 1.33em;\n  margin-block-end: 1.33em;\n  margin-inline-start: 0px;\n  margin-inline-end: 0px;\n}\n\n.bs-callout p:last-child {\n  margin-bottom: 0;\n}\n\n.bs-callout code {\n  border-radius: 3px;\n}\n\n.bs-callout+.bs-callout {\n  margin-top: -5px;\n}\n\n.bs-callout-default {\n  border-left-color: #777;\n}\n\n.bs-callout-default h4 {\n  color: #777;\n}\n\n.bs-callout-primary {\n  border-left-color: #428bca;\n}\n\n.bs-callout-primary h4 {\n  color: #428bca;\n}\n\n.bs-callout-success {\n  border-left-color: #5cb85c;\n}\n\n.bs-callout-success h4 {\n  color: #5cb85c;\n}\n\n.bs-callout-danger {\n  border-left-color: #d9534f;\n}\n\n.bs-callout-danger h4 {\n  color: #d9534f;\n}\n\n.bs-callout-warning {\n  border-left-color: #f0ad4e;\n}\n\n.bs-callout-warning h4 {\n  color: #f0ad4e;\n}\n\n.bs-callout-info {\n  border-left-color: #5bc0de;\n}\n\n.bs-callout-info h4 {\n  color: #5bc0de;\n}"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./style/index.css":
/*!*************************!*\
  !*** ./style/index.css ***!
  \*************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_index_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./index.css */ "./node_modules/css-loader/dist/cjs.js!./style/index.css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_index_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_index_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ }),

/***/ "./style/sos_icon.svg":
/*!****************************!*\
  !*** ./style/sos_icon.svg ***!
  \****************************/
/***/ ((module) => {

module.exports = "data:image/svg+xml,%3C!-- Generator: Adobe Illustrator 21.0.2, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Layer_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 240 240' style='enable-background:new 0 0 240 240;' xml:space='preserve'%3E %3Cstyle type='text/css'%3E .st0%7Bfill:%23BD351A;%7D .st1%7Bfill:%23CC9900;%7D .st2%7Bfill:%236BBA54;%7D .st3%7Bfill:%233870A9;%7D .st4%7Bfill:none;%7D .st5%7Bfill:none;stroke:%23000000;stroke-miterlimit:10;%7D %3C/style%3E %3Cg%3E %3Cg id='XMLID_1_'%3E %3Cg%3E %3Cpath class='st0' d='M207,163.5c0,6.2-1.1,12.7-3.4,19.1L188,157.9l-29.8,1.2c-3.3-15.9-27.8-22.7-43.9-27 c-0.4-0.1-0.8-0.2-1.1-0.3l-0.9-20.4c0-0.7,0.3-1.3,0.9-1.7l20.2-12.9C194.4,114.5,207,139.7,207,163.5z'/%3E %3Cpath class='st1' d='M193.5,37.8c0,7.1-15.6,30.1-23.9,30.1c-7.5,0-19.2-22.8-50.3-22.8c-9.1,0-19.8,2.3-26.7,7.5L81.3,33.5 l-25.6,0.2C67.4,21,87.3,11,119.3,11C162.7,11,193.5,30.5,193.5,37.8z M181,38.5c0-4.1-3.4-7.5-7.5-7.5s-7.5,3.4-7.5,7.5 s3.4,7.5,7.5,7.5S181,42.6,181,38.5z'/%3E %3Cpath class='st2' d='M41.5,68.4c0-7.7,2.2-17.3,8-26.5L77,42.2l9.7,17.2c-1,2-1.6,4.3-1.6,6.8c0,15.3,20.8,22.7,37.3,27.6 l-18.4,12.2c-0.6,0.4-0.9,1-0.8,1.7l1.3,21.8C47.9,112.4,41.5,88.8,41.5,68.4z'/%3E %3Cpath class='st3' d='M33.4,169.6c0-21.5,15.3-34.1,18.3-34.1c5.1,0,0,51.3,64.4,51.3c20.4,0,38.4-6.7,41.9-19.4l26.1-0.6 l15.3,25.1C187.6,212,162.3,229,119,229C76.5,229,33.4,209.8,33.4,169.6z'/%3E %3C/g%3E %3Cg%3E %3C/g%3E %3C/g%3E %3C/g%3E %3Cpath class='st4' d='M49-19'/%3E %3Cline class='st4' x1='-21' y1='144' x2='-21' y2='143'/%3E %3Cpath class='st5' d='M246,135'/%3E %3Cpath class='st5' d='M-25,135'/%3E %3C/svg%3E"

/***/ })

}]);
//# sourceMappingURL=lib_index_js-node_modules_codemirror_addon_mode_sync_recursive.799ba5a4f9fc6c1b97ce.js.map