# This is an automatically generated file.
# DO NOT EDIT or your changes may be overwritten
import base64
from xdrlib import Packer, Unpacker

from .base import String

__all__ = ["Str"]


class Str:
    """
    XDR Source Code::

        typedef string str<64>;
    """

    def __init__(self, str: bytes) -> None:
        self.str = str

    def pack(self, packer: Packer) -> None:
        String(self.str, 64).pack(packer)

    @classmethod
    def unpack(cls, unpacker: Unpacker) -> "Str":
        str = String.unpack(unpacker)
        return cls(str)

    def to_xdr_bytes(self) -> bytes:
        packer = Packer()
        self.pack(packer)
        return packer.get_buffer()

    @classmethod
    def from_xdr_bytes(cls, xdr: bytes) -> "Str":
        unpacker = Unpacker(xdr)
        return cls.unpack(unpacker)

    def to_xdr(self) -> str:
        xdr_bytes = self.to_xdr_bytes()
        return base64.b64encode(xdr_bytes).decode()

    @classmethod
    def from_xdr(cls, xdr: str) -> "Str":
        xdr_bytes = base64.b64decode(xdr.encode())
        return cls.from_xdr_bytes(xdr_bytes)

    def __eq__(self, other: object):
        if not isinstance(other, self.__class__):
            return NotImplemented
        return self.str == other.str

    def __str__(self):
        return f"<Str [str={self.str}]>"
