# amphoradata
API for interacting with the Amphora Data platform.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.2.0dev1
- Package version: 0.2.0.dev1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import amphora_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import amphora_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import amphora_client
from amphora_client.rest import ApiException
from pprint import pprint

configuration = amphora_client.Configuration()
# Configure API key authorization: Bearer
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# Defining host is optional and default to https://beta.amphoradata.com
configuration.host = "https://beta.amphoradata.com"
# Create an instance of the API class
api_instance = amphora_client.AccountApi(amphora_client.ApiClient(configuration))
id = 'id_example' # str | Organisation Id
x_amphoradata_version = 'x_amphoradata_version_example' # str | API Version Number

try:
    # Deletes an organisation.
    api_response = api_instance.account_read(id, x_amphoradata_version)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->account_read: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://beta.amphoradata.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountApi* | [**account_read**](docs/AccountApi.md#account_read) | **GET** /api/Organisations/{id}/Account | Deletes an organisation.
*AmphoraeApi* | [**amphorae_create**](docs/AmphoraeApi.md#amphorae_create) | **POST** /api/amphorae | Creates a new empty Amphora in the user&#39;s organisation
*AmphoraeApi* | [**amphorae_create_file_request**](docs/AmphoraeApi.md#amphorae_create_file_request) | **POST** /api/amphorae/{id}/files/{file} | Creates a file. Returns a blob URL to upload to.
*AmphoraeApi* | [**amphorae_create_signal**](docs/AmphoraeApi.md#amphorae_create_signal) | **POST** /api/amphorae/{id}/signals | Associates a signal with an Amphora. Signal is created if not existing.
*AmphoraeApi* | [**amphorae_delete**](docs/AmphoraeApi.md#amphorae_delete) | **DELETE** /api/amphorae/{id} | Deletes an Amphora
*AmphoraeApi* | [**amphorae_download_file**](docs/AmphoraeApi.md#amphorae_download_file) | **GET** /api/amphorae/{id}/files/{file} | Get&#39;s the contents of a file. Returns application/octet-stream
*AmphoraeApi* | [**amphorae_get_signals**](docs/AmphoraeApi.md#amphorae_get_signals) | **GET** /api/amphorae/{id}/signals | Get&#39;s the signals associated with an Amphora.
*AmphoraeApi* | [**amphorae_list_files**](docs/AmphoraeApi.md#amphorae_list_files) | **GET** /api/amphorae/{id}/files | Get&#39;s a list of an Amphora&#39;s files
*AmphoraeApi* | [**amphorae_read**](docs/AmphoraeApi.md#amphorae_read) | **GET** /api/amphorae/{id} | Get&#39;s details of an Amphora by Id
*AmphoraeApi* | [**amphorae_update**](docs/AmphoraeApi.md#amphorae_update) | **PUT** /api/amphorae/{id} | Updates the details of an Amphora by Id
*AmphoraeApi* | [**amphorae_upload_file**](docs/AmphoraeApi.md#amphorae_upload_file) | **PUT** /api/amphorae/{id}/files/{file} | Set&#39;s the contents of a file. The request body becomes the content.
*AmphoraeApi* | [**amphorae_upload_signal**](docs/AmphoraeApi.md#amphorae_upload_signal) | **POST** /api/amphorae/{id}/signals/values | 
*AuthenticationApi* | [**authentication_request_token**](docs/AuthenticationApi.md#authentication_request_token) | **POST** /api/authentication/request | Returns a JWT (JSON Web Token).             
*MarketApi* | [**market_find**](docs/MarketApi.md#market_find) | **GET** /api/market/search | Finds Amphora using a fuzzy search
*MarketApi* | [**market_lookup_location**](docs/MarketApi.md#market_lookup_location) | **GET** /api/location/fuzzy | Executes a fuzzy location search.
*OrganisationsApi* | [**organisations_create**](docs/OrganisationsApi.md#organisations_create) | **POST** /api/organisations | Creates a new Organisation. This will assign the logged in user to the organisation.
*OrganisationsApi* | [**organisations_delete**](docs/OrganisationsApi.md#organisations_delete) | **DELETE** /api/organisations/{id} | Deletes an organisation.
*OrganisationsApi* | [**organisations_read**](docs/OrganisationsApi.md#organisations_read) | **GET** /api/organisations/{id} | Gets an organisation&#39;s details.
*OrganisationsApi* | [**organisations_update**](docs/OrganisationsApi.md#organisations_update) | **PUT** /api/organisations/{id} | Updates an organisation.
*PurchasesApi* | [**purchases_purchase**](docs/PurchasesApi.md#purchases_purchase) | **POST** /api/Amphorae/{id}/Purchases | Purchases an Amphora as the logged in user.
*SearchApi* | [**search_search_amphorae**](docs/SearchApi.md#search_search_amphorae) | **POST** /api/search/amphorae | Searches for Amphorae.
*SearchApi* | [**search_search_amphorae_by_creator**](docs/SearchApi.md#search_search_amphorae_by_creator) | **GET** /api/search/amphorae/byCreator | Searches for Amphorae by creator.
*SearchApi* | [**search_search_amphorae_by_location**](docs/SearchApi.md#search_search_amphorae_by_location) | **GET** /api/search/amphorae/byLocation | Searches for Amphorae by loction.
*SearchApi* | [**search_search_amphorae_by_organisation**](docs/SearchApi.md#search_search_amphorae_by_organisation) | **GET** /api/search/amphorae/byOrganisation | Searches for Amphorae in an Organisation.
*TermsAndConditionsApi* | [**terms_and_conditions_create**](docs/TermsAndConditionsApi.md#terms_and_conditions_create) | **POST** /api/Organisations/{id}/TermsAndConditions | Adds new Terms and Conditions to your Organisations T/C Library
*TermsAndConditionsApi* | [**terms_and_conditions_read**](docs/TermsAndConditionsApi.md#terms_and_conditions_read) | **GET** /api/Organisations/{id}/TermsAndConditions | Get&#39;s a list of an Organisation&#39;s Terms and Conditions
*TimeSeriesApi* | [**time_series_query_time_series**](docs/TimeSeriesApi.md#time_series_query_time_series) | **POST** /api/timeseries/query | Updates the details of an Amphora by Id
*UsersApi* | [**users_create**](docs/UsersApi.md#users_create) | **POST** /api/users | Creates a new User. Returns the password.
*UsersApi* | [**users_read_self**](docs/UsersApi.md#users_read_self) | **GET** /api/users/self | Get&#39;s logged in users information.


## Documentation For Models

 - [Account](docs/Account.md)
 - [Address](docs/Address.md)
 - [AggregateSeries](docs/AggregateSeries.md)
 - [AmphoraDto](docs/AmphoraDto.md)
 - [AmphoraDtoAllOf](docs/AmphoraDtoAllOf.md)
 - [AmphoraExtendedDto](docs/AmphoraExtendedDto.md)
 - [AmphoraExtendedDtoAllOf](docs/AmphoraExtendedDtoAllOf.md)
 - [CategorySet](docs/CategorySet.md)
 - [Classification](docs/Classification.md)
 - [CreateAmphoraDto](docs/CreateAmphoraDto.md)
 - [CreateAmphoraDtoAllOf](docs/CreateAmphoraDtoAllOf.md)
 - [DateTimeRange](docs/DateTimeRange.md)
 - [EntityDto](docs/EntityDto.md)
 - [EntryPoint](docs/EntryPoint.md)
 - [EventProperty](docs/EventProperty.md)
 - [FuzzySearchResponse](docs/FuzzySearchResponse.md)
 - [GetEvents](docs/GetEvents.md)
 - [GetSeries](docs/GetSeries.md)
 - [Name](docs/Name.md)
 - [OrganisationDto](docs/OrganisationDto.md)
 - [OrganisationDtoAllOf](docs/OrganisationDtoAllOf.md)
 - [PagedResponse](docs/PagedResponse.md)
 - [Poi](docs/Poi.md)
 - [Position](docs/Position.md)
 - [ProblemDetails](docs/ProblemDetails.md)
 - [PropertyValues](docs/PropertyValues.md)
 - [PropertyValuesAllOf](docs/PropertyValuesAllOf.md)
 - [QueryRequest](docs/QueryRequest.md)
 - [QueryResultPage](docs/QueryResultPage.md)
 - [QueryResultPageAllOf](docs/QueryResultPageAllOf.md)
 - [Result](docs/Result.md)
 - [SearchParameters](docs/SearchParameters.md)
 - [SearchParametersAllOf](docs/SearchParametersAllOf.md)
 - [SignalDto](docs/SignalDto.md)
 - [Summary](docs/Summary.md)
 - [TermsAndConditionsDto](docs/TermsAndConditionsDto.md)
 - [TokenRequest](docs/TokenRequest.md)
 - [Tsx](docs/Tsx.md)
 - [UploadResponse](docs/UploadResponse.md)
 - [UserDto](docs/UserDto.md)
 - [Variable](docs/Variable.md)
 - [Viewport](docs/Viewport.md)


## Documentation For Authorization


## Bearer

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author




