# coding=utf-8
# *** WARNING: this file was generated by pulumi-gen-eks. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *
from .vpc_cni import VpcCni
import pulumi_aws
import pulumi_kubernetes

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 cluster_security_group: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroup']] = None,
                 cluster_security_group_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 cluster_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 create_oidc_provider: Optional[pulumi.Input[bool]] = None,
                 creation_role_provider: Optional[pulumi.Input['CreationRoleProviderArgs']] = None,
                 default_addons_to_remove: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 desired_capacity: Optional[pulumi.Input[int]] = None,
                 enabled_cluster_log_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 encrypt_root_block_device: Optional[pulumi.Input[bool]] = None,
                 encryption_config_key_arn: Optional[pulumi.Input[str]] = None,
                 endpoint_private_access: Optional[pulumi.Input[bool]] = None,
                 endpoint_public_access: Optional[pulumi.Input[bool]] = None,
                 fargate: Optional[pulumi.Input[Union[bool, 'FargateProfileArgs']]] = None,
                 gpu: Optional[pulumi.Input[bool]] = None,
                 instance_profile_name: Optional[pulumi.Input[str]] = None,
                 instance_role: Optional[pulumi.Input['pulumi_aws.iam.Role']] = None,
                 instance_roles: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.iam.Role']]]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 kubernetes_service_ip_address_range: Optional[pulumi.Input[str]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_ami_id: Optional[pulumi.Input[str]] = None,
                 node_associate_public_ip_address: Optional[pulumi.Input[bool]] = None,
                 node_group_options: Optional[pulumi.Input['ClusterNodeGroupOptionsArgs']] = None,
                 node_public_key: Optional[pulumi.Input[str]] = None,
                 node_root_volume_delete_on_termination: Optional[pulumi.Input[bool]] = None,
                 node_root_volume_encrypted: Optional[pulumi.Input[bool]] = None,
                 node_root_volume_iops: Optional[pulumi.Input[int]] = None,
                 node_root_volume_size: Optional[pulumi.Input[int]] = None,
                 node_root_volume_throughput: Optional[pulumi.Input[int]] = None,
                 node_root_volume_type: Optional[pulumi.Input[str]] = None,
                 node_security_group_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 node_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 node_user_data: Optional[pulumi.Input[str]] = None,
                 private_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 provider_credential_opts: Optional[pulumi.Input['KubeconfigOptionsArgs']] = None,
                 proxy: Optional[pulumi.Input[str]] = None,
                 public_access_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 public_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['RoleMappingArgs']]]] = None,
                 service_role: Optional[pulumi.Input['pulumi_aws.iam.Role']] = None,
                 skip_default_node_group: Optional[pulumi.Input[bool]] = None,
                 storage_classes: Optional[pulumi.Input[Union[str, Mapping[str, pulumi.Input['StorageClassArgs']]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 use_default_vpc_cni: Optional[pulumi.Input[bool]] = None,
                 user_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['UserMappingArgs']]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 vpc_cni_options: Optional[pulumi.Input['VpcCniOptionsArgs']] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input['pulumi_aws.ec2.SecurityGroup'] cluster_security_group: The security group to use for the cluster API endpoint. If not provided, a new security group will be created with full internet egress and ingress from node groups.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] cluster_security_group_tags: The tags to apply to the cluster security group.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] cluster_tags: The tags to apply to the EKS cluster.
        :param pulumi.Input[bool] create_oidc_provider: Indicates whether an IAM OIDC Provider is created for the EKS cluster.
               
               The OIDC provider is used in the cluster in combination with k8s Service Account annotations to provide IAM roles at the k8s Pod level.
               
               See for more details:
                - https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_create_oidc_verify-thumbprint.html
                - https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html
                - https://aws.amazon.com/blogs/opensource/introducing-fine-grained-iam-roles-service-accounts/
                - https://www.pulumi.com/docs/reference/pkg/nodejs/pulumi/aws/eks/#enabling-iam-roles-for-service-accounts
        :param pulumi.Input['CreationRoleProviderArgs'] creation_role_provider: The IAM Role Provider used to create & authenticate against the EKS cluster. This role is given `[system:masters]` permission in K8S, See: https://docs.aws.amazon.com/eks/latest/userguide/add-user-role.html
        :param pulumi.Input[Sequence[pulumi.Input[str]]] default_addons_to_remove: List of addons to remove upon creation. Any addon listed will be "adopted" and then removed. This allows for the creation of a baremetal cluster where no addon is deployed and direct management of addons via Pulumi Kubernetes resources. Valid entries are kube-proxy, coredns and vpc-cni. Only works on first creation of a cluster.
        :param pulumi.Input[int] desired_capacity: The number of worker nodes that should be running in the cluster. Defaults to 2.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_cluster_log_types: Enable EKS control plane logging. This sends logs to cloudwatch. Possible list of values are: ["api", "audit", "authenticator", "controllerManager", "scheduler"]. By default it is off.
        :param pulumi.Input[bool] encrypt_root_block_device: Encrypt the root block device of the nodes in the node group.
        :param pulumi.Input[str] encryption_config_key_arn: KMS Key ARN to use with the encryption configuration for the cluster.
               
               Only available on Kubernetes 1.13+ clusters created after March 6, 2020.
               See for more details:
               - https://aws.amazon.com/about-aws/whats-new/2020/03/amazon-eks-adds-envelope-encryption-for-secrets-with-aws-kms/
        :param pulumi.Input[bool] endpoint_private_access: Indicates whether or not the Amazon EKS private API server endpoint is enabled. Default is `false`.
        :param pulumi.Input[bool] endpoint_public_access: Indicates whether or not the Amazon EKS public API server endpoint is enabled. Default is `true`.
        :param pulumi.Input[Union[bool, 'FargateProfileArgs']] fargate: Add support for launching pods in Fargate. Defaults to launching pods in the `default` namespace.  If specified, the default node group is skipped as though `skipDefaultNodeGroup: true` had been passed.
        :param pulumi.Input[bool] gpu: Use the latest recommended EKS Optimized Linux AMI with GPU support for the worker nodes from the AWS Systems Manager Parameter Store.
               
               Defaults to false.
               
               Note: `gpu` and `nodeAmiId` are mutually exclusive.
               
               See for more details:
               - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html
               - https://docs.aws.amazon.com/eks/latest/userguide/retrieve-ami-id.html
        :param pulumi.Input[str] instance_profile_name: The default IAM InstanceProfile to use on the Worker NodeGroups, if one is not already set in the NodeGroup.
        :param pulumi.Input['pulumi_aws.iam.Role'] instance_role: This enables the simple case of only registering a *single* IAM instance role with the cluster, that is required to be shared by *all* node groups in their instance profiles.
               
               Note: options `instanceRole` and `instanceRoles` are mutually exclusive.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.iam.Role']]] instance_roles: This enables the advanced case of registering *many* IAM instance roles with the cluster for per node group IAM, instead of the simpler, shared case of `instanceRole`.
               
               Note: options `instanceRole` and `instanceRoles` are mutually exclusive.
        :param pulumi.Input[str] instance_type: The instance type to use for the cluster's nodes. Defaults to "t2.medium".
        :param pulumi.Input[str] kubernetes_service_ip_address_range: The CIDR block to assign Kubernetes service IP addresses from. If you don't
               specify a block, Kubernetes assigns addresses from either the 10.100.0.0/16 or
               172.20.0.0/16 CIDR blocks. We recommend that you specify a block that does not overlap
               with resources in other networks that are peered or connected to your VPC. You can only specify
               a custom CIDR block when you create a cluster, changing this value will force a new cluster to be created.
               
               The block must meet the following requirements:
               - Within one of the following private IP address blocks: 10.0.0.0/8, 172.16.0.0.0/12, or 192.168.0.0/16.
               - Doesn't overlap with any CIDR block assigned to the VPC that you selected for VPC.
               - Between /24 and /12.
        :param pulumi.Input[int] max_size: The maximum number of worker nodes running in the cluster. Defaults to 2.
        :param pulumi.Input[int] min_size: The minimum number of worker nodes running in the cluster. Defaults to 1.
        :param pulumi.Input[str] name: The cluster's physical resource name.
               
               If not specified, the default is to use auto-naming for the cluster's name, resulting in a physical name with the format `${name}-eksCluster-0123abcd`.
               
               See for more details: https://www.pulumi.com/docs/intro/concepts/programming-model/#autonaming
        :param pulumi.Input[str] node_ami_id: The AMI ID to use for the worker nodes.
               
               Defaults to the latest recommended EKS Optimized Linux AMI from the AWS Systems Manager Parameter Store.
               
               Note: `nodeAmiId` and `gpu` are mutually exclusive.
               
               See for more details:
               - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html.
        :param pulumi.Input[bool] node_associate_public_ip_address: Whether or not to auto-assign the EKS worker nodes public IP addresses. If this toggle is set to true, the EKS workers will be auto-assigned public IPs. If false, they will not be auto-assigned public IPs.
        :param pulumi.Input['ClusterNodeGroupOptionsArgs'] node_group_options: The common configuration settings for NodeGroups.
        :param pulumi.Input[str] node_public_key: Public key material for SSH access to worker nodes. See allowed formats at:
               https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
               If not provided, no SSH access is enabled on VMs.
        :param pulumi.Input[bool] node_root_volume_delete_on_termination: Whether to delete a cluster node's root volume on termination. Defaults to true.
        :param pulumi.Input[bool] node_root_volume_encrypted: Whether to encrypt a cluster node's root volume. Defaults to false.
        :param pulumi.Input[int] node_root_volume_iops: Provisioned IOPS for a cluster node's root volume. Only valid for io1 volumes.
        :param pulumi.Input[int] node_root_volume_size: The size in GiB of a cluster node's root volume. Defaults to 20.
        :param pulumi.Input[int] node_root_volume_throughput: Provisioned throughput performance in integer MiB/s for a cluster node's root volume. Only valid for gp3 volumes.
        :param pulumi.Input[str] node_root_volume_type: Configured EBS type for a cluster node's root volume. Default is gp2.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] node_security_group_tags: The tags to apply to the default `nodeSecurityGroup` created by the cluster.
               
               Note: The `nodeSecurityGroupTags` option and the node group option `nodeSecurityGroup` are mutually exclusive.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_subnet_ids: The subnets to use for worker nodes. Defaults to the value of subnetIds.
        :param pulumi.Input[str] node_user_data: Extra code to run on node startup. This code will run after the AWS EKS bootstrapping code and before the node signals its readiness to the managing CloudFormation stack. This code must be a typical user data script: critically it must begin with an interpreter directive (i.e. a `#!`).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_subnet_ids: The set of private subnets to use for the worker node groups on the EKS cluster. These subnets are automatically tagged by EKS for Kubernetes purposes.
               
               If `vpcId` is not set, the cluster will use the AWS account's default VPC subnets.
               
               Worker network architecture options:
                - Private-only: Only set `privateSubnetIds`.
                  - Default workers to run in a private subnet. In this setting, Kubernetes cannot create public, internet-facing load balancers for your pods.
                - Public-only: Only set `publicSubnetIds`.
                  - Default workers to run in a public subnet.
                - Mixed (recommended): Set both `privateSubnetIds` and `publicSubnetIds`.
                  - Default all worker nodes to run in private subnets, and use the public subnets for internet-facing load balancers.
               
               See for more details: https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html.Note: The use of `subnetIds`, along with `publicSubnetIds` and/or `privateSubnetIds` is mutually exclusive. The use of `publicSubnetIds` and `privateSubnetIds` is encouraged.
               
               Also consider setting `nodeAssociatePublicIpAddress: true` for fully private workers.
        :param pulumi.Input['KubeconfigOptionsArgs'] provider_credential_opts: The AWS provider credential options to scope the cluster's kubeconfig authentication when using a non-default credential chain.
               
               This is required for certain auth scenarios. For example:
               - Creating and using a new AWS provider instance, or
               - Setting the AWS_PROFILE environment variable, or
               - Using a named profile configured on the AWS provider via:
               `pulumi config set aws:profile <profileName>`
               
               See for more details:
               - https://www.pulumi.com/docs/reference/pkg/nodejs/pulumi/aws/#Provider
               - https://www.pulumi.com/docs/intro/cloud-providers/aws/setup/
               - https://www.pulumi.com/docs/intro/cloud-providers/aws/#configuration
               - https://docs.aws.amazon.com/eks/latest/userguide/create-kubeconfig.html
        :param pulumi.Input[str] proxy: The HTTP(S) proxy to use within a proxied environment.
               
                The proxy is used during cluster creation, and OIDC configuration.
               
               This is an alternative option to setting the proxy environment variables: HTTP(S)_PROXY and/or http(s)_proxy.
               
               This option is required iff the proxy environment variables are not set.
               
               Format:      <protocol>://<host>:<port>
               Auth Format: <protocol>://<username>:<password>@<host>:<port>
               
               Ex:
                 - "http://proxy.example.com:3128"
                 - "https://proxy.example.com"
                 - "http://username:password@proxy.example.com:3128"
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_access_cidrs: Indicates which CIDR blocks can access the Amazon EKS public API server endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_subnet_ids: The set of public subnets to use for the worker node groups on the EKS cluster. These subnets are automatically tagged by EKS for Kubernetes purposes.
               
               If `vpcId` is not set, the cluster will use the AWS account's default VPC subnets.
               
               Worker network architecture options:
                - Private-only: Only set `privateSubnetIds`.
                  - Default workers to run in a private subnet. In this setting, Kubernetes cannot create public, internet-facing load balancers for your pods.
                - Public-only: Only set `publicSubnetIds`.
                  - Default workers to run in a public subnet.
                - Mixed (recommended): Set both `privateSubnetIds` and `publicSubnetIds`.
                  - Default all worker nodes to run in private subnets, and use the public subnets for internet-facing load balancers.
               
               See for more details: https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html.Note: The use of `subnetIds`, along with `publicSubnetIds` and/or `privateSubnetIds` is mutually exclusive. The use of `publicSubnetIds` and `privateSubnetIds` is encouraged.
        :param pulumi.Input[Sequence[pulumi.Input['RoleMappingArgs']]] role_mappings: Optional mappings from AWS IAM roles to Kubernetes users and groups.
        :param pulumi.Input['pulumi_aws.iam.Role'] service_role: IAM Service Role for EKS to use to manage the cluster.
        :param pulumi.Input[bool] skip_default_node_group: If this toggle is set to true, the EKS cluster will be created without node group attached. Defaults to false, unless `fargate` input is provided.
        :param pulumi.Input[Union[str, Mapping[str, pulumi.Input['StorageClassArgs']]]] storage_classes: An optional set of StorageClasses to enable for the cluster. If this is a single volume type rather than a map, a single StorageClass will be created for that volume type.
               
               Note: As of Kubernetes v1.11+ on EKS, a default `gp2` storage class will always be created automatically for the cluster by the EKS service. See https://docs.aws.amazon.com/eks/latest/userguide/storage-classes.html
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: The set of all subnets, public and private, to use for the worker node groups on the EKS cluster. These subnets are automatically tagged by EKS for Kubernetes purposes.
               
               If `vpcId` is not set, the cluster will use the AWS account's default VPC subnets.
               
               If the list of subnets includes both public and private subnets, the worker nodes will only be attached to the private subnets, and the public subnets will be used for internet-facing load balancers.
               
               See for more details: https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html.
               
               Note: The use of `subnetIds`, along with `publicSubnetIds` and/or `privateSubnetIds` is mutually exclusive. The use of `publicSubnetIds` and `privateSubnetIds` is encouraged.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value mapping of tags that are automatically applied to all AWS resources directly under management with this cluster, which support tagging.
        :param pulumi.Input[bool] use_default_vpc_cni: Use the default VPC CNI instead of creating a custom one. Should not be used in conjunction with `vpcCniOptions`.
        :param pulumi.Input[Sequence[pulumi.Input['UserMappingArgs']]] user_mappings: Optional mappings from AWS IAM users to Kubernetes users and groups.
        :param pulumi.Input[str] version: Desired Kubernetes master / control plane version. If you do not specify a value, the latest available version is used.
        :param pulumi.Input['VpcCniOptionsArgs'] vpc_cni_options: The configuration of the Amazon VPC CNI plugin for this instance. Defaults are described in the documentation for the VpcCniOptions type.
        :param pulumi.Input[str] vpc_id: The VPC in which to create the cluster and its worker nodes. If unset, the cluster will be created in the default VPC.
        """
        if cluster_security_group is not None:
            pulumi.set(__self__, "cluster_security_group", cluster_security_group)
        if cluster_security_group_tags is not None:
            pulumi.set(__self__, "cluster_security_group_tags", cluster_security_group_tags)
        if cluster_tags is not None:
            pulumi.set(__self__, "cluster_tags", cluster_tags)
        if create_oidc_provider is not None:
            pulumi.set(__self__, "create_oidc_provider", create_oidc_provider)
        if creation_role_provider is not None:
            pulumi.set(__self__, "creation_role_provider", creation_role_provider)
        if default_addons_to_remove is not None:
            pulumi.set(__self__, "default_addons_to_remove", default_addons_to_remove)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if enabled_cluster_log_types is not None:
            pulumi.set(__self__, "enabled_cluster_log_types", enabled_cluster_log_types)
        if encrypt_root_block_device is not None:
            pulumi.set(__self__, "encrypt_root_block_device", encrypt_root_block_device)
        if encryption_config_key_arn is not None:
            pulumi.set(__self__, "encryption_config_key_arn", encryption_config_key_arn)
        if endpoint_private_access is not None:
            pulumi.set(__self__, "endpoint_private_access", endpoint_private_access)
        if endpoint_public_access is not None:
            pulumi.set(__self__, "endpoint_public_access", endpoint_public_access)
        if fargate is not None:
            pulumi.set(__self__, "fargate", fargate)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if instance_profile_name is not None:
            pulumi.set(__self__, "instance_profile_name", instance_profile_name)
        if instance_role is not None:
            pulumi.set(__self__, "instance_role", instance_role)
        if instance_roles is not None:
            pulumi.set(__self__, "instance_roles", instance_roles)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if kubernetes_service_ip_address_range is not None:
            pulumi.set(__self__, "kubernetes_service_ip_address_range", kubernetes_service_ip_address_range)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_ami_id is not None:
            pulumi.set(__self__, "node_ami_id", node_ami_id)
        if node_associate_public_ip_address is not None:
            pulumi.set(__self__, "node_associate_public_ip_address", node_associate_public_ip_address)
        if node_group_options is not None:
            pulumi.set(__self__, "node_group_options", node_group_options)
        if node_public_key is not None:
            pulumi.set(__self__, "node_public_key", node_public_key)
        if node_root_volume_delete_on_termination is None:
            node_root_volume_delete_on_termination = True
        if node_root_volume_delete_on_termination is not None:
            pulumi.set(__self__, "node_root_volume_delete_on_termination", node_root_volume_delete_on_termination)
        if node_root_volume_encrypted is None:
            node_root_volume_encrypted = False
        if node_root_volume_encrypted is not None:
            pulumi.set(__self__, "node_root_volume_encrypted", node_root_volume_encrypted)
        if node_root_volume_iops is not None:
            pulumi.set(__self__, "node_root_volume_iops", node_root_volume_iops)
        if node_root_volume_size is None:
            node_root_volume_size = 20
        if node_root_volume_size is not None:
            pulumi.set(__self__, "node_root_volume_size", node_root_volume_size)
        if node_root_volume_throughput is not None:
            pulumi.set(__self__, "node_root_volume_throughput", node_root_volume_throughput)
        if node_root_volume_type is None:
            node_root_volume_type = 'gp2'
        if node_root_volume_type is not None:
            pulumi.set(__self__, "node_root_volume_type", node_root_volume_type)
        if node_security_group_tags is not None:
            pulumi.set(__self__, "node_security_group_tags", node_security_group_tags)
        if node_subnet_ids is not None:
            pulumi.set(__self__, "node_subnet_ids", node_subnet_ids)
        if node_user_data is not None:
            pulumi.set(__self__, "node_user_data", node_user_data)
        if private_subnet_ids is not None:
            pulumi.set(__self__, "private_subnet_ids", private_subnet_ids)
        if provider_credential_opts is not None:
            pulumi.set(__self__, "provider_credential_opts", provider_credential_opts)
        if proxy is not None:
            pulumi.set(__self__, "proxy", proxy)
        if public_access_cidrs is not None:
            pulumi.set(__self__, "public_access_cidrs", public_access_cidrs)
        if public_subnet_ids is not None:
            pulumi.set(__self__, "public_subnet_ids", public_subnet_ids)
        if role_mappings is not None:
            pulumi.set(__self__, "role_mappings", role_mappings)
        if service_role is not None:
            pulumi.set(__self__, "service_role", service_role)
        if skip_default_node_group is not None:
            pulumi.set(__self__, "skip_default_node_group", skip_default_node_group)
        if storage_classes is not None:
            pulumi.set(__self__, "storage_classes", storage_classes)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if use_default_vpc_cni is not None:
            pulumi.set(__self__, "use_default_vpc_cni", use_default_vpc_cni)
        if user_mappings is not None:
            pulumi.set(__self__, "user_mappings", user_mappings)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpc_cni_options is not None:
            pulumi.set(__self__, "vpc_cni_options", vpc_cni_options)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="clusterSecurityGroup")
    def cluster_security_group(self) -> Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]:
        """
        The security group to use for the cluster API endpoint. If not provided, a new security group will be created with full internet egress and ingress from node groups.
        """
        return pulumi.get(self, "cluster_security_group")

    @cluster_security_group.setter
    def cluster_security_group(self, value: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]):
        pulumi.set(self, "cluster_security_group", value)

    @property
    @pulumi.getter(name="clusterSecurityGroupTags")
    def cluster_security_group_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The tags to apply to the cluster security group.
        """
        return pulumi.get(self, "cluster_security_group_tags")

    @cluster_security_group_tags.setter
    def cluster_security_group_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "cluster_security_group_tags", value)

    @property
    @pulumi.getter(name="clusterTags")
    def cluster_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The tags to apply to the EKS cluster.
        """
        return pulumi.get(self, "cluster_tags")

    @cluster_tags.setter
    def cluster_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "cluster_tags", value)

    @property
    @pulumi.getter(name="createOidcProvider")
    def create_oidc_provider(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether an IAM OIDC Provider is created for the EKS cluster.

        The OIDC provider is used in the cluster in combination with k8s Service Account annotations to provide IAM roles at the k8s Pod level.

        See for more details:
         - https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_create_oidc_verify-thumbprint.html
         - https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html
         - https://aws.amazon.com/blogs/opensource/introducing-fine-grained-iam-roles-service-accounts/
         - https://www.pulumi.com/docs/reference/pkg/nodejs/pulumi/aws/eks/#enabling-iam-roles-for-service-accounts
        """
        return pulumi.get(self, "create_oidc_provider")

    @create_oidc_provider.setter
    def create_oidc_provider(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create_oidc_provider", value)

    @property
    @pulumi.getter(name="creationRoleProvider")
    def creation_role_provider(self) -> Optional[pulumi.Input['CreationRoleProviderArgs']]:
        """
        The IAM Role Provider used to create & authenticate against the EKS cluster. This role is given `[system:masters]` permission in K8S, See: https://docs.aws.amazon.com/eks/latest/userguide/add-user-role.html
        """
        return pulumi.get(self, "creation_role_provider")

    @creation_role_provider.setter
    def creation_role_provider(self, value: Optional[pulumi.Input['CreationRoleProviderArgs']]):
        pulumi.set(self, "creation_role_provider", value)

    @property
    @pulumi.getter(name="defaultAddonsToRemove")
    def default_addons_to_remove(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of addons to remove upon creation. Any addon listed will be "adopted" and then removed. This allows for the creation of a baremetal cluster where no addon is deployed and direct management of addons via Pulumi Kubernetes resources. Valid entries are kube-proxy, coredns and vpc-cni. Only works on first creation of a cluster.
        """
        return pulumi.get(self, "default_addons_to_remove")

    @default_addons_to_remove.setter
    def default_addons_to_remove(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "default_addons_to_remove", value)

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The number of worker nodes that should be running in the cluster. Defaults to 2.
        """
        return pulumi.get(self, "desired_capacity")

    @desired_capacity.setter
    def desired_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "desired_capacity", value)

    @property
    @pulumi.getter(name="enabledClusterLogTypes")
    def enabled_cluster_log_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Enable EKS control plane logging. This sends logs to cloudwatch. Possible list of values are: ["api", "audit", "authenticator", "controllerManager", "scheduler"]. By default it is off.
        """
        return pulumi.get(self, "enabled_cluster_log_types")

    @enabled_cluster_log_types.setter
    def enabled_cluster_log_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "enabled_cluster_log_types", value)

    @property
    @pulumi.getter(name="encryptRootBlockDevice")
    def encrypt_root_block_device(self) -> Optional[pulumi.Input[bool]]:
        """
        Encrypt the root block device of the nodes in the node group.
        """
        return pulumi.get(self, "encrypt_root_block_device")

    @encrypt_root_block_device.setter
    def encrypt_root_block_device(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypt_root_block_device", value)

    @property
    @pulumi.getter(name="encryptionConfigKeyArn")
    def encryption_config_key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        KMS Key ARN to use with the encryption configuration for the cluster.

        Only available on Kubernetes 1.13+ clusters created after March 6, 2020.
        See for more details:
        - https://aws.amazon.com/about-aws/whats-new/2020/03/amazon-eks-adds-envelope-encryption-for-secrets-with-aws-kms/
        """
        return pulumi.get(self, "encryption_config_key_arn")

    @encryption_config_key_arn.setter
    def encryption_config_key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_config_key_arn", value)

    @property
    @pulumi.getter(name="endpointPrivateAccess")
    def endpoint_private_access(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether or not the Amazon EKS private API server endpoint is enabled. Default is `false`.
        """
        return pulumi.get(self, "endpoint_private_access")

    @endpoint_private_access.setter
    def endpoint_private_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "endpoint_private_access", value)

    @property
    @pulumi.getter(name="endpointPublicAccess")
    def endpoint_public_access(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether or not the Amazon EKS public API server endpoint is enabled. Default is `true`.
        """
        return pulumi.get(self, "endpoint_public_access")

    @endpoint_public_access.setter
    def endpoint_public_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "endpoint_public_access", value)

    @property
    @pulumi.getter
    def fargate(self) -> Optional[pulumi.Input[Union[bool, 'FargateProfileArgs']]]:
        """
        Add support for launching pods in Fargate. Defaults to launching pods in the `default` namespace.  If specified, the default node group is skipped as though `skipDefaultNodeGroup: true` had been passed.
        """
        return pulumi.get(self, "fargate")

    @fargate.setter
    def fargate(self, value: Optional[pulumi.Input[Union[bool, 'FargateProfileArgs']]]):
        pulumi.set(self, "fargate", value)

    @property
    @pulumi.getter
    def gpu(self) -> Optional[pulumi.Input[bool]]:
        """
        Use the latest recommended EKS Optimized Linux AMI with GPU support for the worker nodes from the AWS Systems Manager Parameter Store.

        Defaults to false.

        Note: `gpu` and `nodeAmiId` are mutually exclusive.

        See for more details:
        - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html
        - https://docs.aws.amazon.com/eks/latest/userguide/retrieve-ami-id.html
        """
        return pulumi.get(self, "gpu")

    @gpu.setter
    def gpu(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "gpu", value)

    @property
    @pulumi.getter(name="instanceProfileName")
    def instance_profile_name(self) -> Optional[pulumi.Input[str]]:
        """
        The default IAM InstanceProfile to use on the Worker NodeGroups, if one is not already set in the NodeGroup.
        """
        return pulumi.get(self, "instance_profile_name")

    @instance_profile_name.setter
    def instance_profile_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_profile_name", value)

    @property
    @pulumi.getter(name="instanceRole")
    def instance_role(self) -> Optional[pulumi.Input['pulumi_aws.iam.Role']]:
        """
        This enables the simple case of only registering a *single* IAM instance role with the cluster, that is required to be shared by *all* node groups in their instance profiles.

        Note: options `instanceRole` and `instanceRoles` are mutually exclusive.
        """
        return pulumi.get(self, "instance_role")

    @instance_role.setter
    def instance_role(self, value: Optional[pulumi.Input['pulumi_aws.iam.Role']]):
        pulumi.set(self, "instance_role", value)

    @property
    @pulumi.getter(name="instanceRoles")
    def instance_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.iam.Role']]]]:
        """
        This enables the advanced case of registering *many* IAM instance roles with the cluster for per node group IAM, instead of the simpler, shared case of `instanceRole`.

        Note: options `instanceRole` and `instanceRoles` are mutually exclusive.
        """
        return pulumi.get(self, "instance_roles")

    @instance_roles.setter
    def instance_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.iam.Role']]]]):
        pulumi.set(self, "instance_roles", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The instance type to use for the cluster's nodes. Defaults to "t2.medium".
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="kubernetesServiceIpAddressRange")
    def kubernetes_service_ip_address_range(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR block to assign Kubernetes service IP addresses from. If you don't
        specify a block, Kubernetes assigns addresses from either the 10.100.0.0/16 or
        172.20.0.0/16 CIDR blocks. We recommend that you specify a block that does not overlap
        with resources in other networks that are peered or connected to your VPC. You can only specify
        a custom CIDR block when you create a cluster, changing this value will force a new cluster to be created.

        The block must meet the following requirements:
        - Within one of the following private IP address blocks: 10.0.0.0/8, 172.16.0.0.0/12, or 192.168.0.0/16.
        - Doesn't overlap with any CIDR block assigned to the VPC that you selected for VPC.
        - Between /24 and /12.
        """
        return pulumi.get(self, "kubernetes_service_ip_address_range")

    @kubernetes_service_ip_address_range.setter
    def kubernetes_service_ip_address_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubernetes_service_ip_address_range", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of worker nodes running in the cluster. Defaults to 2.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of worker nodes running in the cluster. Defaults to 1.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster's physical resource name.

        If not specified, the default is to use auto-naming for the cluster's name, resulting in a physical name with the format `${name}-eksCluster-0123abcd`.

        See for more details: https://www.pulumi.com/docs/intro/concepts/programming-model/#autonaming
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeAmiId")
    def node_ami_id(self) -> Optional[pulumi.Input[str]]:
        """
        The AMI ID to use for the worker nodes.

        Defaults to the latest recommended EKS Optimized Linux AMI from the AWS Systems Manager Parameter Store.

        Note: `nodeAmiId` and `gpu` are mutually exclusive.

        See for more details:
        - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html.
        """
        return pulumi.get(self, "node_ami_id")

    @node_ami_id.setter
    def node_ami_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_ami_id", value)

    @property
    @pulumi.getter(name="nodeAssociatePublicIpAddress")
    def node_associate_public_ip_address(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to auto-assign the EKS worker nodes public IP addresses. If this toggle is set to true, the EKS workers will be auto-assigned public IPs. If false, they will not be auto-assigned public IPs.
        """
        return pulumi.get(self, "node_associate_public_ip_address")

    @node_associate_public_ip_address.setter
    def node_associate_public_ip_address(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "node_associate_public_ip_address", value)

    @property
    @pulumi.getter(name="nodeGroupOptions")
    def node_group_options(self) -> Optional[pulumi.Input['ClusterNodeGroupOptionsArgs']]:
        """
        The common configuration settings for NodeGroups.
        """
        return pulumi.get(self, "node_group_options")

    @node_group_options.setter
    def node_group_options(self, value: Optional[pulumi.Input['ClusterNodeGroupOptionsArgs']]):
        pulumi.set(self, "node_group_options", value)

    @property
    @pulumi.getter(name="nodePublicKey")
    def node_public_key(self) -> Optional[pulumi.Input[str]]:
        """
        Public key material for SSH access to worker nodes. See allowed formats at:
        https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
        If not provided, no SSH access is enabled on VMs.
        """
        return pulumi.get(self, "node_public_key")

    @node_public_key.setter
    def node_public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_public_key", value)

    @property
    @pulumi.getter(name="nodeRootVolumeDeleteOnTermination")
    def node_root_volume_delete_on_termination(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to delete a cluster node's root volume on termination. Defaults to true.
        """
        return pulumi.get(self, "node_root_volume_delete_on_termination")

    @node_root_volume_delete_on_termination.setter
    def node_root_volume_delete_on_termination(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "node_root_volume_delete_on_termination", value)

    @property
    @pulumi.getter(name="nodeRootVolumeEncrypted")
    def node_root_volume_encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to encrypt a cluster node's root volume. Defaults to false.
        """
        return pulumi.get(self, "node_root_volume_encrypted")

    @node_root_volume_encrypted.setter
    def node_root_volume_encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "node_root_volume_encrypted", value)

    @property
    @pulumi.getter(name="nodeRootVolumeIops")
    def node_root_volume_iops(self) -> Optional[pulumi.Input[int]]:
        """
        Provisioned IOPS for a cluster node's root volume. Only valid for io1 volumes.
        """
        return pulumi.get(self, "node_root_volume_iops")

    @node_root_volume_iops.setter
    def node_root_volume_iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_root_volume_iops", value)

    @property
    @pulumi.getter(name="nodeRootVolumeSize")
    def node_root_volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        The size in GiB of a cluster node's root volume. Defaults to 20.
        """
        return pulumi.get(self, "node_root_volume_size")

    @node_root_volume_size.setter
    def node_root_volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_root_volume_size", value)

    @property
    @pulumi.getter(name="nodeRootVolumeThroughput")
    def node_root_volume_throughput(self) -> Optional[pulumi.Input[int]]:
        """
        Provisioned throughput performance in integer MiB/s for a cluster node's root volume. Only valid for gp3 volumes.
        """
        return pulumi.get(self, "node_root_volume_throughput")

    @node_root_volume_throughput.setter
    def node_root_volume_throughput(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_root_volume_throughput", value)

    @property
    @pulumi.getter(name="nodeRootVolumeType")
    def node_root_volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        Configured EBS type for a cluster node's root volume. Default is gp2.
        """
        return pulumi.get(self, "node_root_volume_type")

    @node_root_volume_type.setter
    def node_root_volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_root_volume_type", value)

    @property
    @pulumi.getter(name="nodeSecurityGroupTags")
    def node_security_group_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The tags to apply to the default `nodeSecurityGroup` created by the cluster.

        Note: The `nodeSecurityGroupTags` option and the node group option `nodeSecurityGroup` are mutually exclusive.
        """
        return pulumi.get(self, "node_security_group_tags")

    @node_security_group_tags.setter
    def node_security_group_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "node_security_group_tags", value)

    @property
    @pulumi.getter(name="nodeSubnetIds")
    def node_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The subnets to use for worker nodes. Defaults to the value of subnetIds.
        """
        return pulumi.get(self, "node_subnet_ids")

    @node_subnet_ids.setter
    def node_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "node_subnet_ids", value)

    @property
    @pulumi.getter(name="nodeUserData")
    def node_user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Extra code to run on node startup. This code will run after the AWS EKS bootstrapping code and before the node signals its readiness to the managing CloudFormation stack. This code must be a typical user data script: critically it must begin with an interpreter directive (i.e. a `#!`).
        """
        return pulumi.get(self, "node_user_data")

    @node_user_data.setter
    def node_user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_user_data", value)

    @property
    @pulumi.getter(name="privateSubnetIds")
    def private_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of private subnets to use for the worker node groups on the EKS cluster. These subnets are automatically tagged by EKS for Kubernetes purposes.

        If `vpcId` is not set, the cluster will use the AWS account's default VPC subnets.

        Worker network architecture options:
         - Private-only: Only set `privateSubnetIds`.
           - Default workers to run in a private subnet. In this setting, Kubernetes cannot create public, internet-facing load balancers for your pods.
         - Public-only: Only set `publicSubnetIds`.
           - Default workers to run in a public subnet.
         - Mixed (recommended): Set both `privateSubnetIds` and `publicSubnetIds`.
           - Default all worker nodes to run in private subnets, and use the public subnets for internet-facing load balancers.

        See for more details: https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html.Note: The use of `subnetIds`, along with `publicSubnetIds` and/or `privateSubnetIds` is mutually exclusive. The use of `publicSubnetIds` and `privateSubnetIds` is encouraged.

        Also consider setting `nodeAssociatePublicIpAddress: true` for fully private workers.
        """
        return pulumi.get(self, "private_subnet_ids")

    @private_subnet_ids.setter
    def private_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "private_subnet_ids", value)

    @property
    @pulumi.getter(name="providerCredentialOpts")
    def provider_credential_opts(self) -> Optional[pulumi.Input['KubeconfigOptionsArgs']]:
        """
        The AWS provider credential options to scope the cluster's kubeconfig authentication when using a non-default credential chain.

        This is required for certain auth scenarios. For example:
        - Creating and using a new AWS provider instance, or
        - Setting the AWS_PROFILE environment variable, or
        - Using a named profile configured on the AWS provider via:
        `pulumi config set aws:profile <profileName>`

        See for more details:
        - https://www.pulumi.com/docs/reference/pkg/nodejs/pulumi/aws/#Provider
        - https://www.pulumi.com/docs/intro/cloud-providers/aws/setup/
        - https://www.pulumi.com/docs/intro/cloud-providers/aws/#configuration
        - https://docs.aws.amazon.com/eks/latest/userguide/create-kubeconfig.html
        """
        return pulumi.get(self, "provider_credential_opts")

    @provider_credential_opts.setter
    def provider_credential_opts(self, value: Optional[pulumi.Input['KubeconfigOptionsArgs']]):
        pulumi.set(self, "provider_credential_opts", value)

    @property
    @pulumi.getter
    def proxy(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP(S) proxy to use within a proxied environment.

         The proxy is used during cluster creation, and OIDC configuration.

        This is an alternative option to setting the proxy environment variables: HTTP(S)_PROXY and/or http(s)_proxy.

        This option is required iff the proxy environment variables are not set.

        Format:      <protocol>://<host>:<port>
        Auth Format: <protocol>://<username>:<password>@<host>:<port>

        Ex:
          - "http://proxy.example.com:3128"
          - "https://proxy.example.com"
          - "http://username:password@proxy.example.com:3128"
        """
        return pulumi.get(self, "proxy")

    @proxy.setter
    def proxy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proxy", value)

    @property
    @pulumi.getter(name="publicAccessCidrs")
    def public_access_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Indicates which CIDR blocks can access the Amazon EKS public API server endpoint.
        """
        return pulumi.get(self, "public_access_cidrs")

    @public_access_cidrs.setter
    def public_access_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "public_access_cidrs", value)

    @property
    @pulumi.getter(name="publicSubnetIds")
    def public_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of public subnets to use for the worker node groups on the EKS cluster. These subnets are automatically tagged by EKS for Kubernetes purposes.

        If `vpcId` is not set, the cluster will use the AWS account's default VPC subnets.

        Worker network architecture options:
         - Private-only: Only set `privateSubnetIds`.
           - Default workers to run in a private subnet. In this setting, Kubernetes cannot create public, internet-facing load balancers for your pods.
         - Public-only: Only set `publicSubnetIds`.
           - Default workers to run in a public subnet.
         - Mixed (recommended): Set both `privateSubnetIds` and `publicSubnetIds`.
           - Default all worker nodes to run in private subnets, and use the public subnets for internet-facing load balancers.

        See for more details: https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html.Note: The use of `subnetIds`, along with `publicSubnetIds` and/or `privateSubnetIds` is mutually exclusive. The use of `publicSubnetIds` and `privateSubnetIds` is encouraged.
        """
        return pulumi.get(self, "public_subnet_ids")

    @public_subnet_ids.setter
    def public_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "public_subnet_ids", value)

    @property
    @pulumi.getter(name="roleMappings")
    def role_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RoleMappingArgs']]]]:
        """
        Optional mappings from AWS IAM roles to Kubernetes users and groups.
        """
        return pulumi.get(self, "role_mappings")

    @role_mappings.setter
    def role_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RoleMappingArgs']]]]):
        pulumi.set(self, "role_mappings", value)

    @property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> Optional[pulumi.Input['pulumi_aws.iam.Role']]:
        """
        IAM Service Role for EKS to use to manage the cluster.
        """
        return pulumi.get(self, "service_role")

    @service_role.setter
    def service_role(self, value: Optional[pulumi.Input['pulumi_aws.iam.Role']]):
        pulumi.set(self, "service_role", value)

    @property
    @pulumi.getter(name="skipDefaultNodeGroup")
    def skip_default_node_group(self) -> Optional[pulumi.Input[bool]]:
        """
        If this toggle is set to true, the EKS cluster will be created without node group attached. Defaults to false, unless `fargate` input is provided.
        """
        return pulumi.get(self, "skip_default_node_group")

    @skip_default_node_group.setter
    def skip_default_node_group(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_default_node_group", value)

    @property
    @pulumi.getter(name="storageClasses")
    def storage_classes(self) -> Optional[pulumi.Input[Union[str, Mapping[str, pulumi.Input['StorageClassArgs']]]]]:
        """
        An optional set of StorageClasses to enable for the cluster. If this is a single volume type rather than a map, a single StorageClass will be created for that volume type.

        Note: As of Kubernetes v1.11+ on EKS, a default `gp2` storage class will always be created automatically for the cluster by the EKS service. See https://docs.aws.amazon.com/eks/latest/userguide/storage-classes.html
        """
        return pulumi.get(self, "storage_classes")

    @storage_classes.setter
    def storage_classes(self, value: Optional[pulumi.Input[Union[str, Mapping[str, pulumi.Input['StorageClassArgs']]]]]):
        pulumi.set(self, "storage_classes", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of all subnets, public and private, to use for the worker node groups on the EKS cluster. These subnets are automatically tagged by EKS for Kubernetes purposes.

        If `vpcId` is not set, the cluster will use the AWS account's default VPC subnets.

        If the list of subnets includes both public and private subnets, the worker nodes will only be attached to the private subnets, and the public subnets will be used for internet-facing load balancers.

        See for more details: https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html.

        Note: The use of `subnetIds`, along with `publicSubnetIds` and/or `privateSubnetIds` is mutually exclusive. The use of `publicSubnetIds` and `privateSubnetIds` is encouraged.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value mapping of tags that are automatically applied to all AWS resources directly under management with this cluster, which support tagging.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="useDefaultVpcCni")
    def use_default_vpc_cni(self) -> Optional[pulumi.Input[bool]]:
        """
        Use the default VPC CNI instead of creating a custom one. Should not be used in conjunction with `vpcCniOptions`.
        """
        return pulumi.get(self, "use_default_vpc_cni")

    @use_default_vpc_cni.setter
    def use_default_vpc_cni(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_default_vpc_cni", value)

    @property
    @pulumi.getter(name="userMappings")
    def user_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserMappingArgs']]]]:
        """
        Optional mappings from AWS IAM users to Kubernetes users and groups.
        """
        return pulumi.get(self, "user_mappings")

    @user_mappings.setter
    def user_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserMappingArgs']]]]):
        pulumi.set(self, "user_mappings", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Desired Kubernetes master / control plane version. If you do not specify a value, the latest available version is used.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="vpcCniOptions")
    def vpc_cni_options(self) -> Optional[pulumi.Input['VpcCniOptionsArgs']]:
        """
        The configuration of the Amazon VPC CNI plugin for this instance. Defaults are described in the documentation for the VpcCniOptions type.
        """
        return pulumi.get(self, "vpc_cni_options")

    @vpc_cni_options.setter
    def vpc_cni_options(self, value: Optional[pulumi.Input['VpcCniOptionsArgs']]):
        pulumi.set(self, "vpc_cni_options", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC in which to create the cluster and its worker nodes. If unset, the cluster will be created in the default VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class Cluster(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_security_group: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroup']] = None,
                 cluster_security_group_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 cluster_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 create_oidc_provider: Optional[pulumi.Input[bool]] = None,
                 creation_role_provider: Optional[pulumi.Input[pulumi.InputType['CreationRoleProviderArgs']]] = None,
                 default_addons_to_remove: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 desired_capacity: Optional[pulumi.Input[int]] = None,
                 enabled_cluster_log_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 encrypt_root_block_device: Optional[pulumi.Input[bool]] = None,
                 encryption_config_key_arn: Optional[pulumi.Input[str]] = None,
                 endpoint_private_access: Optional[pulumi.Input[bool]] = None,
                 endpoint_public_access: Optional[pulumi.Input[bool]] = None,
                 fargate: Optional[pulumi.Input[Union[bool, pulumi.InputType['FargateProfileArgs']]]] = None,
                 gpu: Optional[pulumi.Input[bool]] = None,
                 instance_profile_name: Optional[pulumi.Input[str]] = None,
                 instance_role: Optional[pulumi.Input['pulumi_aws.iam.Role']] = None,
                 instance_roles: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.iam.Role']]]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 kubernetes_service_ip_address_range: Optional[pulumi.Input[str]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_ami_id: Optional[pulumi.Input[str]] = None,
                 node_associate_public_ip_address: Optional[pulumi.Input[bool]] = None,
                 node_group_options: Optional[pulumi.Input[pulumi.InputType['ClusterNodeGroupOptionsArgs']]] = None,
                 node_public_key: Optional[pulumi.Input[str]] = None,
                 node_root_volume_delete_on_termination: Optional[pulumi.Input[bool]] = None,
                 node_root_volume_encrypted: Optional[pulumi.Input[bool]] = None,
                 node_root_volume_iops: Optional[pulumi.Input[int]] = None,
                 node_root_volume_size: Optional[pulumi.Input[int]] = None,
                 node_root_volume_throughput: Optional[pulumi.Input[int]] = None,
                 node_root_volume_type: Optional[pulumi.Input[str]] = None,
                 node_security_group_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 node_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 node_user_data: Optional[pulumi.Input[str]] = None,
                 private_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 provider_credential_opts: Optional[pulumi.Input[pulumi.InputType['KubeconfigOptionsArgs']]] = None,
                 proxy: Optional[pulumi.Input[str]] = None,
                 public_access_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 public_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RoleMappingArgs']]]]] = None,
                 service_role: Optional[pulumi.Input['pulumi_aws.iam.Role']] = None,
                 skip_default_node_group: Optional[pulumi.Input[bool]] = None,
                 storage_classes: Optional[pulumi.Input[Union[str, Mapping[str, pulumi.Input[pulumi.InputType['StorageClassArgs']]]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 use_default_vpc_cni: Optional[pulumi.Input[bool]] = None,
                 user_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UserMappingArgs']]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 vpc_cni_options: Optional[pulumi.Input[pulumi.InputType['VpcCniOptionsArgs']]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Cluster is a component that wraps the AWS and Kubernetes resources necessary to run an EKS cluster, its worker nodes, its optional StorageClasses, and an optional deployment of the Kubernetes Dashboard.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input['pulumi_aws.ec2.SecurityGroup'] cluster_security_group: The security group to use for the cluster API endpoint. If not provided, a new security group will be created with full internet egress and ingress from node groups.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] cluster_security_group_tags: The tags to apply to the cluster security group.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] cluster_tags: The tags to apply to the EKS cluster.
        :param pulumi.Input[bool] create_oidc_provider: Indicates whether an IAM OIDC Provider is created for the EKS cluster.
               
               The OIDC provider is used in the cluster in combination with k8s Service Account annotations to provide IAM roles at the k8s Pod level.
               
               See for more details:
                - https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_create_oidc_verify-thumbprint.html
                - https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html
                - https://aws.amazon.com/blogs/opensource/introducing-fine-grained-iam-roles-service-accounts/
                - https://www.pulumi.com/docs/reference/pkg/nodejs/pulumi/aws/eks/#enabling-iam-roles-for-service-accounts
        :param pulumi.Input[pulumi.InputType['CreationRoleProviderArgs']] creation_role_provider: The IAM Role Provider used to create & authenticate against the EKS cluster. This role is given `[system:masters]` permission in K8S, See: https://docs.aws.amazon.com/eks/latest/userguide/add-user-role.html
        :param pulumi.Input[Sequence[pulumi.Input[str]]] default_addons_to_remove: List of addons to remove upon creation. Any addon listed will be "adopted" and then removed. This allows for the creation of a baremetal cluster where no addon is deployed and direct management of addons via Pulumi Kubernetes resources. Valid entries are kube-proxy, coredns and vpc-cni. Only works on first creation of a cluster.
        :param pulumi.Input[int] desired_capacity: The number of worker nodes that should be running in the cluster. Defaults to 2.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_cluster_log_types: Enable EKS control plane logging. This sends logs to cloudwatch. Possible list of values are: ["api", "audit", "authenticator", "controllerManager", "scheduler"]. By default it is off.
        :param pulumi.Input[bool] encrypt_root_block_device: Encrypt the root block device of the nodes in the node group.
        :param pulumi.Input[str] encryption_config_key_arn: KMS Key ARN to use with the encryption configuration for the cluster.
               
               Only available on Kubernetes 1.13+ clusters created after March 6, 2020.
               See for more details:
               - https://aws.amazon.com/about-aws/whats-new/2020/03/amazon-eks-adds-envelope-encryption-for-secrets-with-aws-kms/
        :param pulumi.Input[bool] endpoint_private_access: Indicates whether or not the Amazon EKS private API server endpoint is enabled. Default is `false`.
        :param pulumi.Input[bool] endpoint_public_access: Indicates whether or not the Amazon EKS public API server endpoint is enabled. Default is `true`.
        :param pulumi.Input[Union[bool, pulumi.InputType['FargateProfileArgs']]] fargate: Add support for launching pods in Fargate. Defaults to launching pods in the `default` namespace.  If specified, the default node group is skipped as though `skipDefaultNodeGroup: true` had been passed.
        :param pulumi.Input[bool] gpu: Use the latest recommended EKS Optimized Linux AMI with GPU support for the worker nodes from the AWS Systems Manager Parameter Store.
               
               Defaults to false.
               
               Note: `gpu` and `nodeAmiId` are mutually exclusive.
               
               See for more details:
               - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html
               - https://docs.aws.amazon.com/eks/latest/userguide/retrieve-ami-id.html
        :param pulumi.Input[str] instance_profile_name: The default IAM InstanceProfile to use on the Worker NodeGroups, if one is not already set in the NodeGroup.
        :param pulumi.Input['pulumi_aws.iam.Role'] instance_role: This enables the simple case of only registering a *single* IAM instance role with the cluster, that is required to be shared by *all* node groups in their instance profiles.
               
               Note: options `instanceRole` and `instanceRoles` are mutually exclusive.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.iam.Role']]] instance_roles: This enables the advanced case of registering *many* IAM instance roles with the cluster for per node group IAM, instead of the simpler, shared case of `instanceRole`.
               
               Note: options `instanceRole` and `instanceRoles` are mutually exclusive.
        :param pulumi.Input[str] instance_type: The instance type to use for the cluster's nodes. Defaults to "t2.medium".
        :param pulumi.Input[str] kubernetes_service_ip_address_range: The CIDR block to assign Kubernetes service IP addresses from. If you don't
               specify a block, Kubernetes assigns addresses from either the 10.100.0.0/16 or
               172.20.0.0/16 CIDR blocks. We recommend that you specify a block that does not overlap
               with resources in other networks that are peered or connected to your VPC. You can only specify
               a custom CIDR block when you create a cluster, changing this value will force a new cluster to be created.
               
               The block must meet the following requirements:
               - Within one of the following private IP address blocks: 10.0.0.0/8, 172.16.0.0.0/12, or 192.168.0.0/16.
               - Doesn't overlap with any CIDR block assigned to the VPC that you selected for VPC.
               - Between /24 and /12.
        :param pulumi.Input[int] max_size: The maximum number of worker nodes running in the cluster. Defaults to 2.
        :param pulumi.Input[int] min_size: The minimum number of worker nodes running in the cluster. Defaults to 1.
        :param pulumi.Input[str] name: The cluster's physical resource name.
               
               If not specified, the default is to use auto-naming for the cluster's name, resulting in a physical name with the format `${name}-eksCluster-0123abcd`.
               
               See for more details: https://www.pulumi.com/docs/intro/concepts/programming-model/#autonaming
        :param pulumi.Input[str] node_ami_id: The AMI ID to use for the worker nodes.
               
               Defaults to the latest recommended EKS Optimized Linux AMI from the AWS Systems Manager Parameter Store.
               
               Note: `nodeAmiId` and `gpu` are mutually exclusive.
               
               See for more details:
               - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html.
        :param pulumi.Input[bool] node_associate_public_ip_address: Whether or not to auto-assign the EKS worker nodes public IP addresses. If this toggle is set to true, the EKS workers will be auto-assigned public IPs. If false, they will not be auto-assigned public IPs.
        :param pulumi.Input[pulumi.InputType['ClusterNodeGroupOptionsArgs']] node_group_options: The common configuration settings for NodeGroups.
        :param pulumi.Input[str] node_public_key: Public key material for SSH access to worker nodes. See allowed formats at:
               https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
               If not provided, no SSH access is enabled on VMs.
        :param pulumi.Input[bool] node_root_volume_delete_on_termination: Whether to delete a cluster node's root volume on termination. Defaults to true.
        :param pulumi.Input[bool] node_root_volume_encrypted: Whether to encrypt a cluster node's root volume. Defaults to false.
        :param pulumi.Input[int] node_root_volume_iops: Provisioned IOPS for a cluster node's root volume. Only valid for io1 volumes.
        :param pulumi.Input[int] node_root_volume_size: The size in GiB of a cluster node's root volume. Defaults to 20.
        :param pulumi.Input[int] node_root_volume_throughput: Provisioned throughput performance in integer MiB/s for a cluster node's root volume. Only valid for gp3 volumes.
        :param pulumi.Input[str] node_root_volume_type: Configured EBS type for a cluster node's root volume. Default is gp2.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] node_security_group_tags: The tags to apply to the default `nodeSecurityGroup` created by the cluster.
               
               Note: The `nodeSecurityGroupTags` option and the node group option `nodeSecurityGroup` are mutually exclusive.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_subnet_ids: The subnets to use for worker nodes. Defaults to the value of subnetIds.
        :param pulumi.Input[str] node_user_data: Extra code to run on node startup. This code will run after the AWS EKS bootstrapping code and before the node signals its readiness to the managing CloudFormation stack. This code must be a typical user data script: critically it must begin with an interpreter directive (i.e. a `#!`).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_subnet_ids: The set of private subnets to use for the worker node groups on the EKS cluster. These subnets are automatically tagged by EKS for Kubernetes purposes.
               
               If `vpcId` is not set, the cluster will use the AWS account's default VPC subnets.
               
               Worker network architecture options:
                - Private-only: Only set `privateSubnetIds`.
                  - Default workers to run in a private subnet. In this setting, Kubernetes cannot create public, internet-facing load balancers for your pods.
                - Public-only: Only set `publicSubnetIds`.
                  - Default workers to run in a public subnet.
                - Mixed (recommended): Set both `privateSubnetIds` and `publicSubnetIds`.
                  - Default all worker nodes to run in private subnets, and use the public subnets for internet-facing load balancers.
               
               See for more details: https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html.Note: The use of `subnetIds`, along with `publicSubnetIds` and/or `privateSubnetIds` is mutually exclusive. The use of `publicSubnetIds` and `privateSubnetIds` is encouraged.
               
               Also consider setting `nodeAssociatePublicIpAddress: true` for fully private workers.
        :param pulumi.Input[pulumi.InputType['KubeconfigOptionsArgs']] provider_credential_opts: The AWS provider credential options to scope the cluster's kubeconfig authentication when using a non-default credential chain.
               
               This is required for certain auth scenarios. For example:
               - Creating and using a new AWS provider instance, or
               - Setting the AWS_PROFILE environment variable, or
               - Using a named profile configured on the AWS provider via:
               `pulumi config set aws:profile <profileName>`
               
               See for more details:
               - https://www.pulumi.com/docs/reference/pkg/nodejs/pulumi/aws/#Provider
               - https://www.pulumi.com/docs/intro/cloud-providers/aws/setup/
               - https://www.pulumi.com/docs/intro/cloud-providers/aws/#configuration
               - https://docs.aws.amazon.com/eks/latest/userguide/create-kubeconfig.html
        :param pulumi.Input[str] proxy: The HTTP(S) proxy to use within a proxied environment.
               
                The proxy is used during cluster creation, and OIDC configuration.
               
               This is an alternative option to setting the proxy environment variables: HTTP(S)_PROXY and/or http(s)_proxy.
               
               This option is required iff the proxy environment variables are not set.
               
               Format:      <protocol>://<host>:<port>
               Auth Format: <protocol>://<username>:<password>@<host>:<port>
               
               Ex:
                 - "http://proxy.example.com:3128"
                 - "https://proxy.example.com"
                 - "http://username:password@proxy.example.com:3128"
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_access_cidrs: Indicates which CIDR blocks can access the Amazon EKS public API server endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_subnet_ids: The set of public subnets to use for the worker node groups on the EKS cluster. These subnets are automatically tagged by EKS for Kubernetes purposes.
               
               If `vpcId` is not set, the cluster will use the AWS account's default VPC subnets.
               
               Worker network architecture options:
                - Private-only: Only set `privateSubnetIds`.
                  - Default workers to run in a private subnet. In this setting, Kubernetes cannot create public, internet-facing load balancers for your pods.
                - Public-only: Only set `publicSubnetIds`.
                  - Default workers to run in a public subnet.
                - Mixed (recommended): Set both `privateSubnetIds` and `publicSubnetIds`.
                  - Default all worker nodes to run in private subnets, and use the public subnets for internet-facing load balancers.
               
               See for more details: https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html.Note: The use of `subnetIds`, along with `publicSubnetIds` and/or `privateSubnetIds` is mutually exclusive. The use of `publicSubnetIds` and `privateSubnetIds` is encouraged.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RoleMappingArgs']]]] role_mappings: Optional mappings from AWS IAM roles to Kubernetes users and groups.
        :param pulumi.Input['pulumi_aws.iam.Role'] service_role: IAM Service Role for EKS to use to manage the cluster.
        :param pulumi.Input[bool] skip_default_node_group: If this toggle is set to true, the EKS cluster will be created without node group attached. Defaults to false, unless `fargate` input is provided.
        :param pulumi.Input[Union[str, Mapping[str, pulumi.Input[pulumi.InputType['StorageClassArgs']]]]] storage_classes: An optional set of StorageClasses to enable for the cluster. If this is a single volume type rather than a map, a single StorageClass will be created for that volume type.
               
               Note: As of Kubernetes v1.11+ on EKS, a default `gp2` storage class will always be created automatically for the cluster by the EKS service. See https://docs.aws.amazon.com/eks/latest/userguide/storage-classes.html
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: The set of all subnets, public and private, to use for the worker node groups on the EKS cluster. These subnets are automatically tagged by EKS for Kubernetes purposes.
               
               If `vpcId` is not set, the cluster will use the AWS account's default VPC subnets.
               
               If the list of subnets includes both public and private subnets, the worker nodes will only be attached to the private subnets, and the public subnets will be used for internet-facing load balancers.
               
               See for more details: https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html.
               
               Note: The use of `subnetIds`, along with `publicSubnetIds` and/or `privateSubnetIds` is mutually exclusive. The use of `publicSubnetIds` and `privateSubnetIds` is encouraged.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value mapping of tags that are automatically applied to all AWS resources directly under management with this cluster, which support tagging.
        :param pulumi.Input[bool] use_default_vpc_cni: Use the default VPC CNI instead of creating a custom one. Should not be used in conjunction with `vpcCniOptions`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UserMappingArgs']]]] user_mappings: Optional mappings from AWS IAM users to Kubernetes users and groups.
        :param pulumi.Input[str] version: Desired Kubernetes master / control plane version. If you do not specify a value, the latest available version is used.
        :param pulumi.Input[pulumi.InputType['VpcCniOptionsArgs']] vpc_cni_options: The configuration of the Amazon VPC CNI plugin for this instance. Defaults are described in the documentation for the VpcCniOptions type.
        :param pulumi.Input[str] vpc_id: The VPC in which to create the cluster and its worker nodes. If unset, the cluster will be created in the default VPC.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ClusterArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Cluster is a component that wraps the AWS and Kubernetes resources necessary to run an EKS cluster, its worker nodes, its optional StorageClasses, and an optional deployment of the Kubernetes Dashboard.

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_security_group: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroup']] = None,
                 cluster_security_group_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 cluster_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 create_oidc_provider: Optional[pulumi.Input[bool]] = None,
                 creation_role_provider: Optional[pulumi.Input[pulumi.InputType['CreationRoleProviderArgs']]] = None,
                 default_addons_to_remove: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 desired_capacity: Optional[pulumi.Input[int]] = None,
                 enabled_cluster_log_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 encrypt_root_block_device: Optional[pulumi.Input[bool]] = None,
                 encryption_config_key_arn: Optional[pulumi.Input[str]] = None,
                 endpoint_private_access: Optional[pulumi.Input[bool]] = None,
                 endpoint_public_access: Optional[pulumi.Input[bool]] = None,
                 fargate: Optional[pulumi.Input[Union[bool, pulumi.InputType['FargateProfileArgs']]]] = None,
                 gpu: Optional[pulumi.Input[bool]] = None,
                 instance_profile_name: Optional[pulumi.Input[str]] = None,
                 instance_role: Optional[pulumi.Input['pulumi_aws.iam.Role']] = None,
                 instance_roles: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.iam.Role']]]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 kubernetes_service_ip_address_range: Optional[pulumi.Input[str]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_ami_id: Optional[pulumi.Input[str]] = None,
                 node_associate_public_ip_address: Optional[pulumi.Input[bool]] = None,
                 node_group_options: Optional[pulumi.Input[pulumi.InputType['ClusterNodeGroupOptionsArgs']]] = None,
                 node_public_key: Optional[pulumi.Input[str]] = None,
                 node_root_volume_delete_on_termination: Optional[pulumi.Input[bool]] = None,
                 node_root_volume_encrypted: Optional[pulumi.Input[bool]] = None,
                 node_root_volume_iops: Optional[pulumi.Input[int]] = None,
                 node_root_volume_size: Optional[pulumi.Input[int]] = None,
                 node_root_volume_throughput: Optional[pulumi.Input[int]] = None,
                 node_root_volume_type: Optional[pulumi.Input[str]] = None,
                 node_security_group_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 node_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 node_user_data: Optional[pulumi.Input[str]] = None,
                 private_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 provider_credential_opts: Optional[pulumi.Input[pulumi.InputType['KubeconfigOptionsArgs']]] = None,
                 proxy: Optional[pulumi.Input[str]] = None,
                 public_access_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 public_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RoleMappingArgs']]]]] = None,
                 service_role: Optional[pulumi.Input['pulumi_aws.iam.Role']] = None,
                 skip_default_node_group: Optional[pulumi.Input[bool]] = None,
                 storage_classes: Optional[pulumi.Input[Union[str, Mapping[str, pulumi.Input[pulumi.InputType['StorageClassArgs']]]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 use_default_vpc_cni: Optional[pulumi.Input[bool]] = None,
                 user_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UserMappingArgs']]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 vpc_cni_options: Optional[pulumi.Input[pulumi.InputType['VpcCniOptionsArgs']]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["cluster_security_group"] = cluster_security_group
            __props__.__dict__["cluster_security_group_tags"] = cluster_security_group_tags
            __props__.__dict__["cluster_tags"] = cluster_tags
            __props__.__dict__["create_oidc_provider"] = create_oidc_provider
            __props__.__dict__["creation_role_provider"] = creation_role_provider
            __props__.__dict__["default_addons_to_remove"] = default_addons_to_remove
            __props__.__dict__["desired_capacity"] = desired_capacity
            __props__.__dict__["enabled_cluster_log_types"] = enabled_cluster_log_types
            __props__.__dict__["encrypt_root_block_device"] = encrypt_root_block_device
            __props__.__dict__["encryption_config_key_arn"] = encryption_config_key_arn
            __props__.__dict__["endpoint_private_access"] = endpoint_private_access
            __props__.__dict__["endpoint_public_access"] = endpoint_public_access
            __props__.__dict__["fargate"] = fargate
            __props__.__dict__["gpu"] = gpu
            __props__.__dict__["instance_profile_name"] = instance_profile_name
            __props__.__dict__["instance_role"] = instance_role
            __props__.__dict__["instance_roles"] = instance_roles
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["kubernetes_service_ip_address_range"] = kubernetes_service_ip_address_range
            __props__.__dict__["max_size"] = max_size
            __props__.__dict__["min_size"] = min_size
            __props__.__dict__["name"] = name
            __props__.__dict__["node_ami_id"] = node_ami_id
            __props__.__dict__["node_associate_public_ip_address"] = node_associate_public_ip_address
            __props__.__dict__["node_group_options"] = node_group_options
            __props__.__dict__["node_public_key"] = node_public_key
            if node_root_volume_delete_on_termination is None:
                node_root_volume_delete_on_termination = True
            __props__.__dict__["node_root_volume_delete_on_termination"] = node_root_volume_delete_on_termination
            if node_root_volume_encrypted is None:
                node_root_volume_encrypted = False
            __props__.__dict__["node_root_volume_encrypted"] = node_root_volume_encrypted
            __props__.__dict__["node_root_volume_iops"] = node_root_volume_iops
            if node_root_volume_size is None:
                node_root_volume_size = 20
            __props__.__dict__["node_root_volume_size"] = node_root_volume_size
            __props__.__dict__["node_root_volume_throughput"] = node_root_volume_throughput
            if node_root_volume_type is None:
                node_root_volume_type = 'gp2'
            __props__.__dict__["node_root_volume_type"] = node_root_volume_type
            __props__.__dict__["node_security_group_tags"] = node_security_group_tags
            __props__.__dict__["node_subnet_ids"] = node_subnet_ids
            __props__.__dict__["node_user_data"] = node_user_data
            __props__.__dict__["private_subnet_ids"] = private_subnet_ids
            __props__.__dict__["provider_credential_opts"] = provider_credential_opts
            __props__.__dict__["proxy"] = proxy
            __props__.__dict__["public_access_cidrs"] = public_access_cidrs
            __props__.__dict__["public_subnet_ids"] = public_subnet_ids
            __props__.__dict__["role_mappings"] = role_mappings
            __props__.__dict__["service_role"] = service_role
            __props__.__dict__["skip_default_node_group"] = skip_default_node_group
            __props__.__dict__["storage_classes"] = storage_classes
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["use_default_vpc_cni"] = use_default_vpc_cni
            __props__.__dict__["user_mappings"] = user_mappings
            __props__.__dict__["version"] = version
            __props__.__dict__["vpc_cni_options"] = vpc_cni_options
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["aws_provider"] = None
            __props__.__dict__["core"] = None
            __props__.__dict__["default_node_group"] = None
            __props__.__dict__["eks_cluster"] = None
            __props__.__dict__["eks_cluster_ingress_rule"] = None
            __props__.__dict__["kubeconfig"] = None
            __props__.__dict__["node_security_group"] = None
        super(Cluster, __self__).__init__(
            'eks:index:Cluster',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter(name="awsProvider")
    def aws_provider(self) -> pulumi.Output['pulumi_aws.Provider']:
        """
        The AWS resource provider.
        """
        return pulumi.get(self, "aws_provider")

    @property
    @pulumi.getter(name="clusterSecurityGroup")
    def cluster_security_group(self) -> pulumi.Output['pulumi_aws.ec2.SecurityGroup']:
        """
        The security group for the EKS cluster.
        """
        return pulumi.get(self, "cluster_security_group")

    @property
    @pulumi.getter
    def core(self) -> pulumi.Output['outputs.CoreData']:
        """
        The EKS cluster and its dependencies.
        """
        return pulumi.get(self, "core")

    @property
    @pulumi.getter(name="defaultNodeGroup")
    def default_node_group(self) -> pulumi.Output[Optional['outputs.NodeGroupData']]:
        """
        The default Node Group configuration, or undefined if `skipDefaultNodeGroup` was specified.
        """
        return pulumi.get(self, "default_node_group")

    @property
    @pulumi.getter(name="eksCluster")
    def eks_cluster(self) -> pulumi.Output['pulumi_aws.eks.Cluster']:
        """
        The EKS cluster.
        """
        return pulumi.get(self, "eks_cluster")

    @property
    @pulumi.getter(name="eksClusterIngressRule")
    def eks_cluster_ingress_rule(self) -> pulumi.Output['pulumi_aws.ec2.SecurityGroupRule']:
        """
        The ingress rule that gives node group access to cluster API server.
        """
        return pulumi.get(self, "eks_cluster_ingress_rule")

    @property
    @pulumi.getter(name="instanceRoles")
    def instance_roles(self) -> pulumi.Output[Sequence['pulumi_aws.iam.Role']]:
        """
        The service roles used by the EKS cluster.
        """
        return pulumi.get(self, "instance_roles")

    @property
    @pulumi.getter
    def kubeconfig(self) -> pulumi.Output[Any]:
        """
        A kubeconfig that can be used to connect to the EKS cluster.
        """
        return pulumi.get(self, "kubeconfig")

    @property
    @pulumi.getter(name="nodeSecurityGroup")
    def node_security_group(self) -> pulumi.Output['pulumi_aws.ec2.SecurityGroup']:
        """
        The security group for the cluster's nodes.
        """
        return pulumi.get(self, "node_security_group")

    @pulumi.output_type
    class GetKubeconfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, str):
                raise TypeError("Expected argument 'result' to be a str")
            pulumi.set(__self__, "result", result)

        @property
        @pulumi.getter
        def result(self) -> str:
            return pulumi.get(self, "result")

    def get_kubeconfig(__self__, *,
                       profile_name: Optional[pulumi.Input[str]] = None,
                       role_arn: Optional[pulumi.Input[str]] = None) -> pulumi.Output['str']:
        """
        Generate a kubeconfig for cluster authentication that does not use the default AWS credential provider chain, and instead is scoped to the supported options in `KubeconfigOptions`.

        The kubeconfig generated is automatically stringified for ease of use with the pulumi/kubernetes provider.

        See for more details:
        - https://docs.aws.amazon.com/eks/latest/userguide/create-kubeconfig.html
        - https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-role.html
        - https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-profiles.html


        :param pulumi.Input[str] profile_name: AWS credential profile name to always use instead of the default AWS credential provider chain.
               
               The profile is passed to kubeconfig as an authentication environment setting.
        :param pulumi.Input[str] role_arn: Role ARN to assume instead of the default AWS credential provider chain.
               
               The role is passed to kubeconfig as an authentication exec argument.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        __args__['profileName'] = profile_name
        __args__['roleArn'] = role_arn
        __result__ = pulumi.runtime.call('eks:index:Cluster/getKubeconfig', __args__, res=__self__, typ=Cluster.GetKubeconfigResult)
        return __result__.result

