# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['aiocircuitbreaker']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'aiocircuitbreaker',
    'version': '2.0.0',
    'description': 'This is an async Python implementation of the circuitbreaker library https://github.com/fabfuel/circuitbreaker.',
    'long_description': 'aiocircuitbreaker\n-----------------\n\n.. image:: https://img.shields.io/pypi/v/aiocircuitbreaker.svg\n    :target: https://pypi.python.org/pypi/aiocircuitbreaker\n\nThis is an async Python implementation of the `circuitbreaker`__ library.\n\n.. _circuitbreaker: https://github.com/fabfuel/circuitbreaker\n\n__ circuitbreaker_\n\n\nInstallation\n------------\n\nThe project is available on PyPI. Simply run::\n\n    $ pip install aiocircuitbreaker\n\n\nUsage\n-----\n\nThis is the simplest example. Just decorate a async function with the ``@circuit`` decorator::\n\n    from aiocircuitbreaker import circuit\n\n    @circuit\n    async def external_call():\n        ...\n\n\nThis decorator sets up a circuit breaker with the default settings. The circuit breaker:\n\n- monitors the function execution and counts failures\n- resets the failure count after every successful execution (while it is closed)\n- opens and prevents further executions after 5 subsequent failures\n- switches to half-open and allows one test-execution after 30 seconds recovery timeout\n- closes if the test-execution succeeded\n- considers all raised exceptions (based on class ``Exception``) as an expected failure\n- is named "external_call" - the name of the function it decorates\n\n\nWhat does *failure* mean?\n=========================\nA *failure* is a raised exception, which was not caught during the function call.\nBy default, the circuit breaker listens for all exceptions based on the class ``Exception``.\nThat means, that all exceptions raised during the function call are considered as an\n"expected failure" and will increase the failure count.\n\nGet specific about the expected failure\n=======================================\nIt is important, to be **as specific as possible**, when defining the expected exception.\nThe main purpose of a circuit breaker is to protect your distributed system from a cascading failure.\nThat means, you probably want to open the circuit breaker only, if the integration point on the other\nend is unavailable. So e.g. if there is an ``ConnectionError`` or a request ``Timeout``.\n\nIf you are e.g. using the requests library (http://docs.python-requests.org/) for making HTTP calls,\nits ``RequestException`` class would be a great choice for the ``expected_exception`` parameter.\n\nAll recognized exceptions will be re-raised anyway, but the goal is, to let the circuit breaker only\nrecognize those exceptions which are related to the communication to your integration point.\n\n\nConfiguration\n-------------\nThe following configuration options can be adjusted via decorator parameters. For example::\n\n    from aiocircuitbreaker import circuit\n\n    @circuit(failure_threshold=10, expected_exception=ConnectionError)\n    async def external_call():\n        ...\n\n\n\nfailure threshold\n=================\nBy default, the circuit breaker opens after 5 subsequent failures. You can adjust this value with the ``failure_threshold`` parameter.\n\nrecovery timeout\n================\nBy default, the circuit breaker stays open for 30 seconds to allow the integration point to recover.\nYou can adjust this value with the ``recovery_timeout`` parameter.\n\nexpected exception\n==================\nBy default, the circuit breaker listens for all exceptions which are based on the ``Exception`` class.\nYou can adjust this with the ``expected_exception`` parameter. It can be either an exception class or a tuple of exception classes.\n\nname\n====\nBy default, the circuit breaker name is empty string. You can adjust the name with parameter ``name``.\n\nfallback function\n=================\nBy default, the circuit breaker will raise a ``CircuitBreaker`` exception when the circuit is opened.\nYou can instead specify a function (async function) to be called when the circuit is opened. This function can be specified with the\n``fallback_function`` parameter and will be called with the same parameters as the decorated function would be.\n\nAdvanced Usage\n--------------\nIf you apply circuit breakers to a couple of functions and you always set specific options other than the default values,\nyou can extend the ``CircuitBreaker`` class and create your own circuit breaker subclass instead::\n\n    from aiocircuitbreaker import CircuitBreaker\n\n    class MyCircuitBreaker(CircuitBreaker):\n        FAILURE_THRESHOLD = 10\n        RECOVERY_TIMEOUT = 60\n        EXPECTED_EXCEPTION = RequestException\n\n\nNow you have two options to apply your circuit breaker to a function. As an Object directly::\n\n    @MyCircuitBreaker()\n    async def external_call():\n        ...\n\nPlease note, that the circuit breaker class has to be initialized, you have to use a class instance as decorator (``@MyCircuitBreaker()``), not the class itself (``@MyCircuitBreaker``).\n\nOr via the decorator proxy::\n\n    @circuit(cls=MyCircuitBreaker)\n    async def external_call():\n        ...\n\n',
    'author': 'Evgeny Solomatin',
    'author_email': 'solgenya@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/GenyaSol/aiocircuitbreaker',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.9.0,<4.0.0',
}


setup(**setup_kwargs)
