import pytest
import numpy as np

from naplib.features import auditory_spectrogram

@pytest.fixture(scope='module')
def small_sound_16khz():
    fs = 16_000
    t = 1
    f = 800
    samples = np.linspace(0, t, int(fs*t), endpoint=False)
    signal = np.sin(2 * np.pi * f * samples)
    return signal

@pytest.fixture(scope='module')
def small_sound_10khz():
    fs = 10_000
    t = 1
    f = 800
    samples = np.linspace(0, t, int(fs*t), endpoint=False)
    signal = np.sin(2 * np.pi * f * samples)
    return signal


def test_compare_matlab_small_sound_linear_factor(small_sound_16khz):
    aud = auditory_spectrogram(small_sound_16khz, 16_000, frame_len=8, tc=4, factor='linear')
    aud_truth_last_row = np.array([
        12.7665e-003, 4.5145e-003, 4.3346e-003, 17.7172e-003, 12.1494e-003, 3.6427e-003, 5.2899e-003, 20.0136e-003,
         2.6033e-003, 16.9110e-003, 28.7074e-003, 11.4634e-003, 23.5651e-003, 6.7106e-003, 5.7435e-003, 24.1161e-003,
         3.5655e-003, 46.0241e-003, 2.3623e-003, 16.4227e-003, 15.3328e-003, 4.3531e-003, 31.9761e-003, 14.4224e-003,
        18.4728e-003, 14.9371e-003, 25.4863e-003, 21.4314e-003, 14.2690e-003, 37.5077e-003, 20.9298e-003, 36.6626e-003,
        31.5294e-003, 33.9908e-003, 38.1514e-003, 42.6107e-003, 48.6097e-003, 56.8209e-003, 64.8033e-003, 69.4180e-003,
        77.8216e-003, 111.1104e-003, 134.2264e-003, 160.1196e-003, 201.7453e-003, 242.3133e-003, 232.0276e-003, 270.5047e-003,
         1.1915e+000, 6.3451e+000, 18.4818e+000, 14.8572e+000, 8.9388e+000, 6.2667e+000, 4.3794e+000, 3.0686e+000,
         2.4055e+000, 1.9332e+000, 1.5361e+000, 1.3031e+000, 1.1142e+000, 953.8353e-003, 827.5929e-003, 708.9550e-003,
       623.4019e-003, 545.6571e-003, 454.9138e-003, 418.8994e-003, 413.3810e-003, 238.5473e-003, 374.1855e-003, 273.0237e-003,
       228.6723e-003, 208.6052e-003, 145.8135e-003, 211.0631e-003, 244.2385e-003, 145.4804e-003, 133.9651e-003, 123.6877e-003,
       199.5443e-003, 45.8189e-003, 99.2240e-003, 92.2604e-003, 86.3565e-003, 82.2129e-003, 77.7969e-003, 73.9324e-003,
        70.4115e-003, 67.3037e-003, 61.7673e-003, 64.5794e-003, 57.4525e-003, 55.1104e-003, 58.6096e-003, 52.0780e-003,
        52.4137e-003, 48.4911e-003, 51.8479e-003, 47.9556e-003, 48.0653e-003, 44.4322e-003, 46.9588e-003, 42.6479e-003,
        45.3311e-003, 54.6275e-003, 117.6581e-003, 50.6480e-003, 44.4638e-003, 43.3655e-003, 41.9678e-003, 47.6489e-003,
        43.5825e-003, 42.2070e-003, 42.4957e-003, 42.5041e-003, 42.9599e-003, 44.6294e-003, 42.3402e-003, 45.0433e-003,
        44.1095e-003, 45.5204e-003, 45.1192e-003, 46.8885e-003, 47.5261e-003, 49.0127e-003, 51.1155e-003, 57.1237e-003,
    ])
    assert np.allclose(aud[-1], aud_truth_last_row, atol=1e-3)

def test_compare_matlab_small_sound_halfwave_factor(small_sound_16khz):
    aud = auditory_spectrogram(small_sound_16khz, 16_000, frame_len=8, tc=4, factor='half-wave')
    aud_truth_last_row = np.array([
       199.8445e-099, 15.7427e-003, 157.2358e-096, 3.1158e-099, 15.5043e-099, 14.8679e-003, 32.4218e-003, 154.0745e-102,
         3.9541e-003, 122.1420e-102, 9.2619e-102, 93.7706e-003, 2.8130e-102, 961.2952e-102, 50.1920e-003, 2.0549e-102,
        30.0616e-003, 73.2994e-105, 18.9658e-003, 1.3491e-102, 1.0852e-102, 10.7211e-102, 69.8618e-105, 280.6592e-105,
       148.9003e-105, 106.9533e-105, 74.4392e-105, 23.5777e-105, 204.2324e-105, 9.7181e-105, 17.0782e-105, 4.6446e-105,
         6.1446e-105, 3.9004e-105, 3.1233e-105, 2.4526e-105, 2.0491e-105, 1.2050e-105, 773.4168e-108, 765.2296e-108,
       604.9170e-108, 432.2456e-108, 319.4935e-108, 305.4002e-108, 236.4293e-108, 248.0060e-108, 308.7616e-108, 40.7609e-003,
       981.5488e-003, 70.5576e-111, 159.1762e-111, 28.3584e+000, 26.0175e+000, 21.7057e+000, 19.2532e+000, 13.9391e+000,
        11.0723e+000, 9.4605e+000, 7.7733e+000, 6.7714e+000, 6.2864e+000, 4.7287e+000, 5.0459e+000, 4.4960e+000,
         3.4117e+000, 3.3579e+000, 3.1987e+000, 3.2710e+000, 2.1500e+000, 1.8041e+000, 1.9469e+000, 1.9129e+000,
         1.5838e+000, 1.4483e+000, 548.3857e-003, 1.2880e+000, 1.9251e+000, 932.1618e-003, 879.4990e-003, 830.4846e-003,
         1.2116e+000, 316.4872e-003, 705.9886e-003, 669.7913e-003, 636.1372e-003, 610.2594e-003, 582.6442e-003, 558.4364e-003,
       536.3819e-003, 465.7145e-003, 409.5842e-003, 441.0723e-003, 397.2309e-003, 387.7071e-003, 427.7733e-003, 380.3731e-003,
       389.2594e-003, 360.1676e-003, 397.7181e-003, 367.8170e-003, 376.2258e-003, 344.2808e-003, 373.4120e-003, 335.4436e-003,
       360.7556e-003, 205.9852e-003, 623.4130e-003, 228.7991e-003, 352.6111e-003, 341.3721e-003, 334.8656e-003, 373.0712e-003,
       293.7672e-003, 330.5520e-003, 333.2593e-003, 326.4328e-003, 330.9182e-003, 350.6426e-003, 305.0079e-003, 295.4935e-003,
       271.4444e-003, 285.7177e-003, 271.8767e-003, 288.4255e-003, 203.0216e-003, 198.0731e-003, 210.4034e-003, 126.5195e-003,
    ])
    assert np.allclose(aud[-1], aud_truth_last_row, atol=5e-3)

def test_compare_matlab_small_sound_point1_factor(small_sound_16khz):
    aud = auditory_spectrogram(small_sound_16khz, 16_000, frame_len=8, tc=4, factor=0.1)
    aud_truth_100th_row = np.array([
        92.2533e-003, 36.2357e-003, 31.7171e-003, 127.0441e-003, 87.7030e-003, 29.7736e-003, 44.1239e-003, 143.9761e-003,
        20.0714e-003, 121.9644e-003, 206.2290e-003, 94.4486e-003, 169.7744e-003, 48.2810e-003, 47.5249e-003, 171.7675e-003,
        29.3112e-003, 324.1217e-003, 19.4454e-003, 117.2772e-003, 108.5869e-003, 32.3269e-003, 225.1521e-003, 103.6068e-003,
       131.9405e-003, 106.7497e-003, 179.7606e-003, 153.2127e-003, 109.1480e-003, 262.9377e-003, 153.0452e-003, 256.7687e-003,
       222.2283e-003, 241.0154e-003, 273.0167e-003, 307.5711e-003, 349.8268e-003, 407.7524e-003, 462.1252e-003, 505.3803e-003,
       536.5232e-003, 778.5410e-003, 930.6192e-003, 1.1236e+000, 1.3426e+000, 1.5518e+000, 1.4969e+000, 1.9904e+000,
         8.9231e+000, 18.1148e+000, 41.1508e+000, 32.3052e+000, 21.8487e+000, 16.5113e+000, 12.3931e+000, 9.3895e+000,
         7.8775e+000, 6.8081e+000, 5.5758e+000, 5.0145e+000, 4.5032e+000, 4.0315e+000, 3.4838e+000, 3.0160e+000,
         2.7310e+000, 2.4512e+000, 1.9284e+000, 1.7017e+000, 2.2738e+000, 934.9511e-003, 2.0864e+000, 1.3307e+000,
         1.1840e+000, 1.1233e+000, 999.9866e-003, 1.1481e+000, 1.2072e+000, 813.1592e-003, 756.2608e-003, 703.9348e-003,
         1.2327e+000, 284.2768e-003, 592.9784e-003, 559.6680e-003, 529.0195e-003, 506.0836e-003, 480.0682e-003, 457.0729e-003,
       435.7461e-003, 419.7795e-003, 389.4693e-003, 411.7016e-003, 369.9025e-003, 358.1115e-003, 381.4772e-003, 341.6561e-003,
       341.8682e-003, 318.5485e-003, 344.1197e-003, 320.2033e-003, 325.4864e-003, 301.1992e-003, 320.9275e-003, 293.8091e-003,
       311.9014e-003, 399.4974e-003, 908.4718e-003, 362.0760e-003, 321.0065e-003, 313.4007e-003, 304.2750e-003, 337.2754e-003,
       330.2553e-003, 308.3629e-003, 311.4784e-003, 315.0934e-003, 318.5870e-003, 329.6713e-003, 324.2461e-003, 337.0949e-003,
       336.4252e-003, 346.2156e-003, 346.4721e-003, 358.9232e-003, 365.3810e-003, 377.5651e-003, 387.5417e-003, 443.1055e-003,
    ])
    assert np.allclose(aud[99], aud_truth_100th_row, rtol=1e-4)

def test_compare_small_sound_resample_necessary(small_sound_10khz):
    aud = auditory_spectrogram(small_sound_10khz, 10_000)
    aud_truth_100th_row = np.array([
        1.27928018e-02, 4.51447116e-03, 4.36261937e-03, 1.77458688e-02,
        1.21789858e-02, 3.64274732e-03, 5.28986693e-03, 2.00458812e-02,
        2.62576760e-03, 1.69451982e-02, 2.87424096e-02, 1.14634475e-02,
        2.36022639e-02, 6.74908680e-03, 5.74352916e-03, 2.41567678e-02,
        3.56551035e-03, 4.60669437e-02, 2.36225199e-03, 1.64684299e-02,
        1.53798446e-02, 4.40162089e-03, 3.20258718e-02, 1.44737943e-02,
        1.85256527e-02, 1.49915193e-02, 2.55422906e-02, 2.14890558e-02,
        1.43283886e-02, 3.75687036e-02, 2.09927177e-02, 3.67271903e-02,
        3.15959545e-02, 3.40593079e-02, 3.82219775e-02, 4.26832764e-02,
        4.86843968e-02, 5.68977918e-02, 6.48824911e-02, 6.94994937e-02,
        7.79052626e-02, 1.11196692e-01, 1.34315217e-01, 1.60211145e-01,
        2.01839483e-01, 2.42410225e-01, 2.32127289e-01, 2.70607298e-01,
        1.19154514e+00, 6.34516828e+00, 1.84818890e+01, 1.48572439e+01,
        8.93880550e+00, 6.26666761e+00, 4.37936605e+00, 3.06861344e+00,
        2.40551354e+00, 1.93318073e+00, 1.53610938e+00, 1.30309084e+00,
        1.11416365e+00, 9.53989148e-01, 8.27751269e-01, 7.09117956e-01,
        6.23569636e-01, 5.45829743e-01, 4.55091561e-01, 4.19082357e-01,
        4.13569151e-01, 2.38741276e-01, 3.74384802e-01, 2.73229005e-01,
        2.28883622e-01, 2.08822743e-01, 1.45978414e-01, 2.11326607e-01,
        2.44501683e-01, 1.45724580e-01, 1.34216430e-01, 1.23946404e-01,
        1.99810682e-01, 4.60928673e-02, 9.95061325e-02, 9.25507586e-02,
        8.66554132e-02, 8.25205197e-02, 7.81135697e-02, 7.42583575e-02,
        7.07469325e-02, 6.76489907e-02, 6.21227668e-02, 6.49452111e-02,
        5.78290282e-02, 5.54979322e-02, 5.90085766e-02, 5.24885852e-02,
        5.28363665e-02, 4.89261203e-02, 5.22956216e-02, 4.84164153e-02,
        4.85396659e-02, 4.49204621e-02, 4.74613301e-02, 4.31650609e-02,
        4.58634118e-02, 5.51753428e-02, 1.17658116e-01, 5.12281451e-02,
        4.50608348e-02, 4.39799057e-02, 4.26000131e-02, 4.82993789e-02,
        4.39596775e-02, 4.28951582e-02, 4.32033345e-02, 4.32315203e-02,
        4.37074416e-02, 4.53971977e-02, 4.29908982e-02, 4.58517154e-02,
        4.48700132e-02, 4.63546671e-02, 4.58461330e-02, 4.76959302e-02,
        4.83011382e-02, 4.97950664e-02, 5.21061152e-02, 5.79194538e-02,
    ])
    assert np.allclose(aud[99], aud_truth_100th_row, rtol=1e-6)

