# Generated by Django 3.2.12 on 2022-04-27 19:36

from django.db import migrations, models
import django.db.models.deletion


def load_data_from_fixture(apps, schema_editor):
    from django.core.management import call_command
    call_command("loaddata", "data")


def delete_data(apps, schema_editor):
    Iubenda = apps.get_model("iubenda", "Iubenda")
    Iubenda.objects.all().delete()


class Migration(migrations.Migration):

    initial = True

    operations = [
        migrations.CreateModel(
            name='Iubenda',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('iub_site_id', models.IntegerField(unique=True, verbose_name='Iubenda Site ID')),
                ('iub_policy_id', models.IntegerField(unique=True, verbose_name='Iubenda Policy ID')),
                ('iub_policy_id_it', models.IntegerField(null=True, unique=True, verbose_name='Iubenda Policy ID')),
                ('iub_policy_id_en', models.IntegerField(null=True, unique=True, verbose_name='Iubenda Policy ID')),
                ('active', models.BooleanField(default=True)),
                ('site', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='sites.site', verbose_name='Django Site')),
            ],
            options={
                'verbose_name': 'Iubenda Policy',
                'verbose_name_plural': 'Iubenda Policies',
            },
        ),
        migrations.RunPython(load_data_from_fixture, delete_data),
    ]
