"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotSql = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Defines AWS IoT SQL.
 */
class IotSql {
    /**
     * Uses the original SQL version built on 2015-10-08.
     *
     * @param sql The actual SQL-like syntax query
     * @returns Instance of IotSql
     */
    static fromStringAsVer20151008(sql) {
        return new IotSqlImpl('2015-10-08', sql);
    }
    /**
     * Uses the SQL version built on 2016-03-23.
     *
     * @param sql The actual SQL-like syntax query
     * @returns Instance of IotSql
     */
    static fromStringAsVer20160323(sql) {
        return new IotSqlImpl('2016-03-23', sql);
    }
    /**
     * Uses the most recent beta SQL version. If you use this version, it might
     * introduce breaking changes to your rules.
     *
     * @param sql The actual SQL-like syntax query
     * @returns Instance of IotSql
     */
    static fromStringAsVerNewestUnstable(sql) {
        return new IotSqlImpl('beta', sql);
    }
}
exports.IotSql = IotSql;
_a = JSII_RTTI_SYMBOL_1;
IotSql[_a] = { fqn: "@aws-cdk/aws-iot.IotSql", version: "1.161.0" };
class IotSqlImpl extends IotSql {
    constructor(version, sql) {
        super();
        this.version = version;
        this.sql = sql;
        if (sql === '') {
            throw new Error('IoT SQL string cannot be empty');
        }
    }
    bind(_scope) {
        return {
            awsIotSqlVersion: this.version,
            sql: this.sql,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW90LXNxbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImlvdC1zcWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFpQkE7O0dBRUc7QUFDSCxNQUFzQixNQUFNO0lBQzFCOzs7OztPQUtHO0lBQ0ksTUFBTSxDQUFDLHVCQUF1QixDQUFDLEdBQVc7UUFDL0MsT0FBTyxJQUFJLFVBQVUsQ0FBQyxZQUFZLEVBQUUsR0FBRyxDQUFDLENBQUM7S0FDMUM7SUFFRDs7Ozs7T0FLRztJQUNJLE1BQU0sQ0FBQyx1QkFBdUIsQ0FBQyxHQUFXO1FBQy9DLE9BQU8sSUFBSSxVQUFVLENBQUMsWUFBWSxFQUFFLEdBQUcsQ0FBQyxDQUFDO0tBQzFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksTUFBTSxDQUFDLDZCQUE2QixDQUFDLEdBQVc7UUFDckQsT0FBTyxJQUFJLFVBQVUsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLENBQUM7S0FDcEM7O0FBOUJILHdCQW9DQzs7O0FBRUQsTUFBTSxVQUFXLFNBQVEsTUFBTTtJQUM3QixZQUE2QixPQUFlLEVBQW1CLEdBQVc7UUFDeEUsS0FBSyxFQUFFLENBQUM7UUFEbUIsWUFBTyxHQUFQLE9BQU8sQ0FBUTtRQUFtQixRQUFHLEdBQUgsR0FBRyxDQUFRO1FBR3hFLElBQUksR0FBRyxLQUFLLEVBQUUsRUFBRTtZQUNkLE1BQU0sSUFBSSxLQUFLLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztTQUNuRDtLQUNGO0lBRUQsSUFBSSxDQUFDLE1BQWlCO1FBQ3BCLE9BQU87WUFDTCxnQkFBZ0IsRUFBRSxJQUFJLENBQUMsT0FBTztZQUM5QixHQUFHLEVBQUUsSUFBSSxDQUFDLEdBQUc7U0FDZCxDQUFDO0tBQ0g7Q0FDRiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG4vKipcbiAqIFRoZSB0eXBlIHJldHVybmVkIGZyb20gdGhlIGBiaW5kKClgIG1ldGhvZCBpbiB7QGxpbmsgSW90U3FsfS5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJb3RTcWxDb25maWcge1xuICAvKipcbiAgICogVGhlIHZlcnNpb24gb2YgdGhlIFNRTCBydWxlcyBlbmdpbmUgdG8gdXNlIHdoZW4gZXZhbHVhdGluZyB0aGUgcnVsZS5cbiAgICovXG4gIHJlYWRvbmx5IGF3c0lvdFNxbFZlcnNpb246IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIFNRTCBzdGF0ZW1lbnQgdXNlZCB0byBxdWVyeSB0aGUgdG9waWMuXG4gICAqL1xuICByZWFkb25seSBzcWw6IHN0cmluZztcbn1cblxuLyoqXG4gKiBEZWZpbmVzIEFXUyBJb1QgU1FMLlxuICovXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgSW90U3FsIHtcbiAgLyoqXG4gICAqIFVzZXMgdGhlIG9yaWdpbmFsIFNRTCB2ZXJzaW9uIGJ1aWx0IG9uIDIwMTUtMTAtMDguXG4gICAqXG4gICAqIEBwYXJhbSBzcWwgVGhlIGFjdHVhbCBTUUwtbGlrZSBzeW50YXggcXVlcnlcbiAgICogQHJldHVybnMgSW5zdGFuY2Ugb2YgSW90U3FsXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21TdHJpbmdBc1ZlcjIwMTUxMDA4KHNxbDogc3RyaW5nKTogSW90U3FsIHtcbiAgICByZXR1cm4gbmV3IElvdFNxbEltcGwoJzIwMTUtMTAtMDgnLCBzcWwpO1xuICB9XG5cbiAgLyoqXG4gICAqIFVzZXMgdGhlIFNRTCB2ZXJzaW9uIGJ1aWx0IG9uIDIwMTYtMDMtMjMuXG4gICAqXG4gICAqIEBwYXJhbSBzcWwgVGhlIGFjdHVhbCBTUUwtbGlrZSBzeW50YXggcXVlcnlcbiAgICogQHJldHVybnMgSW5zdGFuY2Ugb2YgSW90U3FsXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21TdHJpbmdBc1ZlcjIwMTYwMzIzKHNxbDogc3RyaW5nKTogSW90U3FsIHtcbiAgICByZXR1cm4gbmV3IElvdFNxbEltcGwoJzIwMTYtMDMtMjMnLCBzcWwpO1xuICB9XG5cbiAgLyoqXG4gICAqIFVzZXMgdGhlIG1vc3QgcmVjZW50IGJldGEgU1FMIHZlcnNpb24uIElmIHlvdSB1c2UgdGhpcyB2ZXJzaW9uLCBpdCBtaWdodFxuICAgKiBpbnRyb2R1Y2UgYnJlYWtpbmcgY2hhbmdlcyB0byB5b3VyIHJ1bGVzLlxuICAgKlxuICAgKiBAcGFyYW0gc3FsIFRoZSBhY3R1YWwgU1FMLWxpa2Ugc3ludGF4IHF1ZXJ5XG4gICAqIEByZXR1cm5zIEluc3RhbmNlIG9mIElvdFNxbFxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tU3RyaW5nQXNWZXJOZXdlc3RVbnN0YWJsZShzcWw6IHN0cmluZyk6IElvdFNxbCB7XG4gICAgcmV0dXJuIG5ldyBJb3RTcWxJbXBsKCdiZXRhJywgc3FsKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIHRoZSBJb1QgU1FMIGNvbmZpZ3VyYXRpb24uXG4gICAqL1xuICBwdWJsaWMgYWJzdHJhY3QgYmluZChzY29wZTogQ29uc3RydWN0KTogSW90U3FsQ29uZmlnO1xufVxuXG5jbGFzcyBJb3RTcWxJbXBsIGV4dGVuZHMgSW90U3FsIHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSB2ZXJzaW9uOiBzdHJpbmcsIHByaXZhdGUgcmVhZG9ubHkgc3FsOiBzdHJpbmcpIHtcbiAgICBzdXBlcigpO1xuXG4gICAgaWYgKHNxbCA9PT0gJycpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignSW9UIFNRTCBzdHJpbmcgY2Fubm90IGJlIGVtcHR5Jyk7XG4gICAgfVxuICB9XG5cbiAgYmluZChfc2NvcGU6IENvbnN0cnVjdCk6IElvdFNxbENvbmZpZyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGF3c0lvdFNxbFZlcnNpb246IHRoaXMudmVyc2lvbixcbiAgICAgIHNxbDogdGhpcy5zcWwsXG4gICAgfTtcbiAgfVxufVxuIl19