# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['anime_pgen', 'anime_pgen.utils']

package_data = \
{'': ['*']}

install_requires = \
['Pillow>=9.0.1,<10.0.0',
 'PyYAML>=6.0,<7.0',
 'click==8.1.3',
 'colour>=0.1.5,<0.2.0',
 'joblib>=1.1.0,<2.0.0',
 'numpy>=1.22.3,<2.0.0',
 'ratelimiter>=1.2.0,<2.0.0',
 'requests>=2.27.1,<3.0.0',
 'typer[all]>=0.4.0,<0.5.0']

entry_points = \
{'console_scripts': ['pgen = anime_pgen.main:app']}

setup_kwargs = {
    'name': 'anime-pgen',
    'version': '1.0.0',
    'description': 'cli-утилита для генерации превью-изображений по данным Шикимори',
    'long_description': '# Генератор превью для Shikimori\n![Демо](https://github.com/shikimori/preview-generator/raw/master/demo.gif)\n\n<p align="center"><i>Демо</i></p>\n\n[![pypi](https://img.shields.io/pypi/v/anime-pgen?color=%2334D058&label=pypi%20package)](https://pypi.org/project/anime-pgen)\n\n\n## Описание\n`anime` представляет собой `cli`-утилиту для генерации превью-изображений по данным Шикимори (_скачивание данных включено в функциональность_). В качестве фреймворка для организации `cli` интерфейса используется [Typer](https://typer.tiangolo.com)\n\n### Требования и установка\n\n- Python `^3.9`\n- `pip`, или, `poetry` или любой другой пакетный менеджер для Python\n- Приложение на [Shikimori](https://shikimori.one/oauth/applications) (_для работы необходимо иметь_ `APPLICATION_NAME`)\n\nУстановка:\n```bash\n$> pip install anime\n```\n\n[Опционально] Подсказки для терминала:\n```bash\n$> pgen --install-completion\n```\n\n\n## Использование\n\n1. Понадобится создать папку для конфигов и контента\n```bash\n$> mkdir previews && cd previews\n```\n\n2. Далее нужно добавить конфиг-файл. Его можно взять [в репозитории](https://github.com/shikimori/preview-generator/blob/master/config.example.yaml). Имя файла: `config.yaml`\n```bash\n$> cp config.example.yaml config.yaml\n$> l\ntotal 16\ndrwxr-xr-x   4 user  staff   128B Jun 28 19:48 .\ndrwxr-xr-x  23 user  staff   736B Jun 28 19:43 ..\n-rw-r--r--   1 user  staff   1.1K Jun 28 19:48 config.yaml\n```\n\n3. Для удобства создадим папку `content` - в ней разместим шрифты и иконки\n```bash\n$> mkdir content\n$> l\ntotal 16\ndrwxr-xr-x   5 user  staff   160B Jun 28 19:52 .\ndrwxr-xr-x  23 user  staff   736B Jun 28 19:49 ..\n-rw-r--r--   1 user  staff   1.1K Jun 28 19:48 config.yaml\ndrwxr-xr-x   2 user  staff    64B Jun 28 19:52 content\n```\n\n4. В новосозданную папку `content` можно сразу [перенести из репозитория](https://github.com/shikimori/preview-generator/tree/master/content) двусоставное лого Шикимори, иконку рейтинга и заполнение заднего фона (или можно использовать свои)\n```bash\n$> cp shikimori-glyph.png content/shikimori-glyph.png\n$> cp shikimori-logo.png content/shikimori-logo.png\n$> cp star.png content/star.png\n$> cp tile.png content/tile.png\n$> tree -a\n.\n└── previews\n    ├── config.yaml\n    └── content\n        ├── shikimori-glyph.png\n        ├── shikimori-logo.png\n        ├── star.png\n        └── tile.png\n```\n\n5. В `content` так же нужно положить шрифты. Для Шикимори используются:\n\t- [🔗](https://fonts.google.com/specimen/Open+Sans) `OpenSans` для заголовка и описания\n\t- [🔗](https://docs.microsoft.com/ru-ru/typography/font-list/tahoma) `Tahoma` для рейтинга\n\t- [🔗](https://fonts.google.com/noto/specimen/Noto+Serif+JP) `NotoSerif_JP` для Японских иероглифов\n\nФинально папка `previews` выглядит примерно так:\n```bash\n$> tree -a -L 4\n.\n└── previews\n    ├── config.yaml\n    └── content\n        ├── Noto_Serif_JP\n        │\xa0\xa0 ├── NotoSerifJP-Black.otf\n        │\xa0\xa0 ├── NotoSerifJP-Bold.otf\n        │\xa0\xa0 ├── NotoSerifJP-ExtraLight.otf\n        │\xa0\xa0 ├── NotoSerifJP-Light.otf\n        │\xa0\xa0 ├── NotoSerifJP-Medium.otf\n        │\xa0\xa0 ├── NotoSerifJP-Regular.otf\n        │\xa0\xa0 ├── NotoSerifJP-SemiBold.otf\n        │\xa0\xa0 └── OFL.txt\n        ├── Open_Sans\n        │\xa0\xa0 ├── LICENSE.txt\n        │\xa0\xa0 ├── OpenSans-Italic-VariableFont_wdth,wght.ttf\n        │\xa0\xa0 ├── OpenSans-VariableFont_wdth,wght.ttf\n        │\xa0\xa0 ├── README.txt\n        │\xa0\xa0 └── static\n        ├── Tahoma\n        │\xa0\xa0 ├── COPYRIGHT.txt\n        │\xa0\xa0 └── tahoma.ttf\n        ├── shikimori-glyph.png\n        ├── shikimori-logo.png\n        ├── star.png\n        └── tile.png\n\n```\n\n### `config.yaml`\n\nРассмотрим конфигурационный файл. По дефолту он выглядит так:\n```yml\nsize: \'big\'\n\ncolors:\n  background: \'#ffffff\'\n  text: \'#343434\'\n  year: \'#555555\' \n\n  rating:\n    active: \'#4c86c8\'\n    regular: \'#cccccc\'\n\ncontent:\n  images: \n    background_tile: content/tile.png \n    star: content/star.png \n    logo: \n      glyph: content/shikimori-glyph.png\n      text: content/shikimori-logo.png\n  fonts: \n    text: content/Open_Sans/OpenSans-VariableFont_wdth,wght.ttf\n    bold_text: content/Open_Sans/static/OpenSans/OpenSans-Bold.ttf\n    numbers: content/Tahoma/tahoma.ttf\n    japanese: content/Noto_Serif_JP/NotoSerifJP-Bold.otf \n```\n---\n```yml\nsize: \'big\'\n```\n\nВозможные значения:\n  - `big`   = 1200 x 630 _(значение по умолчанию)_\n  - `small` = 600 x 315\n\nЭто размер финального изображения. Цифры являются рекоммендацией к формату превью от Facebook/Twitter/Вконтакте.\n\n----\n\n```yml\nrating:\n    active: \'#4c86c8\'\n    regular: \'#cccccc\'\n```\nЦвета звёздочек рейтинга - активных и плейсхолдеров.\nВ конфиге представлены их дефолтные значения.\n\n----\n\n```yml\ncolors:\n  background: \'#ffffff\'\n  text: \'#343434\'\n  year: \'#555555\' \n```\n\nЦвета:\n- Подложки (`background`)\n- Всего текса (`text`)\n- Года выпуска (`year`)\n\nВ конфиге представлены их дефолтные значения.\n\n----\n\n**Важно!**\n\n`colors` и `size` - опциональны. \nВ случае, если они не указаны в файле - будут использовать дефолтные значения (которые совпадают с дефолтным конфигом)\n\n`content` - обязательные поля\n\n**Важно2!**\nДля картинок нельзя использовать `.svg`, только `.jpeg|.jpg|.png` (ограничение библиотеки)\n\n----\n\n```yml\ncontent:\n  images: \n    background_tile: content/tile.png \n```\n\nПуть до файла с тайлом для заднего фона. Например, дефолтный для Шикимори:\n\n![Tile](https://shikimori.one/assets/background/square_bg.png)\n\nРекоммендации:\n- Квадратный (иначе сплющится)\n- Бесшовный\n- `.png` с альфа-каналом, если хочется красивого наложения на белый фон\n\n----\n\n```yml\ncontent:\n  images: \n    star: content/star.png \n```\nПуть до файла со звездой рейтинга.\n\nТребования:\n- Прозрачный фон\n- Фигура чёрного цвета\n- Квадрат\n\nПри накладывании на превью чёрный цвет перекрашивается в `rating.active` или `rating.regular`\n\n----\n\n```yml\nlogo: \n      glyph: content/shikimori-glyph.png\n      text: content/shikimori-logo.png\n```\n\nДвусоставное лого Шикимори - Иероглиф + "SHIKIMORI"\n\nТребования:\n- Одинаковая высота\n- `.png` с альфа-каналом\n\n----\n\n```yml\nfonts: \n    text: content/Open_Sans/OpenSans-VariableFont_wdth,wght.ttf\n    bold_text: content/Open_Sans/static/OpenSans/OpenSans-Bold.ttf\n    numbers: content/Tahoma/tahoma.ttf\n    japanese: content/Noto_Serif_JP/NotoSerifJP-Bold.otf \n```\n\nПуть до шрифтов:\n- `text` - описание и подписи\n- `bold_text` - название\n- `number` - рейтинг и год\n- `japanese` - для Иероглифов, Хираганы и Катаканы\n\nТребования:\n- `TrueType` шрифты\n\n### Использование\n\n- Подробная документация по `cli`-интерфейсу: [DOCS.md](https://github.com/shikimori/preview-generator/blob/master/DOCS.md)\n- Пример использования: [Makefile](https://github.com/shikimori/preview-generator/blob/master/Makefile)\n\nИспользование состоит из двух частей:\n1. Скачиваем данные из API-Шикимори по `id` аниме или манги\n2. Генерируем превью по данным\n\nСкачаем информацию об аниме "Ковбой Бибоп":\n```bash\n$> pgen fetch 1 --app-name <APPLICATION_NAME_из_Шикимори>\nSuccessfully saved to .pgen.json\n\n$> l\ntotal 40\ndrwxr-xr-x  6 vladimirlevin  staff   192B Jun 28 20:36 .\ndrwxr-xr-x  3 vladimirlevin  staff    96B Jun 28 19:56 ..\n-rw-r--r--  1 vladimirlevin  staff   9.2K Jun 28 20:36 .pgen.json\n-rw-r--r--  1 vladimirlevin  staff   1.1K Jun 28 19:48 config.yaml\ndrwxr-xr-x  9 vladimirlevin  staff   288B Jun 28 20:03 content\n```\n\nПо умолчанию данные сохраняются в `.pgen.json`, путь можно изменить, передав флаг `--save-path \'my_file.json\'`\n```bash\n$> pgen fetch 1 --app-name <APPLICATION_NAME_из_Шикимори> --save-path "my_file.json"\nSuccessfully saved to my_file.json\n```\n\nПереходим к генерации:\n```bash\n$>pgen make-preview .pgen.json \\\n\t--output-folder "." \\\n    --config "config.yaml" \\\n    --app-name <APPLICATION_NAME_из_Шикимори>\n\nSuccessfully create previews:\n         - 1.jpg\n```\n\n**Готово!** 🥳\n\n### FAQ\n\n**Q**: Как разметить много за раз? <br>\n**A**: С флагом `-M` можно за раз скачать и разметить много Аниме/Манги:\n```bash\n$> pgen fetch -M "1,5,8" --app-name <APPLICATION_NAME_из_Шикимори>\nSuccessfully saved to .pgen.json\n\n$> pgen make-preview .pgen.json --output-folder "." --config "config.yaml" --app-name <APPLICATION_NAME_из_Шикимори>\nSuccessfully create previews:\n         - 1.jpg\n         - 5.jpg\n         - 8.jpg\n```\n\n**Q**: Как разметить мангу?<br>\n**A**: С помощью флага `-m` можно скачать Мангу. Создание превью опирается на данные, поэтому во второй команде ничего не потребуется менять\n```bash\n$> pgen fetch -mM "1,8" --app-name <APPLICATION_NAME_из_Шикимори>\nSuccessfully saved to .pgen.json\n\n$> pgen make-preview .pgen.json --output-folder "." --config "config.yaml" --app-name <APPLICATION_NAME_из_Шикимори>\nSuccessfully create previews:\n         - 1.jpg\n         - 8.jpg\n```\n',
    'author': 'Vladimir Levin',
    'author_email': 'opaozhub@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/shikimori/preview-generator',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
