# mypy-boto3-docdb

[![PyPI - mypy-boto3-docdb](https://img.shields.io/pypi/v/mypy-boto3-docdb.svg?color=blue)](https://pypi.org/project/mypy-boto3-docdb)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-docdb.svg?color=blue)](https://pypi.org/project/mypy-boto3-docdb)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.DocDB 1.13.10](https://boto3.amazonaws.com/v1/documentation/api/1.13.10/reference/services/docdb.html#DocDB) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.9](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-docdb](#mypy-boto3-docdb)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `DocDB` service.

```bash
python -m pip install boto3-stubs[docdb]

# update installed packages index
mypy_boto3
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import docdb
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_docdb as docdb

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("docdb")
client: docdb.DocDBClient = boto3.client("docdb")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: docdb.DocDBClient = session.client("docdb")


# Waiters need type annotation on creation
db_instance_available_waiter: docdb.DBInstanceAvailableWaiter = client.get_waiter("db_instance_available")
db_instance_deleted_waiter: docdb.DBInstanceDeletedWaiter = client.get_waiter("db_instance_deleted")

# Paginators need type annotation on creation
describe_db_clusters_paginator: docdb.DescribeDBClustersPaginator = client.get_paginator("describe_db_clusters")
describe_db_engine_versions_paginator: docdb.DescribeDBEngineVersionsPaginator = client.get_paginator("describe_db_engine_versions")
describe_db_instances_paginator: docdb.DescribeDBInstancesPaginator = client.get_paginator("describe_db_instances")
describe_db_subnet_groups_paginator: docdb.DescribeDBSubnetGroupsPaginator = client.get_paginator("describe_db_subnet_groups")
describe_events_paginator: docdb.DescribeEventsPaginator = client.get_paginator("describe_events")
describe_orderable_db_instance_options_paginator: docdb.DescribeOrderableDBInstanceOptionsPaginator = client.get_paginator("describe_orderable_db_instance_options")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.