from slack.web.classes.objects import (
    MarkdownTextObject,
    PlainTextObject,
    OptionGroup,
    Option,
)

# Taken from http://vocab.nic.in/rest.php/country/json


COUNTRIES = [
    {"country": {"country_id": "AD", "country_name": "ANDORRA"}},
    {"country": {"country_id": "AE", "country_name": "UNITED ARAB EMIRATES"}},
    {"country": {"country_id": "AF", "country_name": "AFGHANISTAN"}},
    {"country": {"country_id": "AG", "country_name": "ANTIGUA AND BARBUDA"}},
    {"country": {"country_id": "AI", "country_name": "ANGUILLA"}},
    {"country": {"country_id": "AL", "country_name": "ALBANIA"}},
    {"country": {"country_id": "AM", "country_name": "ARMENIA"}},
    {"country": {"country_id": "AN", "country_name": "NETHERLANDS ANTILLES"}},
    {"country": {"country_id": "AO", "country_name": "ANGOLA"}},
    {"country": {"country_id": "AQ", "country_name": "ANTARCTICA"}},
    {"country": {"country_id": "AR", "country_name": "ARGENTINA"}},
    {"country": {"country_id": "AS", "country_name": "AMERICAN SAMOA"}},
    {"country": {"country_id": "AT", "country_name": "AUSTRIA"}},
    {"country": {"country_id": "AU", "country_name": "AUSTRALIA"}},
    {"country": {"country_id": "AW", "country_name": "ARUBA"}},
    {"country": {"country_id": "AX", "country_name": "ÅLAND ISLANDS"}},
    {"country": {"country_id": "AZ", "country_name": "AZERBAIJAN"}},
    {"country": {"country_id": "BA", "country_name": "BOSNIA AND HERZEGOVINA"}},
    {"country": {"country_id": "BB", "country_name": "BARBADOS"}},
    {"country": {"country_id": "BD", "country_name": "BANGLADESH"}},
    {"country": {"country_id": "BE", "country_name": "BELGIUM"}},
    {"country": {"country_id": "BF", "country_name": "BURKINA FASO"}},
    {"country": {"country_id": "BG", "country_name": "BULGARIA"}},
    {"country": {"country_id": "BH", "country_name": "BAHRAIN"}},
    {"country": {"country_id": "BI", "country_name": "BURUNDI"}},
    {"country": {"country_id": "BJ", "country_name": "BENIN"}},
    {"country": {"country_id": "BL", "country_name": "SAINT BARTHÉLEMY"}},
    {"country": {"country_id": "BM", "country_name": "BERMUDA"}},
    {"country": {"country_id": "BN", "country_name": "BRUNEI DARUSSALAM"}},
    {"country": {"country_id": "BO", "country_name": "BOLIVIA"}},
    {"country": {"country_id": "BR", "country_name": "BRAZIL"}},
    {"country": {"country_id": "BS", "country_name": "BAHAMAS"}},
    {"country": {"country_id": "BT", "country_name": "BHUTAN"}},
    {"country": {"country_id": "BV", "country_name": "BOUVET ISLAND"}},
    {"country": {"country_id": "BW", "country_name": "BOTSWANA"}},
    {"country": {"country_id": "BY", "country_name": "BELARUS"}},
    {"country": {"country_id": "BZ", "country_name": "BELIZE"}},
    {"country": {"country_id": "CA", "country_name": "CANADA"}},
    {"country": {"country_id": "CC", "country_name": "COCOS (KEELING) ISLANDS"}},
    {
        "country": {
            "country_id": "CD",
            "country_name": "CONGO, THE DEMOCRATIC REPUBLIC OF THE",
        }
    },
    {"country": {"country_id": "CF", "country_name": "CENTRAL AFRICAN REPUBLIC"}},
    {"country": {"country_id": "CG", "country_name": "CONGO"}},
    {"country": {"country_id": "CH", "country_name": "SWITZERLAND"}},
    {"country": {"country_id": "CI", "country_name": "CÔTE D'IVOIRE"}},
    {"country": {"country_id": "CK", "country_name": "COOK ISLANDS"}},
    {"country": {"country_id": "CL", "country_name": "CHILE"}},
    {"country": {"country_id": "CM", "country_name": "CAMEROON"}},
    {"country": {"country_id": "CN", "country_name": "CHINA"}},
    {"country": {"country_id": "CO", "country_name": "COLOMBIA"}},
    {"country": {"country_id": "CR", "country_name": "COSTA RICA"}},
    {"country": {"country_id": "CU", "country_name": "CUBA"}},
    {"country": {"country_id": "CX", "country_name": "CHRISTMAS ISLAND"}},
    {"country": {"country_id": "CY", "country_name": "CYPRUS"}},
    {"country": {"country_id": "CZ", "country_name": "CZECH REPUBLIC"}},
    {"country": {"country_id": "DE", "country_name": "GERMANY"}},
    {"country": {"country_id": "DJ", "country_name": "DJIBOUTI"}},
    {"country": {"country_id": "DK", "country_name": "DENMARK"}},
    {"country": {"country_id": "DM", "country_name": "DOMINICA"}},
    {"country": {"country_id": "DO", "country_name": "DOMINICAN REPUBLIC"}},
    {"country": {"country_id": "DZ", "country_name": "ALGERIA"}},
    {"country": {"country_id": "EC", "country_name": "ECUADOR"}},
    {"country": {"country_id": "EE", "country_name": "ESTONIA"}},
    {"country": {"country_id": "EG", "country_name": "EGYPT"}},
    {"country": {"country_id": "EH", "country_name": "WESTERN SAHARA"}},
    {"country": {"country_id": "ES", "country_name": "SPAIN"}},
    {"country": {"country_id": "ET", "country_name": "ETHIOPIA"}},
    {"country": {"country_id": "FI", "country_name": "FINLAND"}},
    {"country": {"country_id": "FJ", "country_name": "FIJI"}},
    {"country": {"country_id": "FK", "country_name": "FALKLAND ISLANDS (MALVINAS)"}},
    {
        "country": {
            "country_id": "FM",
            "country_name": "MICRONESIA, FEDERATED STATES OF",
        }
    },
    {"country": {"country_id": "FO", "country_name": "FAROE ISLANDS"}},
    {"country": {"country_id": "FR", "country_name": "FRANCE"}},
    {"country": {"country_id": "GA", "country_name": "GABON"}},
    {"country": {"country_id": "GB", "country_name": "UNITED KINGDOM"}},
    {"country": {"country_id": "GD", "country_name": "GRENADA"}},
    {"country": {"country_id": "GE", "country_name": "GEORGIA"}},
    {"country": {"country_id": "GF", "country_name": "FRENCH GUIANA"}},
    {"country": {"country_id": "GG", "country_name": "GUERNSEY"}},
    {"country": {"country_id": "GH", "country_name": "GHANA"}},
    {"country": {"country_id": "GI", "country_name": "GIBRALTAR"}},
    {"country": {"country_id": "GL", "country_name": "GREENLAND"}},
    {"country": {"country_id": "GM", "country_name": "GAMBIA"}},
    {"country": {"country_id": "GN", "country_name": "GUINEA"}},
    {"country": {"country_id": "GP", "country_name": "GUADELOUPE"}},
    {"country": {"country_id": "GQ", "country_name": "EQUATORIAL GUINEA"}},
    {"country": {"country_id": "GR", "country_name": "GREECE"}},
    {
        "country": {
            "country_id": "GS",
            "country_name": "SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS",
        }
    },
    {"country": {"country_id": "GT", "country_name": "GUATEMALA"}},
    {"country": {"country_id": "GU", "country_name": "GUAM"}},
    {"country": {"country_id": "GW", "country_name": "GUINEA-BISSAU"}},
    {"country": {"country_id": "GY", "country_name": "GUYANA"}},
    {"country": {"country_id": "HK", "country_name": "HONG KONG"}},
    {
        "country": {
            "country_id": "HM",
            "country_name": "HEARD ISLAND AND MCDONALD ISLANDS",
        }
    },
    {"country": {"country_id": "HN", "country_name": "HONDURAS"}},
    {"country": {"country_id": "HR", "country_name": "CROATIA"}},
    {"country": {"country_id": "HT", "country_name": "HAITI"}},
    {"country": {"country_id": "HU", "country_name": "HUNGARY"}},
    {"country": {"country_id": "ID", "country_name": "INDONESIA"}},
    {"country": {"country_id": "IE", "country_name": "IRELAND"}},
    {"country": {"country_id": "IL", "country_name": "ISRAEL"}},
    {"country": {"country_id": "IM", "country_name": "ISLE OF MAN"}},
    {"country": {"country_id": "IO", "country_name": "BRITISH INDIAN OCEAN TERRITORY"}},
    {"country": {"country_id": "IQ", "country_name": "IRAQ"}},
    {"country": {"country_id": "IR", "country_name": "IRAN, ISLAMIC REPUBLIC OF"}},
    {"country": {"country_id": "IS", "country_name": "ICELAND"}},
    {"country": {"country_id": "IT", "country_name": "ITALY"}},
    {"country": {"country_id": "JE", "country_name": "JERSEY"}},
    {"country": {"country_id": "JM", "country_name": "JAMAICA"}},
    {"country": {"country_id": "JO", "country_name": "JORDAN"}},
    {"country": {"country_id": "JP", "country_name": "JAPAN"}},
    {"country": {"country_id": "KE", "country_name": "KENYA"}},
    {"country": {"country_id": "KG", "country_name": "KYRGYZSTAN"}},
    {"country": {"country_id": "KH", "country_name": "CAMBODIA"}},
    {"country": {"country_id": "KI", "country_name": "KIRIBATI"}},
    {"country": {"country_id": "KM", "country_name": "COMOROS"}},
    {"country": {"country_id": "KN", "country_name": "SAINT KITTS AND NEVIS"}},
    {
        "country": {
            "country_id": "KP",
            "country_name": "KOREA, DEMOCRATIC PEOPLE'S REPUBLIC OF",
        }
    },
    {"country": {"country_id": "KR", "country_name": "KOREA, REPUBLIC OF"}},
    {"country": {"country_id": "KW", "country_name": "KUWAIT"}},
    {"country": {"country_id": "KY", "country_name": "CAYMAN ISLANDS"}},
    {"country": {"country_id": "KZ", "country_name": "KAZAKHSTAN"}},
    {
        "country": {
            "country_id": "LA",
            "country_name": "LAO PEOPLE'S DEMOCRATIC REPUBLIC",
        }
    },
    {"country": {"country_id": "LB", "country_name": "LEBANON"}},
    {"country": {"country_id": "LC", "country_name": "SAINT LUCIA"}},
    {"country": {"country_id": "LI", "country_name": "LIECHTENSTEIN"}},
    {"country": {"country_id": "LK", "country_name": "SRI LANKA"}},
    {"country": {"country_id": "LR", "country_name": "LIBERIA"}},
    {"country": {"country_id": "LS", "country_name": "LESOTHO"}},
    {"country": {"country_id": "LT", "country_name": "LITHUANIA"}},
    {"country": {"country_id": "LU", "country_name": "LUXEMBOURG"}},
    {"country": {"country_id": "LV", "country_name": "LATVIA"}},
    {"country": {"country_id": "LY", "country_name": "LIBYAN ARAB JAMAHIRIYA"}},
    {"country": {"country_id": "MA", "country_name": "MOROCCO"}},
    {"country": {"country_id": "MC", "country_name": "MONACO"}},
    {"country": {"country_id": "MD", "country_name": "MOLDOVA, REPUBLIC OF"}},
    {"country": {"country_id": "ME", "country_name": "MONTENEGRO"}},
    {"country": {"country_id": "MF", "country_name": "SAINT MARTIN"}},
    {"country": {"country_id": "MG", "country_name": "MADAGASCAR"}},
    {"country": {"country_id": "MH", "country_name": "MARSHALL ISLANDS"}},
    {
        "country": {
            "country_id": "MK",
            "country_name": "MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF",
        }
    },
    {"country": {"country_id": "ML", "country_name": "MALI"}},
    {"country": {"country_id": "MM", "country_name": "MYANMAR"}},
    {"country": {"country_id": "MN", "country_name": "MONGOLIA"}},
    {"country": {"country_id": "MO", "country_name": "MACAO"}},
    {"country": {"country_id": "MP", "country_name": "NORTHERN MARIANA ISLANDS"}},
    {"country": {"country_id": "MQ", "country_name": "MARTINIQUE"}},
    {"country": {"country_id": "MR", "country_name": "MAURITANIA"}},
    {"country": {"country_id": "MS", "country_name": "MONTSERRAT"}},
    {"country": {"country_id": "MT", "country_name": "MALTA"}},
    {"country": {"country_id": "MU", "country_name": "MAURITIUS"}},
    {"country": {"country_id": "MV", "country_name": "MALDIVES"}},
    {"country": {"country_id": "MW", "country_name": "MALAWI"}},
    {"country": {"country_id": "MX", "country_name": "MEXICO"}},
    {"country": {"country_id": "MY", "country_name": "MALAYSIA"}},
    {"country": {"country_id": "MZ", "country_name": "MOZAMBIQUE"}},
    {"country": {"country_id": "NA", "country_name": "NAMIBIA"}},
    {"country": {"country_id": "NC", "country_name": "NEW CALEDONIA"}},
    {"country": {"country_id": "NE", "country_name": "NIGER"}},
    {"country": {"country_id": "NF", "country_name": "NORFOLK ISLAND"}},
    {"country": {"country_id": "NG", "country_name": "NIGERIA"}},
    {"country": {"country_id": "NI", "country_name": "NICARAGUA"}},
    {"country": {"country_id": "NL", "country_name": "NETHERLANDS"}},
    {"country": {"country_id": "NO", "country_name": "NORWAY"}},
    {"country": {"country_id": "NP", "country_name": "NEPAL"}},
    {"country": {"country_id": "NR", "country_name": "NAURU"}},
    {"country": {"country_id": "NU", "country_name": "NIUE"}},
    {"country": {"country_id": "NZ", "country_name": "NEW ZEALAND"}},
    {"country": {"country_id": "OM", "country_name": "OMAN"}},
    {"country": {"country_id": "PA", "country_name": "PANAMA"}},
    {"country": {"country_id": "PE", "country_name": "PERU"}},
    {"country": {"country_id": "PF", "country_name": "FRENCH POLYNESIA"}},
    {"country": {"country_id": "PG", "country_name": "PAPUA NEW GUINEA"}},
    {"country": {"country_id": "PH", "country_name": "PHILIPPINES"}},
    {"country": {"country_id": "PK", "country_name": "PAKISTAN"}},
    {"country": {"country_id": "PL", "country_name": "POLAND"}},
    {"country": {"country_id": "PM", "country_name": "SAINT PIERRE AND MIQUELON"}},
    {"country": {"country_id": "PN", "country_name": "PITCAIRN"}},
    {"country": {"country_id": "PR", "country_name": "PUERTO RICO"}},
    {
        "country": {
            "country_id": "PS",
            "country_name": "PALESTINIAN TERRITORY, OCCUPIED",
        }
    },
    {"country": {"country_id": "PT", "country_name": "PORTUGAL"}},
    {"country": {"country_id": "PW", "country_name": "PALAU"}},
    {"country": {"country_id": "PY", "country_name": "PARAGUAY"}},
    {"country": {"country_id": "QA", "country_name": "QATAR"}},
    {"country": {"country_id": "RE", "country_name": "REUNION"}},
    {"country": {"country_id": "RO", "country_name": "ROMANIA"}},
    {"country": {"country_id": "RS", "country_name": "SERBIA"}},
    {"country": {"country_id": "RU", "country_name": "RUSSIAN FEDERATION"}},
    {"country": {"country_id": "RW", "country_name": "RWANDA"}},
    {"country": {"country_id": "SA", "country_name": "SAUDI ARABIA"}},
    {"country": {"country_id": "SB", "country_name": "SOLOMON ISLANDS"}},
    {"country": {"country_id": "SC", "country_name": "SEYCHELLES"}},
    {"country": {"country_id": "SD", "country_name": "SUDAN"}},
    {"country": {"country_id": "SE", "country_name": "SWEDEN"}},
    {"country": {"country_id": "SG", "country_name": "SINGAPORE"}},
    {"country": {"country_id": "SH", "country_name": "SAINT HELENA"}},
    {"country": {"country_id": "SI", "country_name": "SLOVENIA"}},
    {"country": {"country_id": "SJ", "country_name": "SVALBARD AND JAN MAYEN"}},
    {"country": {"country_id": "SK", "country_name": "SLOVAKIA"}},
    {"country": {"country_id": "SL", "country_name": "SIERRA LEONE"}},
    {"country": {"country_id": "SM", "country_name": "SAN MARINO"}},
    {"country": {"country_id": "SN", "country_name": "SENEGAL"}},
    {"country": {"country_id": "SO", "country_name": "SOMALIA"}},
    {"country": {"country_id": "SR", "country_name": "SURINAME"}},
    {"country": {"country_id": "ST", "country_name": "SAO TOME AND PRINCIPE"}},
    {"country": {"country_id": "SV", "country_name": "EL SALVADOR"}},
    {"country": {"country_id": "SY", "country_name": "SYRIAN ARAB REPUBLIC"}},
    {"country": {"country_id": "SZ", "country_name": "SWAZILAND"}},
    {"country": {"country_id": "TC", "country_name": "TURKS AND CAICOS ISLANDS"}},
    {"country": {"country_id": "TD", "country_name": "CHAD"}},
    {"country": {"country_id": "TF", "country_name": "FRENCH SOUTHERN TERRITORIES"}},
    {"country": {"country_id": "TG", "country_name": "TOGO"}},
    {"country": {"country_id": "TH", "country_name": "THAILAND"}},
    {"country": {"country_id": "TJ", "country_name": "TAJIKISTAN"}},
    {"country": {"country_id": "TK", "country_name": "TOKELAU"}},
    {"country": {"country_id": "TL", "country_name": "TIMOR-LESTE"}},
    {"country": {"country_id": "TM", "country_name": "TURKMENISTAN"}},
    {"country": {"country_id": "TN", "country_name": "TUNISIA"}},
    {"country": {"country_id": "TO", "country_name": "TONGA"}},
    {"country": {"country_id": "TR", "country_name": "TURKEY"}},
    {"country": {"country_id": "TT", "country_name": "TRINIDAD AND TOBAGO"}},
    {"country": {"country_id": "TV", "country_name": "TUVALU"}},
    {"country": {"country_id": "TW", "country_name": "TAIWAN, PROVINCE OF CHINA"}},
    {"country": {"country_id": "TZ", "country_name": "TANZANIA, UNITED REPUBLIC OF"}},
    {"country": {"country_id": "UA", "country_name": "UKRAINE"}},
    {"country": {"country_id": "UG", "country_name": "UGANDA"}},
    {
        "country": {
            "country_id": "UM",
            "country_name": "UNITED STATES MINOR OUTLYING ISLANDS",
        }
    },
    {"country": {"country_id": "US", "country_name": "UNITED STATES"}},
    {"country": {"country_id": "UY", "country_name": "URUGUAY"}},
    {"country": {"country_id": "UZ", "country_name": "UZBEKISTAN"}},
    {"country": {"country_id": "VA", "country_name": "HOLY SEE (VATICAN CITY STATE)"}},
    {
        "country": {
            "country_id": "VC",
            "country_name": "SAINT VINCENT AND THE GRENADINES",
        }
    },
    {"country": {"country_id": "VE", "country_name": "VENEZUELA"}},
    {"country": {"country_id": "VG", "country_name": "VIRGIN ISLANDS, BRITISH"}},
    {"country": {"country_id": "VI", "country_name": "VIRGIN ISLANDS, U.S."}},
    {"country": {"country_id": "VN", "country_name": "VIET NAM"}},
    {"country": {"country_id": "VU", "country_name": "VANUATU"}},
    {"country": {"country_id": "WF", "country_name": "WALLIS AND FUTUNA"}},
    {"country": {"country_id": "WS", "country_name": "SAMOA"}},
    {"country": {"country_id": "YE", "country_name": "YEMEN"}},
    {"country": {"country_id": "YT", "country_name": "MAYOTTE"}},
    {"country": {"country_id": "ZA", "country_name": "SOUTH AFRICA"}},
    {"country": {"country_id": "ZM", "country_name": "ZAMBIA"}},
    {"country": {"country_id": "ZW", "country_name": "ZIMBABWE"}},
    {"country": {"country_id": "IN", "country_name": "INDIA"}},
]

if __name__ == "__main__":
    print(len(COUNTRIES))

COUNTRY_OPTIONS = [
    Option(
        label=x["country"]["country_name"], value=x["country"]["country_id"]
    ).to_dict()
    for x in COUNTRIES
][:100]
