# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/01_bool.ipynb.

# %% auto 0
__all__ = ['P', 'Boolic', 'Boolish', 'Bools', 'BoolFunc', 'BoolCall', 'BoolCalls', 'BoolFuncQ', 'BoolCallQ', 'FlagFunc',
           'FlagFuncQ', 'Bool01']

# %% ../nbs/01_bool.ipynb 6
#| export


# %% ../nbs/01_bool.ipynb 8
from typing import (Any, List, Union, Callable, Literal, TypeAlias, ParamSpec, Optional)
P = ParamSpec('P')

# %% ../nbs/01_bool.ipynb 10
try: from numpy import bool_ as npbool
except ImportError: npbool = bool

# %% ../nbs/01_bool.ipynb 12
#| export


# %% ../nbs/01_bool.ipynb 14
from ptyp import Alias

# %% ../nbs/01_bool.ipynb 16
Boolic:  TypeAlias = Union[bool, npbool]

@Alias(bool, npbool, 0, 1)
class Bool01: ...
# Bool01: TypeAlias = Union[Literal[0], Literal[1]]

Boolish: TypeAlias = Union[bool, Boolic, Bool01]

Bools: TypeAlias = List[bool]
'''A type alias for a list of booleans.''';

# %% ../nbs/01_bool.ipynb 17
BoolFunc: TypeAlias = Callable[P, Boolish]
'''A type alias for a function that returns a boolean.'''

BoolCall: TypeAlias = Union[Boolish, Callable]
'''A type alias for a boolean or a callable that returns a boolean.'''

BoolCalls: TypeAlias = List[BoolCall]
'''A type alias for a list of booleans or callables that each returns a boolean.'''

# %% ../nbs/01_bool.ipynb 18
BoolFuncQ: TypeAlias = Optional[BoolFunc]
BoolCallQ: TypeAlias = Optional[BoolCall]

# %% ../nbs/01_bool.ipynb 20
FlagFunc: TypeAlias = Callable[[Any], Boolish]
FlagFuncQ: TypeAlias = Optional[FlagFunc]
