# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/54_tens.ipynb.

# %% auto 0
__all__ = ['dtype', 'DType', 'TType', 'TrcType', 'TorchType', 'TorchDType', 'datatype', 'DataType', 'Tens', 'Tensor', 'TrcTensor',
           'IntTens', 'BoolTens', 'FloatTens', 'IntTensor', 'BoolTensor', 'FloatTensor', 'Device', 'Layer', 'Module',
           'Dataset', 'DataLoader', 'DataModule', 'NanTensor']

# %% ../nbs/54_tens.ipynb 6
import inspect
from numbers import Number

# %% ../nbs/54_tens.ipynb 8
import types
from typing import (
    Type, TypeAlias, Tuple,
    ClassVar, Any, Optional, Callable, Iterable, ForwardRef
)
from typing import TypeAlias, List, Union, Iterable, List

# %% ../nbs/54_tens.ipynb 11
try:
    import torch
    torchtype = torch.dtype
    tensor = torch.Tensor
    
    trcint = torch.IntTensor
    trcbool = torch.BoolTensor
    trcfloat = torch.FloatTensor
    
    device = torch.device
    module = torch.nn.Module
    trcnan = torch.nan

except ImportError:
    # Define a placeholder type if torch is not installed
    torchtype = 'torch.dtype'
    tensor = 'torch.Tensor'

    trcint = 'torch.IntTensor'
    trcbool = 'torch.BoolTensor'
    trcfloat = 'torch.FloatTensor'

    
    device = 'torch.device'
    module = 'torch.nn.Module'
    trcnan = 'torch.nan'

# %% ../nbs/54_tens.ipynb 12
try:
    from torch.utils.data import (
        Dataset as dataset, 
        DataLoader as dataloader
    )    
except ImportError:
    tudata = 'torch.utils.data'
    dataset = ForwardRef(f'{tudata}.Dataset', module=tudata, is_class=True)
    dataloader = ForwardRef(f'{tudata}.DataLoader', module=tudata, is_class=True)

# %% ../nbs/54_tens.ipynb 13
try:
    from pytorch_lightning import (LightningDataModule as pldm)
except ImportError:
    pl = 'pytorch_lightning'
    pldm = ForwardRef(f'{pl}.LightningDataModule', module='pytorch_lightning', is_class=True)

# %% ../nbs/54_tens.ipynb 16
from ptyp import Alias

# %% ../nbs/54_tens.ipynb 18
from .nums import Numbers

# %% ../nbs/54_tens.ipynb 22
dtype: TypeAlias = torchtype
DType: TypeAlias = dtype

TType: TypeAlias = dtype
TrcType: TypeAlias = dtype

TorchType: TypeAlias = dtype
TorchDType: TypeAlias = dtype

datatype: TypeAlias = dtype
DataType: TypeAlias = dtype

# %% ../nbs/54_tens.ipynb 24
Tens: TypeAlias = tensor
Tensor: TypeAlias = tensor
TrcTensor: TypeAlias = tensor

# %% ../nbs/54_tens.ipynb 25
@Alias(tensor, attrs=dict(dtype=trcnan))
class NanTensor: ...

# %% ../nbs/54_tens.ipynb 26
IntTens: TypeAlias = trcint
BoolTens: TypeAlias = trcbool
FloatTens: TypeAlias = trcfloat
IntTensor: TypeAlias = trcint
BoolTensor: TypeAlias = trcbool
FloatTensor: TypeAlias = trcfloat

# %% ../nbs/54_tens.ipynb 28
Device: TypeAlias = device

# %% ../nbs/54_tens.ipynb 30
Layer: TypeAlias = module
Module: TypeAlias = Layer

# %% ../nbs/54_tens.ipynb 32
Dataset: TypeAlias = dataset
DataLoader: TypeAlias = dataloader

# %% ../nbs/54_tens.ipynb 34
DataModule: TypeAlias = pldm
