# AUTOGENERATED! DO NOT EDIT! File to edit: ../../../pts/api/llm/01_rate_limits.pct.py.

# %% auto 0
__all__ = ['default_rpm', 'default_retry_on_exception', 'default_max_retries', 'default_retry_delay', 'default_timeout',
           'set_default_request_rate_limit', 'set_request_rate_limit']

# %% ../../../pts/api/llm/01_rate_limits.pct.py 3
try:
    import litellm
    from asynciolimiter import Limiter
    import asyncio
    from typing import Dict, Literal, Union
except ImportError as e:
    raise ImportError(f"Install adulib[llm] to use this API.") from e

# %% ../../../pts/api/llm/01_rate_limits.pct.py 5
default_rpm = 1000 # requests per minute
default_retry_on_exception = [
    litellm.RateLimitError,
    asyncio.TimeoutError
]
default_max_retries = 5
default_retry_delay = 10 # seconds
default_timeout = None # seconds

# %% ../../../pts/api/llm/01_rate_limits.pct.py 6
_request_rate_limiters: Dict[str, Limiter] = {}

# %% ../../../pts/api/llm/01_rate_limits.pct.py 7
def _convert_to_per_minute(rate: float, unit: Literal['per-second', 'per-minute', 'per-hour'] = 'per-minute') -> float:
    if unit == 'per-second':
        return rate * 60
    elif unit == 'per-hour':
        return rate / 60
    else:
        return rate

# %% ../../../pts/api/llm/01_rate_limits.pct.py 8
def set_default_request_rate_limit(
    request_rate: float, request_rate_unit: Literal['per-second', 'per-minute', 'per-hour'] = 'per-minute'
):
    global default_rpm
    default_rpm = _convert_to_per_minute(request_rate, request_rate_unit)
    return default_rpm

# %% ../../../pts/api/llm/01_rate_limits.pct.py 9
def _get_limiter(model: str, api_key: Union[str, None]=None) -> Limiter:
    key = f"{model}-{api_key}" if api_key is not None else model
    if key not in _request_rate_limiters:
        _request_rate_limiters[key] = Limiter(default_rpm / 60)
    return _request_rate_limiters.get(key, None)

# %% ../../../pts/api/llm/01_rate_limits.pct.py 10
def set_request_rate_limit(
    model: str, api_key: str|None, request_rate: float, request_rate_unit: Literal['per-second', 'per-minute', 'per-hour'] = 'per-minute'
):
    limiter = _get_limiter(model, api_key)
    if limiter is not None:
        limiter.breach() # Release any pending requests
    key = f"{model}-{api_key}" if api_key is not None else model
    rpm = _convert_to_per_minute(request_rate, request_rate_unit)
    _request_rate_limiters[key] = Limiter(rpm / 60)
