import { CloudscapeReactTsWebsiteProject } from "../../../../../cloudscape-react-ts-website";
import { TypeSafeApiProject, TypeSafeWebSocketApiProject } from "../../../../../type-safe-api";
import { AwsCdkTypeScriptApp } from "projen/lib/awscdk";
import { AwsCdkTypeScriptAppOptions } from "./aws-cdk-ts-app-options";
/**
 * Configuration options for the InfrastructureTsProject.
 */
export interface InfrastructureTsProjectOptions extends AwsCdkTypeScriptAppOptions {
    /**
     * Stack name.
     *
     * @default infra-dev
     */
    readonly stackName?: string;
    /**
     * TypeSafeApi instance to use when setting up the initial project sample code.
     * @deprecated use typeSafeApis
     */
    readonly typeSafeApi?: TypeSafeApiProject;
    /**
     * CloudscapeReactTsWebsiteProject instance to use when setting up the initial project sample code.
     * @deprecated use cloudscapeReactTsWebsites
     */
    readonly cloudscapeReactTsWebsite?: CloudscapeReactTsWebsiteProject;
    /**
     * TypeSafeApi instances to use when setting up the initial project sample code.
     */
    readonly typeSafeApis?: TypeSafeApiProject[];
    /**
     * TypeSafeWebSocketApi instances to use when setting up the initial project sample code.
     */
    readonly typeSafeWebSocketApis?: TypeSafeWebSocketApiProject[];
    /**
     * CloudscapeReactTsWebsiteProject instances to use when setting up the initial project sample code.
     */
    readonly cloudscapeReactTsWebsites?: CloudscapeReactTsWebsiteProject[];
}
/**
 * Synthesizes a Infrastructure Typescript Project.
 */
export declare class InfrastructureTsProject extends AwsCdkTypeScriptApp {
    constructor(options: InfrastructureTsProjectOptions);
    private generateTypeSafeMustacheConfig;
    private capitalize;
    private emitSampleFiles;
}
