/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
import { ApiGatewayIntegration, Integration, IntegrationRenderProps } from "./integration";
/**
 * Properties for a mock integration response
 */
export interface MockIntegrationResponse {
    /**
     * HTTP response status code
     */
    readonly statusCode: number;
    /**
     * Response body
     */
    readonly body?: string;
}
/**
 * A mock integration to return a hardcoded response
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-mock-integration.html
 */
export declare class MockIntegration extends Integration {
    private readonly props;
    constructor(props: MockIntegrationResponse);
    render(props: IntegrationRenderProps): ApiGatewayIntegration;
}
