/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
import type { OpenAPIV3 } from "openapi-types";
type SchemaDefinitions = {
    [key: string]: OpenAPIV3.SchemaObject;
};
export type ApiGatewaySchemaWithRefs = {
    schema: OpenAPIV3.SchemaObject;
    definitions: SchemaDefinitions;
};
export declare const extractWebSocketSchema: (operationId: string, requestBody: OpenAPIV3.RequestBodyObject | OpenAPIV3.ReferenceObject, spec: OpenAPIV3.Document) => ApiGatewaySchemaWithRefs | undefined;
export declare const extractWebSocketSchemas: (operationIds: string[], serverOperationPaths: {
    [operationId: string]: string;
}, spec: OpenAPIV3.Document) => {
    [operationId: string]: ApiGatewaySchemaWithRefs;
};
export {};
