import { Task } from "projen";
import { TypeScriptProject, TypeScriptProjectOptions } from "projen/lib/typescript";
import { CodeGenerationSourceOptions, GeneratedWithOpenApiGeneratorOptions } from "../../../types";
import { OpenApiGeneratorIgnoreFile } from "../../components/open-api-generator-ignore-file";
import { GenerationOptions } from "../../components/utils";
import { GeneratedHandlersProjects } from "../../generate";
import { GeneratedTypescriptRuntimeBaseProject } from "../../runtime/generated-typescript-runtime-base-project";
export interface GeneratedTypescriptInfrastructureBaseOptions extends TypeScriptProjectOptions, GeneratedWithOpenApiGeneratorOptions {
}
export interface GeneratedTypescriptCdkInfrastructureBaseProjectOptions extends GeneratedTypescriptInfrastructureBaseOptions, CodeGenerationSourceOptions {
    /**
     * Generated typescript types project
     */
    readonly generatedTypescriptTypes: GeneratedTypescriptRuntimeBaseProject;
    /**
     * Generated handlers projects
     */
    readonly generatedHandlers: GeneratedHandlersProjects;
    /**
     * Whether the infrastructure and client projects are parented by an monorepo or not
     */
    readonly isWithinMonorepo?: boolean;
}
export declare abstract class GeneratedTypescriptCdkInfrastructureBaseProject extends TypeScriptProject {
    /**
     * Options configured for the project
     */
    protected readonly options: GeneratedTypescriptCdkInfrastructureBaseProjectOptions;
    /**
     * Path to the packaged copy of the openapi specification
     */
    protected readonly packagedSpecPath = "assets/api.json";
    protected readonly generateTask: Task;
    protected readonly openapiGeneratorIgnore: OpenApiGeneratorIgnoreFile;
    constructor(options: GeneratedTypescriptCdkInfrastructureBaseProjectOptions);
    buildGenerateCommandArgs: () => string;
    protected abstract buildOpenApiGeneratorOptions(): GenerationOptions;
}
