import { JavaProject } from "projen/lib/java";
import { CodeGenerationSourceOptions, GeneratedJavaRuntimeOptions } from "../../types";
import { OpenApiGeneratorIgnoreFile } from "../components/open-api-generator-ignore-file";
import { GenerationOptions } from "../components/utils";
/**
 * Configuration for the generated java runtime project
 */
export interface GeneratedJavaRuntimeBaseProjectOptions extends GeneratedJavaRuntimeOptions, CodeGenerationSourceOptions {
}
/**
 * Java project containing types generated using OpenAPI Generator CLI
 */
export declare abstract class GeneratedJavaRuntimeBaseProject extends JavaProject {
    /**
     * Patterns that are excluded from code generation
     */
    static openApiIgnorePatterns: string[];
    /**
     * The package name, for use in imports
     */
    readonly packageName: string;
    /**
     * Options configured for the project
     */
    protected readonly options: GeneratedJavaRuntimeBaseProjectOptions;
    protected readonly openapiGeneratorIgnore: OpenApiGeneratorIgnoreFile;
    constructor(options: GeneratedJavaRuntimeBaseProjectOptions);
    buildGenerateCommandArgs: () => string;
    protected abstract buildOpenApiGeneratorOptions(): GenerationOptions;
}
