"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NORMALIZED_SERVICE_VARIANTS = void 0;
/** Mapping of service variants to asset key service name */
exports.NORMALIZED_SERVICE_VARIANTS = {
    alexa_for_business: ["ask"],
    api_gateway: ["apigateway", "apigatewayv2"],
    application_discovery_service: ["appintegrations", "servicediscovery"],
    aps: ["managed_service_for_prometheus"],
    certificate_manager: ["acmpca"],
    cloudwatch: ["applicationinsights", "evidently", "logs", "rum", "synthetics"],
    console_mobile_application: ["mobile_hub"],
    connect: ["customerprofiles", "voiceid", "wisdom"],
    cost_and_usage_report: ["cur"],
    cost_explorer: ["ce"],
    data_exchange: ["dax"],
    database_migration_service: ["dms"],
    documentdb: ["docdb"],
    ec2: ["imagebuilder"],
    efs: ["elastic_file_system"],
    ebs: ["elastic_block_store", "dlm"],
    ecr: ["elastic_container_registry"],
    ecs: ["elastic_container_service", "ecs_service"],
    eks: ["elastic_kubernetes_service"],
    eventbridge: ["eventschemas", "events"],
    express_workflows: ["express_workflow"],
    fault_injection_simulator: ["fis"],
    firewall_manager: ["fms"],
    glue_databrew: ["databrew", "gluedatabrewinteractivesessions"],
    iam_identity_center: ["sso", "single_sign_on"],
    iam: [
        "identity_and_access_management",
        "identity_access_management",
        "rolesanywhere",
        "accessanalyzer",
    ],
    inspector: ["inspectorv2"],
    interactive_video_service: ["ivs"],
    iot_core: ["iot", "iotwireless"],
    iot_device_management: ["iotfleethub"],
    iot_greengrass: ["greengrass", "greengrassv2"],
    key_management_service: ["kms"],
    keyspaces: ["cassandra", "managed_apache_cassandra_service"],
    kinesis_data_analytics: ["kinesisanalytics", "kinesisanalyticsv2"],
    kinesis_data_streams: ["kinesis"],
    kinesis_firehose: ["firehose"],
    kinesis_video_streams: ["kinesisvideo"],
    location_service: ["location"],
    mainframe_modernization: ["m2"],
    managed_blockchain: ["qldb"],
    managed_grafana: ["managed_service_for_grafana"],
    memorydb_for_redis: ["memorydb"],
    migration_hub: ["refactorspaces"],
    msk: [
        "managed_streaming_for_apache_kafka",
        "managed_streaming_for_kafka",
        "kafkaconnect",
        "kafka",
    ],
    mwaa: [
        "managed_workflows_for_apache_airflow",
        "managed_workflows_for_airflow",
        "airflow",
    ],
    opensearch: [
        "opensearch_service",
        "opensearch",
        "elasticsearch",
        "elasticsearch_service",
    ],
    outposts_rack: ["outposts_1u_and_2u_servers"],
    quantum_ledger_database: ["qldb"],
    pinpoint: ["pinpointemail"],
    resource_access_manager: ["ram"],
    s3_glacier: ["simple_storage_service_glacier", "glacier"],
    s3: ["simple_storage_service"],
    serverless_application_repository: ["serverless", "serverlessdiscovery"],
    ses: ["simple_email_service"],
    sns: ["simple_notification_service"],
    sqs: ["simple_queue_service"],
    ssm: ["systems_manager", "resourcegroups"],
    transfer_family: ["transfer"],
    vpc: ["virtual_private_cloud", "networkmanager"],
    well_architected_tool: ["well_architect_tool"],
    network_firewall: ["fms", "networkfirewall"],
};
//# sourceMappingURL=data:application/json;base64,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