"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.performGraphFilterPlan = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const constructs_1 = require("constructs");
const filters_1 = require("./filters");
const presets = require("./presets");
const types_1 = require("./types");
const core_1 = require("../core");
__exportStar(require("./types"), exports);
__exportStar(require("./filters"), exports);
/**
 * Perform graph filter plan on store.
 *
 * This operation is performed *in-place* and is destructive, therefore can only be applied
 * on stores that allow destructive mutations.
 * @param {Graph.Store} store - The store to perform filter plan against
 * @param {IGraphFilterPlan} plan - The filter plan to apply
 * @throws Error is store does not allow destructive mutations
 * @destructive
 */
function performGraphFilterPlan(store, plan) {
    filters_1.Filters.verifyFilterable(store);
    if (plan.focus) {
        presets.focusFilter(store, plan);
    }
    if (plan.preset) {
        switch (plan.preset) {
            case types_1.FilterPreset.NON_EXTRANEOUS: {
                presets.nonExtraneousFilterPreset(store);
                break;
            }
            case types_1.FilterPreset.COMPACT: {
                presets.compactFilterPreset(store);
                break;
            }
        }
    }
    if (plan.filters) {
        for (const filter of plan.filters) {
            if (filter.store) {
                // IGraphStoreFilter
                filter.store.filter(store);
            }
            else if (filter.graph) {
                // IGraphFilter
                const _filter = filter.graph;
                const inverse = _filter.inverse === true;
                const allNodes = _filter.allNodes != null ? _filter.allNodes : plan.allNodes === true;
                const nodes = store.root.findAll({
                    order: plan.order || constructs_1.ConstructOrder.PREORDER,
                    predicate: {
                        filter: (node) => {
                            if (allNodes)
                                return true;
                            // by default only return Resources and CfnResources
                            return core_1.Graph.isResourceLike(node);
                        },
                    },
                });
                if (_filter.node) {
                    for (const node of nodes) {
                        if (node.isDestroyed)
                            continue;
                        const match = _filter.node.filter(node);
                        if ((match && inverse) || (!match && !inverse)) {
                            switch (_filter.strategy || types_1.FilterStrategy.PRUNE) {
                                case types_1.FilterStrategy.PRUNE: {
                                    node.mutateDestroy();
                                    break;
                                }
                                case types_1.FilterStrategy.COLLAPSE: {
                                    node.mutateCollapse();
                                    break;
                                }
                                case types_1.FilterStrategy.COLLAPSE_TO_PARENT: {
                                    node.mutateCollapseToParent();
                                    break;
                                }
                            }
                        }
                    }
                }
                if (_filter.edge) {
                    const edges = store.edges;
                    for (const edge of edges) {
                        if (edge.isDestroyed)
                            continue;
                        const match = _filter.edge.filter(edge);
                        if ((match && inverse) || (!match && !inverse)) {
                            edge.mutateDestroy();
                        }
                    }
                }
            }
        }
    }
}
exports.performGraphFilterPlan = performGraphFilterPlan;
//# sourceMappingURL=data:application/json;base64,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