"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findReferencesOfSubGraph = void 0;
/** @internal */
function findReferencesOfSubGraph(subgraph, depth, predicate, strict = true) {
    const chain = new Set();
    if (depth == null) {
        depth = Number.MAX_SAFE_INTEGER;
    }
    function follow(_node, _depth) {
        if (_depth >= depth)
            return;
        for (const _ref of _node.references) {
            if (predicate && !predicate.filter(_ref))
                continue;
            if (_ref === subgraph || chain.has(_ref))
                continue;
            chain.add(_ref);
            follow(_ref, _depth + 1);
        }
        for (const child of _node.children) {
            if (predicate && !predicate.filter(child))
                continue;
            follow(child, _depth + 1);
        }
    }
    follow(subgraph, 0);
    if (strict) {
        for (const ref of chain) {
            if (ref.referencedBy.filter((_by) => !(_by === subgraph || _by.isAncestor(subgraph)) && !chain.has(_by)).length) {
                chain.delete(ref);
            }
        }
    }
    return Array.from(chain);
}
exports.findReferencesOfSubGraph = findReferencesOfSubGraph;
//# sourceMappingURL=data:application/json;base64,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