"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjectUtils = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const readPkg = require("read-pkg-up");
/**
 * Utility for projen projects
 * @experimental
 */
var ProjectUtils;
(function (ProjectUtils) {
    /**
     * List all parent class names of the given class (includes the given class's name as the last element)
     * @internal
     */
    function listParentClassNames(clazz) {
        if (!clazz?.name) {
            return [];
        }
        return [...listParentClassNames(Object.getPrototypeOf(clazz)), clazz.name];
    }
    /**
     * Returns whether the given project is an instance of the given project class.
     * Uses the class name to perform this check, such that the check still passes for
     * classes imported from mismatching package versions.
     */
    function isNamedInstanceOf(instance, clazz) {
        return new Set(listParentClassNames(instance.constructor)).has(clazz.name);
    }
    ProjectUtils.isNamedInstanceOf = isNamedInstanceOf;
    /**
     * Get the current PDK version
     */
    function getPdkVersion() {
        const { packageJson } = readPkg.sync({
            cwd: path.resolve(__dirname),
        });
        return packageJson.version;
    }
    ProjectUtils.getPdkVersion = getPdkVersion;
})(ProjectUtils || (exports.ProjectUtils = ProjectUtils = {}));
//# sourceMappingURL=data:application/json;base64,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