"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MockIntegration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const integration_1 = require("./integration");
const prepare_spec_1 = require("../prepare-spec-event-handler/prepare-spec");
/**
 * A mock integration to return a hardcoded response
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-mock-integration.html
 */
class MockIntegration extends integration_1.Integration {
    constructor(props) {
        super();
        this.props = props;
    }
    render(props) {
        const contentTypes = props.contentTypes ?? ["application/json"];
        return {
            type: "MOCK",
            requestTemplates: Object.fromEntries(contentTypes.map((contentType) => [
                contentType,
                `{"statusCode": ${this.props.statusCode}}`,
            ])),
            responses: {
                default: {
                    statusCode: `${this.props.statusCode}`,
                    responseParameters: props.corsOptions
                        ? (0, prepare_spec_1.generateCorsResponseParameters)(props.corsOptions)
                        : {},
                    responseTemplates: Object.fromEntries(contentTypes.map((contentType) => [
                        contentType,
                        this.props.body ?? "",
                    ])),
                },
            },
        };
    }
}
exports.MockIntegration = MockIntegration;
_a = JSII_RTTI_SYMBOL_1;
MockIntegration[_a] = { fqn: "@aws/pdk.type_safe_api.MockIntegration", version: "0.23.39" };
//# sourceMappingURL=data:application/json;base64,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