import { aws_wafv2, IResolvable } from 'aws-cdk-lib';
/**
 * PartialManagedRuleGroupStatementProperty
 */
export interface PartialManagedRuleGroupStatementProperty {
    /**
     * The version of the managed rule group to use.
     * If you specify this, the version setting is fixed until you change it. If you don't specify this, AWS WAF uses the vendor's default version, and then keeps the version at the vendor's default when the vendor updates the managed rule group settings.
     * @stability external
     */
    readonly version?: string;
    /**
     * An optional nested statement that narrows the scope of the web requests that are evaluated by the managed rule group.
     * Requests are only evaluated by the rule group if they match the scope-down statement. You can use any nestable `Statement` in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.
     * @stability external
     */
    readonly scopeDownStatement?: IResolvable | aws_wafv2.CfnWebACL.StatementProperty;
    /**
     * Action settings to use in the place of the rule actions that are configured inside the rule group.
     * You specify one override for each rule whose action you want to change.
     *
     * You can use overrides for testing, for example you can override all of rule actions to `Count` and then monitor the resulting count metrics to understand how the rule group would handle your web traffic. You can also permanently override some or all actions, to modify how the rule group manages your web traffic.
     * @stability external
     */
    readonly ruleActionOverrides?: IResolvable | Array<IResolvable | aws_wafv2.CfnWebACL.RuleActionOverrideProperty>;
    /**
     * Additional information that's used by a managed rule group. Many managed rule groups don't require this.
     * The rule groups used for intelligent threat mitigation require additional configuration:
     *
     * - Use the `AWSManagedRulesACFPRuleSet` configuration object to configure the account creation fraud prevention managed rule group. The configuration includes the registration and sign-up pages of your application and the locations in the account creation request payload of data, such as the user email and phone number fields.
     * - Use the `AWSManagedRulesATPRuleSet` configuration object to configure the account takeover prevention managed rule group. The configuration includes the sign-in page of your application and the locations in the login request payload of data such as the username and password.
     * - Use the `AWSManagedRulesBotControlRuleSet` configuration object to configure the protection level that you want the Bot Control rule group to use.
     * @stability external
     */
    readonly managedRuleGroupConfigs?: IResolvable | Array<IResolvable | aws_wafv2.CfnWebACL.ManagedRuleGroupConfigProperty>;
    /**
     * Rules in the referenced rule group whose actions are set to `Count` .
     * > Instead of this option, use `RuleActionOverrides` . It accepts any valid action setting, including `Count` .
     * @stability external
     */
    readonly excludedRules?: IResolvable | Array<IResolvable | aws_wafv2.CfnWebACL.ExcludedRuleProperty>;
    /**
     * The name of the managed rule group.
     * You use this, along with the vendor name, to identify the rule group.
     * @stability external
     */
    readonly name: string;
}
