"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenApiGeneratorHandlebarsIgnoreFile = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
const open_api_generator_ignore_file_1 = require("./open-api-generator-ignore-file");
/**
 * Represents an .openapi-generator-ignore-handlebars file.
 * This is used for an optional second code generation pass to generate files using the handlebars templating engine
 * @see https://github.com/OpenAPITools/openapi-generator/blob/master/docs/customization.md#ignore-file-format
 */
class OpenApiGeneratorHandlebarsIgnoreFile extends projen_1.IgnoreFile {
    constructor(project) {
        super(project, ".openapi-generator-ignore-handlebars");
        // Ignore all files by default to allow opting in to generate with specific handlebars templates
        this.addPatterns(...open_api_generator_ignore_file_1.OpenApiGeneratorIgnoreFile.ALL_FILES_PATTERNS);
    }
}
exports.OpenApiGeneratorHandlebarsIgnoreFile = OpenApiGeneratorHandlebarsIgnoreFile;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib3Blbi1hcGktZ2VuZXJhdG9yLWhhbmRsZWJhcnMtaWdub3JlLWZpbGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJvcGVuLWFwaS1nZW5lcmF0b3ItaGFuZGxlYmFycy1pZ25vcmUtZmlsZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQTtzQ0FDc0M7QUFDdEMsbUNBQTZDO0FBQzdDLHFGQUE4RTtBQUU5RTs7OztHQUlHO0FBQ0gsTUFBYSxvQ0FBcUMsU0FBUSxtQkFBVTtJQUNsRSxZQUFZLE9BQWdCO1FBQzFCLEtBQUssQ0FBQyxPQUFPLEVBQUUsc0NBQXNDLENBQUMsQ0FBQztRQUV2RCxnR0FBZ0c7UUFDaEcsSUFBSSxDQUFDLFdBQVcsQ0FBQyxHQUFHLDJEQUEwQixDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckUsQ0FBQztDQUNGO0FBUEQsb0ZBT0MiLCJzb3VyY2VzQ29udGVudCI6WyIvKiEgQ29weXJpZ2h0IFtBbWF6b24uY29tXShodHRwOi8vYW1hem9uLmNvbS8pLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjAgKi9cbmltcG9ydCB7IElnbm9yZUZpbGUsIFByb2plY3QgfSBmcm9tIFwicHJvamVuXCI7XG5pbXBvcnQgeyBPcGVuQXBpR2VuZXJhdG9ySWdub3JlRmlsZSB9IGZyb20gXCIuL29wZW4tYXBpLWdlbmVyYXRvci1pZ25vcmUtZmlsZVwiO1xuXG4vKipcbiAqIFJlcHJlc2VudHMgYW4gLm9wZW5hcGktZ2VuZXJhdG9yLWlnbm9yZS1oYW5kbGViYXJzIGZpbGUuXG4gKiBUaGlzIGlzIHVzZWQgZm9yIGFuIG9wdGlvbmFsIHNlY29uZCBjb2RlIGdlbmVyYXRpb24gcGFzcyB0byBnZW5lcmF0ZSBmaWxlcyB1c2luZyB0aGUgaGFuZGxlYmFycyB0ZW1wbGF0aW5nIGVuZ2luZVxuICogQHNlZSBodHRwczovL2dpdGh1Yi5jb20vT3BlbkFQSVRvb2xzL29wZW5hcGktZ2VuZXJhdG9yL2Jsb2IvbWFzdGVyL2RvY3MvY3VzdG9taXphdGlvbi5tZCNpZ25vcmUtZmlsZS1mb3JtYXRcbiAqL1xuZXhwb3J0IGNsYXNzIE9wZW5BcGlHZW5lcmF0b3JIYW5kbGViYXJzSWdub3JlRmlsZSBleHRlbmRzIElnbm9yZUZpbGUge1xuICBjb25zdHJ1Y3Rvcihwcm9qZWN0OiBQcm9qZWN0KSB7XG4gICAgc3VwZXIocHJvamVjdCwgXCIub3BlbmFwaS1nZW5lcmF0b3ItaWdub3JlLWhhbmRsZWJhcnNcIik7XG5cbiAgICAvLyBJZ25vcmUgYWxsIGZpbGVzIGJ5IGRlZmF1bHQgdG8gYWxsb3cgb3B0aW5nIGluIHRvIGdlbmVyYXRlIHdpdGggc3BlY2lmaWMgaGFuZGxlYmFycyB0ZW1wbGF0ZXNcbiAgICB0aGlzLmFkZFBhdHRlcm5zKC4uLk9wZW5BcGlHZW5lcmF0b3JJZ25vcmVGaWxlLkFMTF9GSUxFU19QQVRURVJOUyk7XG4gIH1cbn1cbiJdfQ==