"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenApiGeneratorIgnoreFile = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
/**
 * Represents an .openapi-generator-ignore file
 * @see https://github.com/OpenAPITools/openapi-generator/blob/master/docs/customization.md#ignore-file-format
 */
class OpenApiGeneratorIgnoreFile extends projen_1.IgnoreFile {
    constructor(project) {
        super(project, ".openapi-generator-ignore");
        // We should always use the projen .gitignore since projen manages the build, and therefore the ignored build
        // artifacts
        this.addPatterns(".gitignore");
    }
}
exports.OpenApiGeneratorIgnoreFile = OpenApiGeneratorIgnoreFile;
OpenApiGeneratorIgnoreFile.ALL_FILES_PATTERNS = ["/*", "**/*", "*"];
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib3Blbi1hcGktZ2VuZXJhdG9yLWlnbm9yZS1maWxlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsib3Blbi1hcGktZ2VuZXJhdG9yLWlnbm9yZS1maWxlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBO3NDQUNzQztBQUN0QyxtQ0FBNkM7QUFFN0M7OztHQUdHO0FBQ0gsTUFBYSwwQkFBMkIsU0FBUSxtQkFBVTtJQUd4RCxZQUFZLE9BQWdCO1FBQzFCLEtBQUssQ0FBQyxPQUFPLEVBQUUsMkJBQTJCLENBQUMsQ0FBQztRQUU1Qyw2R0FBNkc7UUFDN0csWUFBWTtRQUNaLElBQUksQ0FBQyxXQUFXLENBQUMsWUFBWSxDQUFDLENBQUM7SUFDakMsQ0FBQzs7QUFUSCxnRUFVQztBQVRlLDZDQUFrQixHQUFhLENBQUMsSUFBSSxFQUFFLE1BQU0sRUFBRSxHQUFHLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qISBDb3B5cmlnaHQgW0FtYXpvbi5jb21dKGh0dHA6Ly9hbWF6b24uY29tLyksIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMCAqL1xuaW1wb3J0IHsgSWdub3JlRmlsZSwgUHJvamVjdCB9IGZyb20gXCJwcm9qZW5cIjtcblxuLyoqXG4gKiBSZXByZXNlbnRzIGFuIC5vcGVuYXBpLWdlbmVyYXRvci1pZ25vcmUgZmlsZVxuICogQHNlZSBodHRwczovL2dpdGh1Yi5jb20vT3BlbkFQSVRvb2xzL29wZW5hcGktZ2VuZXJhdG9yL2Jsb2IvbWFzdGVyL2RvY3MvY3VzdG9taXphdGlvbi5tZCNpZ25vcmUtZmlsZS1mb3JtYXRcbiAqL1xuZXhwb3J0IGNsYXNzIE9wZW5BcGlHZW5lcmF0b3JJZ25vcmVGaWxlIGV4dGVuZHMgSWdub3JlRmlsZSB7XG4gIHB1YmxpYyBzdGF0aWMgQUxMX0ZJTEVTX1BBVFRFUk5TOiBzdHJpbmdbXSA9IFtcIi8qXCIsIFwiKiovKlwiLCBcIipcIl07XG5cbiAgY29uc3RydWN0b3IocHJvamVjdDogUHJvamVjdCkge1xuICAgIHN1cGVyKHByb2plY3QsIFwiLm9wZW5hcGktZ2VuZXJhdG9yLWlnbm9yZVwiKTtcblxuICAgIC8vIFdlIHNob3VsZCBhbHdheXMgdXNlIHRoZSBwcm9qZW4gLmdpdGlnbm9yZSBzaW5jZSBwcm9qZW4gbWFuYWdlcyB0aGUgYnVpbGQsIGFuZCB0aGVyZWZvcmUgdGhlIGlnbm9yZWQgYnVpbGRcbiAgICAvLyBhcnRpZmFjdHNcbiAgICB0aGlzLmFkZFBhdHRlcm5zKFwiLmdpdGlnbm9yZVwiKTtcbiAgfVxufVxuIl19