"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedAsyncApiHtmlDocumentationProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
const type_safe_api_command_environment_1 = require("../components/type-safe-api-command-environment");
const utils_1 = require("../components/utils");
class GeneratedAsyncApiHtmlDocumentationProject extends projen_1.Project {
    constructor(options) {
        super(options);
        type_safe_api_command_environment_1.TypeSafeApiCommandEnvironment.ensure(this);
        this.generateTask = this.addTask("generate");
        this.generateTask.exec((0, utils_1.buildTypeSafeApiExecCommand)(utils_1.TypeSafeApiScript.GENERATE_ASYNCAPI_HTML_DOCS, `--spec-path ${options.specPath} --output-path .`));
        this.compileTask.spawn(this.generateTask);
        this.gitignore.addPatterns("index.html");
    }
}
exports.GeneratedAsyncApiHtmlDocumentationProject = GeneratedAsyncApiHtmlDocumentationProject;
//# sourceMappingURL=data:application/json;base64,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