import { PythonProject } from "projen/lib/python";
import { PythonVersion } from "../../languages";
import { CodeGenerationSourceOptions, GeneratedPythonHandlersOptions } from "../../types";
import { GenerationOptions } from "../components/utils";
import { GeneratedPythonRuntimeBaseProject } from "../runtime/generated-python-runtime-base-project";
export interface GeneratedPythonHandlersBaseProjectOptions extends GeneratedPythonHandlersOptions, CodeGenerationSourceOptions {
    /**
     * The generated python types
     */
    readonly generatedPythonTypes: GeneratedPythonRuntimeBaseProject;
}
export declare abstract class GeneratedPythonHandlersBaseProject extends PythonProject {
    /**
     * Options configured for the project
     */
    protected readonly options: GeneratedPythonHandlersBaseProjectOptions;
    /**
     * Directory containing tests
     */
    protected readonly tstDir: string;
    /**
     * Python runtime version for the handlers
     */
    readonly runtimeVersion: PythonVersion;
    constructor(options: GeneratedPythonHandlersBaseProjectOptions);
    buildGenerateCommandArgs: () => string;
    abstract buildOpenApiGeneratorOptions(): GenerationOptions;
}
