"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedPythonHandlersProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const generated_python_handlers_base_project_1 = require("./generated-python-handlers-base-project");
const utils_1 = require("../components/utils");
class GeneratedPythonHandlersProject extends generated_python_handlers_base_project_1.GeneratedPythonHandlersBaseProject {
    constructor(options) {
        super(options);
    }
    buildOpenApiGeneratorOptions() {
        return {
            generator: "python-nextgen",
            specPath: this.options.specPath,
            generatorDirectory: utils_1.OtherGenerators.PYTHON_LAMBDA_HANDLERS,
            // Tell the generator where python source files live
            srcDir: this.moduleName,
            tstDir: this.tstDir,
            additionalProperties: {
                packageName: this.moduleName,
                projectName: this.name,
            },
            normalizers: {
                KEEP_ONLY_FIRST_TAG_IN_OPERATION: true,
            },
            extraVendorExtensions: {
                "x-runtime-module-name": this.options.generatedPythonTypes.moduleName,
            },
        };
    }
}
exports.GeneratedPythonHandlersProject = GeneratedPythonHandlersProject;
//# sourceMappingURL=data:application/json;base64,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