"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedTypescriptAsyncHandlersProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const generated_typescript_handlers_base_project_1 = require("./generated-typescript-handlers-base-project");
const utils_1 = require("../components/utils");
class GeneratedTypescriptAsyncHandlersProject extends generated_typescript_handlers_base_project_1.GeneratedTypescriptHandlersBaseProject {
    constructor(options) {
        super(options);
    }
    buildOpenApiGeneratorOptions() {
        return {
            generator: "typescript-fetch",
            specPath: this.options.specPath,
            generatorDirectory: utils_1.OtherGenerators.TYPESCRIPT_ASYNC_LAMBDA_HANDLERS,
            srcDir: this.srcdir,
            tstDir: this.testdir,
            normalizers: {
                KEEP_ONLY_FIRST_TAG_IN_OPERATION: true,
            },
            extraVendorExtensions: {
                "x-runtime-package-name": this.options.generatedTypescriptTypes.package.packageName,
            },
        };
    }
}
exports.GeneratedTypescriptAsyncHandlersProject = GeneratedTypescriptAsyncHandlersProject;
//# sourceMappingURL=data:application/json;base64,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