"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedJavaAsyncCdkInfrastructureProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const generated_java_cdk_infrastructure_base_project_1 = require("./generated-java-cdk-infrastructure-base-project");
const utils_1 = require("../../components/utils");
class GeneratedJavaAsyncCdkInfrastructureProject extends generated_java_cdk_infrastructure_base_project_1.GeneratedJavaCdkInfrastructureBaseProject {
    constructor(options) {
        super(options);
    }
    buildOpenApiGeneratorOptions() {
        return {
            generator: "java",
            specPath: this.options.specPath,
            generatorDirectory: utils_1.OtherGenerators.JAVA_ASYNC_CDK_INFRASTRUCTURE,
            srcDir: this.srcDir,
            normalizers: {
                KEEP_ONLY_FIRST_TAG_IN_OPERATION: true,
            },
            extraVendorExtensions: {
                "x-infrastructure-package": this.packageName,
                "x-runtime-package": this.options.generatedJavaTypes.packageName,
                ...(0, utils_1.getHandlersProjectVendorExtensions)(this, this.options.generatedHandlers),
            },
            // Do not generate map/list types. Generator will use built in HashMap, ArrayList instead
            generateAliasAsModel: false,
        };
    }
}
exports.GeneratedJavaAsyncCdkInfrastructureProject = GeneratedJavaAsyncCdkInfrastructureProject;
//# sourceMappingURL=data:application/json;base64,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